/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.java.parser.BasicDeclarationParser;
import com.intellij.lang.java.parser.BasicJavaParser;
import com.intellij.lang.java.parser.BasicJavaParserUtil;
import com.intellij.lang.java.parser.BasicReferenceParser;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.AbstractBasicJavaElementTypeFactory;
import com.intellij.psi.impl.source.BasicElementTypes;
import com.intellij.psi.impl.source.WhiteSpaceAndCommentSetHolder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicStatementParser {
    private static final TokenSet YIELD_STMT_INDICATOR_TOKENS = TokenSet.create(JavaTokenType.PLUS, JavaTokenType.MINUS, JavaTokenType.EXCL, JavaTokenType.SUPER_KEYWORD, JavaTokenType.THIS_KEYWORD, JavaTokenType.TRUE_KEYWORD, JavaTokenType.FALSE_KEYWORD, JavaTokenType.NULL_KEYWORD, JavaTokenType.STRING_LITERAL, JavaTokenType.INTEGER_LITERAL, JavaTokenType.DOUBLE_LITERAL, JavaTokenType.FLOAT_LITERAL, JavaTokenType.LONG_LITERAL, JavaTokenType.CHARACTER_LITERAL, JavaTokenType.TEXT_BLOCK_LITERAL, JavaTokenType.IDENTIFIER, JavaTokenType.SWITCH_KEYWORD, JavaTokenType.NEW_KEYWORD, JavaTokenType.LPARENTH, JavaTokenType.RBRACE, JavaTokenType.SEMICOLON, JavaTokenType.CASE_KEYWORD);
    private static final TokenSet TRY_CLOSERS_SET = TokenSet.create(JavaTokenType.CATCH_KEYWORD, JavaTokenType.FINALLY_KEYWORD);
    private final BasicJavaParser myParser;
    private final AbstractBasicJavaElementTypeFactory.JavaElementTypeContainer myJavaElementTypeContainer;
    private final WhiteSpaceAndCommentSetHolder myWhiteSpaceAndCommentSetHolder;

    public BasicStatementParser(@NotNull BasicJavaParser javaParser) {
        if (javaParser == null) {
            BasicStatementParser.$$$reportNull$$$0(0);
        }
        this.myWhiteSpaceAndCommentSetHolder = WhiteSpaceAndCommentSetHolder.INSTANCE;
        this.myParser = javaParser;
        this.myJavaElementTypeContainer = javaParser.getJavaElementTypeFactory().getContainer();
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlock(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            BasicStatementParser.$$$reportNull$$$0(1);
        }
        return this.parseCodeBlock(builder2, false);
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlock(@NotNull PsiBuilder builder2, boolean isStatement) {
        if (builder2 == null) {
            BasicStatementParser.$$$reportNull$$$0(2);
        }
        if (builder2.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        if (isStatement && BasicJavaParserUtil.isParseStatementCodeBlocksDeep(builder2)) {
            return this.parseCodeBlockDeep(builder2, false);
        }
        return PsiBuilderUtil.parseBlockLazy(builder2, JavaTokenType.LBRACE, JavaTokenType.RBRACE, this.myJavaElementTypeContainer.CODE_BLOCK);
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlockDeep(@NotNull PsiBuilder builder2, boolean parseUntilEof) {
        if (builder2 == null) {
            BasicStatementParser.$$$reportNull$$$0(3);
        }
        if (builder2.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        PsiBuilder.Marker codeBlock = builder2.mark();
        builder2.advanceLexer();
        this.parseStatements(builder2, parseUntilEof ? BraceMode.TILL_LAST : BraceMode.TILL_FIRST);
        boolean greedyBlock = !BasicJavaParserUtil.expectOrError(builder2, JavaTokenType.RBRACE, "expected.rbrace");
        builder2.getTokenType();
        BasicJavaParserUtil.done(codeBlock, this.myJavaElementTypeContainer.CODE_BLOCK, this.myWhiteSpaceAndCommentSetHolder);
        if (greedyBlock) {
            codeBlock.setCustomEdgeTokenBinders(null, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        }
        return codeBlock;
    }

    public void parseStatements(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            BasicStatementParser.$$$reportNull$$$0(4);
        }
        this.parseStatements(builder2, null);
    }

    private void parseStatements(PsiBuilder builder2, @Nullable BraceMode braceMode) {
        while (builder2.getTokenType() != null) {
            PsiBuilder.Marker statement = this.parseStatement(builder2);
            if (statement != null) continue;
            IElementType tokenType = builder2.getTokenType();
            if (tokenType == JavaTokenType.RBRACE && (braceMode == BraceMode.TILL_FIRST || braceMode == BraceMode.TILL_LAST && builder2.lookAhead(1) == null)) break;
            PsiBuilder.Marker error = builder2.mark();
            builder2.advanceLexer();
            if (tokenType == JavaTokenType.ELSE_KEYWORD) {
                error.error(JavaPsiBundle.message("else.without.if", new Object[0]));
                continue;
            }
            if (tokenType == JavaTokenType.CATCH_KEYWORD) {
                error.error(JavaPsiBundle.message("catch.without.try", new Object[0]));
                continue;
            }
            if (tokenType == JavaTokenType.FINALLY_KEYWORD) {
                error.error(JavaPsiBundle.message("finally.without.try", new Object[0]));
                continue;
            }
            error.error(JavaPsiBundle.message("unexpected.token", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parseStatement(@NotNull PsiBuilder builder2) {
        PsiBuilder.Marker statement;
        IElementType tokenType;
        if (builder2 == null) {
            BasicStatementParser.$$$reportNull$$$0(5);
        }
        if ((tokenType = builder2.getTokenType()) == JavaTokenType.IF_KEYWORD) {
            return this.parseIfStatement(builder2);
        }
        if (tokenType == JavaTokenType.WHILE_KEYWORD) {
            return this.parseWhileStatement(builder2);
        }
        if (tokenType == JavaTokenType.FOR_KEYWORD) {
            return this.parseForStatement(builder2);
        }
        if (tokenType == JavaTokenType.DO_KEYWORD) {
            return this.parseDoWhileStatement(builder2);
        }
        if (tokenType == JavaTokenType.SWITCH_KEYWORD) {
            return this.parseSwitchStatement(builder2);
        }
        if (tokenType == JavaTokenType.CASE_KEYWORD || tokenType == JavaTokenType.DEFAULT_KEYWORD) {
            return this.parseSwitchLabelStatement(builder2);
        }
        if (tokenType == JavaTokenType.BREAK_KEYWORD) {
            return this.parseBreakStatement(builder2);
        }
        if (BasicStatementParser.isStmtYieldToken(builder2, tokenType)) {
            return this.parseYieldStatement(builder2);
        }
        if (tokenType == JavaTokenType.CONTINUE_KEYWORD) {
            return this.parseContinueStatement(builder2);
        }
        if (tokenType == JavaTokenType.RETURN_KEYWORD) {
            return this.parseReturnStatement(builder2);
        }
        if (tokenType == JavaTokenType.THROW_KEYWORD) {
            return this.parseThrowStatement(builder2);
        }
        if (tokenType == JavaTokenType.SYNCHRONIZED_KEYWORD) {
            return this.parseSynchronizedStatement(builder2);
        }
        if (tokenType == JavaTokenType.TRY_KEYWORD) {
            return this.parseTryStatement(builder2);
        }
        if (tokenType == JavaTokenType.ASSERT_KEYWORD) {
            return this.parseAssertStatement(builder2);
        }
        if (tokenType == JavaTokenType.LBRACE) {
            return this.parseBlockStatement(builder2);
        }
        if (tokenType instanceof ILazyParseableElementType) {
            builder2.advanceLexer();
            return null;
        }
        if (tokenType == JavaTokenType.SEMICOLON) {
            PsiBuilder.Marker empty = builder2.mark();
            builder2.advanceLexer();
            BasicJavaParserUtil.done(empty, this.myJavaElementTypeContainer.EMPTY_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
            return empty;
        }
        if (tokenType == JavaTokenType.IDENTIFIER || tokenType == JavaTokenType.AT) {
            PsiBuilder.Marker refPos = builder2.mark();
            this.myParser.getDeclarationParser().parseAnnotations(builder2);
            BasicStatementParser.skipQualifiedName(builder2);
            IElementType suspectedLT = builder2.getTokenType();
            IElementType next2 = builder2.lookAhead(1);
            refPos.rollbackTo();
            if (suspectedLT == JavaTokenType.LT || suspectedLT == JavaTokenType.DOT && next2 == JavaTokenType.AT) {
                PsiBuilder.Marker declStatement = builder2.mark();
                if (this.myParser.getDeclarationParser().parse(builder2, BasicDeclarationParser.BaseContext.CODE_BLOCK) != null) {
                    BasicJavaParserUtil.done(declStatement, this.myJavaElementTypeContainer.DECLARATION_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
                    return declStatement;
                }
                BasicReferenceParser.TypeInfo type2 = this.myParser.getReferenceParser().parseTypeInfo(builder2, 0);
                if (!(suspectedLT != JavaTokenType.LT || type2 != null && type2.isParameterized)) {
                    declStatement.rollbackTo();
                } else {
                    if (type2 == null || builder2.getTokenType() != JavaTokenType.DOUBLE_COLON) {
                        BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
                        if (type2 == null) {
                            builder2.advanceLexer();
                        }
                        BasicJavaParserUtil.done(declStatement, this.myJavaElementTypeContainer.DECLARATION_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
                        return declStatement;
                    }
                    declStatement.rollbackTo();
                }
            }
        }
        PsiBuilder.Marker pos = builder2.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder2);
        if (expr != null) {
            int count = 1;
            PsiBuilder.Marker list = expr.precede();
            PsiBuilder.Marker statement2 = list.precede();
            while (builder2.getTokenType() == JavaTokenType.COMMA) {
                PsiBuilder.Marker commaPos = builder2.mark();
                builder2.advanceLexer();
                PsiBuilder.Marker expr1 = this.myParser.getExpressionParser().parse(builder2);
                if (expr1 == null) {
                    commaPos.rollbackTo();
                    break;
                }
                commaPos.drop();
                ++count;
            }
            if (count > 1) {
                pos.drop();
                BasicJavaParserUtil.done(list, this.myJavaElementTypeContainer.EXPRESSION_LIST, this.myWhiteSpaceAndCommentSetHolder);
                BasicJavaParserUtil.semicolon(builder2);
                BasicJavaParserUtil.done(statement2, this.myJavaElementTypeContainer.EXPRESSION_LIST_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
                return statement2;
            }
            if (BasicJavaParserUtil.exprType(expr) != this.myJavaElementTypeContainer.REFERENCE_EXPRESSION) {
                PsiBuilderUtil.drop(list, pos);
                BasicJavaParserUtil.semicolon(builder2);
                BasicJavaParserUtil.done(statement2, this.myJavaElementTypeContainer.EXPRESSION_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
                return statement2;
            }
            pos.rollbackTo();
        } else {
            pos.drop();
        }
        PsiBuilder.Marker decl = this.myParser.getDeclarationParser().parse(builder2, BasicDeclarationParser.BaseContext.CODE_BLOCK);
        if (decl != null) {
            statement = decl.precede();
            BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.DECLARATION_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
            return statement;
        }
        if (builder2.getTokenType() == JavaTokenType.IDENTIFIER && builder2.lookAhead(1) == JavaTokenType.COLON) {
            statement = builder2.mark();
            PsiBuilderUtil.advance(builder2, 2);
            this.parseStatement(builder2);
            BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.LABELED_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
            return statement;
        }
        if (expr != null) {
            statement = builder2.mark();
            this.myParser.getExpressionParser().parse(builder2);
            BasicJavaParserUtil.semicolon(builder2);
            BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.EXPRESSION_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
            return statement;
        }
        return null;
    }

    private static boolean isStmtYieldToken(@NotNull PsiBuilder builder2, IElementType tokenType) {
        if (builder2 == null) {
            BasicStatementParser.$$$reportNull$$$0(6);
        }
        if (tokenType != JavaTokenType.IDENTIFIER || !"yield".equals(builder2.getTokenText()) || !BasicJavaParserUtil.getLanguageLevel(builder2).isAtLeast(LanguageLevel.JDK_14)) {
            return false;
        }
        PsiBuilder.Marker maybeYieldStmt = builder2.mark();
        builder2.advanceLexer();
        IElementType tokenAfterYield = builder2.getTokenType();
        if (tokenAfterYield == null || YIELD_STMT_INDICATOR_TOKENS.contains(tokenAfterYield)) {
            maybeYieldStmt.rollbackTo();
            return true;
        }
        if (JavaTokenType.PLUSPLUS.equals(tokenAfterYield) || JavaTokenType.MINUSMINUS.equals(tokenAfterYield)) {
            builder2.advanceLexer();
            boolean isYieldStmt = !builder2.getTokenType().equals(JavaTokenType.SEMICOLON);
            maybeYieldStmt.rollbackTo();
            return isYieldStmt;
        }
        maybeYieldStmt.rollbackTo();
        return false;
    }

    private static void skipQualifiedName(PsiBuilder builder2) {
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.IDENTIFIER)) {
            return;
        }
        while (builder2.getTokenType() == JavaTokenType.DOT && builder2.lookAhead(1) == JavaTokenType.IDENTIFIER) {
            PsiBuilderUtil.advance(builder2, 2);
        }
    }

    @NotNull
    private PsiBuilder.Marker parseIfStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement = builder2.mark();
        builder2.advanceLexer();
        if (this.parseExprInParenth(builder2)) {
            PsiBuilder.Marker elseStatement;
            PsiBuilder.Marker thenStatement = this.parseStatement(builder2);
            if (thenStatement == null) {
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.statement", new Object[0]));
            } else if (PsiBuilderUtil.expect(builder2, JavaTokenType.ELSE_KEYWORD) && (elseStatement = this.parseStatement(builder2)) == null) {
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.statement", new Object[0]));
            }
        }
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.IF_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            BasicStatementParser.$$$reportNull$$$0(7);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseWhileStatement(PsiBuilder builder2) {
        PsiBuilder.Marker marker = this.parseExprInParenthWithBlock(builder2, this.myJavaElementTypeContainer.WHILE_STATEMENT, false);
        if (marker == null) {
            BasicStatementParser.$$$reportNull$$$0(8);
        }
        return marker;
    }

    @Contract(pure=true)
    private boolean isRecordPatternInForEach(PsiBuilder builder2) {
        PsiBuilder.Marker patternStart = this.myParser.getPatternParser().preParsePattern(builder2, false);
        if (patternStart == null) {
            return false;
        }
        if (builder2.getTokenType() != JavaTokenType.LPARENTH) {
            patternStart.rollbackTo();
            return false;
        }
        builder2.advanceLexer();
        int parenBalance = 1;
        while (true) {
            IElementType current;
            if ((current = builder2.getTokenType()) == null) {
                patternStart.rollbackTo();
                return false;
            }
            if (current == JavaTokenType.LPARENTH) {
                ++parenBalance;
            }
            if (current == JavaTokenType.RPARENTH && --parenBalance == 0) break;
            builder2.advanceLexer();
        }
        builder2.advanceLexer();
        boolean isRecordPattern = builder2.getTokenType() != JavaTokenType.SEMICOLON && builder2.getTokenType() != JavaTokenType.DOT;
        patternStart.rollbackTo();
        return isRecordPattern;
    }

    @NotNull
    private PsiBuilder.Marker parseForStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement = builder2.mark();
        builder2.advanceLexer();
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.LPARENTH)) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.lparen", new Object[0]));
            BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.FOR_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
            PsiBuilder.Marker marker = statement;
            if (marker == null) {
                BasicStatementParser.$$$reportNull$$$0(9);
            }
            return marker;
        }
        if (this.isRecordPatternInForEach(builder2)) {
            this.myParser.getPatternParser().parsePattern(builder2);
            if (builder2.getTokenType() == JavaTokenType.COLON) {
                return this.parseForEachFromColon(builder2, statement, this.myJavaElementTypeContainer.FOREACH_PATTERN_STATEMENT);
            }
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.colon", new Object[0]));
            while (true) {
                IElementType tokenType;
                if ((tokenType = builder2.getTokenType()) == null) {
                    BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.FOREACH_PATTERN_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
                    PsiBuilder.Marker marker = statement;
                    if (marker == null) {
                        BasicStatementParser.$$$reportNull$$$0(10);
                    }
                    return marker;
                }
                if (tokenType == JavaTokenType.RPARENTH) {
                    PsiBuilder.Marker marker = this.parserForEachFromRparenth(builder2, statement, this.myJavaElementTypeContainer.FOREACH_PATTERN_STATEMENT);
                    if (marker == null) {
                        BasicStatementParser.$$$reportNull$$$0(11);
                    }
                    return marker;
                }
                builder2.advanceLexer();
            }
        }
        PsiBuilder.Marker afterParenth = builder2.mark();
        PsiBuilder.Marker param = this.myParser.getDeclarationParser().parseParameter(builder2, false, false, true);
        if (param == null || BasicJavaParserUtil.exprType(param) != this.myJavaElementTypeContainer.PARAMETER || builder2.getTokenType() != JavaTokenType.COLON) {
            afterParenth.rollbackTo();
            return this.parseForLoopFromInitializer(builder2, statement);
        }
        afterParenth.drop();
        return this.parseForEachFromColon(builder2, statement, this.myJavaElementTypeContainer.FOREACH_STATEMENT);
    }

    @NotNull
    private PsiBuilder.Marker parseForLoopFromInitializer(PsiBuilder builder2, PsiBuilder.Marker statement) {
        PsiBuilder.Marker bodyStatement;
        if (this.parseStatement(builder2) == null) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.statement", new Object[0]));
            if (!PsiBuilderUtil.expect(builder2, JavaTokenType.RPARENTH)) {
                BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.FOR_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
                PsiBuilder.Marker marker = statement;
                if (marker == null) {
                    BasicStatementParser.$$$reportNull$$$0(12);
                }
                return marker;
            }
        } else {
            PsiBuilder.Marker expr;
            boolean missingSemicolon = false;
            if (BasicStatementParser.getLastToken(builder2) != JavaTokenType.SEMICOLON) {
                missingSemicolon = !BasicJavaParserUtil.expectOrError(builder2, JavaTokenType.SEMICOLON, "expected.semicolon");
            }
            missingSemicolon &= (expr = this.myParser.getExpressionParser().parse(builder2)) == null;
            if (!PsiBuilderUtil.expect(builder2, JavaTokenType.SEMICOLON)) {
                if (!missingSemicolon) {
                    BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.semicolon", new Object[0]));
                }
                if (!PsiBuilderUtil.expect(builder2, JavaTokenType.RPARENTH)) {
                    BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.FOR_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
                    PsiBuilder.Marker marker = statement;
                    if (marker == null) {
                        BasicStatementParser.$$$reportNull$$$0(13);
                    }
                    return marker;
                }
            } else {
                this.parseForUpdateExpressions(builder2);
                if (!PsiBuilderUtil.expect(builder2, JavaTokenType.RPARENTH)) {
                    BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.rparen", new Object[0]));
                    BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.FOR_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
                    PsiBuilder.Marker marker = statement;
                    if (marker == null) {
                        BasicStatementParser.$$$reportNull$$$0(14);
                    }
                    return marker;
                }
            }
        }
        if ((bodyStatement = this.parseStatement(builder2)) == null) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.statement", new Object[0]));
        }
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.FOR_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            BasicStatementParser.$$$reportNull$$$0(15);
        }
        return marker;
    }

    private static IElementType getLastToken(PsiBuilder builder2) {
        IElementType token;
        int offset = -1;
        while (BasicElementTypes.BASIC_JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(token = builder2.rawLookup(offset))) {
            --offset;
        }
        return token;
    }

    private void parseForUpdateExpressions(PsiBuilder builder2) {
        PsiBuilder.Marker expressionStatement;
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder2);
        if (expr == null) {
            return;
        }
        if (builder2.getTokenType() != JavaTokenType.COMMA) {
            expressionStatement = expr.precede();
            BasicJavaParserUtil.done(expressionStatement, this.myJavaElementTypeContainer.EXPRESSION_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        } else {
            PsiBuilder.Marker expressionList = expr.precede();
            expressionStatement = expressionList.precede();
            do {
                builder2.advanceLexer();
                PsiBuilder.Marker nextExpression = this.myParser.getExpressionParser().parse(builder2);
                if (nextExpression != null) continue;
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
            } while (builder2.getTokenType() == JavaTokenType.COMMA);
            BasicJavaParserUtil.done(expressionList, this.myJavaElementTypeContainer.EXPRESSION_LIST, this.myWhiteSpaceAndCommentSetHolder);
            BasicJavaParserUtil.done(expressionStatement, this.myJavaElementTypeContainer.EXPRESSION_LIST_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        }
        expressionStatement.setCustomEdgeTokenBinders(null, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    @NotNull
    private PsiBuilder.Marker parseForEachFromColon(PsiBuilder builder2, PsiBuilder.Marker statement, IElementType foreachStatement) {
        builder2.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder2) == null) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
        }
        PsiBuilder.Marker marker = this.parserForEachFromRparenth(builder2, statement, foreachStatement);
        if (marker == null) {
            BasicStatementParser.$$$reportNull$$$0(16);
        }
        return marker;
    }

    private PsiBuilder.Marker parserForEachFromRparenth(PsiBuilder builder2, PsiBuilder.Marker statement, IElementType forEachType2) {
        if (BasicJavaParserUtil.expectOrError(builder2, JavaTokenType.RPARENTH, "expected.rparen") && this.parseStatement(builder2) == null) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.statement", new Object[0]));
        }
        BasicJavaParserUtil.done(statement, forEachType2, this.myWhiteSpaceAndCommentSetHolder);
        return statement;
    }

    @NotNull
    private PsiBuilder.Marker parseDoWhileStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement = builder2.mark();
        builder2.advanceLexer();
        PsiBuilder.Marker body2 = this.parseStatement(builder2);
        if (body2 == null) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.statement", new Object[0]));
        } else if (!PsiBuilderUtil.expect(builder2, JavaTokenType.WHILE_KEYWORD)) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.while", new Object[0]));
        } else if (this.parseExprInParenth(builder2)) {
            BasicJavaParserUtil.semicolon(builder2);
        }
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.DO_WHILE_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            BasicStatementParser.$$$reportNull$$$0(17);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseSwitchStatement(PsiBuilder builder2) {
        PsiBuilder.Marker marker = this.parseExprInParenthWithBlock(builder2, this.myJavaElementTypeContainer.SWITCH_STATEMENT, true);
        if (marker == null) {
            BasicStatementParser.$$$reportNull$$$0(18);
        }
        return marker;
    }

    @NotNull
    @ApiStatus.Internal
    public @NotNull Pair<@Nullable PsiBuilder.Marker, Boolean> parseCaseLabel(PsiBuilder builder2) {
        if (builder2.getTokenType() == JavaTokenType.DEFAULT_KEYWORD) {
            PsiBuilder.Marker defaultElement = builder2.mark();
            builder2.advanceLexer();
            BasicJavaParserUtil.done(defaultElement, this.myJavaElementTypeContainer.DEFAULT_CASE_LABEL_ELEMENT, this.myWhiteSpaceAndCommentSetHolder);
            Pair<PsiBuilder.Marker, Boolean> pair = Pair.create(defaultElement, false);
            if (pair == null) {
                BasicStatementParser.$$$reportNull$$$0(19);
            }
            return pair;
        }
        if (this.myParser.getPatternParser().isPattern(builder2)) {
            PsiBuilder.Marker pattern = this.myParser.getPatternParser().parsePattern(builder2);
            Pair<PsiBuilder.Marker, Boolean> pair = Pair.create(pattern, false);
            if (pair == null) {
                BasicStatementParser.$$$reportNull$$$0(20);
            }
            return pair;
        }
        Pair<PsiBuilder.Marker, Boolean> pair = Pair.create(this.myParser.getExpressionParser().parseAssignmentForbiddingLambda(builder2), true);
        if (pair == null) {
            BasicStatementParser.$$$reportNull$$$0(21);
        }
        return pair;
    }

    private PsiBuilder.Marker parseSwitchLabelStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement = builder2.mark();
        boolean isCase = builder2.getTokenType() == JavaTokenType.CASE_KEYWORD;
        builder2.advanceLexer();
        if (isCase) {
            boolean patternsAllowed = BasicJavaParserUtil.getLanguageLevel(builder2).isAtLeast(LanguageLevel.JDK_17);
            PsiBuilder.Marker list = builder2.mark();
            do {
                Pair<PsiBuilder.Marker, Boolean> markerAndIsExpression = this.parseCaseLabel(builder2);
                PsiBuilder.Marker caseLabel = (PsiBuilder.Marker)markerAndIsExpression.first;
                if (caseLabel != null) continue;
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message(patternsAllowed ? "expected.case.label.element" : "expected.expression", new Object[0]));
            } while (PsiBuilderUtil.expect(builder2, JavaTokenType.COMMA));
            BasicJavaParserUtil.done(list, this.myJavaElementTypeContainer.CASE_LABEL_ELEMENT_LIST, this.myWhiteSpaceAndCommentSetHolder);
            this.parseGuard(builder2);
        }
        if (PsiBuilderUtil.expect(builder2, JavaTokenType.ARROW)) {
            PsiBuilder.Marker body2;
            if (builder2.getTokenType() == JavaTokenType.LBRACE) {
                body2 = builder2.mark();
                this.parseCodeBlock(builder2, true);
                body2.done(this.myJavaElementTypeContainer.BLOCK_STATEMENT);
                if (builder2.getTokenType() == JavaTokenType.SEMICOLON) {
                    PsiBuilder.Marker mark = builder2.mark();
                    while (builder2.getTokenType() == JavaTokenType.SEMICOLON) {
                        builder2.advanceLexer();
                    }
                    mark.error(JavaPsiBundle.message("expected.switch.label", new Object[0]));
                }
            } else if (builder2.getTokenType() == JavaTokenType.THROW_KEYWORD) {
                this.parseThrowStatement(builder2);
            } else {
                PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder2);
                if (expr != null) {
                    body2 = expr.precede();
                    BasicJavaParserUtil.semicolon(builder2);
                    body2.done(this.myJavaElementTypeContainer.EXPRESSION_STATEMENT);
                } else {
                    BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.switch.rule", new Object[0]));
                    PsiBuilderUtil.expect(builder2, JavaTokenType.SEMICOLON);
                }
            }
            BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.SWITCH_LABELED_RULE, this.myWhiteSpaceAndCommentSetHolder);
        } else {
            BasicJavaParserUtil.expectOrError(builder2, JavaTokenType.COLON, "expected.colon.or.arrow");
            BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.SWITCH_LABEL_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        }
        return statement;
    }

    private void parseGuard(PsiBuilder builder2) {
        if (builder2.getTokenType() == JavaTokenType.IDENTIFIER && "when".equals(builder2.getTokenText())) {
            builder2.remapCurrentToken(JavaTokenType.WHEN_KEYWORD);
            builder2.advanceLexer();
            PsiBuilder.Marker guardingExpression = this.myParser.getExpressionParser().parseAssignmentForbiddingLambda(builder2);
            if (guardingExpression == null) {
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
        }
    }

    @NotNull
    private PsiBuilder.Marker parseBreakStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement = builder2.mark();
        builder2.advanceLexer();
        PsiBuilderUtil.expect(builder2, JavaTokenType.IDENTIFIER);
        BasicJavaParserUtil.semicolon(builder2);
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.BREAK_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            BasicStatementParser.$$$reportNull$$$0(22);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseYieldStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement = builder2.mark();
        builder2.remapCurrentToken(JavaTokenType.YIELD_KEYWORD);
        builder2.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder2) == null) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
        } else {
            BasicJavaParserUtil.semicolon(builder2);
        }
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.YIELD_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            BasicStatementParser.$$$reportNull$$$0(23);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseContinueStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement = builder2.mark();
        builder2.advanceLexer();
        PsiBuilderUtil.expect(builder2, JavaTokenType.IDENTIFIER);
        BasicJavaParserUtil.semicolon(builder2);
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.CONTINUE_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            BasicStatementParser.$$$reportNull$$$0(24);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseReturnStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement = builder2.mark();
        builder2.advanceLexer();
        this.myParser.getExpressionParser().parse(builder2);
        BasicJavaParserUtil.semicolon(builder2);
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.RETURN_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            BasicStatementParser.$$$reportNull$$$0(25);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseThrowStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement = builder2.mark();
        builder2.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder2) == null) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
        } else {
            BasicJavaParserUtil.semicolon(builder2);
        }
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.THROW_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            BasicStatementParser.$$$reportNull$$$0(26);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseSynchronizedStatement(PsiBuilder builder2) {
        PsiBuilder.Marker marker = this.parseExprInParenthWithBlock(builder2, this.myJavaElementTypeContainer.SYNCHRONIZED_STATEMENT, true);
        if (marker == null) {
            BasicStatementParser.$$$reportNull$$$0(27);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseTryStatement(PsiBuilder builder2) {
        PsiBuilder.Marker tryBlock;
        boolean hasResourceList;
        PsiBuilder.Marker statement = builder2.mark();
        builder2.advanceLexer();
        boolean bl = hasResourceList = builder2.getTokenType() == JavaTokenType.LPARENTH;
        if (hasResourceList) {
            this.myParser.getDeclarationParser().parseResourceList(builder2);
        }
        if ((tryBlock = this.parseCodeBlock(builder2, true)) == null) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.lbrace", new Object[0]));
        } else if (!hasResourceList && !TRY_CLOSERS_SET.contains(builder2.getTokenType())) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.catch.or.finally", new Object[0]));
        } else {
            PsiBuilder.Marker finallyBlock;
            while (builder2.getTokenType() == JavaTokenType.CATCH_KEYWORD && this.parseCatchBlock(builder2)) {
            }
            if (PsiBuilderUtil.expect(builder2, JavaTokenType.FINALLY_KEYWORD) && (finallyBlock = this.parseCodeBlock(builder2, true)) == null) {
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.lbrace", new Object[0]));
            }
        }
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.TRY_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            BasicStatementParser.$$$reportNull$$$0(28);
        }
        return marker;
    }

    public boolean parseCatchBlock(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            BasicStatementParser.$$$reportNull$$$0(29);
        }
        assert (builder2.getTokenType() == JavaTokenType.CATCH_KEYWORD) : builder2.getTokenType();
        PsiBuilder.Marker section = builder2.mark();
        builder2.advanceLexer();
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.LPARENTH)) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.lparen", new Object[0]));
            BasicJavaParserUtil.done(section, this.myJavaElementTypeContainer.CATCH_SECTION, this.myWhiteSpaceAndCommentSetHolder);
            return false;
        }
        PsiBuilder.Marker param = this.myParser.getDeclarationParser().parseParameter(builder2, false, true, false);
        if (param == null) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.parameter", new Object[0]));
        }
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.RPARENTH)) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.rparen", new Object[0]));
            BasicJavaParserUtil.done(section, this.myJavaElementTypeContainer.CATCH_SECTION, this.myWhiteSpaceAndCommentSetHolder);
            return false;
        }
        PsiBuilder.Marker body2 = this.parseCodeBlock(builder2, true);
        if (body2 == null) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.lbrace", new Object[0]));
            BasicJavaParserUtil.done(section, this.myJavaElementTypeContainer.CATCH_SECTION, this.myWhiteSpaceAndCommentSetHolder);
            return false;
        }
        BasicJavaParserUtil.done(section, this.myJavaElementTypeContainer.CATCH_SECTION, this.myWhiteSpaceAndCommentSetHolder);
        return true;
    }

    @NotNull
    private PsiBuilder.Marker parseAssertStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement = builder2.mark();
        builder2.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder2) == null) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.boolean.expression", new Object[0]));
        } else if (PsiBuilderUtil.expect(builder2, JavaTokenType.COLON) && this.myParser.getExpressionParser().parse(builder2) == null) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
        } else {
            BasicJavaParserUtil.semicolon(builder2);
        }
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.ASSERT_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            BasicStatementParser.$$$reportNull$$$0(30);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseBlockStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement = builder2.mark();
        this.parseCodeBlock(builder2, true);
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.BLOCK_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            BasicStatementParser.$$$reportNull$$$0(31);
        }
        return marker;
    }

    @NotNull
    public PsiBuilder.Marker parseExprInParenthWithBlock(@NotNull PsiBuilder builder2, @NotNull IElementType type2, boolean block) {
        if (builder2 == null) {
            BasicStatementParser.$$$reportNull$$$0(32);
        }
        if (type2 == null) {
            BasicStatementParser.$$$reportNull$$$0(33);
        }
        PsiBuilder.Marker statement = builder2.mark();
        builder2.advanceLexer();
        if (this.parseExprInParenth(builder2)) {
            PsiBuilder.Marker body2;
            PsiBuilder.Marker marker = body2 = block ? this.parseCodeBlock(builder2, true) : this.parseStatement(builder2);
            if (body2 == null) {
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message(block ? "expected.lbrace" : "expected.statement", new Object[0]));
            }
        }
        BasicJavaParserUtil.done(statement, type2, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            BasicStatementParser.$$$reportNull$$$0(34);
        }
        return marker;
    }

    private boolean parseExprInParenth(PsiBuilder builder2) {
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.LPARENTH)) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.lparen", new Object[0]));
            return false;
        }
        PsiBuilder.Marker beforeExpr = builder2.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder2);
        if (expr == null || builder2.getTokenType() == JavaTokenType.SEMICOLON) {
            beforeExpr.rollbackTo();
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
            if (builder2.getTokenType() != JavaTokenType.RPARENTH) {
                return false;
            }
        } else {
            beforeExpr.drop();
            if (builder2.getTokenType() != JavaTokenType.RPARENTH) {
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.rparen", new Object[0]));
                return false;
            }
        }
        builder2.advanceLexer();
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 34: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/parser/BasicStatementParser";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/parser/BasicStatementParser";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parseIfStatement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseWhileStatement";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parseForStatement";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "parseForLoopFromInitializer";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "parseForEachFromColon";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDoWhileStatement";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSwitchStatement";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCaseLabel";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBreakStatement";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "parseYieldStatement";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "parseContinueStatement";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "parseReturnStatement";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "parseThrowStatement";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSynchronizedStatement";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTryStatement";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAssertStatement";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBlockStatement";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "parseExprInParenthWithBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseCodeBlock";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseCodeBlockDeep";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseStatements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isStmtYieldToken";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 34: {
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "parseCatchBlock";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "parseExprInParenthWithBlock";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 34: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum BraceMode {
        TILL_FIRST,
        TILL_LAST;

    }
}

