/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ModuleLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.Closure;
import org.jetbrains.kotlin.backend.common.lower.ClosureAnnotator;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptFixLambdasTransformer;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptFixLambdasTransformerContext;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptToClassTransformer;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptToClassTransformerContext;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptsToClassesLowering;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptsToClassesSymbolRemapper;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReporterWithContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrPropertyBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragmentsKt;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrClassImpl;
import org.jetbrains.kotlin.ir.descriptors.IrBasedDescriptorsKt;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrScriptSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrAnonymousInitializerSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrConstructorSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SimpleTypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmBackendErrors;
import org.jetbrains.kotlin.utils.SortUtilsKt;

@PhaseDescription(name="ScriptsToClasses", description="Put script declarations into classes")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002JH\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112.\u0010\u001d\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f0\u001ej\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f`\"H\u0002J\f\u0010)\u001a\u00020\t*\u00020\rH\u0002J \u0010*\u001a\u00020\t*\u00020\r2\u0006\u0010+\u001a\u00020,2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010#\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b%\u0010&\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ScriptsToClassesLowering;", "Lorg/jetbrains/kotlin/backend/common/ModuleLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "prepareScriptClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irScript", "Lorg/jetbrains/kotlin/ir/declarations/IrScript;", "collectCapturingClasses", "", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrClassImpl;", "typeRemapper", "Lorg/jetbrains/kotlin/ir/util/SimpleTypeRemapper;", "finalizeScriptClass", "symbolRemapper", "Lorg/jetbrains/kotlin/backend/jvm/lower/ScriptsToClassesSymbolRemapper;", "createConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "irScriptClass", "implicitReceiversFieldsWithParameters", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lkotlin/collections/ArrayList;", "scriptingJvmPackage", "Lorg/jetbrains/kotlin/ir/declarations/IrExternalPackageFragment;", "getScriptingJvmPackage", "()Lorg/jetbrains/kotlin/ir/declarations/IrExternalPackageFragment;", "scriptingJvmPackage$delegate", "Lkotlin/Lazy;", "addScriptMainFun", "addSimplePropertyFrom", "from", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "initializer", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nScriptLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ScriptsToClassesLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 5 ScriptLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ScriptLoweringKt\n+ 6 ScriptLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ScriptLoweringKt$addAnonymousInitializer$1\n+ 7 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 8 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 9 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,1124:1\n1#2:1125\n1557#3:1126\n1628#3,3:1127\n1863#3,2:1134\n1863#3,2:1136\n1863#3,2:1138\n1557#3:1140\n1628#3,2:1141\n1630#3:1154\n1863#3:1155\n1864#3:1181\n1557#3:1182\n1628#3,3:1183\n1863#3,2:1186\n50#4,4:1130\n80#4:1143\n74#4,10:1144\n50#4,4:1188\n349#4,6:1192\n249#4:1210\n243#4:1211\n237#4,10:1212\n349#4,6:1222\n127#4:1228\n121#4,10:1229\n74#4,4:1239\n1086#5,3:1156\n1089#5,9:1160\n1086#6:1159\n416#7,10:1169\n72#8,2:1179\n350#9,12:1198\n*S KotlinDebug\n*F\n+ 1 ScriptLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ScriptsToClassesLowering\n*L\n69#1:1126\n69#1:1127,3\n115#1:1134,2\n116#1:1136,2\n119#1:1138,2\n221#1:1140\n221#1:1141,2\n221#1:1154\n256#1:1155\n256#1:1181\n328#1:1182\n328#1:1183,3\n344#1:1186,2\n88#1:1130,4\n222#1:1143\n222#1:1144,10\n360#1:1188,4\n369#1:1192,6\n385#1:1210\n385#1:1211\n385#1:1212,10\n391#1:1222,6\n418#1:1228\n418#1:1229,10\n422#1:1239,4\n273#1:1156,3\n273#1:1160,9\n273#1:1159\n275#1:1169,10\n275#1:1179,2\n379#1:1198,12\n*E\n"})
public final class ScriptsToClassesLowering
implements ModuleLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final Lazy scriptingJvmPackage$delegate;

    public ScriptsToClassesLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.scriptingJvmPackage$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> ScriptsToClassesLowering.scriptingJvmPackage_delegate$lambda$26(this));
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void lower(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkNotNullParameter((Object)irModule, (String)"irModule");
        List scripts = new ArrayList();
        Map scriptDependencies = new LinkedHashMap();
        for (IrFile irFile : irModule.getFiles()) {
            ListIterator<IrDeclaration> iterator2 = irFile.getDeclarations().listIterator();
            while (iterator2.hasNext()) {
                List<IrScriptSymbol> list;
                IrDeclaration declaration2 = iterator2.next();
                if (!(declaration2 instanceof IrScript)) continue;
                IrClass scriptClass = this.prepareScriptClass(irFile, (IrScript)declaration2);
                scripts.add(declaration2);
                List<IrScriptSymbol> it = list = ((IrScript)declaration2).getImportedScripts();
                boolean bl = false;
                Object object = it;
                List<IrScriptSymbol> list2 = !(object == null || object.isEmpty()) ? list : null;
                if (list2 != null) {
                    void $this$mapTo$iv$iv;
                    it = list2;
                    boolean bl2 = false;
                    object = scriptDependencies;
                    IrDeclaration irDeclaration2 = declaration2;
                    Iterable $this$map$iv = it;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        IrScriptSymbol irScriptSymbol = (IrScriptSymbol)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add((IrScript)it2.getOwner());
                    }
                    List list3 = (List)destination$iv$iv;
                    object.put(irDeclaration2, list3);
                }
                iterator2.set(scriptClass);
            }
        }
        ScriptsToClassesSymbolRemapper symbolRemapper = new ScriptsToClassesSymbolRemapper();
        List orderedScripts = CollectionsKt.reversed((Iterable)SortUtilsKt.topologicalSort$default(scripts, null, arg_0 -> ScriptsToClassesLowering.lower$lambda$3(scriptDependencies, arg_0), 2, null));
        for (IrScript irScript : orderedScripts) {
            this.finalizeScriptClass(irScript, symbolRemapper);
            IrClassSymbol irClassSymbol = irScript.getTargetClass();
            Intrinsics.checkNotNull((Object)irClassSymbol);
            PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irClassSymbol.getOwner(), irScript.getParent());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final IrClass prepareScriptClass(IrFile irFile, IrScript irScript) {
        IrClass irClass;
        Name name2;
        void it;
        IrFileEntry fileEntry = irFile.getFileEntry();
        IrFactory $this$buildClass$iv = this.context.getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
        boolean bl = false;
        IrClassBuilder $this$prepareScriptClass_u24lambda_u245 = $this$buildClass_u24lambda_u241$iv;
        boolean bl2 = false;
        $this$prepareScriptClass_u24lambda_u245.setStartOffset(0);
        $this$prepareScriptClass_u24lambda_u245.setEndOffset(fileEntry.getMaxOffset());
        $this$prepareScriptClass_u24lambda_u245.setOrigin(IrDeclarationOrigin.Companion.getSCRIPT_CLASS());
        Name name3 = irScript.getName();
        IrClassBuilder irClassBuilder = $this$prepareScriptClass_u24lambda_u245;
        boolean bl3 = false;
        if (it.isSpecial()) {
            String string2 = it.asStringStripSpecialMarkers();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asStringStripSpecialMarkers(...)");
            name2 = NameUtils.getScriptNameForFile(StringsKt.removePrefix((String)string2, (CharSequence)"script-"));
        } else {
            name2 = it;
        }
        irClassBuilder.setName(name2);
        $this$prepareScriptClass_u24lambda_u245.setKind(ClassKind.CLASS);
        $this$prepareScriptClass_u24lambda_u245.setVisibility(DescriptorVisibilities.PUBLIC);
        $this$prepareScriptClass_u24lambda_u245.setModality(Modality.FINAL);
        IrClass irScriptClass = irClass = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$buildClass_u24lambda_u241$iv);
        boolean bl4 = false;
        Collection collection = irScriptClass.getSuperTypes();
        IrType irType = irScript.getBaseClass();
        if (irType == null) {
            irType = this.context.getIrBuiltIns().getAnyNType();
        }
        irScriptClass.setSuperTypes(CollectionsKt.plus((Collection)collection, (Object)irType));
        irScriptClass.setParent(irFile);
        irScriptClass.setMetadata(irScript.getMetadata());
        irScript.setTargetClass(irScriptClass.getSymbol());
        return irClass;
    }

    private final Set<IrClassImpl> collectCapturingClasses(IrScript irScript, SimpleTypeRemapper typeRemapper) {
        IrScriptSymbol it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Set set;
        ClosureAnnotator annotator = new ClosureAnnotator(irScript, irScript);
        Set capturingClasses = new LinkedHashSet();
        Set it2 = set = (Set)new LinkedHashSet();
        boolean bl = false;
        IrValueParameter irValueParameter = irScript.getThisReceiver();
        org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(it2, irValueParameter != null ? irValueParameter.getType() : null);
        Set scriptsReceivers = set;
        List<IrScriptSymbol> list = irScript.getEarlierScripts();
        if (list != null) {
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (IrScriptSymbol)element$iv;
                boolean bl2 = false;
                IrValueParameter irValueParameter2 = ((IrScript)it.getOwner()).getThisReceiver();
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(scriptsReceivers, irValueParameter2 != null ? irValueParameter2.getType() : null);
            }
        }
        List<IrScriptSymbol> list2 = irScript.getImportedScripts();
        if (list2 != null) {
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (IrScriptSymbol)element$iv;
                boolean bl3 = false;
                IrClassSymbol irClassSymbol = ((IrScript)it.getOwner()).getTargetClass();
                Intrinsics.checkNotNull((Object)irClassSymbol);
                IrValueParameter irValueParameter3 = ((IrClass)irClassSymbol.getOwner()).getThisReceiver();
                Intrinsics.checkNotNull((Object)irValueParameter3);
                scriptsReceivers.add(irValueParameter3.getType());
            }
        }
        Iterable $this$forEach$iv2 = irScript.getImplicitReceiversParameters();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            IrValueParameter it3 = (IrValueParameter)element$iv;
            boolean bl4 = false;
            scriptsReceivers.add(it3.getType());
            scriptsReceivers.add(typeRemapper.remapType(it3.getType()));
        }
        IrElementVisitorVoid collector2 = new IrElementVisitorVoid(annotator, irScript, this, capturingClasses, scriptsReceivers){
            final /* synthetic */ ClosureAnnotator $annotator;
            final /* synthetic */ IrScript $irScript;
            final /* synthetic */ ScriptsToClassesLowering this$0;
            final /* synthetic */ Set<IrClassImpl> $capturingClasses;
            final /* synthetic */ Set<IrType> $scriptsReceivers;
            {
                this.$annotator = $annotator;
                this.$irScript = $irScript;
                this.this$0 = $receiver;
                this.$capturingClasses = $capturingClasses;
                this.$scriptsReceivers = $scriptsReceivers;
            }

            public void visitElement(IrElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                IrVisitorsKt.acceptChildrenVoid(element2, this);
            }

            /*
             * WARNING - void declaration
             */
            public void visitClass(IrClass declaration2) {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                if (declaration2 instanceof IrClassImpl && !((IrClassImpl)declaration2).isInner()) {
                    boolean bl;
                    Object object;
                    Object object2;
                    block20: {
                        void $this$any$iv;
                        Closure closure = this.$annotator.getClassClosure(declaration2);
                        object2 = closure.getCapturedValues();
                        object = this.$scriptsReceivers;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                IrValueSymbol it = (IrValueSymbol)element$iv;
                                boolean bl2 = false;
                                if (!object.contains(it.getOwner().getType())) continue;
                                bl = true;
                                break block20;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        if (IrUtilsKt.isInterface(declaration2)) {
                            collectCapturingClasses.collector.1.visitClass$reportError$default(this.this$0, declaration2, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_INTERFACE(), null, 8, null);
                        } else if (IrUtilsKt.isEnumClass(declaration2)) {
                            collectCapturingClasses.collector.1.visitClass$reportError$default(this.this$0, declaration2, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_ENUM(), null, 8, null);
                        } else if (IrUtilsKt.isEnumEntry(declaration2)) {
                            collectCapturingClasses.collector.1.visitClass$reportError$default(this.this$0, declaration2, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_ENUM_ENTRY(), null, 8, null);
                        } else if (((IrClassImpl)declaration2).isCompanion()) {
                            collectCapturingClasses.collector.1.visitClass$reportError(this.this$0, declaration2, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_OBJECT(), SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
                        } else if (((IrClassImpl)declaration2).getKind().isSingleton()) {
                            collectCapturingClasses.collector.1.visitClass$reportError$default(this.this$0, declaration2, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_OBJECT(), null, 8, null);
                        } else if (IrUtilsKt.isClass(declaration2)) {
                            if (!Intrinsics.areEqual((Object)declaration2.getParent(), (Object)this.$irScript)) {
                                object = declaration2.getParent();
                                IrClass irClass = object instanceof IrClass ? (IrClass)object : null;
                                boolean bl3 = irClass != null ? !irClass.isInner() : false;
                                if (bl3) {
                                    KtDiagnosticReporterWithContext.DiagnosticContextImpl diagnosticContextImpl = this.this$0.getContext().getKtDiagnosticReporter().at(declaration2);
                                    KtDiagnosticFactory2<String, String> ktDiagnosticFactory2 = JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_NESTED_CLASS();
                                    String string2 = ((IrClassImpl)declaration2).getName().asString();
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                                    IrDeclarationParent irDeclarationParent = declaration2.getParent();
                                    Object object3 = irDeclarationParent instanceof IrDeclarationWithName ? (IrDeclarationWithName)((Object)irDeclarationParent) : null;
                                    if (object3 == null || (object3 = object3.getName()) == null) {
                                        object3 = SpecialNames.NO_NAME_PROVIDED;
                                    }
                                    object2 = ((Name)object3).asString();
                                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"asString(...)");
                                    diagnosticContextImpl.report(ktDiagnosticFactory2, string2, object2);
                                }
                            } else {
                                this.$capturingClasses.add((IrClassImpl)declaration2);
                            }
                        }
                    }
                }
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
            }

            public void visitElement(IrElement element2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElement(this, element2, data);
            }

            public void visitDeclaration(IrDeclarationBase declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data);
            }

            public void visitDeclaration(IrDeclarationBase declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
            }

            public void visitValueParameter(IrValueParameter declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data);
            }

            public void visitValueParameter(IrValueParameter declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
            }

            public void visitClass(IrClass declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data);
            }

            public void visitAnonymousInitializer(IrAnonymousInitializer declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
            }

            public void visitAnonymousInitializer(IrAnonymousInitializer declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
            }

            public void visitTypeParameter(IrTypeParameter declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data);
            }

            public void visitTypeParameter(IrTypeParameter declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
            }

            public void visitFunction(IrFunction declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data);
            }

            public void visitFunction(IrFunction declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
            }

            public void visitConstructor(IrConstructor declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data);
            }

            public void visitConstructor(IrConstructor declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
            }

            public void visitEnumEntry(IrEnumEntry declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data);
            }

            public void visitEnumEntry(IrEnumEntry declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
            }

            public void visitErrorDeclaration(IrErrorDeclaration declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
            }

            public void visitErrorDeclaration(IrErrorDeclaration declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
            }

            public void visitField(IrField declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data);
            }

            public void visitField(IrField declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
            }

            public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
            }

            public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
            }

            public void visitModuleFragment(IrModuleFragment declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data);
            }

            public void visitModuleFragment(IrModuleFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
            }

            public void visitProperty(IrProperty declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data);
            }

            public void visitProperty(IrProperty declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
            }

            public void visitScript(IrScript declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data);
            }

            public void visitScript(IrScript declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
            }

            public void visitSimpleFunction(IrSimpleFunction declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data);
            }

            public void visitSimpleFunction(IrSimpleFunction declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
            }

            public void visitTypeAlias(IrTypeAlias declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data);
            }

            public void visitTypeAlias(IrTypeAlias declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
            }

            public void visitVariable(IrVariable declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data);
            }

            public void visitVariable(IrVariable declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
            }

            public void visitPackageFragment(IrPackageFragment declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data);
            }

            public void visitPackageFragment(IrPackageFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
            }

            public void visitExternalPackageFragment(IrExternalPackageFragment declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
            }

            public void visitExternalPackageFragment(IrExternalPackageFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
            }

            public void visitFile(IrFile declaration2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data);
            }

            public void visitFile(IrFile declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
            }

            public void visitExpression(IrExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
            }

            public void visitExpression(IrExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
            }

            public void visitBody(IrBody body2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
            }

            public void visitBody(IrBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
            }

            public void visitExpressionBody(IrExpressionBody body2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
            }

            public void visitExpressionBody(IrExpressionBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
            }

            public void visitBlockBody(IrBlockBody body2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
            }

            public void visitBlockBody(IrBlockBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
            }

            public void visitDeclarationReference(IrDeclarationReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
            }

            public void visitDeclarationReference(IrDeclarationReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
            }

            public void visitMemberAccess(IrMemberAccessExpression<?> expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
            }

            public void visitMemberAccess(IrMemberAccessExpression<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
            }

            public void visitFunctionAccess(IrFunctionAccessExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
            }

            public void visitFunctionAccess(IrFunctionAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
            }

            public void visitConstructorCall(IrConstructorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
            }

            public void visitConstructorCall(IrConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
            }

            public void visitSingletonReference(IrGetSingletonValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
            }

            public void visitSingletonReference(IrGetSingletonValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
            }

            public void visitGetObjectValue(IrGetObjectValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
            }

            public void visitGetObjectValue(IrGetObjectValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
            }

            public void visitGetEnumValue(IrGetEnumValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
            }

            public void visitGetEnumValue(IrGetEnumValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
            }

            public void visitRawFunctionReference(IrRawFunctionReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
            }

            public void visitRawFunctionReference(IrRawFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
            }

            public void visitContainerExpression(IrContainerExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
            }

            public void visitContainerExpression(IrContainerExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
            }

            public void visitBlock(IrBlock expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
            }

            public void visitBlock(IrBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
            }

            public void visitComposite(IrComposite expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
            }

            public void visitComposite(IrComposite expression2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
            }

            public void visitReturnableBlock(IrReturnableBlock expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2, data);
            }

            public void visitReturnableBlock(IrReturnableBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2);
            }

            public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
            }

            public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock) {
                IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock);
            }

            public void visitSyntheticBody(IrSyntheticBody body2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
            }

            public void visitSyntheticBody(IrSyntheticBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
            }

            public void visitBreakContinue(IrBreakContinue jump, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
            }

            public void visitBreakContinue(IrBreakContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
            }

            public void visitBreak(IrBreak jump, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
            }

            public void visitBreak(IrBreak jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
            }

            public void visitContinue(IrContinue jump, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
            }

            public void visitContinue(IrContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
            }

            public void visitCall(IrCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
            }

            public void visitCall(IrCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
            }

            public void visitCallableReference(IrCallableReference<?> expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
            }

            public void visitCallableReference(IrCallableReference<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
            }

            public void visitFunctionReference(IrFunctionReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
            }

            public void visitFunctionReference(IrFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
            }

            public void visitPropertyReference(IrPropertyReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
            }

            public void visitPropertyReference(IrPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
            }

            public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
            }

            public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
            }

            public void visitClassReference(IrClassReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
            }

            public void visitClassReference(IrClassReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
            }

            public void visitConst(IrConst expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
            }

            public void visitConst(IrConst expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
            }

            public void visitConstantValue(IrConstantValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data);
            }

            public void visitConstantValue(IrConstantValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
            }

            public void visitConstantPrimitive(IrConstantPrimitive expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data);
            }

            public void visitConstantPrimitive(IrConstantPrimitive expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
            }

            public void visitConstantObject(IrConstantObject expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data);
            }

            public void visitConstantObject(IrConstantObject expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
            }

            public void visitConstantArray(IrConstantArray expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data);
            }

            public void visitConstantArray(IrConstantArray expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
            }

            public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
            }

            public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
            }

            public void visitDynamicExpression(IrDynamicExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
            }

            public void visitDynamicExpression(IrDynamicExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
            }

            public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
            }

            public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
            }

            public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
            }

            public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
            }

            public void visitEnumConstructorCall(IrEnumConstructorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
            }

            public void visitEnumConstructorCall(IrEnumConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
            }

            public void visitErrorExpression(IrErrorExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
            }

            public void visitErrorExpression(IrErrorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
            }

            public void visitErrorCallExpression(IrErrorCallExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
            }

            public void visitErrorCallExpression(IrErrorCallExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
            }

            public void visitFieldAccess(IrFieldAccessExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
            }

            public void visitFieldAccess(IrFieldAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
            }

            public void visitGetField(IrGetField expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
            }

            public void visitGetField(IrGetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
            }

            public void visitSetField(IrSetField expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
            }

            public void visitSetField(IrSetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
            }

            public void visitFunctionExpression(IrFunctionExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
            }

            public void visitFunctionExpression(IrFunctionExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
            }

            public void visitGetClass(IrGetClass expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
            }

            public void visitGetClass(IrGetClass expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
            }

            public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
            }

            public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
            }

            public void visitLoop(IrLoop loop, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop, data);
            }

            public void visitLoop(IrLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop);
            }

            public void visitWhileLoop(IrWhileLoop loop, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop, data);
            }

            public void visitWhileLoop(IrWhileLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop);
            }

            public void visitDoWhileLoop(IrDoWhileLoop loop, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop, data);
            }

            public void visitDoWhileLoop(IrDoWhileLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop);
            }

            public void visitReturn(IrReturn expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
            }

            public void visitReturn(IrReturn expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
            }

            public void visitStringConcatenation(IrStringConcatenation expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
            }

            public void visitStringConcatenation(IrStringConcatenation expression2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
            }

            public void visitSuspensionPoint(IrSuspensionPoint expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
            }

            public void visitSuspensionPoint(IrSuspensionPoint expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
            }

            public void visitSuspendableExpression(IrSuspendableExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
            }

            public void visitSuspendableExpression(IrSuspendableExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
            }

            public void visitThrow(IrThrow expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
            }

            public void visitThrow(IrThrow expression2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
            }

            public void visitTry(IrTry aTry, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
            }

            public void visitTry(IrTry aTry) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
            }

            public void visitCatch(IrCatch aCatch, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
            }

            public void visitCatch(IrCatch aCatch) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
            }

            public void visitTypeOperator(IrTypeOperatorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
            }

            public void visitTypeOperator(IrTypeOperatorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
            }

            public void visitValueAccess(IrValueAccessExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
            }

            public void visitValueAccess(IrValueAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
            }

            public void visitGetValue(IrGetValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
            }

            public void visitGetValue(IrGetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
            }

            public void visitSetValue(IrSetValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
            }

            public void visitSetValue(IrSetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
            }

            public void visitVararg(IrVararg expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
            }

            public void visitVararg(IrVararg expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
            }

            public void visitSpreadElement(IrSpreadElement spread, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
            }

            public void visitSpreadElement(IrSpreadElement spread) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
            }

            public void visitWhen(IrWhen expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
            }

            public void visitWhen(IrWhen expression2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
            }

            public void visitBranch(IrBranch branch, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
            }

            public void visitBranch(IrBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
            }

            public void visitElseBranch(IrElseBranch branch, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
            }

            public void visitElseBranch(IrElseBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
            }

            private static final void visitClass$reportError(ScriptsToClassesLowering this$0, IrClass $declaration, KtDiagnosticFactory1<String> factory2, Name name2) {
                KtDiagnosticReporterWithContext.DiagnosticContextImpl diagnosticContextImpl = this$0.getContext().getKtDiagnosticReporter().at($declaration);
                Name name3 = name2;
                if (name3 == null) {
                    name3 = ((IrClassImpl)$declaration).getName();
                }
                String string2 = name3.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                diagnosticContextImpl.report(factory2, string2);
            }

            static /* synthetic */ void visitClass$reportError$default(ScriptsToClassesLowering scriptsToClassesLowering, IrClass irClass, KtDiagnosticFactory1 ktDiagnosticFactory1, Name name2, int n, Object object) {
                if ((n & 8) != 0) {
                    name2 = null;
                }
                collectCapturingClasses.collector.1.visitClass$reportError(scriptsToClassesLowering, irClass, ktDiagnosticFactory1, name2);
            }
        };
        for (IrStatement statement : irScript.getStatements()) {
            if (!(statement instanceof IrClassImpl)) continue;
            collector2.visitClass((IrClass)statement);
        }
        return capturingClasses;
    }

    /*
     * WARNING - void declaration
     */
    private final void finalizeScriptClass(IrScript irScript, ScriptsToClassesSymbolRemapper symbolRemapper) {
        block10: {
            IrAnnotationContainer irAnnotationContainer;
            Object $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411;
            IrStatement irStatement;
            void $this$mapTo$iv$iv;
            if (irScript.getThisReceiver() == null) {
                IrSimpleTypeImpl type2 = new IrSimpleTypeImpl((IrClassifierSymbol)irScript.getSymbol(), false, CollectionsKt.emptyList(), CollectionsKt.emptyList(), null, 16, null);
                irScript.setThisReceiver(ScriptLoweringKt.access$createThisReceiverParameter(irScript, this.context, IrDeclarationOrigin.Companion.getINSTANCE_RECEIVER(), type2));
            }
            IrClassSymbol irClassSymbol = irScript.getTargetClass();
            Intrinsics.checkNotNull((Object)irClassSymbol);
            IrClass irScriptClass = (IrClass)irClassSymbol.getOwner();
            SimpleTypeRemapper typeRemapper = new SimpleTypeRemapper(symbolRemapper);
            Set<IrClassImpl> capturingClasses = this.collectCapturingClasses(irScript, typeRemapper);
            IrField earlierScriptField = ScriptLoweringKt.access$addEarlierScriptField(irScriptClass, irScript);
            ArrayList implicitReceiversFieldsWithParameters = ScriptLoweringKt.access$makeImplicitReceiversFieldsWithParameters(irScriptClass, typeRemapper, irScript);
            ScriptToClassTransformer scriptTransformer = new ScriptToClassTransformer(irScript, irScriptClass, typeRemapper, this.context, capturingClasses, earlierScriptField, implicitReceiversFieldsWithParameters);
            ScriptFixLambdasTransformer lambdaPatcher = new ScriptFixLambdasTransformer(irScriptClass);
            ScriptLoweringKt.access$patchDeclarationsDispatchReceiver(irScript, this.context, scriptTransformer.getScriptClassReceiver().getType());
            irScriptClass.setThisReceiver(scriptTransformer.getScriptClassReceiver());
            Object $this$map$iv = irScript.getExplicitCallParameters();
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void parameter2;
                irStatement = (IrVariable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                IrClass $this$addField$iv = irScriptClass;
                boolean $i$f$addField = false;
                Object $this$buildField$iv$iv = $this$addField$iv.getFactory();
                boolean $i$f$buildField = false;
                IrFieldBuilder $this$buildField_u24lambda_u244$iv$iv = new IrFieldBuilder();
                boolean bl2 = false;
                $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411 = $this$buildField_u24lambda_u244$iv$iv;
                boolean bl3 = false;
                ((IrElementBuilder)$this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411).setStartOffset(parameter2.getStartOffset());
                ((IrElementBuilder)$this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411).setEndOffset(parameter2.getEndOffset());
                ((IrDeclarationBuilder)$this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411).setOrigin(IrDeclarationOrigin.Companion.getSCRIPT_CALL_PARAMETER());
                ((IrDeclarationBuilder)$this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411).setName(parameter2.getName());
                ((IrFieldBuilder)$this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411).setType(parameter2.getType());
                ((IrDeclarationBuilder)$this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411).setVisibility(DescriptorVisibilities.LOCAL);
                ((IrFieldBuilder)$this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411).setFinal(true);
                Object field$iv = $this$buildField$iv$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv$iv, $this$buildField_u24lambda_u244$iv$iv);
                boolean bl4 = false;
                ((IrDeclarationBase)field$iv).setParent($this$addField$iv);
                $this$addField$iv.getDeclarations().add((IrDeclaration)field$iv);
                Object field = $this$buildField$iv$iv;
                collection.add(TuplesKt.to((Object)parameter2, (Object)field));
            }
            List explicitParametersWithFields = (List)destination$iv$iv;
            IrConstructor irConstructor = irScript.getConstructor();
            IrElement $i$f$map22 = irConstructor != null ? ScriptsToClassesLowering.finalizeScriptClass$patchDeclarationForClass((IrElement)irConstructor, irScriptClass, scriptTransformer, lambdaPatcher) : null;
            IrConstructor irConstructor2 = $i$f$map22 instanceof IrConstructor ? (IrConstructor)$i$f$map22 : null;
            if (irConstructor2 == null) {
                irConstructor2 = this.createConstructor(irScriptClass, irScript, implicitReceiversFieldsWithParameters);
            }
            Object constructor = $this$map$iv = irConstructor2;
            boolean bl = false;
            int explicitParamsStartIndex = irScript.getEarlierScriptsParameter() == null ? 0 : 1;
            List<IrValueParameter> explicitParameters = ((IrFunction)constructor).getValueParameters().subList(explicitParamsStartIndex, irScript.getExplicitCallParameters().size() + explicitParamsStartIndex);
            ((IrFunction)constructor).setBody(ScriptLoweringKt.access$makeScriptClassConstructorBody(LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)((IrConstructor)constructor).getSymbol(), 0, 0, 6, null), irScript, irScriptClass, explicitParameters, earlierScriptField, explicitParametersWithFields, implicitReceiversFieldsWithParameters));
            irScriptClass.getDeclarations().add((IrDeclaration)constructor);
            ((IrDeclarationBase)constructor).setParent(irScriptClass);
            boolean hasMain = false;
            Iterable $this$forEach$iv = irScript.getStatements();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$finalizeScriptClass_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414;
                void this_$iv$iv;
                Object object;
                IrDeclaration copy;
                IrStatement scriptStatement = (IrStatement)element$iv;
                boolean bl5 = false;
                irStatement = scriptStatement;
                if (irStatement instanceof IrVariable) {
                    IrElement irElement = ScriptsToClassesLowering.finalizeScriptClass$patchDeclarationForClass((IrElement)scriptStatement, irScriptClass, scriptTransformer, lambdaPatcher);
                    Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrVariable");
                    copy = (IrVariable)irElement;
                    ScriptsToClassesLowering.addSimplePropertyFrom$default(this, irScriptClass, copy, null, 2, null);
                    continue;
                }
                if (irStatement instanceof IrDeclaration) {
                    IrElement irElement = ScriptsToClassesLowering.finalizeScriptClass$patchDeclarationForClass((IrElement)scriptStatement, irScriptClass, scriptTransformer, lambdaPatcher);
                    Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
                    copy = (IrDeclaration)irElement;
                    irScriptClass.getDeclarations().add(copy);
                    if (!(copy instanceof IrSimpleFunction) || !Intrinsics.areEqual((Object)((IrSimpleFunction)copy).getName().asString(), (Object)"main")) continue;
                    hasMain = true;
                    continue;
                }
                IrElement irElement = ScriptsToClassesLowering.finalizeScriptClass$patchTopLevelStatementForClass((IrElement)scriptStatement, irScriptClass, scriptTransformer, lambdaPatcher);
                Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.IrStatement");
                IrStatement transformedStatement = (IrStatement)irElement;
                IrClass $this$addAnonymousInitializer_u24default$iv = irScriptClass;
                boolean $i$f$addAnonymousInitializer = false;
                IrFunctionBuilder $this$addAnonymousInitializer_u24lambda_u2412$iv = new IrFunctionBuilder();
                boolean bl6 = false;
                IrFunctionBuilder bl4 = $this$addAnonymousInitializer_u24lambda_u2412$iv;
                boolean bl7 = false;
                IrFunctionBuilder irFunctionBuilder = bl4;
                $this$addAnonymousInitializer_u24lambda_u2412$iv.setReturnType(IrUtilsKt.getDefaultType($this$addAnonymousInitializer_u24default$iv));
                Object anonymousInitializer$iv = $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411 = IrFactory.createAnonymousInitializer$default($this$addAnonymousInitializer_u24default$iv.getFactory(), $this$addAnonymousInitializer_u24lambda_u2412$iv.getStartOffset(), $this$addAnonymousInitializer_u24lambda_u2412$iv.getEndOffset(), $this$addAnonymousInitializer_u24lambda_u2412$iv.getOrigin(), new IrAnonymousInitializerSymbolImpl(null, 1, null), false, 16, null);
                boolean bl8 = false;
                $this$addAnonymousInitializer_u24default$iv.getDeclarations().add((IrDeclaration)anonymousInitializer$iv);
                ((IrDeclarationBase)anonymousInitializer$iv).setParent($this$addAnonymousInitializer_u24default$iv);
                Object irInitializer = object = $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411;
                boolean bl9 = false;
                IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)((IrAnonymousInitializer)irInitializer).getSymbol(), 0, 0, 6, null);
                int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
                int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
                boolean $i$f$irBlockBody = false;
                $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
                boolean $i$f$blockBody = false;
                void var29_45 = this_$iv$iv;
                Object object2 = irInitializer;
                boolean bl10 = false;
                if (transformedStatement instanceof IrComposite) {
                    for (IrStatement statement : ((IrComposite)transformedStatement).getStatements()) {
                        $this$finalizeScriptClass_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.unaryPlus(statement);
                    }
                } else {
                    $this$finalizeScriptClass_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.unaryPlus(transformedStatement);
                }
                ((IrAnonymousInitializer)object2).setBody(this_$iv$iv.doBuild());
            }
            if (!hasMain) {
                this.addScriptMainFun(irScriptClass);
            }
            Collection collection = irScriptClass.getAnnotations();
            IrDeclarationParent irDeclarationParent = irScriptClass.getParent();
            Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFile");
            irScriptClass.setAnnotations(CollectionsKt.plus((Collection)collection, (Iterable)((IrFile)irDeclarationParent).getAnnotations()));
            Object object = irScript.getResultProperty();
            if (object == null || (object = (IrProperty)object.getOwner()) == null) break block10;
            Object irResultProperty = object;
            boolean bl11 = false;
            this.context.getState().getScriptSpecific().setResultFieldName(irResultProperty.getName().getIdentifier());
            this.context.getState().getScriptSpecific().setResultType((irAnnotationContainer = ((IrProperty)irResultProperty).getBackingField()) != null && (irAnnotationContainer = irAnnotationContainer.getType()) != null ? IrBasedDescriptorsKt.toIrBasedKotlinType$default((IrType)irAnnotationContainer, null, 1, null) : null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final IrConstructor createConstructor(IrClass irScriptClass, IrScript irScript, ArrayList<Pair<IrField, IrValueParameter>> implicitReceiversFieldsWithParameters) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$createConstructor_u24lambda_u2425_u24lambda_u2424;
        IrValueParameter it;
        List list;
        Object object = new IrFunctionBuilder();
        IrFunctionBuilder $this$createConstructor_u24lambda_u2418 = object;
        boolean bl = false;
        $this$createConstructor_u24lambda_u2418.setPrimary(true);
        IrValueParameter irValueParameter = irScriptClass.getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        IrType irType = irValueParameter.getType();
        Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        $this$createConstructor_u24lambda_u2418.setReturnType((IrSimpleType)irType);
        IrFunctionBuilder $this$createConstructor_u24lambda_u2419 = object;
        boolean bl2 = false;
        Object irConstructor = object = irScriptClass.getFactory().createConstructor($this$createConstructor_u24lambda_u2419.getStartOffset(), $this$createConstructor_u24lambda_u2419.getEndOffset(), $this$createConstructor_u24lambda_u2419.getOrigin(), SpecialNames.INIT, $this$createConstructor_u24lambda_u2419.getVisibility(), $this$createConstructor_u24lambda_u2419.isInline(), $this$createConstructor_u24lambda_u2419.isExpect(), $this$createConstructor_u24lambda_u2419.getReturnType(), new IrConstructorSymbolImpl(null, null, 3, null), $this$createConstructor_u24lambda_u2419.isPrimary(), $this$createConstructor_u24lambda_u2419.isExternal(), $this$createConstructor_u24lambda_u2419.getContainerSource());
        boolean bl3 = false;
        List list2 = list = CollectionsKt.createListBuilder();
        Object object2 = irConstructor;
        boolean bl4 = false;
        IrValueParameter irValueParameter2 = irScript.getEarlierScriptsParameter();
        if (irValueParameter2 != null) {
            it = irValueParameter2;
            boolean bl5 = false;
            $this$createConstructor_u24lambda_u2425_u24lambda_u2424.add(it);
        }
        Iterable iterable = irScript.getExplicitCallParameters();
        void var14_15 = $this$createConstructor_u24lambda_u2425_u24lambda_u2424;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            IrValueParameter irValueParameter3;
            IrVariable irVariable = (IrVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl6 = false;
            IrValueParameter it3 = irValueParameter3 = this.context.getIrFactory().createValueParameter(it2.getStartOffset(), it2.getEndOffset(), IrDeclarationOrigin.Companion.getSCRIPT_CALL_PARAMETER(), it2.getName(), it2.getType(), false, new IrValueParameterSymbolImpl(null, null, 3, null), null, false, false, false);
            boolean bl7 = false;
            it3.setParent(irScript);
            collection.add(irValueParameter3);
        }
        var14_15.addAll((List)destination$iv$iv);
        Iterable $this$forEach$iv = implicitReceiversFieldsWithParameters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl8 = false;
            IrValueParameter param = (IrValueParameter)pair.component2();
            $this$createConstructor_u24lambda_u2425_u24lambda_u2424.add(param);
        }
        $this$createConstructor_u24lambda_u2425_u24lambda_u2424.addAll((Collection)irScript.getProvidedPropertiesParameters());
        ((IrFunction)object2).setValueParameters(CollectionsKt.build((List)list));
        ((IrDeclarationBase)irConstructor).setParent(irScript);
        return object;
    }

    private final IrExternalPackageFragment getScriptingJvmPackage() {
        Lazy lazy = this.scriptingJvmPackage$delegate;
        return (IrExternalPackageFragment)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void addScriptMainFun(IrClass $this$addScriptMainFun) {
        void $this$addScriptMainFun_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434;
        void $this$addScriptMainFun_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435;
        void $this$addScriptMainFun_u24lambda_u2437_u24lambda_u2436;
        Object object;
        IrValueParameter irValueParameter;
        IrClassSymbol javaLangClass = this.context.getIr().getSymbols().getJavaLangClass();
        IrSimpleFunction kClassJavaPropertyGetter = this.context.getIr().getSymbols().getKClassJavaPropertyGetter();
        Object $this$buildClass$iv = this.context.getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
        boolean bl = false;
        IrClassBuilder $this$addScriptMainFun_u24lambda_u2427 = $this$buildClass_u24lambda_u241$iv;
        boolean bl2 = false;
        $this$addScriptMainFun_u24lambda_u2427.setName(Name.identifier("RunnerKt"));
        $this$addScriptMainFun_u24lambda_u2427.setKind(ClassKind.CLASS);
        $this$addScriptMainFun_u24lambda_u2427.setModality(Modality.FINAL);
        Object $this$addScriptMainFun_u24lambda_u2430 = $this$buildClass$iv = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, $this$buildClass_u24lambda_u241$iv);
        boolean bl3 = false;
        ((IrDeclarationBase)$this$addScriptMainFun_u24lambda_u2430).setParent(this.getScriptingJvmPackage());
        IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor((IrClass)$this$addScriptMainFun_u24lambda_u2430);
        IrSimpleFunction $this$addScriptMainFun_u24lambda_u2430_u24lambda_u2429 = bl = DeclarationBuildersKt.addFunction$default((IrClass)$this$addScriptMainFun_u24lambda_u2430, "runCompiledScript", this.context.getIrBuiltIns().getUnitType(), null, null, true, false, false, false, null, 0, 0, 2028, null);
        boolean bl4 = false;
        DeclarationBuildersKt.addValueParameter$default((IrFunction)$this$addScriptMainFun_u24lambda_u2430_u24lambda_u2429, "scriptClass", (IrType)IrTypesKt.getStarProjectedType(javaLangClass), null, 4, null);
        IrFunction $this$addValueParameter$iv = $this$addScriptMainFun_u24lambda_u2430_u24lambda_u2429;
        boolean $i$f$addValueParameter = false;
        IrValueParameterBuilder $this$addValueParameter_u24lambda_u2432$iv = new IrValueParameterBuilder();
        boolean bl5 = false;
        IrValueParameterBuilder $this$addScriptMainFun_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428 = $this$addValueParameter_u24lambda_u2432$iv;
        boolean bl6 = false;
        $this$addScriptMainFun_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428.setName(Name.identifier("args"));
        Object object2 = new IrType[]{this.context.getIrBuiltIns().getStringType()};
        $this$addScriptMainFun_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428.setType(IrTypesKt.typeWith((IrClassifierSymbol)this.context.getIrBuiltIns().getArrayClass(), object2));
        $this$addScriptMainFun_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428.setOrigin(IrDeclarationOrigin.Companion.getDEFINED());
        $this$addScriptMainFun_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428.setVarargElementType(this.context.getIrBuiltIns().getAnyNType());
        IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u2432$iv, $this$addValueParameter$iv);
        boolean bl7 = false;
        $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), (Object)valueParameter$iv));
        IrClassSymbol scriptRunnerPackageClass = ((IrClass)$this$buildClass$iv).getSymbol();
        Sequence<IrSimpleFunctionSymbol> $this$single$iv = IrUtilsKt.getFunctions(scriptRunnerPackageClass);
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
            boolean bl8 = false;
            if (!Intrinsics.areEqual((Object)((IrSimpleFunction)it.getOwner()).getName().asString(), (Object)"runCompiledScript")) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunctionSymbol scriptRunHelper = single$iv;
        IrClassReferenceImpl scriptClassRef = BuildersKt.IrClassReferenceImpl($this$addScriptMainFun.getStartOffset(), $this$addScriptMainFun.getEndOffset(), IrTypesKt.getStarProjectedType(this.context.getIrBuiltIns().getKClassClass()), this.context.getIrBuiltIns().getKClassClass(), IrUtilsKt.getDefaultType($this$addScriptMainFun));
        IrClass $this$addFunction$iv = $this$addScriptMainFun;
        boolean $i$f$addFunction = false;
        IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
        boolean $i$f$addFunction2 = false;
        Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv$iv$iv = new IrFunctionBuilder();
        boolean bl9 = false;
        IrFunctionBuilder $this$addScriptMainFun_u24lambda_u2432 = $this$buildFun_u24lambda_u2420$iv$iv$iv;
        boolean $i$a$-addFunction-ScriptsToClassesLowering$addScriptMainFun$22 = false;
        $this$addScriptMainFun_u24lambda_u2432.setName(Name.identifier("main"));
        $this$addScriptMainFun_u24lambda_u2432.setVisibility(DescriptorVisibilities.PUBLIC);
        $this$addScriptMainFun_u24lambda_u2432.setReturnType(this.context.getIrBuiltIns().getUnitType());
        $this$addScriptMainFun_u24lambda_u2432.setModality(Modality.FINAL);
        Object function$iv$iv = $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u2420$iv$iv$iv);
        boolean bl10 = false;
        ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
        ((IrDeclarationBase)function$iv$iv).setParent($this$addFunction$iv);
        Object mainFun = object = $this$buildFun$iv$iv$iv;
        boolean bl11 = false;
        IrFunction $this$addValueParameter$iv2 = (IrFunction)mainFun;
        boolean $i$f$addValueParameter22 = false;
        IrValueParameterBuilder $this$addValueParameter_u24lambda_u2432$iv2 = new IrValueParameterBuilder();
        $i$a$-run-DeclarationBuildersKt$addValueParameter$1$iv = false;
        Object $this$addScriptMainFun_u24lambda_u2437_u24lambda_u2433 = $this$addValueParameter_u24lambda_u2432$iv2;
        boolean bl12 = false;
        ((IrDeclarationBuilder)$this$addScriptMainFun_u24lambda_u2437_u24lambda_u2433).setName(Name.identifier("args"));
        IrType[] $i$a$-addFunction-ScriptsToClassesLowering$addScriptMainFun$22 = new IrType[]{this.context.getIrBuiltIns().getStringType()};
        ((IrValueParameterBuilder)$this$addScriptMainFun_u24lambda_u2437_u24lambda_u2433).setType(IrTypesKt.typeWith((IrClassifierSymbol)this.context.getIrBuiltIns().getArrayClass(), $i$a$-addFunction-ScriptsToClassesLowering$addScriptMainFun$22));
        object2 = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv2.getFactory(), $this$addValueParameter_u24lambda_u2432$iv2, $this$addValueParameter$iv2);
        IrType[] valueParameter$iv2 = object2;
        $i$a$-also-DeclarationBuildersKt$addValueParameter$1$1$iv = false;
        $this$addValueParameter$iv2.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv2.getValueParameters(), (Object)valueParameter$iv2));
        IrType[] args = object2;
        DeclarationIrBuilder $i$f$addValueParameter22 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)((IrSimpleFunction)mainFun).getSymbol(), 0, 0, 6, null);
        Object object3 = mainFun;
        boolean bl13 = false;
        IrCall irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$addScriptMainFun_u24lambda_u2437_u24lambda_u2436, scriptRunHelper);
        $this$addScriptMainFun_u24lambda_u2437_u24lambda_u2433 = irCall;
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$addScriptMainFun_u24lambda_u2437_u24lambda_u2436;
        boolean bl14 = false;
        object2 = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$addScriptMainFun_u24lambda_u2437_u24lambda_u2436, IrTypesKt.getStarProjectedType(javaLangClass), null, kClassJavaPropertyGetter.getSymbol());
        valueParameter$iv2 = object2;
        int n = 0;
        void var22_49 = $this$addScriptMainFun_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435;
        boolean bl15 = false;
        $this$addScriptMainFun_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434.setExtensionReceiver(scriptClassRef);
        Unit unit = Unit.INSTANCE;
        var22_49.putValueArgument(n, (IrExpression)object2);
        $this$addScriptMainFun_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435.putValueArgument(1, BuildersKt.IrGetValueImpl$default(-1, -1, args.getType(), args.getSymbol(), null, 16, null));
        ((IrFunction)object3).setBody(ExpressionHelpersKt.irExprBody(irBuilderWithScope, irCall));
    }

    /*
     * WARNING - void declaration
     */
    private final void addSimplePropertyFrom(IrClass $this$addSimplePropertyFrom, IrValueDeclaration from2, IrExpressionBody initializer) {
        void field;
        IrField irField;
        void $this$addSimplePropertyFrom_u24lambda_u2441_u24lambda_u2439;
        Object object;
        IrClass $this$addProperty$iv = $this$addSimplePropertyFrom;
        boolean $i$f$addProperty = false;
        Object $this$buildProperty$iv$iv = $this$addProperty$iv.getFactory();
        boolean $i$f$buildProperty = false;
        IrPropertyBuilder $this$buildProperty_u24lambda_u248$iv$iv = new IrPropertyBuilder();
        boolean bl = false;
        IrPropertyBuilder $this$addSimplePropertyFrom_u24lambda_u2438 = $this$buildProperty_u24lambda_u248$iv$iv;
        boolean $i$a$-addProperty-ScriptsToClassesLowering$addSimplePropertyFrom$22 = false;
        $this$addSimplePropertyFrom_u24lambda_u2438.updateFrom(from2);
        $this$addSimplePropertyFrom_u24lambda_u2438.setName(from2.getName());
        Object property$iv = $this$buildProperty$iv$iv = DeclarationBuildersKt.buildProperty((IrFactory)$this$buildProperty$iv$iv, $this$buildProperty_u24lambda_u248$iv$iv);
        boolean bl2 = false;
        $this$addProperty$iv.getDeclarations().add((IrDeclaration)property$iv);
        ((IrDeclarationBase)property$iv).setParent($this$addProperty$iv);
        Object property = object = $this$buildProperty$iv$iv;
        boolean bl3 = false;
        IrFactory $this$buildField$iv = this.context.getIrFactory();
        boolean $i$f$buildField22 = false;
        IrFieldBuilder $this$buildField_u24lambda_u244$iv = new IrFieldBuilder();
        boolean bl4 = false;
        IrFieldBuilder $i$a$-addProperty-ScriptsToClassesLowering$addSimplePropertyFrom$22 = $this$buildField_u24lambda_u244$iv;
        Object object2 = property;
        boolean bl5 = false;
        $this$addSimplePropertyFrom_u24lambda_u2441_u24lambda_u2439.setName(from2.getName());
        $this$addSimplePropertyFrom_u24lambda_u2441_u24lambda_u2439.setType(from2.getType());
        $this$addSimplePropertyFrom_u24lambda_u2441_u24lambda_u2439.setVisibility(DescriptorVisibilities.PROTECTED);
        IrField $i$f$buildField22 = irField = DeclarationBuildersKt.buildField($this$buildField$iv, $this$buildField_u24lambda_u244$iv);
        boolean bl6 = false;
        field.setParent($this$addSimplePropertyFrom);
        if (initializer != null) {
            field.setInitializer(initializer);
        }
        ((IrProperty)object2).setBackingField(irField);
        DeclarationBuildersKt.addDefaultGetter((IrProperty)property, $this$addSimplePropertyFrom, this.context.getIrBuiltIns());
    }

    static /* synthetic */ void addSimplePropertyFrom$default(ScriptsToClassesLowering scriptsToClassesLowering, IrClass irClass, IrValueDeclaration irValueDeclaration, IrExpressionBody irExpressionBody, int n, Object object) {
        if ((n & 2) != 0) {
            irExpressionBody = null;
        }
        scriptsToClassesLowering.addSimplePropertyFrom(irClass, irValueDeclaration, irExpressionBody);
    }

    private static final Iterable lower$lambda$3(Map $scriptDependencies, IrScript $this$topologicalSort) {
        Intrinsics.checkNotNullParameter((Object)$this$topologicalSort, (String)"$this$topologicalSort");
        List list = (List)$scriptDependencies.get($this$topologicalSort);
        return list != null ? (Iterable)list : (Iterable)CollectionsKt.emptyList();
    }

    private static final <E extends IrElement> IrElement finalizeScriptClass$patchDeclarationForClass(E $this$finalizeScriptClass_u24patchDeclarationForClass, IrClass irScriptClass, ScriptToClassTransformer scriptTransformer, ScriptFixLambdasTransformer lambdaPatcher) {
        IrValueParameter irValueParameter = irScriptClass.getThisReceiver();
        ScriptToClassTransformerContext rootContext = ScriptToClassTransformerContext.Companion.makeRootContext(irValueParameter != null ? irValueParameter.getSymbol() : null, false, $this$finalizeScriptClass_u24patchDeclarationForClass instanceof IrDeclaration ? (IrDeclaration)$this$finalizeScriptClass_u24patchDeclarationForClass : null);
        return $this$finalizeScriptClass_u24patchDeclarationForClass.transform(scriptTransformer, (ScriptToClassTransformerContext)rootContext).transform(lambdaPatcher, new ScriptFixLambdasTransformerContext(false, null, 3, null));
    }

    private static final <E extends IrElement> IrElement finalizeScriptClass$patchTopLevelStatementForClass(E $this$finalizeScriptClass_u24patchTopLevelStatementForClass, IrClass irScriptClass, ScriptToClassTransformer scriptTransformer, ScriptFixLambdasTransformer lambdaPatcher) {
        IrValueParameter irValueParameter = irScriptClass.getThisReceiver();
        ScriptToClassTransformerContext rootContext = ScriptToClassTransformerContext.Companion.makeRootContext$default(ScriptToClassTransformerContext.Companion, irValueParameter != null ? irValueParameter.getSymbol() : null, true, null, 4, null);
        return $this$finalizeScriptClass_u24patchTopLevelStatementForClass.transform(scriptTransformer, (ScriptToClassTransformerContext)rootContext).transform(lambdaPatcher, new ScriptFixLambdasTransformerContext(false, null, 3, null));
    }

    private static final IrExternalPackageFragment scriptingJvmPackage_delegate$lambda$26(ScriptsToClassesLowering this$0) {
        return IrPackageFragmentsKt.createEmptyExternalPackageFragment(this$0.context.getState().getModule(), new FqName("kotlin.script.experimental.jvm"));
    }
}

