/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.in.ReaderConfig;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class Utf32Reader
extends Reader {
    private static final char NULL_CHAR = '\u0000';
    protected final ReaderConfig mConfig;
    protected InputStream mIn;
    protected byte[] mBuffer;
    protected int mPtr;
    protected int mLength;
    protected final boolean mBigEndian;
    protected char mSurrogate = '\u0000';
    protected int mCharCount = 0;
    protected int mByteCount = 0;
    char[] mTmpBuf = null;

    public Utf32Reader(ReaderConfig cfg, InputStream in, byte[] buf, int ptr, int len, boolean isBigEndian) {
        this.mConfig = cfg;
        this.mBigEndian = isBigEndian;
    }

    @Override
    public void close() throws IOException {
        InputStream in = this.mIn;
        if (in != null) {
            this.mIn = null;
            this.freeBuffers();
            in.close();
        }
    }

    @Override
    public int read() throws IOException {
        if (this.mTmpBuf == null) {
            this.mTmpBuf = new char[1];
        }
        if (this.read(this.mTmpBuf, 0, 1) < 1) {
            return -1;
        }
        return this.mTmpBuf[0];
    }

    @Override
    public int read(char[] cbuf, int start, int len) throws IOException {
        if (this.mBuffer == null) {
            return -1;
        }
        if (len < 1) {
            return len;
        }
        if (start < 0 || start + len > cbuf.length) {
            this.reportBounds(cbuf, start, len);
        }
        len += start;
        int outPtr = start;
        if (this.mSurrogate != '\u0000') {
            cbuf[outPtr++] = this.mSurrogate;
            this.mSurrogate = '\u0000';
        } else {
            int left = this.mLength - this.mPtr;
            if (left < 4 && !this.loadMore(left)) {
                return -1;
            }
        }
        byte[] buf = this.mBuffer;
        while (outPtr < len) {
            int ptr = this.mPtr;
            int ch = this.mBigEndian ? buf[ptr] << 24 | (buf[ptr + 1] & 0xFF) << 16 | (buf[ptr + 2] & 0xFF) << 8 | buf[ptr + 3] & 0xFF : buf[ptr] & 0xFF | (buf[ptr + 1] & 0xFF) << 8 | (buf[ptr + 2] & 0xFF) << 16 | buf[ptr + 3] << 24;
            this.mPtr += 4;
            if (ch >= 55296) {
                if (ch > 0x10FFFF) {
                    this.reportInvalid(ch, outPtr - start, "(above " + Integer.toHexString(0x10FFFF) + ") ");
                }
                if (ch > 65535) {
                    cbuf[outPtr++] = (char)(55296 + ((ch -= 65536) >> 10));
                    ch = 0xDC00 | ch & 0x3FF;
                    if (outPtr >= len) {
                        this.mSurrogate = (char)ch;
                        break;
                    }
                } else if (ch < 57344) {
                    this.reportInvalid(ch, outPtr - start, "(a surrogate char) ");
                } else if (ch >= 65534) {
                    this.reportInvalid(ch, outPtr - start, "");
                }
            }
            cbuf[outPtr++] = (char)ch;
            if (this.mPtr < this.mLength) continue;
            break;
        }
        len = outPtr - start;
        this.mCharCount += len;
        return len;
    }

    private boolean loadMore(int available) throws IOException {
        int count;
        this.mByteCount += this.mLength - available;
        if (available > 0) {
            if (this.mPtr > 0) {
                for (int i = 0; i < available; ++i) {
                    this.mBuffer[i] = this.mBuffer[this.mPtr + i];
                }
                this.mPtr = 0;
            }
            this.mLength = available;
        } else {
            this.mPtr = 0;
            count = this.mIn.read(this.mBuffer);
            if (count < 1) {
                this.mLength = 0;
                if (count < 0) {
                    this.freeBuffers();
                    return false;
                }
                this.reportStrangeStream();
            }
            this.mLength = count;
        }
        while (this.mLength < 4) {
            count = this.mIn.read(this.mBuffer, this.mLength, this.mBuffer.length - this.mLength);
            if (count < 1) {
                if (count < 0) {
                    this.freeBuffers();
                    this.reportUnexpectedEOF(this.mLength, 4);
                }
                this.reportStrangeStream();
            }
            this.mLength += count;
        }
        return true;
    }

    public final void freeBuffers() {
        byte[] buf = this.mBuffer;
        if (buf != null) {
            this.mBuffer = null;
            if (this.mConfig != null) {
                this.mConfig.freeFullBBuffer(buf);
            }
        }
    }

    private void reportUnexpectedEOF(int gotBytes, int needed) throws IOException {
        int bytePos = this.mByteCount + gotBytes;
        int charPos = this.mCharCount;
        throw new CharConversionException("Unexpected EOF in the middle of a 4-byte UTF-32 char: got " + gotBytes + ", needed " + needed + ", at char #" + charPos + ", byte #" + bytePos + ")");
    }

    private void reportInvalid(int value2, int offset, String msg) throws IOException {
        int bytePos = this.mByteCount + this.mPtr - 1;
        int charPos = this.mCharCount + offset;
        throw new CharConversionException("Invalid UTF-32 character 0x" + Integer.toHexString(value2) + msg + " at char #" + charPos + ", byte #" + bytePos + ")");
    }

    protected void reportBounds(char[] cbuf, int start, int len) throws IOException {
        throw new ArrayIndexOutOfBoundsException("read(buf," + start + "," + len + "), cbuf[" + cbuf.length + "]");
    }

    protected void reportStrangeStream() throws IOException {
        throw new IOException("Strange I/O stream, returned 0 bytes on read");
    }
}

