/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder;
import org.jetbrains.kotlin.fir.caches.FirCache;
import org.jetbrains.kotlin.fir.caches.NullableMap;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.builder.FirSimpleFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirTypeParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirResolvedDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.resolve.FirOuterClassManager;
import org.jetbrains.kotlin.fir.resolve.FirSamConversionTransformerExtension;
import org.jetbrains.kotlin.fir.resolve.FirSamConversionTransformerExtensionKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SAMInfo;
import org.jetbrains.kotlin.fir.resolve.SamResolutionKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.FirSyntheticFunctionSymbol;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.SubstitutorsKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirFakeOverrideGenerator;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001-B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u0004\u0018\u00010\u00132\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u0004\u0018\u00010\u00132\u0006\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u00020**\u0006\u0012\u0002\b\u00030\u0012H\u0002J\u0018\u0010+\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010,\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u0016\u0012\u0004\u0012\u00020\f\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR&\u0010\u0010\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020\u00000\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/fir/resolve/FirSamResolver;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "outerClassManager", "Lorg/jetbrains/kotlin/fir/resolve/FirOuterClassManager;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/fir/resolve/FirOuterClassManager;)V", "resolvedFunctionType", "Lorg/jetbrains/kotlin/fir/caches/NullableMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/resolve/SAMInfo;", "Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "Ljava/util/Map;", "samConstructorsCache", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "samConversionTransformers", "", "Lorg/jetbrains/kotlin/fir/resolve/FirSamConversionTransformerExtension;", "isSamType", "", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getSamInfoForPossibleSamType", "Lorg/jetbrains/kotlin/fir/resolve/FirSamResolver$SamConversionInfo;", "getFunctionTypeForPossibleSamType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "getSamConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "firClassOrTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "buildSamConstructorForRegularClass", "classSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "buildSamConstructorForTypeAlias", "typeAliasSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeAliasSymbol;", "createSyntheticConstructorSymbol", "Lorg/jetbrains/kotlin/fir/resolve/calls/FirSyntheticFunctionSymbol;", "resolveFunctionTypeIfSamInterface", "firRegularClass", "SamConversionInfo", "resolve"})
@SourceDebugExtension(value={"SMAP\nSamResolution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SamResolution.kt\norg/jetbrains/kotlin/fir/resolve/FirSamResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 FirResolvedTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirResolvedTypeRefBuilderKt\n+ 6 FirSimpleFunctionBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirSimpleFunctionBuilderKt\n+ 7 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 8 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 9 FirValueParameterBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirValueParameterBuilderKt\n+ 10 NullableMap.kt\norg/jetbrains/kotlin/fir/caches/NullableMapKt\n+ 11 NullableMap.kt\norg/jetbrains/kotlin/fir/caches/NullableMap\n*L\n1#1,528:1\n1#2:529\n26#3:530\n19#3:561\n1557#4:531\n1628#4,3:532\n1557#4:535\n1628#4,3:536\n1557#4:539\n1628#4,3:540\n1557#4:543\n1628#4,2:544\n1630#4:547\n1557#4:552\n1628#4,3:553\n1557#4:562\n1628#4,3:563\n1557#4:566\n1628#4,3:567\n1734#4,3:570\n49#5:546\n49#5:558\n49#5:560\n83#6:548\n21#7:549\n37#7:550\n36#7:551\n37#8,2:556\n83#9:559\n43#10:573\n44#10,2:576\n46#10:580\n27#11,2:574\n35#11,2:578\n29#11,3:581\n*S KotlinDebug\n*F\n+ 1 SamResolution.kt\norg/jetbrains/kotlin/fir/resolve/FirSamResolver\n*L\n127#1:530\n231#1:561\n140#1:531\n140#1:532,3\n158#1:535\n158#1:536,3\n162#1:539\n162#1:540,3\n169#1:543\n169#1:544,2\n169#1:547\n192#1:552\n192#1:553,3\n242#1:562\n242#1:563,3\n245#1:566\n245#1:567,3\n248#1:570,3\n170#1:546\n200#1:558\n209#1:560\n177#1:548\n182#1:549\n188#1:550\n189#1:551\n197#1:556,2\n205#1:559\n275#1:573\n275#1:576,2\n275#1:580\n275#1:574,2\n275#1:578,2\n275#1:581,3\n*E\n"})
public final class FirSamResolver {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @Nullable
    private final FirOuterClassManager outerClassManager;
    @NotNull
    private final Map<K, Object> resolvedFunctionType;
    @NotNull
    private final FirCache<FirClassLikeSymbol<?>, FirNamedFunctionSymbol, FirSamResolver> samConstructorsCache;
    @NotNull
    private final List<FirSamConversionTransformerExtension> samConversionTransformers;

    public FirSamResolver(@NotNull FirSession session, @NotNull ScopeSession scopeSession, @Nullable FirOuterClassManager outerClassManager) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        this.session = session;
        this.scopeSession = scopeSession;
        this.outerClassManager = outerClassManager;
        this.resolvedFunctionType = NullableMap.constructor-impl$default(null, 1, null);
        this.samConstructorsCache = SamResolutionKt.access$getSamConstructorStorage(this.session).getSamConstructors();
        this.samConversionTransformers = FirSamConversionTransformerExtensionKt.getSamConversionTransformers(FirExtensionServiceKt.getExtensionService(this.session));
    }

    public /* synthetic */ FirSamResolver(FirSession firSession, ScopeSession scopeSession, FirOuterClassManager firOuterClassManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            firOuterClassManager = null;
        }
        this(firSession, scopeSession, firOuterClassManager);
    }

    public final boolean isSamType(@NotNull ConeKotlinType type2) {
        FirClassLikeSymbol<?> symbol;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ConeKotlinType coneKotlinType = type2;
        return coneKotlinType instanceof ConeClassLikeType ? (symbol = LookupTagUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)type2, this.session, null, 2, null).getLookupTag(), this.session)) instanceof FirRegularClassSymbol && this.resolveFunctionTypeIfSamInterface((FirRegularClass)((FirRegularClassSymbol)symbol).getFir()) != null : (coneKotlinType instanceof ConeFlexibleType ? this.isSamType(((ConeFlexibleType)type2).getLowerBound()) && this.isSamType(((ConeFlexibleType)type2).getUpperBound()) : false);
    }

    @Nullable
    public final SamConversionInfo getSamInfoForPossibleSamType(@NotNull ConeKotlinType type2) {
        SamConversionInfo samConversionInfo;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ConeKotlinType coneKotlinType = type2;
        if (coneKotlinType instanceof ConeClassLikeType) {
            ConeLookupTagBasedType coneLookupTagBasedType = this.getFunctionTypeForPossibleSamType(TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)type2, this.session, null, 2, null));
            if (coneLookupTagBasedType == null) {
                return null;
            }
            samConversionInfo = new SamConversionInfo(coneLookupTagBasedType, type2);
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            Object object = this.getSamInfoForPossibleSamType(((ConeFlexibleType)type2).getLowerBound());
            if (object == null || (object = ((SamConversionInfo)object).getFunctionalType()) == null) {
                return null;
            }
            Object lowerType = object;
            Object object2 = this.getSamInfoForPossibleSamType(((ConeFlexibleType)type2).getUpperBound());
            if (object2 == null || (object2 = ((SamConversionInfo)object2).getFunctionalType()) == null) {
                return null;
            }
            Object upperType = object2;
            samConversionInfo = new SamConversionInfo(new ConeFlexibleType(ConeTypeUtilsKt.lowerBoundIfFlexible((ConeKotlinType)lowerType), ConeTypeUtilsKt.upperBoundIfFlexible((ConeKotlinType)upperType)), type2);
        } else if (coneKotlinType instanceof ConeStubType || coneKotlinType instanceof ConeTypeParameterType || coneKotlinType instanceof ConeTypeVariableType || coneKotlinType instanceof ConeDefinitelyNotNullType || coneKotlinType instanceof ConeIntersectionType || coneKotlinType instanceof ConeIntegerLiteralType) {
            samConversionInfo = null;
        } else if (coneKotlinType instanceof ConeCapturedType) {
            ConeKotlinType coneKotlinType2 = ((ConeCapturedType)type2).getLowerType();
            if (coneKotlinType2 != null) {
                ConeKotlinType it = coneKotlinType2;
                boolean bl = false;
                samConversionInfo = this.getSamInfoForPossibleSamType(it);
            } else {
                samConversionInfo = null;
            }
        } else {
            if (coneKotlinType instanceof ConeLookupTagBasedType) {
                AddToStdlibKt.unreachableBranch(type2);
                throw null;
            }
            throw new NoWhenBranchMatchedException();
        }
        return samConversionInfo;
    }

    private final ConeLookupTagBasedType getFunctionTypeForPossibleSamType(ConeClassLikeType type2) {
        Object functionType;
        FirRegularClass firRegularClass = LookupTagUtilsKt.toFirRegularClass(type2.getLookupTag(), this.session);
        if (firRegularClass == null) {
            return null;
        }
        FirRegularClass firRegularClass2 = firRegularClass;
        SAMInfo<ConeLookupTagBasedType> sAMInfo = this.resolveFunctionTypeIfSamInterface(firRegularClass2);
        if (sAMInfo == null) {
            return null;
        }
        ConeLookupTagBasedType unsubstitutedFunctionType = sAMInfo.component2();
        Object object = SamResolutionKt.access$buildSubstitutorWithUpperBounds(firRegularClass2, this.session, type2);
        if (object == null || (object = ((ConeSubstitutor)object).substituteOrNull(unsubstitutedFunctionType)) == null) {
            object = unsubstitutedFunctionType;
        }
        if (!((functionType = object) instanceof ConeLookupTagBasedType)) {
            boolean bl = false;
            String string2 = "Function type should always be ConeLookupTagBasedType, but " + Reflection.getOrCreateKotlinClass(functionType.getClass()) + " was found";
            throw new IllegalArgumentException(string2.toString());
        }
        return (ConeLookupTagBasedType)TypeUtilsKt.withNullability$default((ConeKotlinType)functionType, ConeNullability.Companion.create(ConeTypeUtilsKt.isMarkedNullable(type2)), TypeComponentsKt.getTypeContext(this.session), null, false, 12, null);
    }

    @Nullable
    public final FirSimpleFunction getSamConstructor(@NotNull FirClassLikeDeclaration firClassOrTypeAlias) {
        Intrinsics.checkNotNullParameter((Object)firClassOrTypeAlias, (String)"firClassOrTypeAlias");
        if (firClassOrTypeAlias instanceof FirTypeAlias) {
            FirClassLikeSymbol<?> firClassLikeSymbol;
            ConeClassLikeLookupTag coneClassLikeLookupTag;
            ConeClassLikeType coneClassLikeType;
            ConeClassLikeType coneClassLikeType2;
            FirTypeRef $this$coneTypeSafe$iv = ((FirTypeAlias)firClassOrTypeAlias).getExpandedTypeRef();
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((coneClassLikeType2 = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) != null && (coneClassLikeType = TypeExpansionUtilsKt.fullyExpandedType$default(coneClassLikeType2, this.session, null, 2, null)) != null && (coneClassLikeLookupTag = coneClassLikeType.getLookupTag()) != null && (firClassLikeSymbol = LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, this.session)) != null) {
                FirClassLikeSymbol<?> it = firClassLikeSymbol;
                boolean bl = false;
                this.samConstructorsCache.getValue(it, this);
            }
        }
        FirNamedFunctionSymbol firNamedFunctionSymbol = this.samConstructorsCache.getValue(firClassOrTypeAlias.getSymbol(), this);
        return firNamedFunctionSymbol != null ? (FirSimpleFunction)firNamedFunctionSymbol.getFir() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FirNamedFunctionSymbol buildSamConstructorForRegularClass(@NotNull FirRegularClassSymbol classSymbol) {
        FirSimpleFunction firSimpleFunction;
        void $this$buildSamConstructorForRegularClass_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412;
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
        FirValueParameterBuilder firValueParameterBuilder;
        void $this$buildSamConstructorForRegularClass_u24lambda_u2414_u24lambda_u2411;
        void $this$mapTo$iv$iv;
        void $this$buildSamConstructorForRegularClass_u24lambda_u2414_u24lambda_u249;
        FirSimpleFunctionBuilder $i$f$map42;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder;
        void $this$mapTo$iv$iv2;
        Iterator $this$map$iv;
        void $this$mapTo$iv$iv3;
        void $this$map$iv2;
        Collection collection;
        void $this$mapTo$iv$iv4;
        Intrinsics.checkNotNullParameter((Object)classSymbol, (String)"classSymbol");
        FirRegularClass firRegularClass = (FirRegularClass)classSymbol.getFir();
        SAMInfo<ConeLookupTagBasedType> sAMInfo = this.resolveFunctionTypeIfSamInterface(firRegularClass);
        if (sAMInfo == null) {
            return null;
        }
        SAMInfo<ConeLookupTagBasedType> sAMInfo2 = sAMInfo;
        FirNamedFunctionSymbol functionSymbol = sAMInfo2.component1$resolve();
        ConeLookupTagBasedType functionType = sAMInfo2.component2();
        FirSyntheticFunctionSymbol syntheticFunctionSymbol = this.createSyntheticConstructorSymbol(classSymbol);
        Iterable $this$map$iv3 = firRegularClass.getTypeParameters();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv3;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            FirTypeParameterBuilder firTypeParameterBuilder;
            void typeParameter;
            FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            FirTypeParameter declaredTypeParameter = (FirTypeParameter)typeParameter.getSymbol().getFir();
            FirTypeParameterBuilder $this$buildSamConstructorForRegularClass_u24lambda_u244_u24lambda_u243 = firTypeParameterBuilder = new FirTypeParameterBuilder();
            boolean bl2 = false;
            $this$buildSamConstructorForRegularClass_u24lambda_u244_u24lambda_u243.setSource(declaredTypeParameter.getSource());
            $this$buildSamConstructorForRegularClass_u24lambda_u244_u24lambda_u243.setModuleData(FirModuleDataKt.getModuleData(this.session));
            $this$buildSamConstructorForRegularClass_u24lambda_u244_u24lambda_u243.setOrigin(FirDeclarationOrigin.SamConstructor.INSTANCE);
            $this$buildSamConstructorForRegularClass_u24lambda_u244_u24lambda_u243.setResolvePhase(FirResolvePhase.Companion.getDECLARATIONS());
            $this$buildSamConstructorForRegularClass_u24lambda_u244_u24lambda_u243.setName(declaredTypeParameter.getName());
            $this$buildSamConstructorForRegularClass_u24lambda_u244_u24lambda_u243.setSymbol(new FirTypeParameterSymbol());
            $this$buildSamConstructorForRegularClass_u24lambda_u244_u24lambda_u243.setVariance(Variance.INVARIANT);
            $this$buildSamConstructorForRegularClass_u24lambda_u244_u24lambda_u243.setReified(false);
            CollectionsKt.addAll((Collection)$this$buildSamConstructorForRegularClass_u24lambda_u244_u24lambda_u243.getAnnotations(), (Iterable)declaredTypeParameter.getAnnotations());
            $this$buildSamConstructorForRegularClass_u24lambda_u244_u24lambda_u243.setContainingDeclarationSymbol(syntheticFunctionSymbol);
            collection.add(firTypeParameterBuilder);
        }
        List newTypeParameters = (List)destination$iv$iv;
        Iterable $i$f$map22 = newTypeParameters;
        boolean $i$f$map32 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            FirTypeParameterBuilder bl = (FirTypeParameterBuilder)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add(new ConeTypeParameterTypeImpl(it.getSymbol().toLookupTag(), false, null, 4, null));
        }
        List newTypeParameterTypes = (List)destination$iv$iv2;
        Iterable $i$f$map32 = firRegularClass.getTypeParameters();
        boolean $i$f$map42 = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            FirTypeParameterRef bl3 = (FirTypeParameterRef)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        ConeSubstitutor substitutor2 = SubstitutorsKt.substitutorByMap(MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)((List)destination$iv$iv3), (Iterable)newTypeParameterTypes)), this.session);
        for (Pair $i$f$map42 : CollectionsKt.zip((Iterable)newTypeParameters, (Iterable)firRegularClass.getTypeParameters())) {
            void $this$mapTo$iv$iv5;
            Object item$iv$iv;
            FirTypeParameterBuilder newTypeParameter = (FirTypeParameterBuilder)$i$f$map42.component1();
            FirTypeParameterRef oldTypeParameter = (FirTypeParameterRef)$i$f$map42.component2();
            FirTypeParameter declared = (FirTypeParameter)oldTypeParameter.getSymbol().getFir();
            item$iv$iv = newTypeParameter.getBounds();
            Iterable $this$map$iv4 = declared.getSymbol().getResolvedBounds();
            boolean $i$f$map5 = false;
            Iterable bl = $this$map$iv4;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv5) {
                void typeRef;
                FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv$iv2;
                collection = destination$iv$iv4;
                boolean bl4 = false;
                boolean $i$f$buildResolvedTypeRef = false;
                firAnnotationContainerBuilder = new FirResolvedTypeRefBuilder();
                FirResolvedTypeRefBuilder $this$buildSamConstructorForRegularClass_u24lambda_u248_u24lambda_u247 = firAnnotationContainerBuilder;
                boolean bl5 = false;
                $this$buildSamConstructorForRegularClass_u24lambda_u248_u24lambda_u247.setSource(typeRef.getSource());
                $this$buildSamConstructorForRegularClass_u24lambda_u248_u24lambda_u247.setType(substitutor2.substituteOrSelf(FirTypeUtilsKt.getConeType((FirTypeRef)typeRef)));
                collection.add(((FirResolvedTypeRefBuilder)firAnnotationContainerBuilder).build());
            }
            $this$map$iv4 = (List)destination$iv$iv4;
            CollectionsKt.addAll((Collection)item$iv$iv, (Iterable)$this$map$iv4);
        }
        boolean $i$f$buildSimpleFunction = false;
        FirSimpleFunctionBuilder $this$buildSamConstructorForRegularClass_u24lambda_u2414 = $i$f$map42 = new FirSimpleFunctionBuilder();
        boolean bl = false;
        $this$buildSamConstructorForRegularClass_u24lambda_u2414.setModuleData(FirModuleDataKt.getModuleData(this.session));
        $this$buildSamConstructorForRegularClass_u24lambda_u2414.setSource(firRegularClass.getSource());
        $this$buildSamConstructorForRegularClass_u24lambda_u2414.setName(syntheticFunctionSymbol.getName());
        $this$buildSamConstructorForRegularClass_u24lambda_u2414.setOrigin(FirDeclarationOrigin.SamConstructor.INSTANCE);
        Object $this$visibility$iv = firRegularClass;
        boolean $i$f$getVisibility22 = false;
        Visibility visibility = ((FirMemberDeclaration)$this$visibility$iv).getStatus().getVisibility();
        $this$visibility$iv = new FirResolvedDeclarationStatusImpl(visibility, Modality.FINAL, EffectiveVisibility.Local.INSTANCE);
        FirPureAbstractElement $i$f$getVisibility22 = $this$visibility$iv;
        Object object = $this$buildSamConstructorForRegularClass_u24lambda_u2414;
        boolean bl6 = false;
        FirMemberDeclaration $this$isExpect$iv = firRegularClass;
        boolean $i$f$isExpect = false;
        $this$buildSamConstructorForRegularClass_u24lambda_u2414_u24lambda_u249.setExpect($this$isExpect$iv.getStatus().isExpect());
        Object $this$isActual$iv = firRegularClass;
        boolean $i$f$isActual = false;
        $this$buildSamConstructorForRegularClass_u24lambda_u2414_u24lambda_u249.setActual(((FirMemberDeclaration)$this$isActual$iv).getStatus().isActual());
        ((FirSimpleFunctionBuilder)object).setStatus((FirDeclarationStatus)$this$visibility$iv);
        $this$buildSamConstructorForRegularClass_u24lambda_u2414.setSymbol(syntheticFunctionSymbol);
        $this$visibility$iv = $this$buildSamConstructorForRegularClass_u24lambda_u2414.getTypeParameters();
        Iterable $this$map$iv5 = newTypeParameters;
        boolean $i$f$map6 = false;
        $this$isActual$iv = $this$map$iv5;
        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
        boolean $i$f$mapTo5 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeParameterBuilder bl4 = (FirTypeParameterBuilder)item$iv$iv;
            object = destination$iv$iv5;
            boolean bl7 = false;
            object.add(it.build());
        }
        $this$map$iv5 = (List)destination$iv$iv5;
        CollectionsKt.addAll((Collection)$this$visibility$iv, (Iterable)$this$map$iv5);
        ConeKotlinType substitutedFunctionType = substitutor2.substituteOrSelf(functionType);
        Collection $this$toTypedArray$iv = newTypeParameterTypes;
        boolean $i$f$toTypedArray22 = false;
        Object thisCollection$iv = $this$toTypedArray$iv;
        ConeClassLikeTypeImpl substitutedReturnType = new ConeClassLikeTypeImpl(firRegularClass.getSymbol().toLookupTag(), thisCollection$iv.toArray(new ConeTypeParameterTypeImpl[0]), false, null, 8, null);
        boolean $i$f$buildResolvedTypeRef = false;
        FirResolvedTypeRefBuilder $i$f$toTypedArray22 = new FirResolvedTypeRefBuilder();
        thisCollection$iv = $i$f$toTypedArray22;
        object = $this$buildSamConstructorForRegularClass_u24lambda_u2414;
        boolean bl8 = false;
        $this$buildSamConstructorForRegularClass_u24lambda_u2414_u24lambda_u2411.setSource(null);
        $this$buildSamConstructorForRegularClass_u24lambda_u2414_u24lambda_u2411.setType(substitutedReturnType);
        ((FirSimpleFunctionBuilder)object).setReturnTypeRef($i$f$toTypedArray22.build());
        Collection collection2 = $this$buildSamConstructorForRegularClass_u24lambda_u2414.getValueParameters();
        boolean $i$f$buildValueParameter = false;
        FirValueParameterBuilder $this$buildSamConstructorForRegularClass_u24lambda_u2414_u24lambda_u2413 = firValueParameterBuilder = new FirValueParameterBuilder();
        boolean bl9 = false;
        $this$buildSamConstructorForRegularClass_u24lambda_u2414_u24lambda_u2413.setModuleData(FirModuleDataKt.getModuleData(this.session));
        $this$buildSamConstructorForRegularClass_u24lambda_u2414_u24lambda_u2413.setContainingFunctionSymbol(syntheticFunctionSymbol);
        $this$buildSamConstructorForRegularClass_u24lambda_u2414_u24lambda_u2413.setOrigin(FirDeclarationOrigin.SamConstructor.INSTANCE);
        boolean $i$f$buildResolvedTypeRef2 = false;
        FirResolvedTypeRefBuilder bl7 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
        firAnnotationContainerBuilder = $this$buildSamConstructorForRegularClass_u24lambda_u2414_u24lambda_u2413;
        boolean bl10 = false;
        $this$buildSamConstructorForRegularClass_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412.setSource(firRegularClass.getSource());
        $this$buildSamConstructorForRegularClass_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412.setType(substitutedFunctionType);
        ((FirValueParameterBuilder)firAnnotationContainerBuilder).setReturnTypeRef(firResolvedTypeRefBuilder.build());
        $this$buildSamConstructorForRegularClass_u24lambda_u2414_u24lambda_u2413.setName(SamResolutionKt.access$getSAM_PARAMETER_NAME$p());
        $this$buildSamConstructorForRegularClass_u24lambda_u2414_u24lambda_u2413.setSymbol(new FirValueParameterSymbol(SamResolutionKt.access$getSAM_PARAMETER_NAME$p()));
        $this$buildSamConstructorForRegularClass_u24lambda_u2414_u24lambda_u2413.setCrossinline(false);
        $this$buildSamConstructorForRegularClass_u24lambda_u2414_u24lambda_u2413.setNoinline(false);
        $this$buildSamConstructorForRegularClass_u24lambda_u2414_u24lambda_u2413.setVararg(false);
        $this$buildSamConstructorForRegularClass_u24lambda_u2414_u24lambda_u2413.setResolvePhase(FirResolvePhase.BODY_RESOLVE);
        FirValueParameter firValueParameter = firValueParameterBuilder.build();
        collection2.add(firValueParameter);
        CollectionsKt.addAll((Collection)$this$buildSamConstructorForRegularClass_u24lambda_u2414.getAnnotations(), (Iterable)functionSymbol.getAnnotations());
        $this$buildSamConstructorForRegularClass_u24lambda_u2414.setResolvePhase(FirResolvePhase.BODY_RESOLVE);
        FirSimpleFunction $this$buildSamConstructorForRegularClass_u24lambda_u2415 = firSimpleFunction = $i$f$map42.build();
        boolean bl11 = false;
        Object object2 = this.outerClassManager;
        ClassMembersKt.setContainingClassForStaticMemberAttr($this$buildSamConstructorForRegularClass_u24lambda_u2415, object2 != null && (object2 = ((FirOuterClassManager)object2).outerClass(firRegularClass.getSymbol())) != null ? ((FirClassLikeSymbol)object2).toLookupTag() : null);
        return firSimpleFunction.getSymbol();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FirNamedFunctionSymbol buildSamConstructorForTypeAlias(@NotNull FirTypeAliasSymbol typeAliasSymbol) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)typeAliasSymbol, (String)"typeAliasSymbol");
        FirTypeRef $this$coneTypeUnsafe$iv = ((FirTypeAlias)typeAliasSymbol.getFir()).getExpandedTypeRef();
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
        if (coneKotlinType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeClassLikeType");
        }
        ConeClassLikeType type2 = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)), this.session, null, 2, null);
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(type2.getLookupTag(), this.session);
        FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
        FirRegularClass firRegularClass = firClassLikeDeclaration instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration : null;
        if (firRegularClass == null) {
            return null;
        }
        FirRegularClass expansionRegularClass = firRegularClass;
        FirSimpleFunction firSimpleFunction = this.getSamConstructor(expansionRegularClass);
        if (firSimpleFunction == null) {
            return null;
        }
        FirSimpleFunction samConstructorForClass = firSimpleFunction;
        ConeSubstitutor coneSubstitutor = SamResolutionKt.access$buildSubstitutorWithUpperBounds(samConstructorForClass, this.session, type2);
        if (coneSubstitutor == null) {
            return samConstructorForClass.getSymbol();
        }
        ConeSubstitutor substitutor2 = coneSubstitutor;
        ConeKotlinType newReturnType = substitutor2.substituteOrNull(FirTypeUtilsKt.getConeType(samConstructorForClass.getReturnTypeRef()));
        Iterable $this$map$iv = samConstructorForClass.getValueParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(substitutor2.substituteOrNull(FirTypeUtilsKt.getConeType(it.getReturnTypeRef())));
        }
        List newParameterTypes = (List)destination$iv$iv;
        Iterable $this$map$iv2 = samConstructorForClass.getContextReceivers();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirContextReceiver bl = (FirContextReceiver)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(substitutor2.substituteOrNull(FirTypeUtilsKt.getConeType(it.getTypeRef())));
        }
        List newContextReceiverTypes = (List)destination$iv$iv2;
        if (newReturnType == null) {
            boolean bl;
            boolean $i$f$all;
            Iterable $this$all$iv;
            block15: {
                $this$all$iv = newParameterTypes;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        ConeKotlinType it = (ConeKotlinType)element$iv;
                        boolean bl3 = false;
                        if (it == null) continue;
                        bl = false;
                        break block15;
                    }
                    bl = true;
                }
            }
            if (bl) {
                boolean bl4;
                block16: {
                    $this$all$iv = newContextReceiverTypes;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl4 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            ConeKotlinType it = (ConeKotlinType)element$iv;
                            boolean bl5 = false;
                            if (it == null) continue;
                            bl4 = false;
                            break block16;
                        }
                        bl4 = true;
                    }
                }
                if (bl4) {
                    return samConstructorForClass.getSymbol();
                }
            }
        }
        FirFakeOverrideGenerator firFakeOverrideGenerator = FirFakeOverrideGenerator.INSTANCE;
        FirSyntheticFunctionSymbol firSyntheticFunctionSymbol = this.createSyntheticConstructorSymbol(typeAliasSymbol);
        Iterator iterator2 = this.session;
        FirDeclarationOrigin.SamConstructor samConstructor = FirDeclarationOrigin.SamConstructor.INSTANCE;
        List<FirTypeParameter> list = ((FirTypeAlias)typeAliasSymbol.getFir()).getTypeParameters();
        return FirFakeOverrideGenerator.createCopyForFirFunction$default(firFakeOverrideGenerator, firSyntheticFunctionSymbol, samConstructorForClass, null, iterator2, samConstructor, false, null, newParameterTypes, list, null, newContextReceiverTypes, newReturnType, null, null, null, null, 61472, null).getSymbol();
    }

    /*
     * WARNING - void declaration
     */
    private final FirSyntheticFunctionSymbol createSyntheticConstructorSymbol(FirClassLikeSymbol<?> $this$createSyntheticConstructorSymbol) {
        void it;
        FqName fqName;
        FqName fqName2 = fqName = $this$createSyntheticConstructorSymbol.getClassId().getRelativeClassName().parent();
        FqName fqName3 = $this$createSyntheticConstructorSymbol.getClassId().getPackageFqName();
        boolean bl = false;
        boolean bl2 = !it.isRoot();
        Name name2 = $this$createSyntheticConstructorSymbol.getClassId().getShortClassName();
        FqName fqName4 = bl2 ? fqName : null;
        FqName fqName5 = fqName3;
        CallableId callableId = new CallableId(fqName5, fqName4, name2);
        return new FirSyntheticFunctionSymbol(callableId);
    }

    private final SAMInfo<ConeLookupTagBasedType> resolveFunctionTypeIfSamInterface(FirRegularClass firRegularClass) {
        Object object;
        Map<FirRegularClass, Object> $this$getOrPut_u2dLcU4HiU$iv = this.resolvedFunctionType;
        boolean bl = false;
        boolean bl2 = false;
        Object value$iv$iv = $this$getOrPut_u2dLcU4HiU$iv.get(firRegularClass);
        if (value$iv$iv == null) {
            NullableMap.NullValue nullValue;
            Object object2;
            boolean bl3 = false;
            boolean bl4 = false;
            if (!firRegularClass.getStatus().isFun()) {
                object2 = null;
            } else {
                FirSimpleFunction firSimpleFunction = SamResolutionKt.access$getSingleAbstractMethodOrNull(firRegularClass, this.session, this.scopeSession);
                if (firSimpleFunction == null) {
                    object2 = null;
                } else {
                    ConeLookupTagBasedType coneLookupTagBasedType;
                    FirSimpleFunction abstractMethod;
                    block9: {
                        abstractMethod = firSimpleFunction;
                        for (FirSamConversionTransformerExtension it : (Iterable)this.samConversionTransformers) {
                            boolean bl5 = false;
                            ConeLookupTagBasedType coneLookupTagBasedType2 = it.getCustomFunctionTypeForSamConversion(abstractMethod);
                            if (coneLookupTagBasedType2 == null) continue;
                            coneLookupTagBasedType = coneLookupTagBasedType2;
                            break block9;
                        }
                        coneLookupTagBasedType = null;
                    }
                    ConeLookupTagBasedType typeFromExtension = coneLookupTagBasedType;
                    FirNamedFunctionSymbol firNamedFunctionSymbol = abstractMethod.getSymbol();
                    ConeLookupTagBasedType coneLookupTagBasedType3 = typeFromExtension;
                    if (coneLookupTagBasedType3 == null) {
                        coneLookupTagBasedType3 = SamResolutionKt.access$getFunctionTypeForAbstractMethod(abstractMethod, this.session);
                    }
                    object2 = new SAMInfo<ConeKotlinType>(firNamedFunctionSymbol, coneLookupTagBasedType3);
                }
            }
            NullableMap.NullValue it$iv = nullValue = object2;
            boolean bl6 = false;
            boolean bl7 = false;
            NullableMap.NullValue nullValue2 = it$iv;
            if (nullValue2 == null) {
                nullValue2 = NullableMap.NullValue.INSTANCE;
            }
            $this$getOrPut_u2dLcU4HiU$iv.put(firRegularClass, nullValue2);
            object = nullValue;
        } else {
            object = Intrinsics.areEqual((Object)value$iv$iv, (Object)NullableMap.NullValue.INSTANCE) ? null : value$iv$iv;
        }
        return (SAMInfo)object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/FirSamResolver$SamConversionInfo;", "", "functionalType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "samType", "<init>", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "getFunctionalType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getSamType", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "resolve"})
    public static final class SamConversionInfo {
        @NotNull
        private final ConeKotlinType functionalType;
        @NotNull
        private final ConeKotlinType samType;

        public SamConversionInfo(@NotNull ConeKotlinType functionalType, @NotNull ConeKotlinType samType) {
            Intrinsics.checkNotNullParameter((Object)functionalType, (String)"functionalType");
            Intrinsics.checkNotNullParameter((Object)samType, (String)"samType");
            this.functionalType = functionalType;
            this.samType = samType;
        }

        @NotNull
        public final ConeKotlinType getFunctionalType() {
            return this.functionalType;
        }

        @NotNull
        public final ConeKotlinType getSamType() {
            return this.samType;
        }

        @NotNull
        public final ConeKotlinType component1() {
            return this.functionalType;
        }

        @NotNull
        public final ConeKotlinType component2() {
            return this.samType;
        }

        @NotNull
        public final SamConversionInfo copy(@NotNull ConeKotlinType functionalType, @NotNull ConeKotlinType samType) {
            Intrinsics.checkNotNullParameter((Object)functionalType, (String)"functionalType");
            Intrinsics.checkNotNullParameter((Object)samType, (String)"samType");
            return new SamConversionInfo(functionalType, samType);
        }

        public static /* synthetic */ SamConversionInfo copy$default(SamConversionInfo samConversionInfo, ConeKotlinType coneKotlinType, ConeKotlinType coneKotlinType2, int n, Object object) {
            if ((n & 1) != 0) {
                coneKotlinType = samConversionInfo.functionalType;
            }
            if ((n & 2) != 0) {
                coneKotlinType2 = samConversionInfo.samType;
            }
            return samConversionInfo.copy(coneKotlinType, coneKotlinType2);
        }

        @NotNull
        public String toString() {
            return "SamConversionInfo(functionalType=" + this.functionalType + ", samType=" + this.samType + ')';
        }

        public int hashCode() {
            int result2 = this.functionalType.hashCode();
            result2 = result2 * 31 + this.samType.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SamConversionInfo)) {
                return false;
            }
            SamConversionInfo samConversionInfo = (SamConversionInfo)other;
            if (!Intrinsics.areEqual((Object)this.functionalType, (Object)samConversionInfo.functionalType)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.samType, (Object)samConversionInfo.samType);
        }
    }
}

