/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirDesugaredAssignmentValueReferenceExpression;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExpressionAnnotationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpressionAnnotationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionAnnotationChecker\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,62:1\n381#2,7:63\n*S KotlinDebug\n*F\n+ 1 FirExpressionAnnotationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionAnnotationChecker\n*L\n50#1:63,7\n*E\n"})
public final class FirExpressionAnnotationChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirExpressionAnnotationChecker INSTANCE = new FirExpressionAnnotationChecker();

    private FirExpressionAnnotationChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirStatement expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                if (expression2 instanceof FirDeclaration || expression2 instanceof FirErrorExpression) break block10;
                if (!(expression2 instanceof FirBlock)) break block11;
                KtSourceElement ktSourceElement = ((FirBlock)expression2).getSource();
                if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtRealSourceElementKind.INSTANCE)) break block11;
            }
            return;
        }
        if (expression2 instanceof FirVariableAssignment && ((FirVariableAssignment)expression2).getLValue() instanceof FirDesugaredAssignmentValueReferenceExpression) {
            return;
        }
        List<FirAnnotation> annotations2 = expression2.getAnnotations();
        if (annotations2.isEmpty()) {
            return;
        }
        HashMap annotationsMap = new HashMap();
        for (FirAnnotation annotation : annotations2) {
            Object object;
            void $this$getOrPut$iv;
            AnnotationUseSiteTarget annotationUseSiteTarget = annotation.getUseSiteTarget();
            if (annotationUseSiteTarget == null) {
                annotationUseSiteTarget = FirAnnotationHelpersKt.getDefaultUseSiteTarget(expression2, annotation, context2);
            }
            AnnotationUseSiteTarget useSiteTarget2 = annotationUseSiteTarget;
            Map map = annotationsMap;
            ConeKotlinType key$iv = FirTypeUtilsKt.getConeType(annotation.getAnnotationTypeRef());
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            List existingTargetsForAnnotation = (List)object;
            if (!FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotation, context2.getSession()).contains((Object)KotlinTarget.EXPRESSION)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET(), (Object)"expression", (DiagnosticContext)context2, null, 16, null);
            }
            FirAnnotationHelpersKt.checkRepeatedAnnotation(useSiteTarget2, existingTargetsForAnnotation, annotation, context2, reporter, annotation.getSource());
            existingTargetsForAnnotation.add(useSiteTarget2);
        }
    }
}

