/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.formatting.FormattingMode;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.psi.codeStyle.DocCommentSettings;
import com.intellij.psi.codeStyle.FormattingModeAwareIndentAdjuster;
import com.intellij.psi.codeStyle.Indent;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeStyleManager {
    public static CodeStyleManager getInstance(@NotNull Project project) {
        if (project == null) {
            CodeStyleManager.$$$reportNull$$$0(0);
        }
        return project.getService(CodeStyleManager.class);
    }

    public static CodeStyleManager getInstance(@NotNull PsiManager manager) {
        if (manager == null) {
            CodeStyleManager.$$$reportNull$$$0(1);
        }
        return CodeStyleManager.getInstance(manager.getProject());
    }

    @NotNull
    public abstract Project getProject();

    @NotNull
    public abstract PsiElement reformat(@NotNull PsiElement var1) throws IncorrectOperationException;

    @NotNull
    public abstract PsiElement reformat(@NotNull PsiElement var1, boolean var2) throws IncorrectOperationException;

    public abstract PsiElement reformatRange(@NotNull PsiElement var1, int var2, int var3) throws IncorrectOperationException;

    public abstract PsiElement reformatRange(@NotNull PsiElement var1, int var2, int var3, boolean var4) throws IncorrectOperationException;

    public abstract void reformatText(@NotNull PsiFile var1, int var2, int var3) throws IncorrectOperationException;

    public abstract void reformatText(@NotNull PsiFile var1, @NotNull Collection<? extends TextRange> var2) throws IncorrectOperationException;

    public abstract void reformatTextWithContext(@NotNull PsiFile var1, @NotNull ChangedRangesInfo var2) throws IncorrectOperationException;

    public void reformatTextWithContext(@NotNull PsiFile file2, @NotNull Collection<? extends TextRange> ranges) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManager.$$$reportNull$$$0(2);
        }
        if (ranges == null) {
            CodeStyleManager.$$$reportNull$$$0(3);
        }
        ArrayList<TextRange> rangesList = new ArrayList<TextRange>(ranges);
        this.reformatTextWithContext(file2, new ChangedRangesInfo(rangesList, null));
    }

    public abstract void adjustLineIndent(@NotNull PsiFile var1, TextRange var2) throws IncorrectOperationException;

    public abstract int adjustLineIndent(@NotNull PsiFile var1, int var2) throws IncorrectOperationException;

    public abstract int adjustLineIndent(@NotNull Document var1, int var2);

    public void scheduleIndentAdjustment(@NotNull Document document, int offset) {
        if (document == null) {
            CodeStyleManager.$$$reportNull$$$0(4);
        }
    }

    @Deprecated
    public abstract boolean isLineToBeIndented(@NotNull PsiFile var1, int var2);

    @Nullable
    public abstract String getLineIndent(@NotNull PsiFile var1, int var2);

    @Nullable
    public List<String> getLineIndents(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeStyleManager.$$$reportNull$$$0(5);
        }
        return null;
    }

    @Nullable
    public String getLineIndent(@NotNull PsiFile file2, int offset, FormattingMode mode) {
        if (file2 == null) {
            CodeStyleManager.$$$reportNull$$$0(6);
        }
        return this.getLineIndent(file2, offset);
    }

    @Nullable
    public abstract String getLineIndent(@NotNull Document var1, int var2);

    @Deprecated
    public abstract Indent getIndent(String var1, FileType var2);

    @Deprecated
    public abstract String fillIndent(Indent var1, FileType var2);

    @Deprecated
    public abstract Indent zeroIndent();

    public abstract void reformatNewlyAddedElement(@NotNull ASTNode var1, @NotNull ASTNode var2) throws IncorrectOperationException;

    public abstract boolean isSequentialProcessingAllowed();

    public abstract void performActionWithFormatterDisabled(Runnable var1);

    public abstract <T extends Throwable> void performActionWithFormatterDisabled(ThrowableRunnable<T> var1) throws T;

    public abstract <T> T performActionWithFormatterDisabled(Computable<T> var1);

    public int getSpacing(@NotNull PsiFile file2, int offset) {
        if (file2 == null) {
            CodeStyleManager.$$$reportNull$$$0(7);
        }
        return -1;
    }

    public int getMinLineFeeds(@NotNull PsiFile file2, int offset) {
        if (file2 == null) {
            CodeStyleManager.$$$reportNull$$$0(8);
        }
        return -1;
    }

    public static FormattingMode getCurrentFormattingMode(@NotNull Project project) {
        CodeStyleManager instance2;
        if (project == null) {
            CodeStyleManager.$$$reportNull$$$0(9);
        }
        if (!project.isDisposed() && (instance2 = CodeStyleManager.getInstance(project)) instanceof FormattingModeAwareIndentAdjuster) {
            return ((FormattingModeAwareIndentAdjuster)((Object)instance2)).getCurrentFormattingMode();
        }
        return FormattingMode.REFORMAT;
    }

    public void runWithDocCommentFormattingDisabled(@NotNull PsiFile file2, @NotNull Runnable runnable) {
        if (file2 == null) {
            CodeStyleManager.$$$reportNull$$$0(10);
        }
        if (runnable == null) {
            CodeStyleManager.$$$reportNull$$$0(11);
        }
        runnable.run();
    }

    @NotNull
    public DocCommentSettings getDocCommentSettings(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeStyleManager.$$$reportNull$$$0(12);
        }
        DocCommentSettings docCommentSettings = DocCommentSettings.DEFAULTS;
        if (docCommentSettings == null) {
            CodeStyleManager.$$$reportNull$$$0(13);
        }
        return docCommentSettings;
    }

    public void scheduleReformatWhenSettingsComputed(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeStyleManager.$$$reportNull$$$0(14);
        }
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/CodeStyleManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleManager";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocCommentSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reformatTextWithContext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scheduleIndentAdjustment";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndents";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMinLineFeeds";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentFormattingMode";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runWithDocCommentFormattingDisabled";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDocCommentSettings";
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "scheduleReformatWhenSettingsComputed";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

