/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.lang.JavaVersion;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;

public final class WinProcessManager {
    private static final Logger LOG = Logger.getInstance(WinProcessManager.class);

    private WinProcessManager() {
    }

    public static int getProcessId(Process process2) {
        String processClassName = process2.getClass().getName();
        if (processClassName.equals("java.lang.Win32Process") || processClassName.equals("java.lang.ProcessImpl")) {
            try {
                if (JavaVersion.current().feature >= 9) {
                    return ((Long)Process.class.getMethod("pid", new Class[0]).invoke((Object)process2, new Object[0])).intValue();
                }
                long handle = Objects.requireNonNull(ReflectionUtil.getField(process2.getClass(), process2, Long.TYPE, "handle"));
                return Kernel32.INSTANCE.GetProcessId(new WinNT.HANDLE(Pointer.createConstant(handle)));
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to get PID from instance of " + process2.getClass() + ", OS: " + SystemInfo.OS_NAME, t);
            }
        }
        throw new IllegalStateException("Unable to get PID from instance of " + process2.getClass() + ", OS: " + SystemInfo.OS_NAME);
    }

    public static int getCurrentProcessId() {
        return Kernel32.INSTANCE.GetCurrentProcessId();
    }

    public static boolean kill(Process process2, boolean tree) {
        return WinProcessManager.kill(-1, process2, tree);
    }

    public static boolean kill(int pid, boolean tree) {
        return WinProcessManager.kill(pid, null, tree);
    }

    private static boolean kill(int pid, Process process2, boolean tree) {
        LOG.assertTrue(pid > 0 || process2 != null);
        try {
            if (process2 != null) {
                pid = WinProcessManager.getProcessId(process2);
            }
            @NonNls String[] cmdArray = new String[]{"taskkill", "/f", "/pid", String.valueOf(pid), tree ? "/t" : ""};
            if (LOG.isDebugEnabled()) {
                LOG.debug(StringUtil.join(cmdArray, " "));
            }
            Process p = new ProcessBuilder(cmdArray).redirectErrorStream(true).start();
            String output = FileUtil.loadTextAndClose(p.getInputStream());
            int res2 = p.waitFor();
            if (res2 != 0 && (process2 == null || WinProcessManager.isAlive(process2))) {
                LOG.warn(StringUtil.join(cmdArray, " ") + " failed: " + output);
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(output);
            }
            return true;
        }
        catch (Exception e) {
            LOG.warn(e);
            return false;
        }
    }

    private static boolean isAlive(Process process2) {
        try {
            process2.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }
}

