/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.ReferencedSymbolRemapper;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\b\u001a\u00020\t*\u00020\n\u001a\n\u0010\u000b\u001a\u00020\t*\u00020\n\u001a\n\u0010\f\u001a\u00020\t*\u00020\n\u001a\n\u0010\r\u001a\u00020\t*\u00020\n\u001a\n\u0010\u000e\u001a\u00020\t*\u00020\n\u001a\n\u0010\u000f\u001a\u00020\t*\u00020\n\u001a\n\u0010\u0010\u001a\u00020\t*\u00020\n\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0011\u001a\n\u0010\u000b\u001a\u00020\t*\u00020\u0011\u001a\n\u0010\f\u001a\u00020\t*\u00020\u0011\u001a\n\u0010\r\u001a\u00020\t*\u00020\u0011\u001a\n\u0010\u000e\u001a\u00020\t*\u00020\u0011\u001a\u001c\u0010\u0012\u001a\u00020\t*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\u0016\u001a\u00020\t*\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019*\u00020\n\u001a\n\u0010\u001a\u001a\u00020\t*\u00020\n\u001a\n\u0010\u001b\u001a\u00020\t*\u00020\n\u001a\n\u0010\u001c\u001a\u00020\t*\u00020\n\u001a\n\u0010\u001d\u001a\u00020\t*\u00020\n\u001a\n\u0010\u001e\u001a\u00020\t*\u00020\n\u001a\n\u0010\u001f\u001a\u00020\t*\u00020\n\u001a\n\u0010 \u001a\u00020\t*\u00020\n\u001a\n\u0010!\u001a\u00020\t*\u00020\n\u001a\n\u0010\"\u001a\u00020\t*\u00020\n\u001a\n\u0010#\u001a\u00020\t*\u00020\n\u001a\n\u0010$\u001a\u00020\t*\u00020\n\u001a!\u0010%\u001a\u00020\t*\u00020\n2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\t0'H\u0082\b\u001a\n\u0010)\u001a\u00020\t*\u00020\n\u001a\f\u0010*\u001a\u0004\u0018\u00010+*\u00020\n\u001a&\u0010,\u001a\u00020\n*\u00020\n2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00192\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\n0\u0019\u001a\u001e\u0010,\u001a\u00020\n*\u00020\n2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\n01\u001a\u0016\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00192\u0006\u00105\u001a\u000204H\u0002\u001a\u001e\u00106\u001a\u0002072\u0006\u00105\u001a\u0002042\f\u00108\u001a\b\u0012\u0004\u0012\u00020409H\u0002\u001a\u0014\u0010:\u001a\b\u0012\u0004\u0012\u0002040;2\u0006\u0010<\u001a\u00020=\u001a\u001e\u0010>\u001a\u0002072\u0006\u0010<\u001a\u00020=2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020=09H\u0002\u001a\u0010\u0010@\u001a\b\u0012\u0004\u0012\u00020=0;*\u00020=\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"kotlinPackageFqn", "Lorg/jetbrains/kotlin/name/FqName;", "getKotlinPackageFqn", "()Lorg/jetbrains/kotlin/name/FqName;", "kotlinEnumsPackageFqn", "getKotlinEnumsPackageFqn", "kotlinReflectionPackageFqn", "kotlinCoroutinesPackageFqn", "isFunctionMarker", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isFunction", "isKFunction", "isSuspendFunction", "isKSuspendFunction", "isKProperty", "isKMutableProperty", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "isClassWithName", "name", "", "packageFqName", "isClassWithNamePrefix", "prefix", "superTypes", "", "isFunctionTypeOrSubtype", "isSuspendFunctionTypeOrSubtype", "isTypeParameter", "isInterface", "isExternalObject", "isAnnotation", "isFunctionOrKFunction", "isSuspendFunctionOrKFunction", "isThrowable", "isUnsigned", "isUnsignedArray", "isTypeFromKotlinPackage", "namePredicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "isPrimitiveArray", "getPrimitiveArrayElementType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "substitute", "params", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "arguments", "substitutionMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "getImmediateSupertypes", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "irType", "collectAllSupertypes", "", "result", "", "getAllSubstitutedSupertypes", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "collectAllSuperclasses", "set", "getAllSuperclasses", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nIrTypeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrTypeUtils.kt\norg/jetbrains/kotlin/ir/util/IrTypeUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n+ 5 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt\n+ 6 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt$deepCopyWithSymbols$1\n*L\n1#1,176:1\n80#1,6:178\n80#1,6:184\n80#1,6:190\n80#1,6:196\n1#2:177\n1557#3:202\n1628#3,3:203\n1628#3,2:207\n1630#3:227\n1628#3,3:229\n1557#3:232\n1628#3,3:233\n774#3:236\n865#3,2:237\n1628#3,3:240\n16#4:206\n16#4:228\n16#4:239\n22#5,16:209\n38#5:226\n24#6:225\n*S KotlinDebug\n*F\n+ 1 IrTypeUtils.kt\norg/jetbrains/kotlin/ir/util/IrTypeUtilsKt\n*L\n73#1:178,6\n75#1:184,6\n77#1:190,6\n88#1:196,6\n95#1:202\n95#1:203,3\n100#1:207,2\n100#1:227\n109#1:229,3\n129#1:232\n129#1:233,3\n134#1:236\n134#1:237,2\n135#1:240,3\n100#1:206\n109#1:228\n135#1:239\n100#1:209,16\n100#1:226\n100#1:225\n*E\n"})
public final class IrTypeUtilsKt {
    @NotNull
    private static final FqName kotlinPackageFqn;
    @NotNull
    private static final FqName kotlinEnumsPackageFqn;
    @NotNull
    private static final FqName kotlinReflectionPackageFqn;
    @NotNull
    private static final FqName kotlinCoroutinesPackageFqn;

    @NotNull
    public static final FqName getKotlinPackageFqn() {
        return kotlinPackageFqn;
    }

    @NotNull
    public static final FqName getKotlinEnumsPackageFqn() {
        return kotlinEnumsPackageFqn;
    }

    public static final boolean isFunctionMarker(@NotNull IrType $this$isFunctionMarker) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionMarker, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isFunctionMarker);
        return irClassifierSymbol != null ? IrTypeUtilsKt.isClassWithName(irClassifierSymbol, "Function", kotlinPackageFqn) : false;
    }

    public static final boolean isFunction(@NotNull IrType $this$isFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunction, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isFunction);
        return irClassifierSymbol != null ? IrTypeUtilsKt.isClassWithNamePrefix(irClassifierSymbol, "Function", kotlinPackageFqn) : false;
    }

    public static final boolean isKFunction(@NotNull IrType $this$isKFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isKFunction, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isKFunction);
        return irClassifierSymbol != null ? IrTypeUtilsKt.isClassWithNamePrefix(irClassifierSymbol, "KFunction", kotlinReflectionPackageFqn) : false;
    }

    public static final boolean isSuspendFunction(@NotNull IrType $this$isSuspendFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendFunction, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isSuspendFunction);
        return irClassifierSymbol != null ? IrTypeUtilsKt.isClassWithNamePrefix(irClassifierSymbol, "SuspendFunction", kotlinCoroutinesPackageFqn) : false;
    }

    public static final boolean isKSuspendFunction(@NotNull IrType $this$isKSuspendFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isKSuspendFunction, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isKSuspendFunction);
        return irClassifierSymbol != null ? IrTypeUtilsKt.isClassWithNamePrefix(irClassifierSymbol, "KSuspendFunction", kotlinReflectionPackageFqn) : false;
    }

    public static final boolean isKProperty(@NotNull IrType $this$isKProperty) {
        Intrinsics.checkNotNullParameter((Object)$this$isKProperty, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isKProperty);
        return irClassifierSymbol != null ? IrTypeUtilsKt.isClassWithNamePrefix(irClassifierSymbol, "KProperty", kotlinReflectionPackageFqn) : false;
    }

    public static final boolean isKMutableProperty(@NotNull IrType $this$isKMutableProperty) {
        Intrinsics.checkNotNullParameter((Object)$this$isKMutableProperty, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isKMutableProperty);
        return irClassifierSymbol != null ? IrTypeUtilsKt.isClassWithNamePrefix(irClassifierSymbol, "KMutableProperty", kotlinReflectionPackageFqn) : false;
    }

    public static final boolean isFunctionMarker(@NotNull IrClassifierSymbol $this$isFunctionMarker) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionMarker, (String)"<this>");
        return IrTypeUtilsKt.isClassWithName($this$isFunctionMarker, "Function", kotlinPackageFqn);
    }

    public static final boolean isFunction(@NotNull IrClassifierSymbol $this$isFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunction, (String)"<this>");
        return IrTypeUtilsKt.isClassWithNamePrefix($this$isFunction, "Function", kotlinPackageFqn);
    }

    public static final boolean isKFunction(@NotNull IrClassifierSymbol $this$isKFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isKFunction, (String)"<this>");
        return IrTypeUtilsKt.isClassWithNamePrefix($this$isKFunction, "KFunction", kotlinReflectionPackageFqn);
    }

    public static final boolean isSuspendFunction(@NotNull IrClassifierSymbol $this$isSuspendFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendFunction, (String)"<this>");
        return IrTypeUtilsKt.isClassWithNamePrefix($this$isSuspendFunction, "SuspendFunction", kotlinCoroutinesPackageFqn);
    }

    public static final boolean isKSuspendFunction(@NotNull IrClassifierSymbol $this$isKSuspendFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isKSuspendFunction, (String)"<this>");
        return IrTypeUtilsKt.isClassWithNamePrefix($this$isKSuspendFunction, "KSuspendFunction", kotlinReflectionPackageFqn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isClassWithName(IrClassifierSymbol $this$isClassWithName, String name2, FqName packageFqName) {
        IrSymbolOwner irSymbolOwner = $this$isClassWithName.getOwner();
        Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
        IrDeclarationWithName declaration2 = (IrDeclarationWithName)irSymbolOwner;
        if (!Intrinsics.areEqual((Object)name2, (Object)declaration2.getName().asString())) return false;
        IrDeclarationParent irDeclarationParent = declaration2.getParent();
        IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
        if (!Intrinsics.areEqual((Object)(irPackageFragment != null ? irPackageFragment.getPackageFqName() : null), (Object)packageFqName)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isClassWithNamePrefix(IrClassifierSymbol $this$isClassWithNamePrefix, String prefix, FqName packageFqName) {
        IrSymbolOwner irSymbolOwner = $this$isClassWithNamePrefix.getOwner();
        Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
        IrDeclarationWithName declaration2 = (IrDeclarationWithName)irSymbolOwner;
        String string2 = declaration2.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        if (!StringsKt.startsWith$default((String)string2, (String)prefix, (boolean)false, (int)2, null)) return false;
        IrDeclarationParent irDeclarationParent = declaration2.getParent();
        IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
        if (!Intrinsics.areEqual((Object)(irPackageFragment != null ? irPackageFragment.getPackageFqName() : null), (Object)packageFqName)) return false;
        return true;
    }

    @NotNull
    public static final List<IrType> superTypes(@NotNull IrType $this$superTypes) {
        Intrinsics.checkNotNullParameter((Object)$this$superTypes, (String)"<this>");
        Object object = IrTypesKt.getClassifierOrNull($this$superTypes);
        if (object == null || (object = org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.superTypes((IrClassifierSymbol)object)) == null) {
            object = kotlin.collections.CollectionsKt.emptyList();
        }
        return object;
    }

    public static final boolean isFunctionTypeOrSubtype(@NotNull IrType $this$isFunctionTypeOrSubtype) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionTypeOrSubtype, (String)"<this>");
        Boolean bl = DFS.ifAny(kotlin.collections.CollectionsKt.listOf((Object)$this$isFunctionTypeOrSubtype), IrTypeUtilsKt::superTypes, isFunctionTypeOrSubtype.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"ifAny(...)");
        return bl;
    }

    public static final boolean isSuspendFunctionTypeOrSubtype(@NotNull IrType $this$isSuspendFunctionTypeOrSubtype) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendFunctionTypeOrSubtype, (String)"<this>");
        Boolean bl = DFS.ifAny(kotlin.collections.CollectionsKt.listOf((Object)$this$isSuspendFunctionTypeOrSubtype), IrTypeUtilsKt::superTypes, isSuspendFunctionTypeOrSubtype.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"ifAny(...)");
        return bl;
    }

    public static final boolean isTypeParameter(@NotNull IrType $this$isTypeParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$isTypeParameter, (String)"<this>");
        return IrTypesKt.getClassifierOrNull($this$isTypeParameter) instanceof IrTypeParameterSymbol;
    }

    public static final boolean isInterface(@NotNull IrType $this$isInterface) {
        Intrinsics.checkNotNullParameter((Object)$this$isInterface, (String)"<this>");
        Object object = IrTypesKt.getClassOrNull($this$isInterface);
        return (object != null && (object = (IrClass)object.getOwner()) != null ? ((IrClass)object).getKind() : null) == ClassKind.INTERFACE;
    }

    public static final boolean isExternalObject(@NotNull IrType $this$isExternalObject) {
        Intrinsics.checkNotNullParameter((Object)$this$isExternalObject, (String)"<this>");
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$isExternalObject);
        IrClass it = irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null;
        boolean bl = false;
        IrClass irClass = it;
        return (irClass != null ? irClass.getKind() : null) == ClassKind.OBJECT && it.isExternal();
    }

    public static final boolean isAnnotation(@NotNull IrType $this$isAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$isAnnotation, (String)"<this>");
        Object object = IrTypesKt.getClassOrNull($this$isAnnotation);
        return (object != null && (object = (IrClass)object.getOwner()) != null ? ((IrClass)object).getKind() : null) == ClassKind.ANNOTATION_CLASS;
    }

    public static final boolean isFunctionOrKFunction(@NotNull IrType $this$isFunctionOrKFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionOrKFunction, (String)"<this>");
        return IrTypeUtilsKt.isFunction($this$isFunctionOrKFunction) || IrTypeUtilsKt.isKFunction($this$isFunctionOrKFunction);
    }

    public static final boolean isSuspendFunctionOrKFunction(@NotNull IrType $this$isSuspendFunctionOrKFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendFunctionOrKFunction, (String)"<this>");
        return IrTypeUtilsKt.isSuspendFunction($this$isSuspendFunctionOrKFunction) || IrTypeUtilsKt.isKSuspendFunction($this$isSuspendFunctionOrKFunction);
    }

    public static final boolean isThrowable(@NotNull IrType $this$isThrowable) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isThrowable, (String)"<this>");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isThrowable;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
            if (irClassSymbol == null) {
                bl = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name name2 = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)name2.asString(), (Object)"Throwable")) {
                    bl = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
                    if (irPackageFragment == null) {
                        bl = false;
                    } else {
                        IrPackageFragment parent$iv = irPackageFragment;
                        bl = Intrinsics.areEqual((Object)parent$iv.getPackageFqName(), (Object)kotlinPackageFqn);
                    }
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isUnsigned(@NotNull IrType $this$isUnsigned) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isUnsigned, (String)"<this>");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isUnsigned;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
            if (irClassSymbol == null) {
                bl = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name name2 = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl2 = false;
                if (!UnsignedTypes.INSTANCE.isShortNameOfUnsignedType(name2)) {
                    bl = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
                    if (irPackageFragment == null) {
                        bl = false;
                    } else {
                        IrPackageFragment parent$iv = irPackageFragment;
                        bl = Intrinsics.areEqual((Object)parent$iv.getPackageFqName(), (Object)kotlinPackageFqn);
                    }
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isUnsignedArray(@NotNull IrType $this$isUnsignedArray) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isUnsignedArray, (String)"<this>");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isUnsignedArray;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
            if (irClassSymbol == null) {
                bl = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name name2 = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl2 = false;
                if (!UnsignedTypes.INSTANCE.isShortNameOfUnsignedArray(name2)) {
                    bl = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
                    if (irPackageFragment == null) {
                        bl = false;
                    } else {
                        IrPackageFragment parent$iv = irPackageFragment;
                        bl = Intrinsics.areEqual((Object)parent$iv.getPackageFqName(), (Object)kotlinPackageFqn);
                    }
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean isTypeFromKotlinPackage(IrType $this$isTypeFromKotlinPackage, Function1<? super Name, Boolean> namePredicate) {
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage).getClassifier();
            IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
            if (irClassSymbol == null) {
                return false;
            }
            IrClassSymbol classClassifier = irClassSymbol;
            if (!((Boolean)namePredicate.invoke((Object)((IrClass)classClassifier.getOwner()).getName())).booleanValue()) {
                return false;
            }
            IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier.getOwner()).getParent();
            IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
            if (irPackageFragment == null) {
                return false;
            }
            IrPackageFragment parent2 = irPackageFragment;
            return Intrinsics.areEqual((Object)parent2.getPackageFqName(), (Object)kotlinPackageFqn);
        }
        return false;
    }

    public static final boolean isPrimitiveArray(@NotNull IrType $this$isPrimitiveArray) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isPrimitiveArray, (String)"<this>");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isPrimitiveArray;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
            if (irClassSymbol == null) {
                bl = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name it = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl2 = false;
                if (!StandardNames.FqNames.primitiveArrayTypeShortNames.contains(it)) {
                    bl = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
                    if (irPackageFragment == null) {
                        bl = false;
                    } else {
                        IrPackageFragment parent$iv = irPackageFragment;
                        bl = Intrinsics.areEqual((Object)parent$iv.getPackageFqName(), (Object)kotlinPackageFqn);
                    }
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final PrimitiveType getPrimitiveArrayElementType(@NotNull IrType $this$getPrimitiveArrayElementType) {
        PrimitiveType primitiveType;
        Intrinsics.checkNotNullParameter((Object)$this$getPrimitiveArrayElementType, (String)"<this>");
        IrSimpleType irSimpleType = $this$getPrimitiveArrayElementType instanceof IrSimpleType ? (IrSimpleType)$this$getPrimitiveArrayElementType : null;
        if (irSimpleType != null) {
            IrSimpleType it = irSimpleType;
            boolean bl = false;
            IrSymbolOwner irSymbolOwner = it.getClassifier().getOwner();
            Object object = irSymbolOwner instanceof IrClass ? (IrClass)irSymbolOwner : null;
            if (object != null && (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) != null && (object = ((FqName)object).toUnsafe()) != null) {
                Object fqn = object;
                boolean bl2 = false;
                primitiveType = StandardNames.FqNames.arrayClassFqNameToPrimitiveType.get(fqn);
            } else {
                primitiveType = null;
            }
        } else {
            primitiveType = null;
        }
        return primitiveType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrType substitute(@NotNull IrType $this$substitute, @NotNull List<? extends IrTypeParameter> params, @NotNull List<? extends IrType> arguments2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$substitute, (String)"<this>");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        Iterable iterable = params;
        IrType irType = $this$substitute;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        return IrTypeUtilsKt.substitute(irType, MapsKt.toMap((Iterable)kotlin.collections.CollectionsKt.zip((Iterable)((List)destination$iv$iv), (Iterable)arguments2)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrType substitute(@NotNull IrType $this$substitute, @NotNull Map<IrTypeParameterSymbol, ? extends IrType> substitutionMap) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)$this$substitute, (String)"<this>");
        Intrinsics.checkNotNullParameter(substitutionMap, (String)"substitutionMap");
        if (!($this$substitute instanceof IrSimpleType) || substitutionMap.isEmpty()) {
            return $this$substitute;
        }
        Object $this$memoryOptimizedMap$iv = $this$substitute.getAnnotations();
        boolean $i$f$memoryOptimizedMap = false;
        Iterable iterable = (Iterable)$this$memoryOptimizedMap$iv;
        Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            IrConstructorCall irConstructorCall = (IrConstructorCall)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            IrElement $this$deepCopyWithSymbols_u24default$iv = (IrElement)it;
            IrDeclarationParent initialParent$iv = null;
            boolean $i$f$deepCopyWithSymbols = false;
            IrElement $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
            boolean $i$f$deepCopyImpl = false;
            DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
            IrVisitorsKt.acceptVoid($this$deepCopyImpl$iv$iv, symbolRemapper$iv$iv);
            DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
            boolean bl2 = false;
            ReferencedSymbolRemapper p0 = deepCopySymbolRemapper;
            TypeRemapper typeRemapper$iv$iv = new DeepCopyTypeRemapper(p0);
            IrElement irElement = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv$iv, typeRemapper$iv$iv), null);
            if (irElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConstructorCall");
            }
            collection.add((IrConstructorCall)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrConstructorCall)irElement), initialParent$iv));
        }
        List newAnnotations = CollectionsKt.compactIfPossible((List)destination$iv$iv);
        $this$memoryOptimizedMap$iv = substitutionMap.get(((IrSimpleType)$this$substitute).getClassifier());
        if ($this$memoryOptimizedMap$iv != null) {
            Object substitutedType = $this$memoryOptimizedMap$iv;
            boolean bl = false;
            return IrTypesKt.addAnnotations(IrTypesKt.mergeNullability((IrType)substitutedType, $this$substitute), newAnnotations);
        }
        Collection $this$memoryOptimizedMap$iv2 = ((IrSimpleType)$this$substitute).getArguments();
        boolean $i$f$memoryOptimizedMap2 = false;
        Iterable bl = $this$memoryOptimizedMap$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$memoryOptimizedMap$iv2.size());
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrTypeArgument irTypeArgument;
            void it;
            IrTypeArgument bl3 = (IrTypeArgument)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl4 = false;
            void var13_19 = it;
            if (var13_19 instanceof IrTypeProjection) {
                irTypeArgument = IrSimpleTypeImplKt.makeTypeProjection(IrTypeUtilsKt.substitute(((IrTypeProjection)it).getType(), substitutionMap), ((IrTypeProjection)it).getVariance());
            } else if (var13_19 instanceof IrStarProjection) {
                irTypeArgument = it;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(irTypeArgument);
        }
        List newArguments2 = CollectionsKt.compactIfPossible((List)destination$iv$iv2);
        return new IrSimpleTypeImpl(((IrSimpleType)$this$substitute).getClassifier(), ((IrSimpleType)$this$substitute).getNullability(), newArguments2, newAnnotations, null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<IrSimpleType> getImmediateSupertypes(IrSimpleType irType) {
        void $this$memoryOptimizedMap$iv;
        Iterable $this$filterTo$iv$iv;
        Collection $this$filter$iv;
        IrType it;
        Collection collection;
        void $this$mapTo$iv$iv;
        IrClass irClass = IrTypesKt.getClass(irType);
        if (irClass == null) {
            throw new AssertionError((Object)("Not a class type: " + RenderIrElementKt.render$default(irType, null, 1, null)));
        }
        IrClass irClass2 = irClass;
        List<IrType> originalSupertypes = irClass2.getSuperTypes();
        Iterable $this$map$iv = irType.getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            IrType irType2 = IrTypesKt.getTypeOrNull(it);
            if (irType2 == null) {
                throw new AssertionError((Object)("*-projection in supertype arguments: " + RenderIrElementKt.render$default(irType, null, 1, null)));
            }
            collection.add(irType2);
        }
        List arguments2 = (List)destination$iv$iv;
        $this$map$iv = originalSupertypes;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrType)element$iv$iv;
            boolean bl = false;
            if (!(IrTypesKt.getClassOrNull(it) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$memoryOptimizedMap = false;
        $this$filterTo$iv$iv = (Iterable)$this$memoryOptimizedMap$iv;
        destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void superType;
            it = (IrType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            IrType irType3 = IrTypeUtilsKt.substitute((IrType)superType, irClass2.getTypeParameters(), arguments2);
            Intrinsics.checkNotNull((Object)irType3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            collection.add((IrSimpleType)irType3);
        }
        return CollectionsKt.compactIfPossible((List)destination$iv$iv);
    }

    private static final void collectAllSupertypes(IrSimpleType irType, Set<IrSimpleType> result2) {
        List<IrSimpleType> immediateSupertypes = IrTypeUtilsKt.getImmediateSupertypes(irType);
        result2.addAll((Collection<IrSimpleType>)immediateSupertypes);
        for (IrSimpleType supertype : immediateSupertypes) {
            IrTypeUtilsKt.collectAllSupertypes(supertype, result2);
        }
    }

    @NotNull
    public static final Set<IrSimpleType> getAllSubstitutedSupertypes(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        HashSet result2 = new HashSet();
        IrTypeUtilsKt.collectAllSupertypes(IrUtilsKt.getDefaultType(irClass), result2);
        return result2;
    }

    private static final void collectAllSuperclasses(IrClass irClass, Set<IrClass> set) {
        for (IrType superType : irClass.getSuperTypes()) {
            IrClassSymbol classifier;
            IrClass superClass;
            IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(superType);
            IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
            if (irClassSymbol == null || !set.add(superClass = (IrClass)(classifier = irClassSymbol).getOwner())) continue;
            IrTypeUtilsKt.collectAllSuperclasses(superClass, set);
        }
    }

    @NotNull
    public static final Set<IrClass> getAllSuperclasses(@NotNull IrClass $this$getAllSuperclasses) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllSuperclasses, (String)"<this>");
        HashSet result2 = new HashSet();
        IrTypeUtilsKt.collectAllSuperclasses($this$getAllSuperclasses, result2);
        return result2;
    }

    static {
        FqName fqName = FqName.fromSegments(kotlin.collections.CollectionsKt.listOf((Object)"kotlin"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"fromSegments(...)");
        kotlinPackageFqn = fqName;
        FqName fqName2 = kotlinPackageFqn.child(Name.identifier("enums"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"child(...)");
        kotlinEnumsPackageFqn = fqName2;
        FqName fqName3 = kotlinPackageFqn.child(Name.identifier("reflect"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"child(...)");
        kotlinReflectionPackageFqn = fqName3;
        FqName fqName4 = kotlinPackageFqn.child(Name.identifier("coroutines"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"child(...)");
        kotlinCoroutinesPackageFqn = fqName4;
    }
}

