/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirNameConflictsTrackerComponent;
import org.jetbrains.kotlin.fir.FirNameConflictsTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticProperty;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderInternals;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirProviderImpl;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirScriptSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirSyntheticPropertySymbol;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004-./0B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0011J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!H\u0002J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110#2\u0006\u0010\u001a\u001a\u00020$H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u001bH\u0016J\u0014\u0010(\u001a\u00020\u001e2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00110#J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010\u001a\u001a\u00020$H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "kotlinScopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getKotlinScopeProvider", "()Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "getSymbolProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "getFirCallableContainerFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getFirScriptContainerFile", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirScriptSymbol;", "getFirScriptByFilePath", "path", "", "getFirClassifierContainerFile", "fqName", "Lorg/jetbrains/kotlin/name/ClassId;", "getFirClassifierContainerFileIfAny", "recordFile", "", "file", "state", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$State;", "getFirFilesByPackage", "", "Lorg/jetbrains/kotlin/name/FqName;", "getFirClassifierByFqName", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "classId", "ensureConsistent", "files", "getClassNamesInPackage", "", "Lorg/jetbrains/kotlin/name/Name;", "SymbolProvider", "FirRecorderData", "FirRecorder", "State", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirProviderImpl.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl\n+ 2 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n+ 3 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,340:1\n105#2:341\n99#2:342\n87#2:343\n93#2:345\n39#3:344\n1317#4,2:346\n1863#5,2:348\n1557#5:350\n1628#5,3:351\n1557#5:354\n1628#5,3:355\n1863#5,2:358\n1863#5,2:360\n*S KotlinDebug\n*F\n+ 1 FirProviderImpl.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl\n*L\n24#1:341\n24#1:342\n24#1:343\n24#1:345\n24#1:344\n113#1:346,2\n264#1:348,2\n277#1:350\n277#1:351,3\n291#1:354\n291#1:355,3\n307#1:358,2\n309#1:360,2\n*E\n"})
public final class FirProviderImpl
extends FirProvider {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirKotlinScopeProvider kotlinScopeProvider;
    @NotNull
    private final FirSymbolProvider symbolProvider;
    @NotNull
    private final State state;

    public FirProviderImpl(@NotNull FirSession session, @NotNull FirKotlinScopeProvider kotlinScopeProvider2) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)kotlinScopeProvider2, (String)"kotlinScopeProvider");
        this.session = session;
        this.kotlinScopeProvider = kotlinScopeProvider2;
        this.symbolProvider = new SymbolProvider();
        this.state = new State();
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final FirKotlinScopeProvider getKotlinScopeProvider() {
        return this.kotlinScopeProvider;
    }

    @Override
    @NotNull
    public FirSymbolProvider getSymbolProvider() {
        return this.symbolProvider;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public FirFile getFirCallableContainerFile(@NotNull FirCallableSymbol<?> symbol) {
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        $this$originalIfFakeOverride$iv = symbol;
        $i$f$originalIfFakeOverride = false;
        $this$originalIfFakeOverride$iv$iv = (FirCallableDeclaration)$this$originalIfFakeOverride$iv.getFir();
        $i$f$originalIfFakeOverride = false;
        $this$originalForSubstitutionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
        $i$f$getOriginalForSubstitutionOverride = false;
        if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv)) ** GOTO lbl-1000
        $this$isSynthetic$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv;
        $i$f$isSynthetic = false;
        if ($this$isSynthetic$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
        // 2 sources

        {
            v0 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv);
        } else {
            v0 = v1 = null;
        }
        if (v0 == null) {
            $this$baseForIntersectionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
            $i$f$getBaseForIntersectionOverride = false;
            v1 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv) : null;
        }
        v2 = var2_12 = v1 != null ? v1.getSymbol() : null;
        if (var2_12 != null) {
            originalSymbol = var2_12;
            $i$a$-let-FirProviderImpl$getFirCallableContainerFile$1 = false;
            return FirProviderKt.getFirProvider(originalSymbol.getModuleData().getSession()).getFirCallableContainerFile(originalSymbol);
        }
        if (symbol instanceof FirBackingFieldSymbol) {
            return this.getFirCallableContainerFile(((FirBackingField)((FirBackingFieldSymbol)symbol).getFir()).getPropertySymbol());
        }
        if (symbol instanceof FirSyntheticPropertySymbol && (fir = (FirProperty)((FirSyntheticPropertySymbol)symbol).getFir()) instanceof FirSyntheticProperty) {
            return this.getFirCallableContainerFile(((FirSyntheticProperty)fir).getGetter().getDelegate().getSymbol());
        }
        return this.state.getCallableContainerMap().get(symbol);
    }

    @Override
    @Nullable
    public FirFile getFirScriptContainerFile(@NotNull FirScriptSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        return this.state.getScriptContainerMap().get(symbol2);
    }

    @Override
    @Nullable
    public FirScriptSymbol getFirScriptByFilePath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.state.getScriptByFilePathMap().get(path);
    }

    @Override
    @NotNull
    public FirFile getFirClassifierContainerFile(@NotNull ClassId fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        FirFile firFile = this.state.getClassifierContainerFileMap().get(fqName);
        if (firFile == null) {
            throw new IllegalStateException(("Couldn't find container for " + fqName).toString());
        }
        return firFile;
    }

    @Override
    @Nullable
    public FirFile getFirClassifierContainerFileIfAny(@NotNull ClassId fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        return this.state.getClassifierContainerFileMap().get(fqName);
    }

    public final void recordFile(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.recordFile(file2, this.state);
    }

    /*
     * WARNING - void declaration
     */
    private final void recordFile(FirFile file2, State state) {
        void $this$forEach$iv;
        FqName packageName2 = UtilsKt.getPackageFqName(file2);
        state.getFileMap().merge(packageName2, CollectionsKt.listOf((Object)file2), (arg_0, arg_1) -> FirProviderImpl.recordFile$lambda$2(FirProviderImpl::recordFile$lambda$1, arg_0, arg_1));
        Sequence sequence2 = SequencesKt.generateSequence((Object)packageName2, FirProviderImpl::recordFile$lambda$3);
        Set<FqName> set = state.getAllSubPackages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FqName p0 = (FqName)element$iv;
            boolean bl = false;
            set.add(p0);
        }
        file2.acceptChildren(FirRecorder.INSTANCE, new FirRecorderData(state, file2, FirNameConflictsTrackerComponentKt.getNameConflictsTracker(this.session)));
    }

    @Override
    @NotNull
    public List<FirFile> getFirFilesByPackage(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        List list = this.state.getFileMap().get(fqName);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public FirClassLikeDeclaration getFirClassifierByFqName(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        if (!(!classId.isLocal())) {
            boolean bl = false;
            String string2 = "Local " + classId + " should never be used to find its corresponding classifier";
            throw new IllegalArgumentException(string2.toString());
        }
        return this.state.getClassifierMap().get(classId);
    }

    public final void ensureConsistent(@NotNull List<? extends FirFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        State newState = new State();
        Iterable $this$forEach$iv = files2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirFile it = (FirFile)element$iv;
            boolean bl = false;
            this.recordFile(it, newState);
        }
        List failures = new ArrayList();
        FirProviderImpl.ensureConsistent$checkMMapDiff(failures, "fileMap", this.state.getFileMap(), newState.getFileMap());
        FirProviderImpl.ensureConsistent$checkMapDiff$default(failures, "classifierMap", this.state.getClassifierMap(), newState.getClassifierMap(), null, 16, null);
        FirProviderImpl.ensureConsistent$checkMapDiff$default(failures, "classifierContainerFileMap", this.state.getClassifierContainerFileMap(), newState.getClassifierContainerFileMap(), null, 16, null);
        FirProviderImpl.ensureConsistent$checkMMapDiff(failures, "callableMap", this.state.getFunctionMap(), newState.getFunctionMap());
        FirProviderImpl.ensureConsistent$checkMMapDiff(failures, "callableMap", this.state.getPropertyMap(), newState.getPropertyMap());
        FirProviderImpl.ensureConsistent$checkMMapDiff(failures, "callableMap", this.state.getConstructorMap(), newState.getConstructorMap());
        FirProviderImpl.ensureConsistent$checkMapDiff$default(failures, "callableContainerMap", this.state.getCallableContainerMap(), newState.getCallableContainerMap(), null, 16, null);
        this.state.setFrom(newState);
    }

    @Override
    @NotNull
    public Set<Name> getClassNamesInPackage(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Set set = this.state.getClassesInPackage().get(fqName);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private static final List recordFile$lambda$1(List a, List b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return CollectionsKt.plus((Collection)a, (Iterable)b);
    }

    private static final List recordFile$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return (List)$tmp0.invoke(p0, p1);
    }

    private static final FqName recordFile$lambda$3(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FqNamesUtilKt.parentOrNull(it);
    }

    private static final boolean ensureConsistent$checkMapDiff$lambda$6(Object old, Object object) {
        return old == object;
    }

    /*
     * WARNING - void declaration
     */
    private static final <K, V> void ensureConsistent$checkMapDiff(List<String> failures, String title, Map<K, ? extends V> a, Map<K, ? extends V> b, Function2<? super V, ? super V, Boolean> equal) {
        void $this$mapTo$iv$iv;
        boolean hasTitle = false;
        Set unionKeys = SetsKt.plus(a.keySet(), (Iterable)b.keySet());
        Iterable $this$map$iv = unionKeys;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Triple((Object)it, a.get(it), b.get(it)));
        }
        for (Triple triple : (List)destination$iv$iv) {
            Object bValue;
            Object key = triple.component1();
            Object aValue = triple.component2();
            if (((Boolean)equal.invoke(aValue, bValue = triple.component3())).booleanValue()) continue;
            if (!hasTitle) {
                ((Collection)failures).add(title);
                hasTitle = true;
            }
            ((Collection)failures).add("diff at key = '" + key + "': was: '" + aValue + "', become: '" + bValue + '\'');
        }
    }

    static /* synthetic */ void ensureConsistent$checkMapDiff$default(List list, String string2, Map map, Map map2, Function2 function2, int n, Object object) {
        if ((n & 0x10) != 0) {
            function2 = FirProviderImpl::ensureConsistent$checkMapDiff$lambda$6;
        }
        FirProviderImpl.ensureConsistent$checkMapDiff(list, string2, map, map2, function2);
    }

    /*
     * WARNING - void declaration
     */
    private static final <K, V> void ensureConsistent$checkMMapDiff(List<String> failures, String title, Map<K, ? extends List<? extends V>> a, Map<K, ? extends List<? extends V>> b) {
        void $this$mapTo$iv$iv;
        boolean hasTitle = false;
        Set unionKeys = SetsKt.plus(a.keySet(), (Iterable)b.keySet());
        Iterable $this$map$iv = unionKeys;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Triple((Object)it, a.get(it), b.get(it)));
        }
        for (Triple triple : (List)destination$iv$iv) {
            Object it;
            Object element$iv;
            Object key = triple.component1();
            List aValue = (List)triple.component2();
            List bValue = (List)triple.component3();
            if (aValue == null || bValue == null) {
                if (!hasTitle) {
                    ((Collection)failures).add(title);
                    hasTitle = true;
                }
                ((Collection)failures).add("diff at key = '" + key + "': was: " + aValue + ", become: " + bValue);
                continue;
            }
            Set aSet = CollectionsKt.toSet((Iterable)aValue);
            Set bSet = CollectionsKt.toSet((Iterable)bValue);
            Set aLost = SetsKt.minus((Set)aSet, (Iterable)bSet);
            Set bNew = SetsKt.minus((Set)bSet, (Iterable)aSet);
            if (!(!((Collection)aLost).isEmpty()) && !(!((Collection)bNew).isEmpty())) continue;
            ((Collection)failures).add("diff at key = '" + key + "':");
            ((Collection)failures).add("    Lost:");
            Iterable $this$forEach$iv = aLost;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv.iterator();
            while (iterator3.hasNext()) {
                it = element$iv = iterator3.next();
                boolean bl = false;
                ((Collection)failures).add("     " + it);
            }
            ((Collection)failures).add("    New:");
            $this$forEach$iv = bNew;
            $i$f$forEach = false;
            iterator3 = $this$forEach$iv.iterator();
            while (iterator3.hasNext()) {
                it = element$iv = iterator3.next();
                boolean bl = false;
                ((Collection)failures).add("     " + it);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u0003H\u0016JT\u0010\u0016\u001a\u00020\u0002\"\n\b\u0000\u0010\u0017\u0018\u0001*\u00020\u0018\"\u000e\b\u0001\u0010\u0019*\b\u0012\u0004\u0012\u0002H\u00170\u001a2\u0006\u0010\u001b\u001a\u0002H\u00192\u0006\u0010\t\u001a\u00020\u00032\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00190\u001f0\u001dH\u0082\b\u00a2\u0006\u0002\u0010 J\u0018\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020)2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020/2\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$FirRecorder;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$FirRecorderData;", "<init>", "()V", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "visitClassifier", "classLike", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "visitPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "registerCallable", "D", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "S", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "symbol", "map", "", "Lorg/jetbrains/kotlin/name/CallableId;", "", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$FirRecorderData;Ljava/util/Map;)V", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "visitScript", "script", "Lorg/jetbrains/kotlin/fir/declarations/FirScript;", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirProviderImpl.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$FirRecorder\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,340:1\n172#1,4:362\n172#1,4:366\n172#1,4:370\n381#2,7:341\n381#2,7:348\n381#2,7:355\n1#3:374\n*S KotlinDebug\n*F\n+ 1 FirProviderImpl.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$FirRecorder\n*L\n179#1:362,4\n184#1:366,4\n189#1:370,4\n131#1:341,7\n132#1:348,7\n141#1:355,7\n*E\n"})
    private static final class FirRecorder
    extends FirDefaultVisitor<Unit, FirRecorderData> {
        @NotNull
        public static final FirRecorder INSTANCE = new FirRecorder();

        private FirRecorder() {
        }

        @Override
        public void visitElement(@NotNull FirElement element2, @NotNull FirRecorderData data) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        }

        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull FirRecorderData data) {
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.visitClassifier(regularClass, data);
            ClassId classId = regularClass.getSymbol().getClassId();
            if (!classId.isNestedClass() && !classId.isLocal()) {
                Object object;
                Object object2;
                Map<FqName, Set<Name>> $this$getOrPut$iv;
                Map<FqName, Set<Name>> map = data.getState().getClassesInPackage();
                FqName key$iv = classId.getPackageFqName();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean $i$f$visitRegularClass$stub_for_inlining = false;
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((Set)object2).add(classId.getShortClassName());
                $this$getOrPut$iv = data.getState().getClassifierInPackage();
                key$iv = classId.getPackageFqName();
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean $i$f$visitRegularClass$stub_for_inlining$0 = false;
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).add(classId.getShortClassName());
            }
            regularClass.acceptChildren(this, data);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitTypeAlias(@NotNull FirTypeAlias typeAlias, @NotNull FirRecorderData data) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.visitClassifier(typeAlias, data);
            ClassId classId = typeAlias.getSymbol().getClassId();
            Map<FqName, Set<Name>> map = data.getState().getClassifierInPackage();
            FqName key$iv = classId.getPackageFqName();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean $i$f$visitTypeAlias$stub_for_inlining$1 = false;
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Set)object).add(classId.getShortClassName());
        }

        private final void visitClassifier(FirClassLikeDeclaration classLike, FirRecorderData data) {
            block1: {
                ClassId classId;
                block0: {
                    classId = classLike.getSymbol().getClassId();
                    if (data.getState().getClassifierMap().containsKey(classId)) break block0;
                    data.getState().getClassifierMap().put(classId, classLike);
                    data.getState().getClassifierContainerFileMap().put(classId, data.getFile());
                    break block1;
                }
                FirNameConflictsTrackerComponent firNameConflictsTrackerComponent = data.getNameConflictsTracker();
                if (firNameConflictsTrackerComponent == null) break block1;
                firNameConflictsTrackerComponent.registerClassifierRedeclaration(classId, classLike.getSymbol(), data.getFile(), ((FirClassLikeDeclaration)MapsKt.getValue(data.getState().getClassifierMap(), (Object)classId)).getSymbol(), (FirFile)MapsKt.getValue(data.getState().getClassifierContainerFileMap(), (Object)classId));
            }
        }

        @Override
        public void visitPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor, @NotNull FirRecorderData data) {
            Intrinsics.checkNotNullParameter((Object)propertyAccessor, (String)"propertyAccessor");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            FirPropertyAccessorSymbol symbol2 = propertyAccessor.getSymbol();
            data.getState().getCallableContainerMap().put(symbol2, data.getFile());
        }

        private final /* synthetic */ <D extends FirCallableDeclaration, S extends FirCallableSymbol<? extends D>> void registerCallable(S symbol2, FirRecorderData data, Map<CallableId, List<S>> map) {
            boolean $i$f$registerCallable = false;
            CallableId callableId = symbol2.getCallableId();
            Function2 function2 = registerCallable.1.INSTANCE;
            map.merge(callableId, CollectionsKt.listOf(symbol2), new BiFunction(function2){
                private final /* synthetic */ Function2 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                    this.function = function2;
                }

                public final /* synthetic */ Object apply(Object p0, Object p1) {
                    return this.function.invoke(p0, p1);
                }
            });
            data.getState().getCallableContainerMap().put(symbol2, data.getFile());
        }

        @Override
        public void visitConstructor(@NotNull FirConstructor constructor, @NotNull FirRecorderData data) {
            Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            FirConstructorSymbol symbol2 = constructor.getSymbol();
            FirRecorder firRecorder = this;
            Map<CallableId, List<FirConstructorSymbol>> map$iv = data.getState().getConstructorMap();
            boolean $i$f$registerCallable = false;
            CallableId callableId$iv = ((FirCallableSymbol)symbol2).getCallableId();
            Function2 function2 = registerCallable.1.INSTANCE;
            map$iv.merge(callableId$iv, CollectionsKt.listOf((Object)symbol2), new /* invalid duplicate definition of identical inner class */);
            data.getState().getCallableContainerMap().put(symbol2, data.getFile());
        }

        @Override
        public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull FirRecorderData data) {
            Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            FirNamedFunctionSymbol symbol2 = simpleFunction.getSymbol();
            FirRecorder firRecorder = this;
            Map<CallableId, List<FirNamedFunctionSymbol>> map$iv = data.getState().getFunctionMap();
            boolean $i$f$registerCallable = false;
            CallableId callableId$iv = ((FirCallableSymbol)symbol2).getCallableId();
            Function2 function2 = registerCallable.1.INSTANCE;
            map$iv.merge(callableId$iv, CollectionsKt.listOf((Object)symbol2), new /* invalid duplicate definition of identical inner class */);
            data.getState().getCallableContainerMap().put(symbol2, data.getFile());
        }

        @Override
        public void visitProperty(@NotNull FirProperty property, @NotNull FirRecorderData data) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                FirPropertySymbol symbol2 = property.getSymbol();
                FirRecorder firRecorder = this;
                Map<CallableId, List<FirPropertySymbol>> map$iv = data.getState().getPropertyMap();
                boolean $i$f$registerCallable = false;
                CallableId callableId$iv = ((FirCallableSymbol)symbol2).getCallableId();
                Function2 function2 = registerCallable.1.INSTANCE;
                map$iv.merge(callableId$iv, CollectionsKt.listOf((Object)symbol2), new /* invalid duplicate definition of identical inner class */);
                data.getState().getCallableContainerMap().put(symbol2, data.getFile());
                FirPropertyAccessor firPropertyAccessor = property.getGetter();
                if (firPropertyAccessor != null) {
                    FirPropertyAccessor it = firPropertyAccessor;
                    boolean bl = false;
                    INSTANCE.visitPropertyAccessor(it, data);
                }
                FirPropertyAccessor firPropertyAccessor2 = property.getSetter();
                if (firPropertyAccessor2 == null) break block1;
                FirPropertyAccessor it = firPropertyAccessor2;
                boolean bl = false;
                INSTANCE.visitPropertyAccessor(it, data);
            }
        }

        @Override
        public void visitEnumEntry(@NotNull FirEnumEntry enumEntry, @NotNull FirRecorderData data) {
            Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            FirEnumEntrySymbol symbol2 = enumEntry.getSymbol();
            data.getState().getCallableContainerMap().put(symbol2, data.getFile());
        }

        @Override
        public void visitScript(@NotNull FirScript script, @NotNull FirRecorderData data) {
            Intrinsics.checkNotNullParameter((Object)script, (String)"script");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            FirScriptSymbol symbol2 = script.getSymbol();
            data.getState().getScriptContainerMap().put(symbol2, data.getFile());
            Object object = data.getFile().getSourceFile();
            if (object != null && (object = object.getPath()) != null) {
                Object it = object;
                boolean bl = false;
                data.getState().getScriptByFilePathMap().put((String)it, symbol2);
            }
            script.acceptChildren(this, data);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$FirRecorderData;", "", "state", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$State;", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "nameConflictsTracker", "Lorg/jetbrains/kotlin/fir/FirNameConflictsTrackerComponent;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$State;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/fir/FirNameConflictsTrackerComponent;)V", "getState", "()Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$State;", "getFile", "()Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getNameConflictsTracker", "()Lorg/jetbrains/kotlin/fir/FirNameConflictsTrackerComponent;", "resolve"})
    private static final class FirRecorderData {
        @NotNull
        private final State state;
        @NotNull
        private final FirFile file;
        @Nullable
        private final FirNameConflictsTrackerComponent nameConflictsTracker;

        public FirRecorderData(@NotNull State state, @NotNull FirFile file2, @Nullable FirNameConflictsTrackerComponent nameConflictsTracker) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            this.state = state;
            this.file = file2;
            this.nameConflictsTracker = nameConflictsTracker;
        }

        @NotNull
        public final State getState() {
            return this.state;
        }

        @NotNull
        public final FirFile getFile() {
            return this.file;
        }

        @Nullable
        public final FirNameConflictsTrackerComponent getNameConflictsTracker() {
            return this.nameConflictsTracker;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0000R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR#\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\nR#\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\nR#\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\nR#\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\nR#\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\nR!\u0010$\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030%\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\nR\u001d\u0010'\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\nR\u001d\u0010*\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020(0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\n\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$State;", "", "<init>", "()V", "fileMap", "", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getFileMap", "()Ljava/util/Map;", "allSubPackages", "", "getAllSubPackages", "()Ljava/util/Set;", "classifierMap", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "getClassifierMap", "classifierContainerFileMap", "getClassifierContainerFileMap", "classifierInPackage", "Lorg/jetbrains/kotlin/name/Name;", "getClassifierInPackage", "classesInPackage", "getClassesInPackage", "functionMap", "Lorg/jetbrains/kotlin/name/CallableId;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getFunctionMap", "propertyMap", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getPropertyMap", "constructorMap", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "getConstructorMap", "callableContainerMap", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getCallableContainerMap", "scriptContainerMap", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirScriptSymbol;", "getScriptContainerMap", "scriptByFilePathMap", "", "getScriptByFilePathMap", "setFrom", "", "other", "resolve"})
    private static final class State {
        @NotNull
        private final Map<FqName, List<FirFile>> fileMap = new LinkedHashMap();
        @NotNull
        private final Set<FqName> allSubPackages = new LinkedHashSet();
        @NotNull
        private final Map<ClassId, FirClassLikeDeclaration> classifierMap = new LinkedHashMap();
        @NotNull
        private final Map<ClassId, FirFile> classifierContainerFileMap = new LinkedHashMap();
        @NotNull
        private final Map<FqName, Set<Name>> classifierInPackage = new LinkedHashMap();
        @NotNull
        private final Map<FqName, Set<Name>> classesInPackage = new LinkedHashMap();
        @NotNull
        private final Map<CallableId, List<FirNamedFunctionSymbol>> functionMap = new LinkedHashMap();
        @NotNull
        private final Map<CallableId, List<FirPropertySymbol>> propertyMap = new LinkedHashMap();
        @NotNull
        private final Map<CallableId, List<FirConstructorSymbol>> constructorMap = new LinkedHashMap();
        @NotNull
        private final Map<FirCallableSymbol<?>, FirFile> callableContainerMap = new LinkedHashMap();
        @NotNull
        private final Map<FirScriptSymbol, FirFile> scriptContainerMap = new LinkedHashMap();
        @NotNull
        private final Map<String, FirScriptSymbol> scriptByFilePathMap = new LinkedHashMap();

        @NotNull
        public final Map<FqName, List<FirFile>> getFileMap() {
            return this.fileMap;
        }

        @NotNull
        public final Set<FqName> getAllSubPackages() {
            return this.allSubPackages;
        }

        @NotNull
        public final Map<ClassId, FirClassLikeDeclaration> getClassifierMap() {
            return this.classifierMap;
        }

        @NotNull
        public final Map<ClassId, FirFile> getClassifierContainerFileMap() {
            return this.classifierContainerFileMap;
        }

        @NotNull
        public final Map<FqName, Set<Name>> getClassifierInPackage() {
            return this.classifierInPackage;
        }

        @NotNull
        public final Map<FqName, Set<Name>> getClassesInPackage() {
            return this.classesInPackage;
        }

        @NotNull
        public final Map<CallableId, List<FirNamedFunctionSymbol>> getFunctionMap() {
            return this.functionMap;
        }

        @NotNull
        public final Map<CallableId, List<FirPropertySymbol>> getPropertyMap() {
            return this.propertyMap;
        }

        @NotNull
        public final Map<CallableId, List<FirConstructorSymbol>> getConstructorMap() {
            return this.constructorMap;
        }

        @NotNull
        public final Map<FirCallableSymbol<?>, FirFile> getCallableContainerMap() {
            return this.callableContainerMap;
        }

        @NotNull
        public final Map<FirScriptSymbol, FirFile> getScriptContainerMap() {
            return this.scriptContainerMap;
        }

        @NotNull
        public final Map<String, FirScriptSymbol> getScriptByFilePathMap() {
            return this.scriptByFilePathMap;
        }

        public final void setFrom(@NotNull State other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            this.fileMap.clear();
            this.allSubPackages.clear();
            this.classifierMap.clear();
            this.classifierContainerFileMap.clear();
            this.functionMap.clear();
            this.propertyMap.clear();
            this.constructorMap.clear();
            this.callableContainerMap.clear();
            this.scriptContainerMap.clear();
            this.scriptByFilePathMap.clear();
            this.fileMap.putAll(other.fileMap);
            this.allSubPackages.addAll((Collection<FqName>)other.allSubPackages);
            this.classifierMap.putAll(other.classifierMap);
            this.classifierContainerFileMap.putAll(other.classifierContainerFileMap);
            this.functionMap.putAll(other.functionMap);
            this.propertyMap.putAll(other.propertyMap);
            this.constructorMap.putAll(other.constructorMap);
            this.callableContainerMap.putAll(other.callableContainerMap);
            this.scriptContainerMap.putAll(other.scriptContainerMap);
            this.scriptByFilePathMap.putAll(other.scriptByFilePathMap);
            this.classesInPackage.putAll(other.classesInPackage);
            this.classifierInPackage.putAll(other.classifierInPackage);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J*\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J&\u0010\u0011\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J&\u0010\u0013\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$SymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl;)V", "getClassLikeSymbolByClassId", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getTopLevelCallableSymbolsTo", "", "destination", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelFunctionSymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelPropertySymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getPackage", "fqName", "symbolNamesProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getSymbolNamesProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "resolve"})
    private final class SymbolProvider
    extends FirSymbolProvider {
        @NotNull
        private final FirSymbolNamesProvider symbolNamesProvider;

        public SymbolProvider() {
            super(FirProviderImpl.this.getSession());
            this.symbolNamesProvider = new FirSymbolNamesProvider(FirProviderImpl.this){
                final /* synthetic */ FirProviderImpl this$0;
                {
                    this.this$0 = $receiver;
                }

                /*
                 * WARNING - void declaration
                 */
                public Set<String> getPackageNames() {
                    Set set;
                    Collection $this$mapToSetOrEmpty$iv = FirProviderImpl.access$getState$p(this.this$0).getAllSubPackages();
                    boolean $i$f$mapToSetOrEmpty = false;
                    if (!$this$mapToSetOrEmpty$iv.isEmpty()) {
                        void destination$iv$iv;
                        void $this$mapTo$iv$iv;
                        Iterable iterable = $this$mapToSetOrEmpty$iv;
                        Collection collection = new LinkedHashSet<E>();
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void p0;
                            FqName fqName = (FqName)item$iv$iv;
                            void var11_11 = destination$iv$iv;
                            boolean $i$f$getPackageNames$stub_for_inlining = false;
                            boolean bl = false;
                            var11_11.add(p0.asString());
                        }
                        set = (Set)destination$iv$iv;
                    } else {
                        set = SetsKt.emptySet();
                    }
                    return set;
                }

                public boolean getHasSpecificClassifierPackageNamesComputation() {
                    return false;
                }

                public boolean getHasSpecificCallablePackageNamesComputation() {
                    return false;
                }

                public Set<Name> getTopLevelClassifierNamesInPackage(FqName packageFqName) {
                    Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
                    Set set = FirProviderImpl.access$getState$p(this.this$0).getClassifierInPackage().get(packageFqName);
                    if (set == null) {
                        set = SetsKt.emptySet();
                    }
                    return set;
                }

                public Set<Name> getTopLevelCallableNamesInPackage(FqName packageFqName) {
                    Set set;
                    Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
                    FirProviderImpl firProviderImpl = this.this$0;
                    Set $this$getTopLevelCallableNamesInPackage_u24lambda_u240 = set = SetsKt.createSetBuilder();
                    boolean bl = false;
                    for (CallableId key : FirProviderImpl.access$getState$p(firProviderImpl).getFunctionMap().keySet()) {
                        if (!Intrinsics.areEqual((Object)key.getPackageName(), (Object)packageFqName)) continue;
                        $this$getTopLevelCallableNamesInPackage_u24lambda_u240.add(key.getCallableName());
                    }
                    for (CallableId key : FirProviderImpl.access$getState$p(firProviderImpl).getPropertyMap().keySet()) {
                        if (!Intrinsics.areEqual((Object)key.getPackageName(), (Object)packageFqName)) continue;
                        $this$getTopLevelCallableNamesInPackage_u24lambda_u240.add(key.getCallableName());
                    }
                    return SetsKt.build((Set)set);
                }
            };
        }

        @Override
        @Nullable
        public FirClassLikeSymbol<?> getClassLikeSymbolByClassId(@NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            FirClassLikeDeclaration firClassLikeDeclaration = FirProviderImpl.this.getFirClassifierByFqName(classId);
            return firClassLikeDeclaration != null ? firClassLikeDeclaration.getSymbol() : null;
        }

        @Override
        @FirSymbolProviderInternals
        public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
            Intrinsics.checkNotNullParameter(destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Collection collection = destination;
            List<FirNamedFunctionSymbol> list = FirProviderImpl.this.state.getFunctionMap().get(new CallableId(packageFqName, name2));
            CollectionsKt.addAll((Collection)collection, (Iterable)(list != null ? (Iterable)list : (Iterable)CollectionsKt.emptyList()));
            collection = destination;
            List<FirPropertySymbol> list2 = FirProviderImpl.this.state.getPropertyMap().get(new CallableId(packageFqName, name2));
            CollectionsKt.addAll((Collection)collection, (Iterable)(list2 != null ? (Iterable)list2 : (Iterable)CollectionsKt.emptyList()));
        }

        @Override
        @FirSymbolProviderInternals
        public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
            Intrinsics.checkNotNullParameter(destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Collection collection = destination;
            List<FirNamedFunctionSymbol> list = FirProviderImpl.this.state.getFunctionMap().get(new CallableId(packageFqName, name2));
            CollectionsKt.addAll((Collection)collection, (Iterable)(list != null ? (Iterable)list : (Iterable)CollectionsKt.emptyList()));
        }

        @Override
        @FirSymbolProviderInternals
        public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
            Intrinsics.checkNotNullParameter(destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Collection collection = destination;
            List<FirPropertySymbol> list = FirProviderImpl.this.state.getPropertyMap().get(new CallableId(packageFqName, name2));
            CollectionsKt.addAll((Collection)collection, (Iterable)(list != null ? (Iterable)list : (Iterable)CollectionsKt.emptyList()));
        }

        @Override
        @Nullable
        public FqName getPackage(@NotNull FqName fqName) {
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
            if (FirProviderImpl.this.state.getAllSubPackages().contains(fqName)) {
                return fqName;
            }
            return null;
        }

        @Override
        @NotNull
        public FirSymbolNamesProvider getSymbolNamesProvider() {
            return this.symbolNamesProvider;
        }
    }
}

