/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import com.intellij.openapi.util.text.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.rendering.ContextIndependentParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRendererKt;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00130\u00120\u0011\"\u0004\b\u0000\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0011H\u0007J\u009b\u0001\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0005\"\u0004\b\u0000\u0010\u0017\"\u0004\b\u0001\u0010\u00162\u0006\u0010\u0018\u001a\u00020\u00072\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u0002H\u00170\u001aj\b\u0012\u0004\u0012\u0002H\u0017`\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00112!\u0010\u001d\u001a\u001d\u0012\b\u0012\u00060\u001fj\u0002` \u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u00020!0\u001e\u00a2\u0006\u0002\b\"2\u0018\u0010#\u001a\u0014\u0012\u0004\u0012\u0002H\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\u00120$2\u0014\b\u0002\u0010%\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u00020\u00070$H\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/CommonRenderers;", "", "<init>", "()V", "EMPTY", "Lorg/jetbrains/kotlin/diagnostics/rendering/ContextIndependentParameterRenderer;", "STRING", "", "NAME", "Lorg/jetbrains/kotlin/name/Name;", "THROWABLE", "", "RENDER_POSITION_VARIANCE", "Lorg/jetbrains/kotlin/types/Variance;", "CLASS_KIND", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "commaSeparated", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;", "", "T", "itemRenderer", "renderConflictingSignatureData", "Data", "Declaration", "signatureKind", "sortUsing", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "declarationRenderer", "renderSignature", "Lkotlin/Function2;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "", "Lkotlin/ExtensionFunctionType;", "declarations", "Lkotlin/Function1;", "declarationKind", "frontend.common-psi"})
public final class CommonRenderers {
    @NotNull
    public static final CommonRenderers INSTANCE = new CommonRenderers();
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<Object> EMPTY = DiagnosticParameterRendererKt.Renderer(CommonRenderers::EMPTY$lambda$0);
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<String> STRING = DiagnosticParameterRendererKt.Renderer(CommonRenderers::STRING$lambda$1);
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<Name> NAME = DiagnosticParameterRendererKt.Renderer(CommonRenderers::NAME$lambda$2);
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<Throwable> THROWABLE = DiagnosticParameterRendererKt.Renderer(CommonRenderers::THROWABLE$lambda$3);
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<Variance> RENDER_POSITION_VARIANCE = DiagnosticParameterRendererKt.Renderer(CommonRenderers::RENDER_POSITION_VARIANCE$lambda$4);
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<ClassKind> CLASS_KIND = DiagnosticParameterRendererKt.Renderer(CommonRenderers::CLASS_KIND$lambda$5);

    private CommonRenderers() {
    }

    @JvmStatic
    @NotNull
    public static final <T> DiagnosticParameterRenderer<Collection<? extends T>> commaSeparated(@NotNull DiagnosticParameterRenderer<? super T> itemRenderer) {
        Intrinsics.checkNotNullParameter(itemRenderer, (String)"itemRenderer");
        return DiagnosticParameterRendererKt.ContextDependentRenderer((arg_0, arg_1) -> CommonRenderers.commaSeparated$lambda$7(itemRenderer, arg_0, arg_1));
    }

    @JvmStatic
    @NotNull
    public static final <Declaration, Data> ContextIndependentParameterRenderer<Data> renderConflictingSignatureData(@NotNull String signatureKind, @NotNull Comparator<Declaration> sortUsing, @NotNull DiagnosticParameterRenderer<? super Declaration> declarationRenderer, @NotNull Function2<? super StringBuilder, ? super Data, Unit> renderSignature, @NotNull Function1<? super Data, ? extends Collection<? extends Declaration>> declarations2, @NotNull Function1<? super Data, String> declarationKind) {
        Intrinsics.checkNotNullParameter((Object)signatureKind, (String)"signatureKind");
        Intrinsics.checkNotNullParameter(sortUsing, (String)"sortUsing");
        Intrinsics.checkNotNullParameter(declarationRenderer, (String)"declarationRenderer");
        Intrinsics.checkNotNullParameter(renderSignature, (String)"renderSignature");
        Intrinsics.checkNotNullParameter(declarations2, (String)"declarations");
        Intrinsics.checkNotNullParameter(declarationKind, (String)"declarationKind");
        return DiagnosticParameterRendererKt.Renderer(arg_0 -> CommonRenderers.renderConflictingSignatureData$lambda$11(declarations2, sortUsing, declarationKind, signatureKind, renderSignature, declarationRenderer, arg_0));
    }

    public static /* synthetic */ ContextIndependentParameterRenderer renderConflictingSignatureData$default(String string2, Comparator comparator, DiagnosticParameterRenderer diagnosticParameterRenderer, Function2 function2, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 0x20) != 0) {
            function12 = CommonRenderers::renderConflictingSignatureData$lambda$8;
        }
        return CommonRenderers.renderConflictingSignatureData(string2, comparator, diagnosticParameterRenderer, function2, function1, function12);
    }

    private static final String EMPTY$lambda$0(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "";
    }

    private static final String STRING$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final String NAME$lambda$2(Name it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string2 = it.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        return string2;
    }

    private static final String THROWABLE$lambda$3(Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        StringWriter writer = new StringWriter();
        it.printStackTrace(new PrintWriter(writer));
        String string2 = StringUtil.first(writer.toString(), 2048, true);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"first(...)");
        return string2;
    }

    private static final String RENDER_POSITION_VARIANCE$lambda$4(Variance variance2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)((Object)variance2), (String)"variance");
        switch (WhenMappings.$EnumSwitchMapping$0[variance2.ordinal()]) {
            case 1: {
                string2 = "invariant";
                break;
            }
            case 2: {
                string2 = "in";
                break;
            }
            case 3: {
                string2 = "out";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    private static final String CLASS_KIND$lambda$5(ClassKind classKind2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)((Object)classKind2), (String)"classKind");
        switch (WhenMappings.$EnumSwitchMapping$1[classKind2.ordinal()]) {
            case 1: {
                string2 = "class";
                break;
            }
            case 2: {
                string2 = "interface";
                break;
            }
            case 3: {
                string2 = "enum class";
                break;
            }
            case 4: {
                string2 = "enum entry";
                break;
            }
            case 5: {
                string2 = "annotation class";
                break;
            }
            case 6: {
                string2 = "object";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    private static final String commaSeparated$lambda$7(DiagnosticParameterRenderer $itemRenderer, Collection collection, RenderingContext context2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        StringBuilder $this$commaSeparated_u24lambda_u247_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterator iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            Object next2 = iterator2.next();
            $this$commaSeparated_u24lambda_u247_u24lambda_u246.append($itemRenderer.render(next2, context2));
            if (!iterator2.hasNext()) continue;
            $this$commaSeparated_u24lambda_u247_u24lambda_u246.append(", ");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private static final String renderConflictingSignatureData$lambda$8(Object it) {
        return "declarations";
    }

    private static final Unit renderConflictingSignatureData$lambda$11$lambda$10$lambda$9(DiagnosticParameterRenderer $declarationRenderer, RenderingContext.Impl $renderingContext, StringBuilder $this$joinToWithBuffer, Object descriptor2) {
        Intrinsics.checkNotNullParameter((Object)$this$joinToWithBuffer, (String)"$this$joinToWithBuffer");
        $this$joinToWithBuffer.append("    ");
        $this$joinToWithBuffer.append($declarationRenderer.render(descriptor2, $renderingContext));
        return Unit.INSTANCE;
    }

    private static final String renderConflictingSignatureData$lambda$11(Function1 $declarations, Comparator $sortUsing, Function1 $declarationKind, String $signatureKind, Function2 $renderSignature, DiagnosticParameterRenderer $declarationRenderer, Object data) {
        StringBuilder stringBuilder;
        List sortedDeclarations = CollectionsKt.sortedWith((Iterable)((Iterable)$declarations.invoke(data)), (Comparator)$sortUsing);
        RenderingContext.Impl renderingContext = new RenderingContext.Impl(sortedDeclarations);
        StringBuilder $this$renderConflictingSignatureData_u24lambda_u2411_u24lambda_u2410 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$renderConflictingSignatureData_u24lambda_u2411_u24lambda_u2410.append("The following ");
        $this$renderConflictingSignatureData_u24lambda_u2411_u24lambda_u2410.append((String)$declarationKind.invoke(data));
        $this$renderConflictingSignatureData_u24lambda_u2411_u24lambda_u2410.append(" have the same ");
        $this$renderConflictingSignatureData_u24lambda_u2411_u24lambda_u2410.append($signatureKind);
        $this$renderConflictingSignatureData_u24lambda_u2411_u24lambda_u2410.append(" signature (");
        $renderSignature.invoke((Object)$this$renderConflictingSignatureData_u24lambda_u2411_u24lambda_u2410, data);
        StringBuilder stringBuilder2 = $this$renderConflictingSignatureData_u24lambda_u2411_u24lambda_u2410.append("):");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        AddToStdlibKt.joinToWithBuffer$default(sortedDeclarations, $this$renderConflictingSignatureData_u24lambda_u2411_u24lambda_u2410, "\n", null, null, 0, null, (arg_0, arg_1) -> CommonRenderers.renderConflictingSignatureData$lambda$11$lambda$10$lambda$9($declarationRenderer, renderingContext, arg_0, arg_1), 60, null);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Variance.values().length];
            try {
                nArray[Variance.INVARIANT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.IN_VARIANCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.OUT_VARIANCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.INTERFACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_CLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

