/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.localfs;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.localfs.KotlinLocalFileSystem;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0016J\u0013\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\u0018J\"\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001eH\u0016J\b\u0010#\u001a\u00020\u001eH\u0016J\"\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u00132\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u001eH\u0016J\b\u0010-\u001a\u00020\u0013H\u0016J\u0013\u0010.\u001a\u00020\u00132\b\u0010/\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u00100\u001a\u000201H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/cli/common/localfs/KotlinLocalVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "Ljava/io/File;", "_fileSystem", "Lorg/jetbrains/kotlin/cli/common/localfs/KotlinLocalFileSystem;", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlin/cli/common/localfs/KotlinLocalFileSystem;)V", "getFile", "()Ljava/io/File;", "_children", "", "[Lcom/intellij/openapi/vfs/VirtualFile;", "getName", "", "getFileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "getPath", "isWritable", "", "isDirectory", "isValid", "getParent", "getChildren", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "getOutputStream", "Ljava/io/OutputStream;", "requestor", "", "newModificationStamp", "", "newTimeStamp", "contentsToByteArray", "", "getTimeStamp", "getLength", "refresh", "", "asynchronous", "recursive", "postRunnable", "Ljava/lang/Runnable;", "getInputStream", "Ljava/io/InputStream;", "getModificationStamp", "isInLocalFileSystem", "equals", "other", "hashCode", "", "cli-base"})
@SourceDebugExtension(value={"SMAP\nKotlinLocalVirtualFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLocalVirtualFile.kt\norg/jetbrains/kotlin/cli/common/localfs/KotlinLocalVirtualFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,105:1\n1#2:106\n11165#3:107\n11500#3,3:108\n37#4,2:111\n*S KotlinDebug\n*F\n+ 1 KotlinLocalVirtualFile.kt\norg/jetbrains/kotlin/cli/common/localfs/KotlinLocalVirtualFile\n*L\n53#1:107\n53#1:108,3\n53#1:111,2\n*E\n"})
public final class KotlinLocalVirtualFile
extends VirtualFile {
    @NotNull
    private final File file;
    @NotNull
    private final KotlinLocalFileSystem _fileSystem;
    @Nullable
    private VirtualFile[] _children;

    public KotlinLocalVirtualFile(@NotNull File file2, @NotNull KotlinLocalFileSystem _fileSystem) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)_fileSystem, (String)"_fileSystem");
        this.file = file2;
        this._fileSystem = _fileSystem;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return string2;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this._fileSystem;
    }

    @Override
    @NotNull
    public String getPath() {
        String string2 = FileUtil.toSystemIndependentName(this.file.getAbsolutePath());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
        return string2;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    @Nullable
    public VirtualFile getParent() {
        File file2 = this.file.getParentFile();
        if (file2 == null) {
            return null;
        }
        File parentFile = file2;
        return new KotlinLocalVirtualFile(parentFile, this._fileSystem);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public VirtualFile[] getChildren() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        File[] fileChildren;
        VirtualFile[] virtualFileArray = this._children;
        if (virtualFileArray != null) {
            VirtualFile[] it = virtualFileArray;
            boolean bl = false;
            return it;
        }
        File[] fileArray = this.file.listFiles();
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        File[] fileArray2 = fileChildren = fileArray;
        KotlinLocalVirtualFile kotlinLocalVirtualFile = this;
        boolean $i$f$map = false;
        void bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_13 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new KotlinLocalVirtualFile((File)it, this._fileSystem));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        kotlinLocalVirtualFile._children = thisCollection$iv.toArray(new VirtualFile[0]);
        Intrinsics.checkNotNull((Object)this._children);
        return this._children;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(@Nullable Object requestor, long newModificationStamp, long newTimeStamp) {
        AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
        throw new KotlinNothingValueException();
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() {
        byte[] byArray = FileUtil.loadFileBytes(this.file);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"loadFileBytes(...)");
        return byArray;
    }

    @Override
    public long getTimeStamp() {
        return this.file.lastModified();
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        InputStream inputStream = VfsUtilCore.inputStreamSkippingBOM(new BufferedInputStream(new FileInputStream(this.file)), this);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStreamSkippingBOM(...)");
        return inputStream;
    }

    @Override
    public long getModificationStamp() {
        return 0L;
    }

    @Override
    public boolean isInLocalFileSystem() {
        return true;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cli.common.localfs.KotlinLocalVirtualFile");
        KotlinLocalVirtualFile cfr_ignored_0 = (KotlinLocalVirtualFile)other;
        return Intrinsics.areEqual((Object)this.file, (Object)((KotlinLocalVirtualFile)other).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

