/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.ParameterTypeConversion;
import org.jetbrains.kotlin.resolve.calls.components.candidate.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtomsKt;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0004H\u0016J(\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/SuspendTypeConversions;", "Lorg/jetbrains/kotlin/resolve/calls/components/ParameterTypeConversion;", "()V", "conversionDefinitelyNotNeeded", "", "candidate", "Lorg/jetbrains/kotlin/resolve/calls/components/candidate/ResolutionCandidate;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "expectedParameterType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "conversionIsNeededAfterSubtypingCheck", "conversionIsNeededBeforeSubtypingCheck", "areSuspendOnlySamConversionsSupported", "convertParameterType", "parameter", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "resolution"})
@SourceDebugExtension(value={"SMAP\nSuspendConversionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuspendConversionUtils.kt\norg/jetbrains/kotlin/resolve/calls/components/SuspendTypeConversions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1547#2:65\n1618#2,3:66\n*S KotlinDebug\n*F\n+ 1 SuspendConversionUtils.kt\norg/jetbrains/kotlin/resolve/calls/components/SuspendTypeConversions\n*L\n51#1:65\n51#1:66,3\n*E\n"})
public final class SuspendTypeConversions
implements ParameterTypeConversion {
    @NotNull
    public static final SuspendTypeConversions INSTANCE = new SuspendTypeConversions();

    private SuspendTypeConversions() {
    }

    @Override
    public boolean conversionDefinitelyNotNeeded(@NotNull ResolutionCandidate candidate2, @NotNull KotlinCallArgument argument2, @NotNull UnwrappedType expectedParameterType) {
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)expectedParameterType, (String)"expectedParameterType");
        if (!(argument2 instanceof SimpleKotlinCallArgument)) {
            return true;
        }
        UnwrappedType argumentType = ArgumentsUtilsKt.getStableType(((SimpleKotlinCallArgument)argument2).getReceiver());
        if (FunctionTypesKt.isSuspendFunctionType(argumentType)) {
            return true;
        }
        return !FunctionTypesKt.isSuspendFunctionType(expectedParameterType);
    }

    @Override
    public boolean conversionIsNeededBeforeSubtypingCheck(@NotNull KotlinCallArgument argument2, boolean areSuspendOnlySamConversionsSupported) {
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        return argument2 instanceof SimpleKotlinCallArgument && (FunctionTypesKt.isFunctionType(ArgumentsUtilsKt.getStableType(((SimpleKotlinCallArgument)argument2).getReceiver())) || FunctionTypesKt.isKFunctionType(ArgumentsUtilsKt.getStableType(((SimpleKotlinCallArgument)argument2).getReceiver())));
    }

    @Override
    public boolean conversionIsNeededAfterSubtypingCheck(@NotNull KotlinCallArgument argument2) {
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        return argument2 instanceof SimpleKotlinCallArgument && FunctionTypesKt.isFunctionTypeOrSubtype(ArgumentsUtilsKt.getStableType(((SimpleKotlinCallArgument)argument2).getReceiver()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public UnwrappedType convertParameterType(@NotNull ResolutionCandidate candidate2, @NotNull KotlinCallArgument argument2, @NotNull ParameterDescriptor parameter2, @NotNull UnwrappedType expectedParameterType) {
        Collection<KotlinType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)expectedParameterType, (String)"expectedParameterType");
        Iterable iterable = FunctionTypesKt.getValueParameterTypesFromFunctionType(expectedParameterType);
        List<KotlinType> list2 = FunctionTypesKt.getContextReceiverTypesFromFunctionType(expectedParameterType);
        KotlinType kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType(expectedParameterType);
        Annotations annotations2 = expectedParameterType.getAnnotations();
        KotlinBuiltIns kotlinBuiltIns = candidate2.getCallComponents().getBuiltIns();
        boolean $i$f$map = false;
        void var8_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            KotlinType kotlinType2 = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
            collection.add(kotlinType2);
        }
        collection = (List)destination$iv$iv;
        SimpleType nonSuspendParameterType = FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType, list2, (List<? extends KotlinType>)collection, null, FunctionTypesKt.getReturnTypeFromFunctionType(expectedParameterType), false);
        candidate2.getResolvedCall().registerArgumentWithSuspendConversion(argument2, nonSuspendParameterType);
        ResolvedCallAtomsKt.markCandidateForCompatibilityResolve$default(candidate2, false, 1, null);
        return nonSuspendParameterType;
    }
}

