/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.java.enhancement.EnhancedForWarningConeSubstitutor;
import org.jetbrains.kotlin.fir.java.enhancement.EnhancedTypeForWarningAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u001a2\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a@\u0010\f\u001a\u00020\b*\u00020\t2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000f0\u000eH\u0000\u00a8\u0006\u0010"}, d2={"getEnhancedTypesForComparison", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "actualType", "expectedType", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "checkConditionForEnhancedTypeMismatch", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkExpressionForEnhancedTypeMismatch", "factory", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory3;", "", "checkers.jvm"})
public final class FirExpressionJavaNullabilityWarningCheckersKt {
    private static final void checkConditionForEnhancedTypeMismatch(FirExpression $this$checkConditionForEnhancedTypeMismatch, CheckerContext context2, DiagnosticReporter reporter) {
        FirExpressionJavaNullabilityWarningCheckersKt.checkExpressionForEnhancedTypeMismatch($this$checkConditionForEnhancedTypeMismatch, context2.getSession().getBuiltinTypes().getBooleanType().getType(), reporter, context2, FirJvmErrors.INSTANCE.getNULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS());
    }

    public static final void checkExpressionForEnhancedTypeMismatch(@NotNull FirExpression $this$checkExpressionForEnhancedTypeMismatch, @Nullable ConeKotlinType expectedType, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2, @NotNull KtDiagnosticFactory3<ConeKotlinType, ConeKotlinType, String> factory2) {
        Intrinsics.checkNotNullParameter((Object)$this$checkExpressionForEnhancedTypeMismatch, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(factory2, (String)"factory");
        if (expectedType == null) {
            return;
        }
        ConeKotlinType actualType = FirTypeUtilsKt.getResolvedType($this$checkExpressionForEnhancedTypeMismatch);
        Pair<ConeKotlinType, ConeKotlinType> pair = FirExpressionJavaNullabilityWarningCheckersKt.getEnhancedTypesForComparison(actualType, expectedType, context2);
        if (pair == null) {
            return;
        }
        Pair<ConeKotlinType, ConeKotlinType> pair2 = pair;
        ConeKotlinType actualTypeForComparison = (ConeKotlinType)pair2.component1();
        ConeKotlinType expectedTypeForComparison = (ConeKotlinType)pair2.component2();
        if (!TypeUtilsKt.isSubtypeOf(actualTypeForComparison, TypeComponentsKt.getTypeContext(context2.getSession()), expectedTypeForComparison) && TypeUtilsKt.isSubtypeOf(actualType, TypeComponentsKt.getTypeContext(context2.getSession()), expectedType)) {
            String string2;
            if (EnhancedTypeForWarningAttributeKt.isEnhancedTypeForWarningDeprecation(actualType) || EnhancedTypeForWarningAttributeKt.isEnhancedTypeForWarningDeprecation(expectedType)) {
                LanguageVersion languageVersion = LanguageFeature.SupportJavaErrorEnhancementOfArgumentsOfWarningLevelEnhanced.getSinceVersion();
                String versionString = languageVersion != null ? languageVersion.getVersionString() : null;
                string2 = "This will become an error in Kotlin " + versionString + ". See https://youtrack.jetbrains.com/issue/KT-63209";
            } else {
                string2 = "";
            }
            String suffix = string2;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)$this$checkExpressionForEnhancedTypeMismatch.getSource(), factory2, (Object)actualTypeForComparison, (Object)expectedTypeForComparison, (Object)suffix, (DiagnosticContext)context2, null, 64, null);
        }
    }

    private static final Pair<ConeKotlinType, ConeKotlinType> getEnhancedTypesForComparison(ConeKotlinType actualType, ConeKotlinType expectedType, CheckerContext context2) {
        ConeKotlinType coneKotlinType;
        ConeKotlinType actualTypeForComparison;
        if (actualType == null || expectedType == null) {
            return null;
        }
        if (actualType instanceof ConeErrorType || expectedType instanceof ConeErrorType) {
            return null;
        }
        EnhancedForWarningConeSubstitutor substitutor2 = new EnhancedForWarningConeSubstitutor(TypeComponentsKt.getTypeContext(context2.getSession()));
        ConeKotlinType enhancedActualType = substitutor2.substituteOrNull(actualType);
        ConeKotlinType enhancedExpectedType = substitutor2.substituteOrNull(expectedType);
        if (enhancedActualType == null && enhancedExpectedType == null) {
            return null;
        }
        ConeKotlinType coneKotlinType2 = enhancedActualType;
        if (coneKotlinType2 == null) {
            coneKotlinType2 = actualTypeForComparison = actualType;
        }
        if ((coneKotlinType = enhancedExpectedType) == null) {
            coneKotlinType = expectedType;
        }
        ConeKotlinType expectedTypeForComparison = coneKotlinType;
        return TuplesKt.to((Object)actualTypeForComparison, (Object)expectedTypeForComparison);
    }

    public static final /* synthetic */ void access$checkConditionForEnhancedTypeMismatch(FirExpression $receiver, CheckerContext context2, DiagnosticReporter reporter) {
        FirExpressionJavaNullabilityWarningCheckersKt.checkConditionForEnhancedTypeMismatch($receiver, context2, reporter);
    }
}

