/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.cfa.FirPropertyInitializationAnalyzerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirControlFlowGraphOwner;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirBackingFieldReference;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCandidate;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImplKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeDiagnosticWithCandidates;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\u0017\u001a\u00020\u0011*\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReassignmentAndInvisibleSetterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirVariableAssignmentChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkValReassignment", "checkValReassignmentOnValueParameter", "checkValReassignmentViaBackingField", "checkVariableExpected", "isInFileGraph", "", "property", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "isInOwnersInitializer", "receiver", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "isConflictingError", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirReassignmentAndInvisibleSetterChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirReassignmentAndInvisibleSetterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReassignmentAndInvisibleSetterChecker\n+ 2 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n94#2,5:144\n1745#3,3:149\n746#3,10:152\n1547#3:162\n1618#3,3:163\n2727#3,5:166\n2733#3:172\n350#3,7:173\n1#4:171\n*S KotlinDebug\n*F\n+ 1 FirReassignmentAndInvisibleSetterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReassignmentAndInvisibleSetterChecker\n*L\n43#1:144,5\n78#1:149,3\n102#1:152,10\n110#1:162\n110#1:163,3\n111#1:166,5\n111#1:172\n119#1:173,7\n*E\n"})
public final class FirReassignmentAndInvisibleSetterChecker
extends FirExpressionChecker<FirVariableAssignment> {
    @NotNull
    public static final FirReassignmentAndInvisibleSetterChecker INSTANCE = new FirReassignmentAndInvisibleSetterChecker();

    private FirReassignmentAndInvisibleSetterChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirVariableAssignment expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkValReassignmentViaBackingField(expression2, context2, reporter);
        this.checkValReassignmentOnValueParameter(expression2, context2, reporter);
        this.checkVariableExpected(expression2, context2, reporter);
        this.checkValReassignment(expression2, context2, reporter);
    }

    private final void checkValReassignmentViaBackingField(FirVariableAssignment expression2, CheckerContext context2, DiagnosticReporter reporter) {
        Object object;
        FirElement firElement;
        FirBackingFieldSymbol propertySymbol;
        FirBackingFieldReference backingFieldReference;
        block7: {
            FirReference firReference = ReferenceUtilsKt.getCalleeReference(expression2);
            FirBackingFieldReference firBackingFieldReference = firReference instanceof FirBackingFieldReference ? (FirBackingFieldReference)firReference : null;
            if (firBackingFieldReference == null) {
                return;
            }
            backingFieldReference = firBackingFieldReference;
            propertySymbol = backingFieldReference.getResolvedSymbol();
            if (propertySymbol.isVar()) {
                return;
            }
            CheckerContext $this$findClosest$iv = context2;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest$iv.getContainingDeclarations())) {
                FirDeclaration firDeclaration = it$iv;
                if (!(firDeclaration instanceof FirPropertyAccessor)) {
                    firDeclaration = null;
                }
                if ((firElement = (FirElement)((FirPropertyAccessor)firDeclaration)) == null) continue;
                FirElement firElement2 = firElement;
                FirPropertyAccessor it = (FirPropertyAccessor)firElement2;
                boolean bl = false;
                firElement = it.isGetter() ? firElement2 : null;
                if (firElement == null) {
                    continue;
                }
                break block7;
            }
            firElement = null;
        }
        if ((object = (FirPropertyAccessor)firElement) == null || (object = ((FirPropertyAccessor)object).getSymbol()) == null) {
            return;
        }
        Object closestGetter = object;
        if (!Intrinsics.areEqual((Object)propertySymbol.getGetterSymbol(), (Object)closestGetter)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)backingFieldReference.getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT_VIA_BACKING_FIELD(), (Object)propertySymbol, (DiagnosticContext)context2, null, 16, null);
    }

    private final void checkValReassignmentOnValueParameter(FirVariableAssignment expression2, CheckerContext context2, DiagnosticReporter reporter) {
        Object object = ReferenceUtilsKt.getCalleeReference(expression2);
        if (object == null || (object = FirReferenceUtilsKt.toResolvedValueParameterSymbol$default((FirReference)object, false, 1, null)) == null) {
            return;
        }
        Object valueParameter2 = object;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getLValue().getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT(), valueParameter2, (DiagnosticContext)context2, null, 16, null);
    }

    private final void checkVariableExpected(FirVariableAssignment expression2, CheckerContext context2, DiagnosticReporter reporter) {
        block4: {
            block3: {
                FirReference calleeReference = ReferenceUtilsKt.getCalleeReference(expression2);
                if (!(FirExpressionUtilKt.unwrapLValue(expression2) instanceof FirPropertyAccessExpression)) break block3;
                FirReference firReference = calleeReference;
                if (firReference != null ? this.isConflictingError(firReference) : false) break block4;
                FirReference firReference2 = calleeReference;
                if ((firReference2 != null ? FirReferenceUtilsKt.toResolvedVariableSymbol$default(firReference2, false, 1, null) : null) != null) break block4;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getLValue().getSource(), FirErrors.INSTANCE.getVARIABLE_EXPECTED(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final boolean isConflictingError(FirReference $this$isConflictingError) {
        boolean bl;
        block10: {
            if (!FirReferenceUtilsKt.isError($this$isConflictingError)) {
                return false;
            }
            ConeDiagnostic it = ((FirDiagnosticHolder)((Object)$this$isConflictingError)).getDiagnostic();
            if (it instanceof ConeSimpleDiagnostic) {
                bl = ((ConeSimpleDiagnostic)it).getKind() == DiagnosticKind.VariableExpected;
            } else if (it instanceof ConeUnresolvedNameError) {
                bl = true;
            } else if (it instanceof ConeDiagnosticWithCandidates) {
                Iterable $this$any$iv = ((ConeDiagnosticWithCandidates)it).getCandidates();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AbstractCandidate it2 = (AbstractCandidate)element$iv;
                        boolean bl2 = false;
                        if (!(it2.getSymbol() instanceof FirPropertySymbol)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final void checkValReassignment(FirVariableAssignment expression2, CheckerContext context2, DiagnosticReporter reporter) {
        Object object = ReferenceUtilsKt.getCalleeReference(expression2);
        if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) {
            return;
        }
        Object property2 = object;
        if (((FirPropertySymbol)property2).isVar()) {
            return;
        }
        if ((((FirPropertySymbol)property2).isLocal() || this.isInFileGraph((FirPropertySymbol)property2, context2)) && FirPropertyInitializationAnalyzerKt.requiresInitialization((FirPropertySymbol)property2, false)) {
            return;
        }
        FirExpression firExpression2 = FirExpressionUtilKt.getDispatchReceiver(expression2);
        if (this.isInOwnersInitializer(firExpression2 != null ? FirExpressionUtilKt.unwrapSmartcastExpression(firExpression2) : null, context2) && FirPropertyInitializationAnalyzerKt.requiresInitialization((FirPropertySymbol)property2, true)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getLValue().getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT(), property2, (DiagnosticContext)context2, null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isInFileGraph(FirPropertySymbol property2, CheckerContext context2) {
        Object v2;
        void $this$reduceOrNull$iv;
        FirDeclaration firDeclaration;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable $this$dropWhile$iv = context2.getContainingDeclarations();
        boolean $i$f$dropWhile = false;
        boolean yielding$iv22 = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$dropWhile$iv) {
            if (yielding$iv22) {
                list$iv.add(item$iv);
                continue;
            }
            FirDeclaration it = (FirDeclaration)item$iv;
            boolean bl = false;
            if (!(it instanceof FirFile)) continue;
            list$iv.add(item$iv);
            yielding$iv22 = true;
        }
        List declarations2 = list$iv;
        Object yielding$iv22 = CollectionsKt.firstOrNull((List)declarations2);
        FirFile firFile = yielding$iv22 instanceof FirFile ? (FirFile)yielding$iv22 : null;
        if (firFile == null) {
            return false;
        }
        FirFile file2 = firFile;
        if (!Intrinsics.areEqual((Object)file2.getSymbol(), FirHelpersKt.getContainingSymbol(property2, context2.getSession()))) {
            return false;
        }
        yielding$iv22 = declarations2;
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            firDeclaration = (FirDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FirElement firElement = it instanceof FirControlFlowGraphOwner ? (FirControlFlowGraphOwner)it : null;
            collection.add(firElement != null && (firElement = firElement.getControlFlowGraphReference()) != null ? FirControlFlowGraphReferenceImplKt.getControlFlowGraph((FirControlFlowGraphReference)firElement) : null);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                FirDeclaration firDeclaration2;
                void graph;
                ControlFlowGraph $i$f$mapTo2 = (ControlFlowGraph)iterator$iv.next();
                ControlFlowGraph acc = (ControlFlowGraph)accumulator$iv;
                boolean bl = false;
                if (graph != null) {
                    FirDeclaration it = firDeclaration;
                    boolean bl2 = false;
                    firDeclaration2 = acc != null && acc.getSubGraphs().contains(it) ? firDeclaration : null;
                } else {
                    firDeclaration2 = null;
                }
                accumulator$iv = firDeclaration2;
            }
            v2 = accumulator$iv;
        }
        ControlFlowGraph containingGraph = v2;
        return containingGraph != null;
    }

    private final boolean isInOwnersInitializer(FirExpression receiver, CheckerContext context2) {
        int index2;
        List<FirDeclaration> containingDeclarations2;
        block7: {
            int n;
            Object object = receiver instanceof FirThisReceiverExpression ? (FirThisReceiverExpression)receiver : null;
            if (object == null || (object = ((FirThisReceiverExpression)object).getCalleeReference()) == null || (object = ((FirThisReference)object).getBoundSymbol()) == null) {
                return false;
            }
            Object uninitializedThisSymbol = object;
            List<FirDeclaration> $this$indexOfFirst$iv = containingDeclarations2 = context2.getContainingDeclarations();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<FirDeclaration> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                FirDeclaration item$iv;
                FirDeclaration it = item$iv = iterator2.next();
                boolean bl = false;
                if (it instanceof FirClass && Intrinsics.areEqual(((FirClass)it).getSymbol(), (Object)uninitializedThisSymbol)) {
                    n = index$iv;
                    break block7;
                }
                ++index$iv;
            }
            n = index2 = -1;
        }
        if (index2 == -1) {
            return false;
        }
        int n = containingDeclarations2.size();
        for (int i = index2; i < n; ++i) {
            FirDeclaration container2;
            FirDeclaration firDeclaration;
            block10: {
                FirDeclaration next;
                block8: {
                    block9: {
                        FirDeclaration firDeclaration2;
                        if (!(containingDeclarations2.get(i) instanceof FirClass)) continue;
                        next = (FirDeclaration)CollectionsKt.getOrNull(containingDeclarations2, (int)(i + 1));
                        if (!(next instanceof FirProperty)) break block8;
                        firDeclaration = (FirDeclaration)CollectionsKt.getOrNull(containingDeclarations2, (int)(i + 2));
                        if (firDeclaration == null) break block9;
                        FirDeclaration it = firDeclaration2 = firDeclaration;
                        boolean bl = false;
                        firDeclaration = it instanceof FirPropertyAccessor ? firDeclaration2 : null;
                        if (firDeclaration != null) break block10;
                    }
                    firDeclaration = next;
                    break block10;
                }
                firDeclaration = next;
            }
            FirDeclaration firDeclaration3 = container2 = firDeclaration;
            boolean bl = firDeclaration3 != null ? !FirPropertyInitializationAnalyzerKt.getEvaluatedInPlace(firDeclaration3) : false;
            if (!bl) continue;
            return false;
        }
        return true;
    }
}

