/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirMissingDependencyStorageKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a*\u0010\u0000\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"checkMissingDependencySuperTypes", "", "declaration", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "classifierType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirMissingDependencySupertypeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirMissingDependencySupertypeUtils.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirMissingDependencySupertypeUtilsKt\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,45:1\n26#2:46\n26#2:47\n*S KotlinDebug\n*F\n+ 1 FirMissingDependencySupertypeUtils.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirMissingDependencySupertypeUtilsKt\n*L\n37#1:46\n38#1:47\n*E\n"})
public final class FirMissingDependencySupertypeUtilsKt {
    public static final boolean checkMissingDependencySuperTypes(@Nullable ConeKotlinType classifierType, @Nullable KtSourceElement source, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ConeKotlinType coneKotlinType = classifierType;
        return FirMissingDependencySupertypeUtilsKt.checkMissingDependencySuperTypes((FirBasedSymbol)(coneKotlinType != null ? TypeUtilsKt.toSymbol(coneKotlinType, context2.getSession()) : null), source, reporter, context2);
    }

    public static final boolean checkMissingDependencySuperTypes(@Nullable FirBasedSymbol<?> declaration2, @Nullable KtSourceElement source, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(declaration2 instanceof FirClassSymbol)) {
            return false;
        }
        Set<ConeKotlinType> missingSuperTypes = FirMissingDependencyStorageKt.getMissingDependencyStorage(context2.getSession()).getMissingSuperTypes((FirClassSymbol)declaration2);
        for (ConeKotlinType superType2 : missingSuperTypes) {
            boolean $i$f$emptyArray = false;
            $i$f$emptyArray = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getMISSING_DEPENDENCY_SUPERCLASS(), (Object)TypeUtilsKt.withNullability$default(TypeUtilsKt.withArguments(superType2, new ConeTypeProjection[0]), ConeNullability.NOT_NULL, TypeComponentsKt.getTypeContext(context2.getSession()), null, false, 12, null), (Object)TypeConstructionUtilsKt.constructType$default((FirClassLikeSymbol)declaration2, new ConeTypeProjection[0], false, null, 4, null), (DiagnosticContext)context2, null, 32, null);
        }
        return !((Collection)missingSuperTypes).isEmpty();
    }
}

