/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.InnerClassConsumer;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.JvmKotlinType;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptor;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptorKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.util.DeclarationUtilKt;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public abstract class ClassBodyCodegen
extends MemberCodegen<KtPureClassOrObject> {
    @NotNull
    public final KtPureClassOrObject myClass;
    @NotNull
    public final OwnerKind kind;
    @NotNull
    public final ClassDescriptor descriptor;

    protected ClassBodyCodegen(@NotNull KtPureClassOrObject myClass, @NotNull ClassContext context2, @NotNull ClassBuilder v, @NotNull GenerationState state, @Nullable MemberCodegen<?> parentCodegen) {
        if (myClass == null) {
            ClassBodyCodegen.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            ClassBodyCodegen.$$$reportNull$$$0(1);
        }
        if (v == null) {
            ClassBodyCodegen.$$$reportNull$$$0(2);
        }
        if (state == null) {
            ClassBodyCodegen.$$$reportNull$$$0(3);
        }
        super(state, parentCodegen, context2, myClass, v);
        this.myClass = myClass;
        this.kind = context2.getContextKind();
        this.descriptor = SyntheticClassOrObjectDescriptorKt.findClassDescriptor(myClass, this.bindingContext);
    }

    @Override
    protected void generateBody() {
        ArrayList<KtObjectDeclaration> companions = new ArrayList<KtObjectDeclaration>();
        if (this.kind != OwnerKind.DEFAULT_IMPLS && this.kind != OwnerKind.ERASED_INLINE_CLASS) {
            for (KtDeclaration ktDeclaration : this.myClass.getDeclarations()) {
                if (!ClassBodyCodegen.shouldProcessFirst(ktDeclaration)) continue;
                if (ktDeclaration instanceof KtObjectDeclaration && ((KtObjectDeclaration)ktDeclaration).isCompanion()) {
                    companions.add((KtObjectDeclaration)ktDeclaration);
                    CodegenUtilKt.populateCompanionBackingFieldNamesToOuterContextIfNeeded((KtObjectDeclaration)ktDeclaration, this.context, this.state);
                    continue;
                }
                this.generateDeclaration(ktDeclaration);
            }
        }
        for (KtDeclaration ktDeclaration : this.myClass.getDeclarations()) {
            if (ClassBodyCodegen.shouldProcessFirst(ktDeclaration)) continue;
            this.generateDeclaration(ktDeclaration);
        }
        boolean generateNonClassMembers = this.shouldGenerateNonClassMembers();
        if (generateNonClassMembers) {
            this.generatePrimaryConstructorProperties();
            this.generateConstructors();
            this.generateDefaultImplsIfNeeded();
            this.generateErasedInlineClassIfNeeded();
            this.generateUnboxMethodForInlineClass();
        }
        for (KtObjectDeclaration companion : companions) {
            this.genClassOrObject(companion);
        }
        if (this.kind != OwnerKind.DEFAULT_IMPLS) {
            Collection<DeclarationDescriptor> collection = this.descriptor.getUnsubstitutedMemberScope().getContributedDescriptors(DescriptorKindFilter.CLASSIFIERS, MemberScope.Companion.getALL_NAME_FILTER());
            for (DeclarationDescriptor memberDescriptor : collection) {
                if (!(memberDescriptor instanceof SyntheticClassOrObjectDescriptor)) continue;
                this.genSyntheticClassOrObject((SyntheticClassOrObjectDescriptor)memberDescriptor);
            }
        }
        if (generateNonClassMembers) {
            this.generateBridges();
        }
    }

    private void generateBridges() {
        if (DescriptorUtils.isInterface(this.descriptor)) {
            return;
        }
        for (DeclarationDescriptor memberDescriptor : DescriptorUtils.getAllDescriptors(this.descriptor.getDefaultType().getMemberScope())) {
            PropertySetterDescriptor setter2;
            CallableMemberDescriptor member2;
            if (!(memberDescriptor instanceof CallableMemberDescriptor) || (member2 = (CallableMemberDescriptor)memberDescriptor).getKind().isReal() || DeclarationUtilKt.findInterfaceImplementation(member2) != null) continue;
            if (member2 instanceof FunctionDescriptor) {
                this.functionCodegen.generateBridges((FunctionDescriptor)member2);
                continue;
            }
            if (!(member2 instanceof PropertyDescriptor)) continue;
            PropertyGetterDescriptor getter2 = ((PropertyDescriptor)member2).getGetter();
            if (getter2 != null) {
                this.functionCodegen.generateBridges(getter2);
            }
            if ((setter2 = ((PropertyDescriptor)member2).getSetter()) == null) continue;
            this.functionCodegen.generateBridges(setter2);
        }
    }

    private boolean shouldGenerateNonClassMembers() {
        return !(this.myClass instanceof KtClassOrObject) || this.state.getGenerateDeclaredClassFilter().shouldGenerateClassMembers((KtClassOrObject)this.myClass);
    }

    protected void generateConstructors() {
    }

    protected void generateDefaultImplsIfNeeded() {
    }

    protected void generateErasedInlineClassIfNeeded() {
    }

    protected void generateUnboxMethodForInlineClass() {
    }

    private static boolean shouldProcessFirst(KtDeclaration declaration2) {
        return !(declaration2 instanceof KtProperty) && !(declaration2 instanceof KtNamedFunction);
    }

    protected void generateDeclaration(KtDeclaration declaration2) {
        if (declaration2 instanceof KtProperty || declaration2 instanceof KtNamedFunction || declaration2 instanceof KtTypeAlias) {
            if (this.shouldGenerateNonClassMembers()) {
                this.genSimpleMember(declaration2);
            }
        } else if (declaration2 instanceof KtClassOrObject) {
            if (declaration2 instanceof KtEnumEntry && !CodegenBinding.enumEntryNeedSubclass(this.bindingContext, (KtEnumEntry)declaration2)) {
                return;
            }
            this.genClassOrObject((KtClassOrObject)declaration2);
        }
    }

    private void generatePrimaryConstructorProperties() {
        ClassConstructorDescriptor constructor2 = (ClassConstructorDescriptor)CollectionsKt.firstOrNull(this.descriptor.getConstructors());
        if (constructor2 == null) {
            return;
        }
        boolean isAnnotation = this.descriptor.getKind() == ClassKind.ANNOTATION_CLASS;
        FunctionDescriptor expectedAnnotationConstructor = isAnnotation && constructor2.isActual() ? CodegenUtil.findExpectedFunctionForActual(constructor2) : null;
        for (KtParameter p : this.getPrimaryConstructorParameters()) {
            PropertyDescriptor propertyDescriptor;
            if (!p.hasValOrVar() || (propertyDescriptor = this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, p)) == null) continue;
            if (isAnnotation) {
                this.propertyCodegen.generateConstructorPropertyAsMethodForAnnotationClass(p, propertyDescriptor, expectedAnnotationConstructor);
                continue;
            }
            this.propertyCodegen.generatePrimaryConstructorProperty(propertyDescriptor);
        }
    }

    @NotNull
    public List<KtParameter> getPrimaryConstructorParameters() {
        if (this.myClass instanceof KtClass) {
            List<KtParameter> list2 = this.myClass.getPrimaryConstructorParameters();
            if (list2 == null) {
                ClassBodyCodegen.$$$reportNull$$$0(4);
            }
            return list2;
        }
        List<KtParameter> list3 = Collections.emptyList();
        if (list3 == null) {
            ClassBodyCodegen.$$$reportNull$$$0(5);
        }
        return list3;
    }

    @Override
    @Nullable
    protected ClassDescriptor classForInnerClassRecord() {
        return InnerClassConsumer.Companion.classForInnerClassRecord(this.descriptor, false);
    }

    protected void generateDelegatesToDefaultImpl() {
        if (JvmCodegenUtil.isJvmInterface(this.descriptor)) {
            return;
        }
        boolean isErasedInlineClass = InlineClassesUtilsKt.isInlineClass(this.descriptor) && this.kind == OwnerKind.ERASED_INLINE_CLASS;
        JvmKotlinType receiverType2 = new JvmKotlinType(this.typeMapper.mapType(this.descriptor), this.descriptor.getDefaultType());
        for (Map.Entry<FunctionDescriptor, FunctionDescriptor> entry : CodegenUtil.getNonPrivateTraitMethods(this.descriptor).entrySet()) {
            ClassBodyCodegen.generateDelegationToDefaultImpl(entry.getKey(), entry.getValue(), receiverType2, this.functionCodegen, this.state, isErasedInlineClass);
        }
    }

    public static void generateDelegationToDefaultImpl(final @NotNull FunctionDescriptor interfaceFun, final @NotNull FunctionDescriptor inheritedFun, final @NotNull JvmKotlinType receiverType2, @NotNull FunctionCodegen functionCodegen, @NotNull GenerationState state, final boolean isErasedInlineClass) {
        CallableMemberDescriptor actualImplementation;
        if (interfaceFun == null) {
            ClassBodyCodegen.$$$reportNull$$$0(6);
        }
        if (inheritedFun == null) {
            ClassBodyCodegen.$$$reportNull$$$0(7);
        }
        if (receiverType2 == null) {
            ClassBodyCodegen.$$$reportNull$$$0(8);
        }
        if (functionCodegen == null) {
            ClassBodyCodegen.$$$reportNull$$$0(9);
        }
        if (state == null) {
            ClassBodyCodegen.$$$reportNull$$$0(10);
        }
        CallableMemberDescriptor callableMemberDescriptor = actualImplementation = interfaceFun.getKind().isReal() ? interfaceFun : DeclarationUtilKt.findImplementationFromInterface(interfaceFun);
        assert (actualImplementation != null) : "Can't find actual implementation for " + interfaceFun;
        if (CodegenUtilKt.isDefinitelyNotDefaultImplsMethod(actualImplementation) || JvmAnnotationUtilKt.isCallableMemberCompiledToJvmDefault(actualImplementation, state.getJvmDefaultMode())) {
            return;
        }
        final KotlinTypeMapper typeMapper2 = state.getTypeMapper();
        functionCodegen.generateMethod(new JvmDeclarationOrigin(JvmDeclarationOriginKind.CLASS_MEMBER_DELEGATION_TO_DEFAULT_IMPL, DescriptorToSourceUtils.descriptorToDeclaration(interfaceFun), interfaceFun, null), inheritedFun, new FunctionGenerationStrategy.CodegenBased(state){

            @Override
            public void doGenerateBody(@NotNull ExpressionCodegen codegen2, @NotNull JvmMethodSignature signature) {
                DeclarationDescriptor containingDeclaration2;
                if (codegen2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (signature == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!DescriptorUtils.isInterface(containingDeclaration2 = interfaceFun.getContainingDeclaration())) {
                    return;
                }
                DeclarationDescriptor declarationInheritedFun = inheritedFun.getContainingDeclaration();
                PsiElement classForInheritedFun = DescriptorToSourceUtils.descriptorToDeclaration(declarationInheritedFun);
                if (classForInheritedFun instanceof KtDeclaration) {
                    codegen2.markLineNumber(classForInheritedFun, false);
                }
                ClassDescriptor containingTrait = (ClassDescriptor)containingDeclaration2;
                Type traitImplType = typeMapper2.mapDefaultImpls(containingTrait);
                FunctionDescriptor originalInterfaceFun = interfaceFun.getOriginal();
                Method traitMethod = typeMapper2.mapAsmMethod(originalInterfaceFun, OwnerKind.DEFAULT_IMPLS);
                this.putArgumentsOnStack(codegen2, signature, traitMethod);
                InstructionAdapter iv = codegen2.v;
                if (KotlinBuiltIns.isCloneable(containingTrait) && traitMethod.getName().equals("clone")) {
                    iv.invokespecial("java/lang/Object", "clone", "()Ljava/lang/Object;", false);
                } else {
                    iv.invokestatic(traitImplType.getInternalName(), traitMethod.getName(), traitMethod.getDescriptor(), false);
                }
                Type returnType2 = signature.getReturnType();
                StackValue.onStack(traitMethod.getReturnType(), originalInterfaceFun.getReturnType()).put(returnType2, iv);
                iv.areturn(returnType2);
            }

            private void putArgumentsOnStack(@NotNull ExpressionCodegen codegen2, @NotNull JvmMethodSignature signature, @NotNull Method defaultImplsMethod) {
                if (codegen2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (signature == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (defaultImplsMethod == null) {
                    1.$$$reportNull$$$0(4);
                }
                InstructionAdapter iv = codegen2.v;
                Type[] myArgTypes = signature.getAsmMethod().getArgumentTypes();
                Type[] toArgTypes = defaultImplsMethod.getArgumentTypes();
                int myArgI = 0;
                int argVar = 0;
                SimpleType interfaceKotlinType = ((ClassDescriptor)inheritedFun.getContainingDeclaration()).getDefaultType();
                StackValue.local(argVar, receiverType2.getType(), receiverType2.getKotlinType()).put(AsmTypes.OBJECT_TYPE, interfaceKotlinType, iv);
                if (isErasedInlineClass) {
                    ++myArgI;
                }
                argVar += receiverType2.getType().getSize();
                int toArgI = 1;
                List<ParameterDescriptor> myParameters = this.getParameters(inheritedFun);
                List<ParameterDescriptor> toParameters = this.getParameters(interfaceFun);
                assert (myParameters.size() == toParameters.size()) : "Inconsistent value parameters between delegating fun " + inheritedFun + "and interface fun " + interfaceFun;
                Iterator<ParameterDescriptor> myParametersIterator = myParameters.iterator();
                Iterator<ParameterDescriptor> toParametersIterator = toParameters.iterator();
                while (myArgI < myArgTypes.length) {
                    Type myArgType = myArgTypes[myArgI];
                    Type toArgType = toArgTypes[toArgI];
                    KotlinType myArgKotlinType = myParametersIterator.hasNext() ? myParametersIterator.next().getType() : null;
                    KotlinType toArgKotlinType = toParametersIterator.hasNext() ? toParametersIterator.next().getType() : null;
                    StackValue.local(argVar, myArgType, myArgKotlinType).put(toArgType, toArgKotlinType, iv);
                    argVar += myArgType.getSize();
                    ++myArgI;
                    ++toArgI;
                }
                assert (toArgI == toArgTypes.length) : "Invalid trait implementation signature: " + signature + " vs " + defaultImplsMethod + " for " + interfaceFun;
            }

            private List<ParameterDescriptor> getParameters(FunctionDescriptor functionDescriptor) {
                ArrayList<ParameterDescriptor> valueParameterDescriptors = new ArrayList<ParameterDescriptor>(functionDescriptor.getValueParameters().size() + 1);
                ReceiverParameterDescriptor extensionReceiverParameter2 = functionDescriptor.getExtensionReceiverParameter();
                if (extensionReceiverParameter2 != null) {
                    valueParameterDescriptors.add(extensionReceiverParameter2);
                }
                valueParameterDescriptors.addAll(functionDescriptor.getValueParameters());
                return valueParameterDescriptors;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "codegen";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "signature";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "defaultImplsMethod";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/codegen/ClassBodyCodegen$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doGenerateBody";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "putArgumentsOnStack";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/ClassBodyCodegen";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceFun";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inheritedFun";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionCodegen";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/ClassBodyCodegen";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryConstructorParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generateDelegationToDefaultImpl";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

