/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.filter2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import org.jdom.Content;
import org.jdom.filter.Filter;
import org.jdom.filter2.AndFilter;
import org.jdom.filter2.NegateFilter;
import org.jdom.filter2.OrFilter;

public abstract class AbstractFilter<T>
implements org.jdom.filter2.Filter<T> {
    private static final long serialVersionUID = 200L;

    @Override
    public final boolean matches(Object content2) {
        return this.filter(content2) != null;
    }

    @Override
    public List<T> filter(List<?> content2) {
        if (content2 == null) {
            return Collections.emptyList();
        }
        if (content2 instanceof RandomAccess) {
            int sz = content2.size();
            ArrayList ret = new ArrayList(sz);
            for (int i = 0; i < sz; ++i) {
                Object c = this.filter(content2.get(i));
                if (c == null) continue;
                ret.add(c);
            }
            if (ret.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(ret);
        }
        ArrayList ret = new ArrayList(10);
        Iterator<?> it = content2.iterator();
        while (it.hasNext()) {
            Object c = this.filter(it.next());
            if (c == null) continue;
            ret.add(c);
        }
        if (ret.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(ret);
    }

    @Override
    public final org.jdom.filter2.Filter<?> negate() {
        if (this instanceof NegateFilter) {
            return ((NegateFilter)this).getBaseFilter();
        }
        return new NegateFilter(this);
    }

    @Override
    public final org.jdom.filter2.Filter<? extends Content> or(org.jdom.filter2.Filter<?> filter2) {
        return new OrFilter(this, filter2);
    }

    @Override
    public final org.jdom.filter2.Filter<T> and(org.jdom.filter2.Filter<?> filter2) {
        return new AndFilter(filter2, this);
    }

    @Override
    public <R> org.jdom.filter2.Filter<R> refine(org.jdom.filter2.Filter<R> filter2) {
        return new AndFilter<R>(this, filter2);
    }

    public static <E extends Content> Filter<E> toFilter(final org.jdom.filter2.Filter<E> filter2) {
        return new Filter<E>(){

            @Override
            public boolean matches(Object obj) {
                return filter2.matches(obj);
            }
        };
    }
}

