/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference.components;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.resolve.calls.model.PostponedResolvedAtomMarker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.MarkerExtensionsKt;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemContextHelpersKt;
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContext;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ&\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004J\b\u0010\u001e\u001a\u00020\u0016H\u0002J\b\u0010\u001f\u001a\u00020\u0016H\u0002J\b\u0010 \u001a\u00020\u0016H\u0002J\b\u0010!\u001a\u00020\u0016H\u0002J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040#2\u0006\u0010$\u001a\u00020\u0004H\u0002J\u0016\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00102\u0006\u0010&\u001a\u00020\u0004J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040#2\u0006\u0010$\u001a\u00020\u0004H\u0002J\u0016\u0010(\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00102\u0006\u0010&\u001a\u00020\u0004J\u0010\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u0004H\u0002J\u000e\u0010+\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u0004J\u000e\u0010,\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u0004J \u0010-\u001a\u00020\u001a*\u00020\n2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00160/H\u0002R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDependencyInformationProvider;", "", "notFixedTypeVariables", "", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "postponedKtPrimitives", "", "Lorg/jetbrains/kotlin/resolve/calls/model/PostponedResolvedAtomMarker;", "topLevelType", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "typeSystemContext", "Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;", "(Ljava/util/Map;Ljava/util/List;Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;)V", "deepTypeVariableDependencies", "", "", "postponeArgumentsEdges", "relatedToAllOutputTypes", "relatedToTopLevelType", "shallowTypeVariableDependencies", "addAllRelatedNodes", "", "to", "node", "includePostponedEdges", "", "areVariablesDependentShallowly", "a", "b", "computeConstraintEdges", "computePostponeArgumentsEdges", "computeRelatedToAllOutputTypes", "computeRelatedToTopLevelType", "getConstraintEdges", "", "from", "getDeeplyDependentVariables", "variable", "getPostponeEdges", "getShallowlyDependentVariables", "isMyTypeVariable", "typeConstructor", "isVariableRelatedToAnyOutputType", "isVariableRelatedToTopLevelType", "forAllMyTypeVariables", "action", "Lkotlin/Function1;", "resolution.common"})
@SourceDebugExtension(value={"SMAP\nTypeVariableDependencyInformationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeVariableDependencyInformationProvider.kt\norg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDependencyInformationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,156:1\n1745#2,3:157\n1745#2,3:160\n372#3,7:163\n372#3,7:170\n372#3,7:177\n372#3,7:184\n372#3,7:191\n*S KotlinDebug\n*F\n+ 1 TypeVariableDependencyInformationProvider.kt\norg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDependencyInformationProvider\n*L\n55#1:157,3\n56#1:160,3\n61#1:163,7\n62#1:170,7\n66#1:177,7\n67#1:184,7\n90#1:191,7\n*E\n"})
public final class TypeVariableDependencyInformationProvider {
    @NotNull
    private final Map<TypeConstructorMarker, VariableWithConstraints> notFixedTypeVariables;
    @NotNull
    private final List<PostponedResolvedAtomMarker> postponedKtPrimitives;
    @Nullable
    private final KotlinTypeMarker topLevelType;
    @NotNull
    private final TypeSystemInferenceExtensionContext typeSystemContext;
    @NotNull
    private final Map<TypeConstructorMarker, Set<TypeConstructorMarker>> deepTypeVariableDependencies;
    @NotNull
    private final Map<TypeConstructorMarker, Set<TypeConstructorMarker>> shallowTypeVariableDependencies;
    @NotNull
    private final Map<TypeConstructorMarker, Set<TypeConstructorMarker>> postponeArgumentsEdges;
    @NotNull
    private final Set<TypeConstructorMarker> relatedToAllOutputTypes;
    @NotNull
    private final Set<TypeConstructorMarker> relatedToTopLevelType;

    public TypeVariableDependencyInformationProvider(@NotNull Map<TypeConstructorMarker, ? extends VariableWithConstraints> notFixedTypeVariables, @NotNull List<? extends PostponedResolvedAtomMarker> postponedKtPrimitives, @Nullable KotlinTypeMarker topLevelType, @NotNull TypeSystemInferenceExtensionContext typeSystemContext2) {
        Intrinsics.checkNotNullParameter(notFixedTypeVariables, "notFixedTypeVariables");
        Intrinsics.checkNotNullParameter(postponedKtPrimitives, "postponedKtPrimitives");
        Intrinsics.checkNotNullParameter(typeSystemContext2, "typeSystemContext");
        this.notFixedTypeVariables = notFixedTypeVariables;
        this.postponedKtPrimitives = postponedKtPrimitives;
        this.topLevelType = topLevelType;
        this.typeSystemContext = typeSystemContext2;
        this.deepTypeVariableDependencies = new HashMap();
        this.shallowTypeVariableDependencies = new HashMap();
        this.postponeArgumentsEdges = new HashMap();
        this.relatedToAllOutputTypes = new HashSet();
        this.relatedToTopLevelType = new HashSet();
        this.computeConstraintEdges();
        this.computePostponeArgumentsEdges();
        this.computeRelatedToAllOutputTypes();
        this.computeRelatedToTopLevelType();
    }

    public final boolean isVariableRelatedToTopLevelType(@NotNull TypeConstructorMarker variable2) {
        Intrinsics.checkNotNullParameter(variable2, "variable");
        return this.relatedToTopLevelType.contains(variable2);
    }

    public final boolean isVariableRelatedToAnyOutputType(@NotNull TypeConstructorMarker variable2) {
        Intrinsics.checkNotNullParameter(variable2, "variable");
        return this.relatedToAllOutputTypes.contains(variable2);
    }

    @Nullable
    public final Set<TypeConstructorMarker> getDeeplyDependentVariables(@NotNull TypeConstructorMarker variable2) {
        Intrinsics.checkNotNullParameter(variable2, "variable");
        return this.deepTypeVariableDependencies.get(variable2);
    }

    @Nullable
    public final Set<TypeConstructorMarker> getShallowlyDependentVariables(@NotNull TypeConstructorMarker variable2) {
        Intrinsics.checkNotNullParameter(variable2, "variable");
        return this.shallowTypeVariableDependencies.get(variable2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean areVariablesDependentShallowly(@NotNull TypeConstructorMarker a, @NotNull TypeConstructorMarker b) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        if (Intrinsics.areEqual(a, b)) {
            return true;
        }
        Set<TypeConstructorMarker> set = this.shallowTypeVariableDependencies.get(a);
        if (set == null) {
            return false;
        }
        Set<TypeConstructorMarker> shallowDependencies = set;
        Iterable $this$any$iv = shallowDependencies;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl2 = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                TypeConstructorMarker it = (TypeConstructorMarker)element$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual(it, b)) continue;
                return true;
            }
            bl2 = false;
        }
        if (bl2) return true;
        $this$any$iv = this.shallowTypeVariableDependencies.values();
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return false;
            element$iv = iterator2.next();
            Set dependencies2 = (Set)element$iv;
            boolean bl4 = false;
            if (dependencies2.contains(a) && dependencies2.contains(b)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final void computeConstraintEdges() {
        for (VariableWithConstraints variableWithConstraints : this.notFixedTypeVariables.values()) {
            TypeConstructorMarker from2 = MarkerExtensionsKt.freshTypeConstructor(variableWithConstraints.getTypeVariable(), this.typeSystemContext);
            for (Constraint constraint : variableWithConstraints.getConstraints()) {
                TypeConstructorMarker constraintTypeConstructor = TypeSystemContextHelpersKt.typeConstructor(constraint.getType(), this.typeSystemContext);
                this.forAllMyTypeVariables(constraint.getType(), (Function1<? super TypeConstructorMarker, Unit>)new Function1<TypeConstructorMarker, Unit>(this, from2){
                    final /* synthetic */ TypeVariableDependencyInformationProvider this$0;
                    final /* synthetic */ TypeConstructorMarker $from;
                    {
                        this.this$0 = $receiver;
                        this.$from = $from;
                        super(1);
                    }

                    public final void invoke(TypeConstructorMarker it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        if (TypeVariableDependencyInformationProvider.access$isMyTypeVariable(this.this$0, it)) {
                            TypeVariableDependencyInformationProvider.access$computeConstraintEdges$addConstraintEdgeForDeepDependency(this.this$0, this.$from, it);
                        }
                    }
                });
                if (!this.isMyTypeVariable(constraintTypeConstructor)) continue;
                TypeVariableDependencyInformationProvider.computeConstraintEdges$addConstraintEdgeForShallowDependency(this, from2, constraintTypeConstructor);
            }
        }
    }

    private final void computePostponeArgumentsEdges() {
        for (PostponedResolvedAtomMarker argument2 : this.postponedKtPrimitives) {
            if (argument2.getAnalyzed()) continue;
            SmartSet<TypeConstructorMarker> typeVariablesInOutputType = SmartSet.Companion.create();
            KotlinTypeMarker kotlinTypeMarker = argument2.getOutputType();
            if (kotlinTypeMarker == null) continue;
            this.forAllMyTypeVariables(kotlinTypeMarker, (Function1<? super TypeConstructorMarker, Unit>)new Function1<TypeConstructorMarker, Unit>(typeVariablesInOutputType){
                final /* synthetic */ SmartSet<TypeConstructorMarker> $typeVariablesInOutputType;
                {
                    this.$typeVariablesInOutputType = $typeVariablesInOutputType;
                    super(1);
                }

                public final void invoke(TypeConstructorMarker it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    this.$typeVariablesInOutputType.add(it);
                }
            });
            if (typeVariablesInOutputType.isEmpty()) continue;
            for (KotlinTypeMarker inputType : argument2.getInputTypes()) {
                this.forAllMyTypeVariables(inputType, (Function1<? super TypeConstructorMarker, Unit>)new Function1<TypeConstructorMarker, Unit>(typeVariablesInOutputType, this){
                    final /* synthetic */ SmartSet<TypeConstructorMarker> $typeVariablesInOutputType;
                    final /* synthetic */ TypeVariableDependencyInformationProvider this$0;
                    {
                        this.$typeVariablesInOutputType = $typeVariablesInOutputType;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(TypeConstructorMarker from2) {
                        Intrinsics.checkNotNullParameter(from2, "from");
                        for (TypeConstructorMarker to : this.$typeVariablesInOutputType) {
                            TypeVariableDependencyInformationProvider.access$computePostponeArgumentsEdges$addPostponeArgumentsEdges(this.this$0, from2, to);
                        }
                    }
                });
            }
        }
    }

    private final void computeRelatedToAllOutputTypes() {
        for (PostponedResolvedAtomMarker argument2 : this.postponedKtPrimitives) {
            if (argument2.getAnalyzed()) continue;
            KotlinTypeMarker kotlinTypeMarker = argument2.getOutputType();
            if (kotlinTypeMarker == null) continue;
            this.forAllMyTypeVariables(kotlinTypeMarker, (Function1<? super TypeConstructorMarker, Unit>)new Function1<TypeConstructorMarker, Unit>(this){
                final /* synthetic */ TypeVariableDependencyInformationProvider this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(TypeConstructorMarker it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    TypeVariableDependencyInformationProvider.access$addAllRelatedNodes(this.this$0, TypeVariableDependencyInformationProvider.access$getRelatedToAllOutputTypes$p(this.this$0), it, false);
                }
            });
        }
    }

    private final void computeRelatedToTopLevelType() {
        if (this.topLevelType == null) {
            return;
        }
        this.forAllMyTypeVariables(this.topLevelType, (Function1<? super TypeConstructorMarker, Unit>)new Function1<TypeConstructorMarker, Unit>(this){
            final /* synthetic */ TypeVariableDependencyInformationProvider this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(TypeConstructorMarker it) {
                Intrinsics.checkNotNullParameter(it, "it");
                TypeVariableDependencyInformationProvider.access$addAllRelatedNodes(this.this$0, TypeVariableDependencyInformationProvider.access$getRelatedToTopLevelType$p(this.this$0), it, true);
            }
        });
    }

    private final boolean isMyTypeVariable(TypeConstructorMarker typeConstructor2) {
        return this.notFixedTypeVariables.containsKey(typeConstructor2);
    }

    private final boolean forAllMyTypeVariables(KotlinTypeMarker $this$forAllMyTypeVariables, Function1<? super TypeConstructorMarker, Unit> action) {
        TypeSystemInferenceExtensionContext $this$forAllMyTypeVariables_u24lambda_u247 = this.typeSystemContext;
        boolean bl = false;
        return $this$forAllMyTypeVariables_u24lambda_u247.contains($this$forAllMyTypeVariables, (Function1<? super KotlinTypeMarker, Boolean>)new Function1<KotlinTypeMarker, Boolean>($this$forAllMyTypeVariables_u24lambda_u247, this, action){
            final /* synthetic */ TypeSystemInferenceExtensionContext $this_with;
            final /* synthetic */ TypeVariableDependencyInformationProvider this$0;
            final /* synthetic */ Function1<TypeConstructorMarker, Unit> $action;
            {
                this.$this_with = $receiver;
                this.this$0 = $receiver2;
                this.$action = $action;
                super(1);
            }

            public final Boolean invoke(KotlinTypeMarker it) {
                Intrinsics.checkNotNullParameter(it, "it");
                TypeConstructorMarker typeConstructor2 = this.$this_with.typeConstructor(it);
                if (TypeVariableDependencyInformationProvider.access$isMyTypeVariable(this.this$0, typeConstructor2)) {
                    this.$action.invoke(typeConstructor2);
                }
                return false;
            }
        });
    }

    private final Set<TypeConstructorMarker> getConstraintEdges(TypeConstructorMarker from2) {
        Set<TypeConstructorMarker> set = this.deepTypeVariableDependencies.get(from2);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final Set<TypeConstructorMarker> getPostponeEdges(TypeConstructorMarker from2) {
        Set<TypeConstructorMarker> set = this.postponeArgumentsEdges.get(from2);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final void addAllRelatedNodes(Set<TypeConstructorMarker> to, TypeConstructorMarker node, boolean includePostponedEdges) {
        if (to.add(node)) {
            for (TypeConstructorMarker relatedNode : this.getConstraintEdges(node)) {
                this.addAllRelatedNodes(to, relatedNode, includePostponedEdges);
            }
            if (includePostponedEdges) {
                for (TypeConstructorMarker relatedNode : this.getPostponeEdges(node)) {
                    this.addAllRelatedNodes(to, relatedNode, includePostponedEdges);
                }
            }
        }
    }

    private static final void computeConstraintEdges$addConstraintEdgeForDeepDependency(TypeVariableDependencyInformationProvider this$0, TypeConstructorMarker from2, TypeConstructorMarker to) {
        Set set;
        Set set2;
        Map<TypeConstructorMarker, Set<TypeConstructorMarker>> $this$getOrPut$iv = this$0.deepTypeVariableDependencies;
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get(from2);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(from2, answer$iv);
            set2 = answer$iv;
        } else {
            set2 = value$iv;
        }
        set2.add((TypeConstructorMarker)to);
        $this$getOrPut$iv = this$0.deepTypeVariableDependencies;
        $i$f$getOrPut = false;
        value$iv = $this$getOrPut$iv.get(to);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(to, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        set.add((TypeConstructorMarker)from2);
    }

    private static final void computeConstraintEdges$addConstraintEdgeForShallowDependency(TypeVariableDependencyInformationProvider this$0, TypeConstructorMarker from2, TypeConstructorMarker to) {
        Set set;
        Set set2;
        Map<TypeConstructorMarker, Set<TypeConstructorMarker>> $this$getOrPut$iv = this$0.shallowTypeVariableDependencies;
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get(from2);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(from2, answer$iv);
            set2 = answer$iv;
        } else {
            set2 = value$iv;
        }
        set2.add((TypeConstructorMarker)to);
        $this$getOrPut$iv = this$0.shallowTypeVariableDependencies;
        $i$f$getOrPut = false;
        value$iv = $this$getOrPut$iv.get(to);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(to, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        set.add((TypeConstructorMarker)from2);
    }

    private static final void computePostponeArgumentsEdges$addPostponeArgumentsEdges(TypeVariableDependencyInformationProvider this$0, TypeConstructorMarker from2, TypeConstructorMarker to) {
        Set set;
        Map<TypeConstructorMarker, Set<TypeConstructorMarker>> $this$getOrPut$iv = this$0.postponeArgumentsEdges;
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get(from2);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new HashSet();
            $this$getOrPut$iv.put(from2, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        set.add((TypeConstructorMarker)to);
    }

    public static final /* synthetic */ boolean access$isMyTypeVariable(TypeVariableDependencyInformationProvider $this, TypeConstructorMarker typeConstructor2) {
        return $this.isMyTypeVariable(typeConstructor2);
    }

    public static final /* synthetic */ void access$computeConstraintEdges$addConstraintEdgeForDeepDependency(TypeVariableDependencyInformationProvider this$0, TypeConstructorMarker from2, TypeConstructorMarker to) {
        TypeVariableDependencyInformationProvider.computeConstraintEdges$addConstraintEdgeForDeepDependency(this$0, from2, to);
    }

    public static final /* synthetic */ void access$computePostponeArgumentsEdges$addPostponeArgumentsEdges(TypeVariableDependencyInformationProvider this$0, TypeConstructorMarker from2, TypeConstructorMarker to) {
        TypeVariableDependencyInformationProvider.computePostponeArgumentsEdges$addPostponeArgumentsEdges(this$0, from2, to);
    }

    public static final /* synthetic */ void access$addAllRelatedNodes(TypeVariableDependencyInformationProvider $this, Set to, TypeConstructorMarker node, boolean includePostponedEdges) {
        $this.addAllRelatedNodes(to, node, includePostponedEdges);
    }

    public static final /* synthetic */ Set access$getRelatedToAllOutputTypes$p(TypeVariableDependencyInformationProvider $this) {
        return $this.relatedToAllOutputTypes;
    }

    public static final /* synthetic */ Set access$getRelatedToTopLevelType$p(TypeVariableDependencyInformationProvider $this) {
        return $this.relatedToTopLevelType;
    }
}

