/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.IntExternalizer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004J\u0019\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0002H\u0086\u0002J\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/FileToIdMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "file", "Ljava/io/File;", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "dumpValue", "", "value", "get", "(Ljava/io/File;)Ljava/lang/Integer;", "remove", "", "set", "id", "toMap", "", "kotlin-build-common"})
public final class FileToIdMap
extends BasicStringMap<Integer> {
    public FileToIdMap(@NotNull File file2, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(icContext, "icContext");
        super(file2, IntExternalizer.INSTANCE, icContext);
    }

    @Override
    @NotNull
    public String dumpValue(int value2) {
        return String.valueOf(value2);
    }

    @Override
    @Nullable
    public final Integer get(@NotNull File file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        return (Integer)this.getStorage().get(this.getPathConverter().toPath(file2));
    }

    @Override
    public final void set(@NotNull File file2, int id) {
        Intrinsics.checkNotNullParameter(file2, "file");
        this.getStorage().set(this.getPathConverter().toPath(file2), id);
    }

    @Override
    public final void remove(@NotNull File file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        this.getStorage().remove(this.getPathConverter().toPath(file2));
    }

    @NotNull
    public final Map<File, Integer> toMap() {
        HashMap result2 = new HashMap();
        for (String key : this.getStorage().getKeys()) {
            Integer n = (Integer)this.getStorage().get(key);
            if (n == null) {
                continue;
            }
            int value2 = n;
            Integer n2 = value2;
            ((Map)result2).put(this.getPathConverter().toFile(key), n2);
        }
        return result2;
    }
}

