/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirIntegerLiteralOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedErrorReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.references.builder.FirResolvedErrorReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirResolvedNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.scopes.CallableCopyTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirIntegerConstantOperatorScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001(B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J&\u0010\u001a\u001a\u00020\u001b\"\u0004\b\u0000\u0010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0002H\u0016J)\u0010 \u001a\u0002H!\"\b\b\u0000\u0010!*\u00020\"2\u0006\u0010#\u001a\u0002H!2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010$J\u001a\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0002H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/IntegerLiteralAndOperatorApproximationTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "toLongSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getToLongSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "toLongSymbol$delegate", "Lkotlin/Lazy;", "toULongSymbol", "getToULongSymbol", "toULongSymbol$delegate", "findConversionFunction", "receiverType", "Lorg/jetbrains/kotlin/fir/types/impl/FirImplicitBuiltinTypeRef;", "name", "Lorg/jetbrains/kotlin/name/Name;", "transformConstExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "T", "constExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirConstExpression;", "data", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformIntegerLiteralOperatorCall", "integerLiteralOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirIntegerLiteralOperatorCall;", "Companion", "resolve"})
@SourceDebugExtension(value={"SMAP\nIntegerLiteralAndOperatorApproximationTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntegerLiteralAndOperatorApproximationTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/IntegerLiteralAndOperatorApproximationTransformer\n+ 2 BodyResolveUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/BodyResolveUtilsKt\n+ 3 FirResolvedErrorReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirResolvedErrorReferenceBuilderKt\n+ 4 FirResolvedNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirResolvedNamedReferenceBuilderKt\n+ 5 FirFunctionCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirFunctionCallBuilderKt\n*L\n1#1,137:1\n30#2,2:138\n30#2,2:140\n42#3,4:142\n39#4,4:146\n39#4,4:154\n63#5,4:150\n*S KotlinDebug\n*F\n+ 1 IntegerLiteralAndOperatorApproximationTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/IntegerLiteralAndOperatorApproximationTransformer\n*L\n67#1:138,2\n87#1:140,2\n96#1:142,4\n102#1:146,4\n125#1:154,4\n120#1:150,4\n*E\n"})
public final class IntegerLiteralAndOperatorApproximationTransformer
extends FirTransformer<ConeKotlinType> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final Lazy toLongSymbol$delegate;
    @NotNull
    private final Lazy toULongSymbol$delegate;
    @NotNull
    private static final Name TO_LONG;
    @NotNull
    private static final Name TO_U_LONG;

    public IntegerLiteralAndOperatorApproximationTransformer(@NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        this.session = session2;
        this.scopeSession = scopeSession;
        this.toLongSymbol$delegate = LazyKt.lazy((Function0)new Function0<FirNamedFunctionSymbol>(this){
            final /* synthetic */ IntegerLiteralAndOperatorApproximationTransformer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final FirNamedFunctionSymbol invoke() {
                return IntegerLiteralAndOperatorApproximationTransformer.access$findConversionFunction(this.this$0, this.this$0.getSession().getBuiltinTypes().getIntType(), IntegerLiteralAndOperatorApproximationTransformer.access$getTO_LONG$cp());
            }
        });
        this.toULongSymbol$delegate = LazyKt.lazy((Function0)new Function0<FirNamedFunctionSymbol>(this){
            final /* synthetic */ IntegerLiteralAndOperatorApproximationTransformer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final FirNamedFunctionSymbol invoke() {
                return IntegerLiteralAndOperatorApproximationTransformer.access$findConversionFunction(this.this$0, this.this$0.getSession().getBuiltinTypes().getUIntType(), IntegerLiteralAndOperatorApproximationTransformer.access$getTO_U_LONG$cp());
            }
        });
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    private final FirNamedFunctionSymbol getToLongSymbol() {
        Lazy lazy = this.toLongSymbol$delegate;
        return (FirNamedFunctionSymbol)lazy.getValue();
    }

    private final FirNamedFunctionSymbol getToULongSymbol() {
        Lazy lazy = this.toULongSymbol$delegate;
        return (FirNamedFunctionSymbol)lazy.getValue();
    }

    private final FirNamedFunctionSymbol findConversionFunction(FirImplicitBuiltinTypeRef receiverType2, Name name2) {
        FirTypeScope firTypeScope = ScopeUtilsKt.scope(receiverType2.getType(), this.session, this.scopeSession, CallableCopyTypeCalculator.DoNothing.INSTANCE, FirResolvePhase.STATUS);
        Intrinsics.checkNotNull(firTypeScope);
        return CollectionsKt.single(FirScopeKt.getFunctions(firTypeScope, name2));
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element2, @Nullable ConeKotlinType data2) {
        Intrinsics.checkNotNullParameter(element2, "element");
        return element2;
    }

    @Override
    @NotNull
    public <T> FirStatement transformConstExpression(@NotNull FirConstExpression<T> constExpression, @Nullable ConeKotlinType data2) {
        Intrinsics.checkNotNullParameter(constExpression, "constExpression");
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getResolvedType(constExpression);
        ConeIntegerLiteralType coneIntegerLiteralType = coneKotlinType instanceof ConeIntegerLiteralType ? (ConeIntegerLiteralType)coneKotlinType : null;
        if (coneIntegerLiteralType == null) {
            return constExpression;
        }
        ConeIntegerLiteralType type2 = coneIntegerLiteralType;
        ConeKotlinType coneKotlinType2 = data2;
        ConeClassLikeType approximatedType = type2.getApproximatedType(coneKotlinType2 != null ? TypeExpansionUtilsKt.fullyExpandedType(coneKotlinType2, this.session) : null);
        FirExpression $this$resultType$iv = constExpression;
        boolean $i$f$setResultType = false;
        $this$resultType$iv.replaceConeTypeOrNull(approximatedType);
        ConstantValueKind<?> constantValueKind = FirTypeUtilsKt.toConstKind(approximatedType);
        Intrinsics.checkNotNull(constantValueKind, "null cannot be cast to non-null type org.jetbrains.kotlin.types.ConstantValueKind<T of org.jetbrains.kotlin.fir.resolve.transformers.IntegerLiteralAndOperatorApproximationTransformer.transformConstExpression>");
        ConstantValueKind<?> kind = constantValueKind;
        constExpression.replaceKind(kind);
        return constExpression;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FirStatement transformIntegerLiteralOperatorCall(@NotNull FirIntegerLiteralOperatorCall integerLiteralOperatorCall, @Nullable ConeKotlinType data2) {
        void $this$transformIntegerLiteralOperatorCall_u24lambda_u243_u24lambda_u242;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder;
        Intrinsics.checkNotNullParameter(integerLiteralOperatorCall, "integerLiteralOperatorCall");
        FirIntegerLiteralOperatorCall call2 = integerLiteralOperatorCall;
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getResolvedType(call2);
        ConeIntegerLiteralType coneIntegerLiteralType = coneKotlinType instanceof ConeIntegerLiteralType ? (ConeIntegerLiteralType)coneKotlinType : null;
        if (coneIntegerLiteralType == null) {
            return call2;
        }
        ConeIntegerLiteralType operatorType = coneIntegerLiteralType;
        ConeKotlinType coneKotlinType2 = data2;
        ConeClassLikeType approximatedType = operatorType.getApproximatedType(coneKotlinType2 != null ? TypeExpansionUtilsKt.fullyExpandedType(coneKotlinType2, this.session) : null);
        call2.transformDispatchReceiver(this, null);
        call2.transformExtensionReceiver(this, null);
        call2.getArgumentList().transformArguments(this, null);
        FirExpression $this$resultType$iv = call2;
        boolean $i$f$setResultType = false;
        $this$resultType$iv.replaceConeTypeOrNull(approximatedType);
        FirNamedReference calleeReference = call2.getCalleeReference();
        if (calleeReference instanceof FirResolvedNamedReference) {
            FirResolvedNamedReference firResolvedNamedReference;
            Object object;
            FirBasedSymbol<?> firBasedSymbol = ((FirResolvedNamedReference)calleeReference).getResolvedSymbol();
            Intrinsics.checkNotNull(firBasedSymbol, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol");
            FirNamedFunctionSymbol wrappedFunctionSymbol = (FirNamedFunctionSymbol)firBasedSymbol;
            FirNamedFunctionSymbol firNamedFunctionSymbol = FirIntegerConstantOperatorScopeKt.getOriginalForWrappedIntegerOperator((FirSimpleFunction)wrappedFunctionSymbol.getFir());
            Intrinsics.checkNotNull(firNamedFunctionSymbol);
            FirNamedFunctionSymbol originalFunctionSymbol = firNamedFunctionSymbol;
            if (calleeReference instanceof FirResolvedErrorReference) {
                boolean $i$f$buildResolvedErrorReference = false;
                Object $this$transformIntegerLiteralOperatorCall_u24lambda_u240 = object = new FirResolvedErrorReferenceBuilder();
                boolean bl = false;
                ((FirResolvedErrorReferenceBuilder)$this$transformIntegerLiteralOperatorCall_u24lambda_u240).setName(calleeReference.getName());
                ((FirResolvedErrorReferenceBuilder)$this$transformIntegerLiteralOperatorCall_u24lambda_u240).setSource(calleeReference.getSource());
                ((FirResolvedErrorReferenceBuilder)$this$transformIntegerLiteralOperatorCall_u24lambda_u240).setResolvedSymbol(originalFunctionSymbol);
                ((FirResolvedErrorReferenceBuilder)$this$transformIntegerLiteralOperatorCall_u24lambda_u240).setDiagnostic(((FirResolvedErrorReference)calleeReference).getDiagnostic());
                firResolvedNamedReference = ((FirResolvedErrorReferenceBuilder)object).build();
            } else {
                boolean $i$f$buildResolvedNamedReference = false;
                Object $this$transformIntegerLiteralOperatorCall_u24lambda_u241 = object = new FirResolvedNamedReferenceBuilder();
                boolean bl2 = false;
                ((FirResolvedNamedReferenceBuilder)$this$transformIntegerLiteralOperatorCall_u24lambda_u241).setName(calleeReference.getName());
                ((FirResolvedNamedReferenceBuilder)$this$transformIntegerLiteralOperatorCall_u24lambda_u241).setSource(calleeReference.getSource());
                ((FirResolvedNamedReferenceBuilder)$this$transformIntegerLiteralOperatorCall_u24lambda_u241).setResolvedSymbol(originalFunctionSymbol);
                firResolvedNamedReference = ((FirResolvedNamedReferenceBuilder)object).build();
            }
            FirResolvedNamedReference newCalleeReference = firResolvedNamedReference;
            call2.replaceCalleeReference(newCalleeReference);
        }
        if (ConeBuiltinTypeUtilsKt.isInt(approximatedType) || ConeBuiltinTypeUtilsKt.isUInt(approximatedType)) {
            return call2;
        }
        ConeClassLikeType typeBeforeConversion = operatorType.isUnsigned() ? this.session.getBuiltinTypes().getUIntType().getType() : this.session.getBuiltinTypes().getIntType().getType();
        call2.replaceConeTypeOrNull(typeBeforeConversion);
        boolean $i$f$buildFunctionCall = false;
        FirFunctionCallBuilder $this$transformIntegerLiteralOperatorCall_u24lambda_u243 = firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl = false;
        KtSourceElement ktSourceElement = call2.getSource();
        $this$transformIntegerLiteralOperatorCall_u24lambda_u243.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.IntToLongConversion.INSTANCE, 0, 0, 6, null) : null);
        $this$transformIntegerLiteralOperatorCall_u24lambda_u243.setConeTypeOrNull(this.session.getBuiltinTypes().getLongType().getType());
        $this$transformIntegerLiteralOperatorCall_u24lambda_u243.setExplicitReceiver(call2);
        $this$transformIntegerLiteralOperatorCall_u24lambda_u243.setDispatchReceiver(call2);
        boolean $i$f$buildResolvedNamedReference = false;
        FirResolvedNamedReferenceBuilder bl2 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$transformIntegerLiteralOperatorCall_u24lambda_u243;
        boolean bl3 = false;
        if (operatorType.isUnsigned()) {
            $this$transformIntegerLiteralOperatorCall_u24lambda_u243_u24lambda_u242.setName(TO_U_LONG);
            $this$transformIntegerLiteralOperatorCall_u24lambda_u243_u24lambda_u242.setResolvedSymbol(this.getToULongSymbol());
        } else {
            $this$transformIntegerLiteralOperatorCall_u24lambda_u243_u24lambda_u242.setName(TO_LONG);
            $this$transformIntegerLiteralOperatorCall_u24lambda_u243_u24lambda_u242.setResolvedSymbol(this.getToLongSymbol());
        }
        firFunctionCallBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
        return firFunctionCallBuilder.build();
    }

    public static final /* synthetic */ FirNamedFunctionSymbol access$findConversionFunction(IntegerLiteralAndOperatorApproximationTransformer $this, FirImplicitBuiltinTypeRef receiverType2, Name name2) {
        return $this.findConversionFunction(receiverType2, name2);
    }

    public static final /* synthetic */ Name access$getTO_LONG$cp() {
        return TO_LONG;
    }

    public static final /* synthetic */ Name access$getTO_U_LONG$cp() {
        return TO_U_LONG;
    }

    static {
        Name name2 = Name.identifier("toLong");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        TO_LONG = name2;
        Name name3 = Name.identifier("toULong");
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
        TO_U_LONG = name3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/IntegerLiteralAndOperatorApproximationTransformer$Companion;", "", "()V", "TO_LONG", "Lorg/jetbrains/kotlin/name/Name;", "TO_U_LONG", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

