/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirInlineCheckerPlatformSpecificComponent;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r0\fH\u0016J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/FirJvmInlineCheckerComponent;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirInlineCheckerPlatformSpecificComponent;", "()V", "checkFunctionalParametersWithInheritedDefaultValues", "", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "overriddenSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "checkSuspendFunctionalParameterWithDefaultValue", "param", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "isGenerallyOk", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmInlineCheckerComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmInlineCheckerComponent.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/FirJvmInlineCheckerComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1358#2:67\n1444#2,2:68\n1567#2,11:70\n1862#2,2:81\n1864#2:85\n1578#2:86\n1446#2,3:87\n1862#2,3:90\n1#3:83\n1#3:84\n*S KotlinDebug\n*F\n+ 1 FirJvmInlineCheckerComponent.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/FirJvmInlineCheckerComponent\n*L\n48#1:67\n48#1:68,2\n50#1:70,11\n50#1:81,2\n50#1:85\n50#1:86\n48#1:87,3\n54#1:90,3\n50#1:84\n*E\n"})
public final class FirJvmInlineCheckerComponent
extends FirInlineCheckerPlatformSpecificComponent {
    @Override
    public boolean isGenerallyOk(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean bl;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (DeclarationUtilsKt.isLocalMember(declaration2) && !(CollectionsKt.lastOrNull(context2.getContainingDeclarations()) instanceof FirScript)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getNOT_YET_SUPPORTED_IN_INLINE(), (Object)"Local inline functions", (DiagnosticContext)context2, null, 16, null);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    @Override
    public void checkSuspendFunctionalParameterWithDefaultValue(@NotNull FirValueParameter param, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(param, "param");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)param.getSource(), FirErrors.INSTANCE.getNOT_YET_SUPPORTED_IN_INLINE(), (Object)"Suspend functional parameters with default values", (DiagnosticContext)context2, null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void checkFunctionalParametersWithInheritedDefaultValues(@NotNull FirSimpleFunction function2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull List<? extends FirCallableSymbol<? extends FirCallableDeclaration>> overriddenSymbols2) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(overriddenSymbols2, "overriddenSymbols");
        Iterable $this$flatMap$iv = overriddenSymbols2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list2;
            FirCallableSymbol it = (FirCallableSymbol)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof FirFunctionSymbol)) {
                list2 = CollectionsKt.emptyList();
            } else {
                void $this$mapIndexedNotNullTo$iv$iv;
                Iterable $this$mapIndexedNotNull$iv = ((FirFunctionSymbol)it).getValueParameterSymbols();
                boolean $i$f$mapIndexedNotNull = false;
                Iterable iterable2 = $this$mapIndexedNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapIndexedNotNullTo = false;
                void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv$iv$iv = 0;
                for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                    Integer it$iv$iv;
                    void param;
                    void element$iv$iv2;
                    int n;
                    if ((n = index$iv$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t = item$iv$iv$iv;
                    int index$iv$iv = n;
                    boolean bl2 = false;
                    FirValueParameterSymbol firValueParameterSymbol = (FirValueParameterSymbol)element$iv$iv2;
                    int idx = index$iv$iv;
                    boolean bl3 = false;
                    Integer n2 = idx;
                    int it2 = ((Number)n2).intValue();
                    boolean bl4 = false;
                    if ((param.getHasDefaultValue() ? n2 : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv2;
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Set paramsWithDefaults = CollectionsKt.toSet((List)destination$iv$iv);
        Iterable $this$forEachIndexed$iv = function2.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void param;
            int n;
            Object element$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (FirValueParameter)item$iv;
            int idx = n;
            boolean bl = false;
            if (param.getDefaultValue() != null || !paramsWithDefaults.contains(idx)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)param.getSource(), FirErrors.INSTANCE.getNOT_YET_SUPPORTED_IN_INLINE(), (Object)"Functional parameters with inherited default values", (DiagnosticContext)context2, null, 16, null);
        }
    }
}

