/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.CachedFieldsForObjectInstances;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.JvmStaticAnnotationLoweringKt;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/SingletonObjectJvmStaticTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "cachedFields", "Lorg/jetbrains/kotlin/backend/jvm/CachedFieldsForObjectInstances;", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/backend/jvm/CachedFieldsForObjectInstances;)V", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitMemberAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "backend.jvm.lower"})
public final class SingletonObjectJvmStaticTransformer
extends IrElementTransformerVoid {
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final CachedFieldsForObjectInstances cachedFields;

    public SingletonObjectJvmStaticTransformer(@NotNull IrBuiltIns irBuiltIns, @NotNull CachedFieldsForObjectInstances cachedFields) {
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        Intrinsics.checkNotNullParameter(cachedFields, "cachedFields");
        this.irBuiltIns = irBuiltIns;
        this.cachedFields = cachedFields;
    }

    @Override
    @NotNull
    public IrStatement visitClass(@NotNull IrClass declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        if (IrUtilsKt.isNonCompanionObject(declaration2)) {
            for (IrSimpleFunction function2 : IrUtilsKt.simpleFunctions(declaration2)) {
                if (!JvmStaticAnnotationLoweringKt.access$isJvmStaticDeclaration(function2)) continue;
                if (function2.getDispatchReceiverParameter() != null) {
                    IrValueParameter oldDispatchReceiverParameter;
                    boolean bl = false;
                    function2.setDispatchReceiverParameter(null);
                    JvmIrUtilsKt.replaceThisByStaticReference(function2, this.cachedFields, declaration2, oldDispatchReceiverParameter);
                }
            }
        }
        return super.visitClass(declaration2);
    }

    @Override
    @NotNull
    public IrExpression visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        IrSymbolOwner callee = expression2.getSymbol().getOwner();
        if (callee instanceof IrDeclaration && JvmStaticAnnotationLoweringKt.isJvmStaticInObject((IrDeclaration)callee)) {
            return JvmStaticAnnotationLoweringKt.access$makeStatic(expression2, this.irBuiltIns, null);
        }
        return expression2;
    }
}

