/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtSourceFileLinesMapping;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/KtSourceFileLinesMappingFromLineStartOffsets;", "Lorg/jetbrains/kotlin/KtSourceFileLinesMapping;", "lineStartOffsets", "", "lastOffset", "", "([II)V", "getLastOffset", "()I", "getLineStartOffsets", "()[I", "linesCount", "getLinesCount", "getLineAndColumnByOffset", "Lkotlin/Pair;", "offset", "getLineByOffset", "getLineStartOffset", "line", "frontend.common"})
public class KtSourceFileLinesMappingFromLineStartOffsets
implements KtSourceFileLinesMapping {
    @NotNull
    private final int[] lineStartOffsets;
    private final int lastOffset;

    public KtSourceFileLinesMappingFromLineStartOffsets(@NotNull int[] lineStartOffsets2, int lastOffset) {
        Intrinsics.checkNotNullParameter(lineStartOffsets2, "lineStartOffsets");
        this.lineStartOffsets = lineStartOffsets2;
        this.lastOffset = lastOffset;
    }

    @NotNull
    public final int[] getLineStartOffsets() {
        return this.lineStartOffsets;
    }

    @Override
    public int getLastOffset() {
        return this.lastOffset;
    }

    @Override
    public int getLineStartOffset(int line) {
        return this.lineStartOffsets[line];
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> getLineAndColumnByOffset(int offset) {
        int lineNumber = this.getLineByOffset(offset);
        if (lineNumber < 0) {
            return TuplesKt.to(-1, -1);
        }
        int lineStartOffset = this.lineStartOffsets[lineNumber];
        return TuplesKt.to(lineNumber, offset - lineStartOffset);
    }

    @Override
    public int getLineByOffset(int offset) {
        int index2 = ArraysKt.binarySearch$default(this.lineStartOffsets, offset, 0, 0, 6, null);
        return index2 >= 0 ? index2 : -index2 - 2;
    }

    @Override
    public int getLinesCount() {
        return this.lineStartOffsets.length;
    }
}

