/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.util;

import com.fasterxml.aalto.util.XmlChars;

public final class XmlNames {
    public static int findIllegalNameChar(String name2, boolean xml11) {
        int ptr = 0;
        char c = name2.charAt(ptr);
        int len = name2.length();
        if (c < '\ud800' || c >= '\ue000') {
            if (xml11 ? !XmlChars.is11NameStartChar(c) : !XmlChars.is10NameStartChar(c)) {
                return ptr;
            }
        } else {
            if (len < 2) {
                return ptr;
            }
            if (!XmlNames.validSurrogateNameChar(c, name2.charAt(++ptr))) {
                return ptr;
            }
        }
        ++ptr;
        if (xml11) {
            while (ptr < len) {
                c = name2.charAt(ptr);
                if (c < '\ud800' || c >= '\ue000') {
                    if (!XmlChars.is11NameChar(c)) {
                        return ptr;
                    }
                } else {
                    if (ptr + 1 >= len) {
                        return ptr;
                    }
                    if (!XmlNames.validSurrogateNameChar(c, name2.charAt(ptr + 1))) {
                        return ptr;
                    }
                    ++ptr;
                }
                ++ptr;
            }
        } else {
            while (ptr < len) {
                c = name2.charAt(ptr);
                if (c < '\ud800' || c >= '\ue000') {
                    if (!XmlChars.is10NameChar(c)) {
                        return ptr;
                    }
                } else {
                    if (ptr + 1 >= len) {
                        return ptr;
                    }
                    if (!XmlNames.validSurrogateNameChar(c, name2.charAt(ptr + 1))) {
                        return ptr;
                    }
                    ++ptr;
                }
                ++ptr;
            }
        }
        return -1;
    }

    private static boolean validSurrogateNameChar(char firstChar, char sec) {
        if (firstChar >= '\udc00') {
            return false;
        }
        if (sec < '\udc00' || sec >= '\ue000') {
            return false;
        }
        return false;
    }
}

