/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import com.google.common.collect.HashMultimap;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportInfo;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.LazyExplicitImportScope;
import org.jetbrains.kotlin.resolve.PlatformClassesMappedToKotlinChecker;
import org.jetbrains.kotlin.resolve.lazy.ImportForceResolver;
import org.jetbrains.kotlin.resolve.lazy.ImportResolutionComponents;
import org.jetbrains.kotlin.resolve.lazy.IndexedImports;
import org.jetbrains.kotlin.resolve.lazy.LazyImportResolver;
import org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B;\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\b\u0010\u0019\u001a\u00020\u0012H\u0016R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/lazy/LazyImportResolverForKtImportDirective;", "Lorg/jetbrains/kotlin/resolve/lazy/LazyImportResolver;", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "Lorg/jetbrains/kotlin/resolve/lazy/ImportForceResolver;", "components", "Lorg/jetbrains/kotlin/resolve/lazy/ImportResolutionComponents;", "indexedImports", "Lorg/jetbrains/kotlin/resolve/lazy/IndexedImports;", "excludedImportNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "traceForImportResolve", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "packageFragment", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "(Lorg/jetbrains/kotlin/resolve/lazy/ImportResolutionComponents;Lorg/jetbrains/kotlin/resolve/lazy/IndexedImports;Ljava/util/Collection;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;)V", "forceResolveImportDirective", "Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;", "", "forceResolveNonDefaultImportsTask", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "checkResolvedImportDirective", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportInfo;", "forceResolveImport", "forceResolveNonDefaultImports", "frontend"})
public final class LazyImportResolverForKtImportDirective
extends LazyImportResolver<KtImportDirective>
implements ImportForceResolver {
    @NotNull
    private final MemoizedFunctionToNotNull<KtImportDirective, Unit> forceResolveImportDirective;
    @NotNull
    private final NotNullLazyValue<Unit> forceResolveNonDefaultImportsTask;

    public LazyImportResolverForKtImportDirective(@NotNull ImportResolutionComponents components2, @NotNull IndexedImports<KtImportDirective> indexedImports, @NotNull Collection<FqName> excludedImportNames, @NotNull BindingTrace traceForImportResolve, @Nullable PackageFragmentDescriptor packageFragment) {
        Intrinsics.checkNotNullParameter(components2, "components");
        Intrinsics.checkNotNullParameter(indexedImports, "indexedImports");
        Intrinsics.checkNotNullParameter(excludedImportNames, "excludedImportNames");
        Intrinsics.checkNotNullParameter(traceForImportResolve, "traceForImportResolve");
        super(components2, indexedImports, excludedImportNames, traceForImportResolve, packageFragment);
        this.forceResolveImportDirective = components2.getStorageManager().createMemoizedFunction((Function1)new Function1<KtImportDirective, Unit>(this, components2, traceForImportResolve){
            final /* synthetic */ LazyImportResolverForKtImportDirective this$0;
            final /* synthetic */ ImportResolutionComponents $components;
            final /* synthetic */ BindingTrace $traceForImportResolve;
            {
                this.this$0 = $receiver;
                this.$components = $components;
                this.$traceForImportResolve = $traceForImportResolve;
                super(1);
            }

            public final void invoke(KtImportDirective directive) {
                Intrinsics.checkNotNullParameter(directive, "directive");
                ImportingScope scope = this.this$0.getImportScope(directive);
                if (scope instanceof LazyExplicitImportScope) {
                    Collection<DeclarationDescriptor> allDescriptors2 = ((LazyExplicitImportScope)scope).storeReferencesToDescriptors$frontend();
                    PlatformClassesMappedToKotlinChecker.checkPlatformClassesMappedToKotlin(this.$components.getPlatformToKotlinClassMapper(), this.$traceForImportResolve, directive, allDescriptors2);
                }
            }
        });
        this.forceResolveNonDefaultImportsTask = components2.getStorageManager().createLazyValue((Function0)new Function0<Unit>(indexedImports, this, traceForImportResolve){
            final /* synthetic */ IndexedImports<KtImportDirective> $indexedImports;
            final /* synthetic */ LazyImportResolverForKtImportDirective this$0;
            final /* synthetic */ BindingTrace $traceForImportResolve;
            {
                this.$indexedImports = $indexedImports;
                this.this$0 = $receiver;
                this.$traceForImportResolve = $traceForImportResolve;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                Object object;
                HashMultimap<K, V> explicitClassImports = HashMultimap.create();
                for (KtImportDirective importInfo : (KtImportDirective[])this.$indexedImports.getImports()) {
                    KotlinLookupLocation lookupLocation;
                    this.this$0.forceResolveImport(importInfo);
                    ImportingScope scope = this.this$0.getImportScope(importInfo);
                    Name alias = importInfo.getImportedName();
                    if (alias != null && scope.getContributedClassifier(alias, lookupLocation = new KotlinLookupLocation(importInfo)) != null) {
                        explicitClassImports.put(alias.asString(), importInfo);
                    }
                    LazyImportResolverForKtImportDirective.access$checkResolvedImportDirective(this.this$0, importInfo);
                }
                for (Map.Entry entry : explicitClassImports.entries()) {
                    boolean bl;
                    block6: {
                        Intrinsics.checkNotNull(entry);
                        String alias = (String)entry.getKey();
                        object = (KtImportDirective)entry.getValue();
                        Intrinsics.checkNotNull(alias);
                        CharSequence $this$all$iv = alias;
                        boolean $i$f$all = false;
                        for (int i = 0; i < $this$all$iv.length(); ++i) {
                            char element$iv;
                            char it = element$iv = $this$all$iv.charAt(i);
                            boolean bl2 = false;
                            if (it == '_') continue;
                            bl = false;
                            break block6;
                        }
                        bl = true;
                    }
                    if (!bl) continue;
                    this.$traceForImportResolve.report(Errors.UNDERSCORE_IS_RESERVED.on((PsiElement)object));
                }
                for (String alias : explicitClassImports.keySet()) {
                    void $this$forEach$iv;
                    Set imports2 = explicitClassImports.get(alias);
                    if (imports2.size() <= 1) continue;
                    Intrinsics.checkNotNull(imports2);
                    object = imports2;
                    BindingTrace bindingTrace = this.$traceForImportResolve;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        KtImportDirective it = (KtImportDirective)element$iv;
                        boolean bl = false;
                        bindingTrace.report(Errors.CONFLICTING_IMPORT.on((KtImportDirective)((PsiElement)it), alias));
                    }
                }
            }
        });
    }

    @Override
    public void forceResolveNonDefaultImports() {
        this.forceResolveNonDefaultImportsTask.invoke();
    }

    private final void checkResolvedImportDirective(KtImportInfo importDirective) {
        if (!(importDirective instanceof KtImportDirective)) {
            return;
        }
        KtExpression ktExpression = ((KtImportDirective)importDirective).getImportedReference();
        if (ktExpression == null) {
            return;
        }
        KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtil.getLastReference(ktExpression);
        if (ktSimpleNameExpression == null) {
            return;
        }
        KtSimpleNameExpression importedReference = ktSimpleNameExpression;
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.getTraceForImportResolve().getBindingContext().get(BindingContext.REFERENCE_TARGET, importedReference);
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor importedDescriptor = declarationDescriptor;
        String aliasName = importDirective.getAliasName();
        if (importedDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)importedDescriptor).isOperator() && aliasName != null && OperatorConventions.isConventionName(Name.identifier(aliasName))) {
            this.getTraceForImportResolve().report(Errors.OPERATOR_RENAMED_ON_IMPORT.on((KtSimpleNameExpression)((PsiElement)importedReference)));
        }
    }

    @Override
    public void forceResolveImport(@NotNull KtImportDirective importDirective) {
        Intrinsics.checkNotNullParameter(importDirective, "importDirective");
        this.forceResolveImportDirective.invoke(importDirective);
    }

    public static final /* synthetic */ void access$checkResolvedImportDirective(LazyImportResolverForKtImportDirective $this, KtImportInfo importDirective) {
        $this.checkResolvedImportDirective(importDirective);
    }
}

