/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.overrides;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0006\u001a\u0014\u0010\u0007\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0000\u00a8\u0006\n"}, d2={"isVisibleForOverride", "", "overriding", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableMember;", "fromSuper", "isEffectivelyPrivate", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithVisibility;", "isVisibleInClass", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nIrVisibilityUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrVisibilityUtil.kt\norg/jetbrains/kotlin/ir/overrides/IrVisibilityUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1724#2,3:62\n*S KotlinDebug\n*F\n+ 1 IrVisibilityUtil.kt\norg/jetbrains/kotlin/ir/overrides/IrVisibilityUtilKt\n*L\n30#1:62,3\n*E\n"})
public final class IrVisibilityUtilKt {
    public static final boolean isVisibleForOverride(@NotNull IrOverridableMember overriding, @NotNull IrOverridableMember fromSuper) {
        Intrinsics.checkNotNullParameter(overriding, "overriding");
        Intrinsics.checkNotNullParameter(fromSuper, "fromSuper");
        return IrVisibilityUtilKt.isVisibleInClass(fromSuper, IrUtilsKt.getParentAsClass(overriding));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEffectivelyPrivate(@NotNull IrDeclarationWithVisibility $this$isEffectivelyPrivate) {
        Intrinsics.checkNotNullParameter($this$isEffectivelyPrivate, "<this>");
        if (!IrVisibilityUtilKt.isEffectivelyPrivate$isNonPrivate($this$isEffectivelyPrivate.getVisibility())) {
            boolean bl;
            List list2;
            IrOverridableDeclaration irOverridableDeclaration;
            if (!Intrinsics.areEqual($this$isEffectivelyPrivate.getVisibility(), DescriptorVisibilities.INVISIBLE_FAKE)) return true;
            IrOverridableDeclaration irOverridableDeclaration2 = irOverridableDeclaration = $this$isEffectivelyPrivate instanceof IrOverridableDeclaration ? (IrOverridableDeclaration)$this$isEffectivelyPrivate : null;
            if (irOverridableDeclaration != null && (list2 = irOverridableDeclaration.getOverriddenSymbols()) != null) {
                boolean bl2;
                void $this$all$iv;
                Iterable iterable = list2;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    return true;
                }
                Iterator iterator2 = $this$all$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return true;
                    Object element$iv = iterator2.next();
                    IrSymbol it = (IrSymbol)element$iv;
                    boolean bl3 = false;
                    IrSymbolOwner irSymbolOwner = it.getOwner();
                    IrDeclarationWithVisibility irDeclarationWithVisibility = irSymbolOwner instanceof IrDeclarationWithVisibility ? (IrDeclarationWithVisibility)irSymbolOwner : null;
                    if (irDeclarationWithVisibility != null) {
                        if (IrVisibilityUtilKt.isEffectivelyPrivate(irDeclarationWithVisibility)) {
                            bl2 = true;
                            continue;
                        }
                        bl2 = false;
                        continue;
                    }
                    bl2 = false;
                } while (bl2);
                bl = false;
            } else {
                bl = false;
            }
            boolean overridesOnlyPrivateDeclarations = bl;
            if (overridesOnlyPrivateDeclarations) return true;
            IrClass irClass = IrUtilsKt.getParentClassOrNull($this$isEffectivelyPrivate);
            if (irClass == null) return false;
            boolean bl4 = IrVisibilityUtilKt.isEffectivelyPrivate(irClass);
            if (!bl4) return false;
            return true;
        }
        IrClass irClass = IrUtilsKt.getParentClassOrNull($this$isEffectivelyPrivate);
        if (irClass == null) return false;
        boolean bl = IrVisibilityUtilKt.isEffectivelyPrivate(irClass);
        return bl;
    }

    public static final boolean isVisibleInClass(@NotNull IrOverridableMember $this$isVisibleInClass, @NotNull IrClass klass) {
        IrValueParameter irValueParameter;
        Intrinsics.checkNotNullParameter($this$isVisibleInClass, "<this>");
        Intrinsics.checkNotNullParameter(klass, "klass");
        if (DescriptorVisibilities.isPrivate($this$isVisibleInClass.getVisibility()) || Intrinsics.areEqual($this$isVisibleInClass.getVisibility(), DescriptorVisibilities.INVISIBLE_FAKE)) {
            return false;
        }
        IrOverridableMember irOverridableMember = $this$isVisibleInClass;
        if (irOverridableMember instanceof IrSimpleFunction) {
            irValueParameter = ((IrSimpleFunction)$this$isVisibleInClass).getDispatchReceiverParameter();
        } else if (irOverridableMember instanceof IrProperty) {
            IrSimpleFunction irSimpleFunction = ((IrProperty)$this$isVisibleInClass).getGetter();
            irValueParameter = irSimpleFunction != null ? irSimpleFunction.getDispatchReceiverParameter() : null;
        } else {
            throw new IllegalStateException(("Unsupported member: " + RenderIrElementKt.render$default($this$isVisibleInClass, null, 1, null)).toString());
        }
        if (irValueParameter == null) {
            throw new IllegalStateException(("Members without dispatch receiver are not possible here: " + RenderIrElementKt.render$default($this$isVisibleInClass, null, 1, null) + " (klass=" + IrUtilsKt.getFqNameWhenAvailable(klass)).toString());
        }
        IrValueParameter dispatchReceiver = irValueParameter;
        IrClass irClass = IrTypesKt.getClass(dispatchReceiver.getType());
        Intrinsics.checkNotNull(irClass);
        IrClass originalClass = irClass;
        return $this$isVisibleInClass.getVisibility().visibleFromPackage(IrUtilsKt.getPackageFragment(klass).getPackageFqName(), IrUtilsKt.getPackageFragment(originalClass).getPackageFqName());
    }

    private static final boolean isEffectivelyPrivate$isNonPrivate(DescriptorVisibility $this$isEffectivelyPrivate_u24isNonPrivate) {
        return Intrinsics.areEqual($this$isEffectivelyPrivate_u24isNonPrivate, DescriptorVisibilities.PUBLIC) || Intrinsics.areEqual($this$isEffectivelyPrivate_u24isNonPrivate, DescriptorVisibilities.PROTECTED) || Intrinsics.areEqual($this$isEffectivelyPrivate_u24isNonPrivate, DescriptorVisibilities.INTERNAL);
    }
}

