/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.wasm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.wasm.FirWasmErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/wasm/checkers/declaration/FirWasmExternalInheritanceChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.wasm"})
public final class FirWasmExternalInheritanceChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirWasmExternalInheritanceChecker INSTANCE = new FirWasmExternalInheritanceChecker();

    private FirWasmExternalInheritanceChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirSession session2 = context2.getSession();
        boolean isCurrentClassExternal = FirWebCommonHelpersKt.isEffectivelyExternal((FirBasedSymbol)declaration2.getSymbol(), session2);
        for (FirTypeRef superTypeRef : declaration2.getSuperTypeRefs()) {
            FirClassLikeSymbol<?> superClass;
            if (FirHelpersKt.toClassLikeSymbol(superTypeRef, session2) == null || Intrinsics.areEqual(superClass.getClassId(), StandardClassIds.INSTANCE.getAny())) continue;
            boolean isSuperClassExternal = FirWebCommonHelpersKt.isEffectivelyExternal((FirBasedSymbol)superClass, session2);
            if (!isCurrentClassExternal && isSuperClassExternal) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirWasmErrors.INSTANCE.getNON_EXTERNAL_TYPE_EXTENDS_EXTERNAL_TYPE(), (Object)FirTypeUtilsKt.getConeType(superTypeRef), (DiagnosticContext)context2, null, 16, null);
                continue;
            }
            if (!isCurrentClassExternal || isSuperClassExternal || declaration2.getClassKind() == ClassKind.ANNOTATION_CLASS && Intrinsics.areEqual(superClass.getClassId(), StandardClassIds.INSTANCE.getAnnotation()) || declaration2.getClassKind() == ClassKind.ENUM_CLASS && Intrinsics.areEqual(superClass.getClassId(), StandardClassIds.INSTANCE.getEnum())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirWasmErrors.INSTANCE.getEXTERNAL_TYPE_EXTENDS_NON_EXTERNAL_TYPE(), (Object)FirTypeUtilsKt.getConeType(superTypeRef), (DiagnosticContext)context2, null, 16, null);
        }
    }
}

