/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.InvocationKindTransformerKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmSuspensionPointInsideMutexLockChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "()V", "synchronizedBlockParamName", "Lorg/jetbrains/kotlin/name/Name;", "synchronizedCallableId", "Lorg/jetbrains/kotlin/name/CallableId;", "withLockCallableId", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmSuspensionPointInsideMutexLockChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmSuspensionPointInsideMutexLockChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmSuspensionPointInsideMutexLockChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,77:1\n31#2:78\n58#3,4:79\n226#4:83\n46#5:84\n*S KotlinDebug\n*F\n+ 1 FirJvmSuspensionPointInsideMutexLockChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmSuspensionPointInsideMutexLockChecker\n*L\n34#1:78\n42#1:79,4\n44#1:83\n60#1:84\n*E\n"})
public final class FirJvmSuspensionPointInsideMutexLockChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirJvmSuspensionPointInsideMutexLockChecker INSTANCE = new FirJvmSuspensionPointInsideMutexLockChecker();
    @NotNull
    private static final CallableId synchronizedCallableId;
    @NotNull
    private static final CallableId withLockCallableId;
    @NotNull
    private static final Name synchronizedBlockParamName;

    private FirJvmSuspensionPointInsideMutexLockChecker() {
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirCallableSymbol symbol2;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol $this$isSuspend$iv = symbol2 = firCallableSymbol;
        boolean $i$f$isSuspend = false;
        if (!$this$isSuspend$iv.getRawStatus().isSuspend()) {
            return;
        }
        FirElement anonymousFunctionArg = null;
        boolean isMutexLockFound = false;
        boolean isSuspendFunctionFound = false;
        for (FirElement element2 : CollectionsKt.asReversed(context2.getContainingElements())) {
            block18: {
                block20: {
                    FirCallableSymbol callableSymbol;
                    block19: {
                        FirValueParameter enclosingAnonymousFuncParam;
                        FirValueParameter firValueParameter;
                        block17: {
                            if (!(element2 instanceof FirFunctionCall)) break block18;
                            if (FirReferenceUtilsKt.toResolvedCallableSymbol$default(((FirFunctionCall)element2).getCalleeReference(), false, 1, null) == null) continue;
                            FirCall $this$resolvedArgumentMapping$iv = (FirCall)element2;
                            boolean $i$f$getResolvedArgumentMapping = false;
                            FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
                            LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
                            if (linkedHashMap != null) {
                                for (Map.Entry entry : ((Map)linkedHashMap).entrySet()) {
                                    FirValueParameter firValueParameter2;
                                    FirValueParameter firValueParameter3;
                                    boolean bl = false;
                                    if (InvocationKindTransformerKt.unwrapAnonymousFunctionExpression((FirExpression)entry.getKey()) != null) {
                                        FirAnonymousFunction it;
                                        boolean bl2 = false;
                                        boolean condition$iv = Intrinsics.areEqual(it, anonymousFunctionArg);
                                        boolean $i$f$runIf = false;
                                        if (condition$iv) {
                                            boolean bl3 = false;
                                            firValueParameter3 = (FirValueParameter)entry.getValue();
                                        } else {
                                            firValueParameter3 = null;
                                        }
                                    } else {
                                        firValueParameter3 = null;
                                    }
                                    if ((firValueParameter2 = firValueParameter3) == null) continue;
                                    firValueParameter = firValueParameter2;
                                    break block17;
                                }
                                firValueParameter = null;
                            } else {
                                firValueParameter = null;
                            }
                        }
                        FirValueParameter firValueParameter4 = enclosingAnonymousFuncParam = firValueParameter;
                        FirTypeRef firTypeRef = firValueParameter4 != null ? firValueParameter4.getReturnTypeRef() : null;
                        Object object = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
                        boolean bl = object != null && (object = ((FirResolvedTypeRef)object).getType()) != null ? FunctionalTypeUtilsKt.isSuspendOrKSuspendFunctionType((ConeKotlinType)object, context2.getSession()) : false;
                        if (bl) {
                            isSuspendFunctionFound = true;
                            break;
                        }
                        if (!Intrinsics.areEqual(callableSymbol.getCallableId(), synchronizedCallableId)) break block19;
                        FirValueParameter firValueParameter5 = enclosingAnonymousFuncParam;
                        if (Intrinsics.areEqual(firValueParameter5 != null ? firValueParameter5.getName() : null, synchronizedBlockParamName)) break block20;
                    }
                    if (!Intrinsics.areEqual(callableSymbol.getCallableId(), withLockCallableId)) continue;
                }
                isMutexLockFound = true;
                continue;
            }
            if (!(element2 instanceof FirFunction)) continue;
            FirMemberDeclaration $this$isSuspend$iv2 = (FirMemberDeclaration)element2;
            boolean $i$f$isSuspend2 = false;
            if ($this$isSuspend$iv2.getStatus().isSuspend()) {
                isSuspendFunctionFound = true;
                break;
            }
            if (!(element2 instanceof FirAnonymousFunction)) continue;
            anonymousFunctionArg = element2;
        }
        if (isMutexLockFound && isSuspendFunctionFound) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJvmErrors.INSTANCE.getSUSPENSION_POINT_INSIDE_CRITICAL_SECTION(), (Object)symbol2, (DiagnosticContext)context2, null, 16, null);
        }
    }

    static {
        FqName fqName2 = new FqName("kotlin");
        Name name2 = Name.identifier("synchronized");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        synchronizedCallableId = new CallableId(fqName2, name2);
        FqName fqName3 = new FqName("kotlin.concurrent");
        Name name3 = Name.identifier("withLock");
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
        withLockCallableId = new CallableId(fqName3, name3);
        Name name4 = Name.identifier("block");
        Intrinsics.checkNotNullExpressionValue(name4, "identifier(...)");
        synchronizedBlockParamName = name4;
    }
}

