/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDelegatedPropertyChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCandidate;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeConstraintSystemHasContradiction;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicabilityKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDelegatedPropertyChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirDelegatedPropertyChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirDelegatedPropertyChecker INSTANCE = new FirDelegatedPropertyChecker();

    private FirDelegatedPropertyChecker() {
    }

    @Override
    public void check(@NotNull FirProperty declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block4: {
            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000/\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDelegatedPropertyChecker$check$DelegatedPropertyAccessorVisitor", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "isGet", "", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Z)V", "checkFunctionCall", "", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "checkFunctionReferenceErrors", "checkReturnType", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitFunctionCall", "visitImplicitInvokeCall", "implicitInvokeCall", "Lorg/jetbrains/kotlin/fir/expressions/FirImplicitInvokeCall;", "checkers"})
            @SourceDebugExtension(value={"SMAP\nFirDelegatedPropertyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDelegatedPropertyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDelegatedPropertyChecker$check$DelegatedPropertyAccessorVisitor\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n44#2:145\n1547#3:146\n1618#3,3:147\n1547#3:150\n1618#3,3:151\n*S KotlinDebug\n*F\n+ 1 FirDelegatedPropertyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDelegatedPropertyChecker$check$DelegatedPropertyAccessorVisitor\n*L\n67#1:145\n98#1:146\n98#1:147,3\n102#1:150\n102#1:151,3\n*E\n"})
            public final class DelegatedPropertyAccessorVisitor
            extends FirVisitorVoid {
                private final boolean isGet;
                final /* synthetic */ DiagnosticReporter $reporter;
                final /* synthetic */ KtSourceElement $source;
                final /* synthetic */ ConeKotlinType $delegateType;
                final /* synthetic */ CheckerContext $context;
                final /* synthetic */ FirProperty $declaration;

                public DelegatedPropertyAccessorVisitor(DiagnosticReporter $reporter, KtSourceElement $source, ConeKotlinType $delegateType, CheckerContext $context, FirProperty $declaration, boolean isGet) {
                    Intrinsics.checkNotNullParameter($reporter, "$reporter");
                    Intrinsics.checkNotNullParameter($delegateType, "$delegateType");
                    Intrinsics.checkNotNullParameter($context, "$context");
                    Intrinsics.checkNotNullParameter($declaration, "$declaration");
                    this.$reporter = $reporter;
                    this.$source = $source;
                    this.$delegateType = $delegateType;
                    this.$context = $context;
                    this.$declaration = $declaration;
                    this.isGet = isGet;
                }

                public void visitElement(FirElement element2) {
                    Intrinsics.checkNotNullParameter(element2, "element");
                    element2.acceptChildren(this);
                }

                public void visitFunctionCall(FirFunctionCall functionCall) {
                    Intrinsics.checkNotNullParameter(functionCall, "functionCall");
                    this.checkFunctionCall(functionCall);
                }

                public void visitImplicitInvokeCall(FirImplicitInvokeCall implicitInvokeCall) {
                    Intrinsics.checkNotNullParameter(implicitInvokeCall, "implicitInvokeCall");
                    this.checkFunctionCall(implicitInvokeCall);
                }

                private final void checkFunctionCall(FirFunctionCall functionCall) {
                    boolean hasReferenceError = this.checkFunctionReferenceErrors(functionCall);
                    if (this.isGet && !hasReferenceError) {
                        this.checkReturnType(functionCall);
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                private final boolean checkFunctionReferenceErrors(FirFunctionCall functionCall) {
                    FirNamedReference reference2 = functionCall.getCalleeReference();
                    if (!FirReferenceUtilsKt.isError(reference2)) {
                        return false;
                    }
                    ConeDiagnostic diagnostic = ((FirDiagnosticHolder)((Object)reference2)).getDiagnostic();
                    KtSourceElement ktSourceElement = reference2.getSource();
                    if (!Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) {
                        return false;
                    }
                    FirCall $this$arguments$iv = functionCall;
                    boolean $i$f$getArguments = false;
                    String expectedFunctionSignature2 = (this.isGet ? "getValue" : "setValue") + '(' + CollectionsKt.joinToString$default($this$arguments$iv.getArgumentList().getArguments(), ", ", null, null, 0, null, check.DelegatedPropertyAccessorVisitor.checkFunctionReferenceErrors.expectedFunctionSignature.1.INSTANCE, 30, null) + ')';
                    String delegateDescription = this.isGet ? "delegate" : "delegate for var (read-write property)";
                    boolean errorReported = true;
                    ConeDiagnostic coneDiagnostic = diagnostic;
                    if (coneDiagnostic instanceof ConeUnresolvedNameError) {
                        KtDiagnosticReportHelpersKt.reportOn$default(this.$reporter, (AbstractKtSourceElement)this.$source, FirErrors.INSTANCE.getDELEGATE_SPECIAL_FUNCTION_MISSING(), (Object)expectedFunctionSignature2, (Object)this.$delegateType, (Object)delegateDescription, (DiagnosticContext)this.$context, null, 64, null);
                    } else if (coneDiagnostic instanceof ConeAmbiguityError) {
                        if (CandidateApplicabilityKt.isSuccess(((ConeAmbiguityError)diagnostic).getApplicability())) {
                            Collection<FirBasedSymbol<?>> collection;
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            Iterable iterable = ((ConeAmbiguityError)diagnostic).getCandidates();
                            String string2 = expectedFunctionSignature2;
                            KtDiagnosticFactory2<String, Collection<FirBasedSymbol<?>>> ktDiagnosticFactory2 = FirErrors.INSTANCE.getDELEGATE_SPECIAL_FUNCTION_AMBIGUITY();
                            AbstractKtSourceElement abstractKtSourceElement = this.$source;
                            DiagnosticReporter diagnosticReporter = this.$reporter;
                            boolean $i$f$map = false;
                            void var10_20 = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                AbstractCandidate abstractCandidate = (AbstractCandidate)item$iv$iv;
                                collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(it.getSymbol());
                            }
                            collection = (List)destination$iv$iv;
                            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticReporter, abstractKtSourceElement, ktDiagnosticFactory2, (Object)string2, collection, (DiagnosticContext)this.$context, null, 32, null);
                        } else {
                            Collection<FirBasedSymbol<?>> collection;
                            Iterable $this$map$iv = ((ConeAmbiguityError)diagnostic).getCandidates();
                            CheckerContext checkerContext = this.$context;
                            String string3 = expectedFunctionSignature2;
                            KtSourceElement ktSourceElement2 = this.$source;
                            DiagnosticReporter diagnosticReporter = this.$reporter;
                            boolean $i$f$map = false;
                            Iterable $this$mapTo$iv$iv = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                AbstractCandidate it = (AbstractCandidate)item$iv$iv;
                                collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(it.getSymbol());
                            }
                            collection = (List)destination$iv$iv;
                            DelegatedPropertyAccessorVisitor.checkFunctionReferenceErrors$reportInapplicableDiagnostics(diagnosticReporter, ktSourceElement2, string3, checkerContext, (Collection)collection);
                        }
                    } else if (coneDiagnostic instanceof ConeInapplicableWrongReceiver) {
                        KtDiagnosticReportHelpersKt.reportOn$default(this.$reporter, (AbstractKtSourceElement)this.$source, FirErrors.INSTANCE.getDELEGATE_SPECIAL_FUNCTION_MISSING(), (Object)expectedFunctionSignature2, (Object)this.$delegateType, (Object)delegateDescription, (DiagnosticContext)this.$context, null, 64, null);
                    } else if (coneDiagnostic instanceof ConeInapplicableCandidateError) {
                        DelegatedPropertyAccessorVisitor.checkFunctionReferenceErrors$reportInapplicableDiagnostics(this.$reporter, this.$source, expectedFunctionSignature2, this.$context, (Collection)CollectionsKt.listOf(((ConeInapplicableCandidateError)diagnostic).getCandidate().getSymbol()));
                    } else if (coneDiagnostic instanceof ConeConstraintSystemHasContradiction) {
                        DelegatedPropertyAccessorVisitor.checkFunctionReferenceErrors$reportInapplicableDiagnostics(this.$reporter, this.$source, expectedFunctionSignature2, this.$context, (Collection)CollectionsKt.listOf(((ConeConstraintSystemHasContradiction)diagnostic).getCandidate().getSymbol()));
                    } else {
                        errorReported = false;
                    }
                    return errorReported;
                }

                private final void checkReturnType(FirFunctionCall functionCall) {
                    ConeKotlinType returnType2 = FirTypeUtilsKt.getResolvedType(functionCall);
                    ConeKotlinType propertyType = FirTypeUtilsKt.getConeType(this.$declaration.getReturnTypeRef());
                    if (!AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, TypeComponentsKt.getTypeContext(this.$context.getSession()), (KotlinTypeMarker)returnType2, (KotlinTypeMarker)propertyType, false, 8, null)) {
                        KtDiagnosticReportHelpersKt.reportOn$default(this.$reporter, (AbstractKtSourceElement)this.$source, FirErrors.INSTANCE.getDELEGATE_SPECIAL_FUNCTION_RETURN_TYPE_MISMATCH(), (Object)"getValue", (Object)propertyType, (Object)returnType2, (DiagnosticContext)this.$context, null, 64, null);
                    }
                }

                private static final void checkFunctionReferenceErrors$reportInapplicableDiagnostics(DiagnosticReporter $reporter, KtSourceElement source, String expectedFunctionSignature2, CheckerContext $context, Collection<? extends FirBasedSymbol<?>> candidates2) {
                    KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDELEGATE_SPECIAL_FUNCTION_NONE_APPLICABLE(), (Object)expectedFunctionSignature2, candidates2, (DiagnosticContext)$context, null, 32, null);
                }
            }
            FirPureAbstractElement firPureAbstractElement;
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            FirExpression firExpression2 = declaration2.getDelegate();
            if (firExpression2 == null) {
                return;
            }
            FirExpression delegate2 = firExpression2;
            ConeKotlinType delegateType = FirTypeUtilsKt.getResolvedType(delegate2);
            KtSourceElement source = delegate2.getSource();
            if (delegateType instanceof ConeErrorType) {
                if (source != null && FirHelpersKt.hasDiagnosticKind(delegateType, DiagnosticKind.RecursionInImplicitTypes)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getRECURSION_IN_IMPLICIT_TYPES(), (DiagnosticContext)context2, null, 8, null);
                }
                return;
            }
            FirPureAbstractElement firPureAbstractElement2 = declaration2.getGetter();
            if (firPureAbstractElement2 != null && (firPureAbstractElement2 = ((FirPropertyAccessor)firPureAbstractElement2).getBody()) != null) {
                firPureAbstractElement2.acceptChildren(new DelegatedPropertyAccessorVisitor(reporter, source, delegateType, context2, declaration2, true));
            }
            if ((firPureAbstractElement = declaration2.getSetter()) == null || (firPureAbstractElement = ((FirPropertyAccessor)firPureAbstractElement).getBody()) == null) break block4;
            firPureAbstractElement.acceptChildren(new DelegatedPropertyAccessorVisitor(reporter, source, delegateType, context2, declaration2, false));
        }
    }
}

