/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.overrides;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.linkage.partial.ImplementAsErrorThrowingStubs;
import org.jetbrains.kotlin.backend.common.linkage.partial.PartialLinkageSupportForLinker;
import org.jetbrains.kotlin.backend.common.overrides.DefaultFakeOverrideClassFilter;
import org.jetbrains.kotlin.backend.common.overrides.FakeOverrideClassFilter;
import org.jetbrains.kotlin.backend.common.overrides.FakeOverrideDeclarationTable;
import org.jetbrains.kotlin.backend.common.overrides.FileLocalAwareLinker;
import org.jetbrains.kotlin.backend.common.overrides.IrLinkerFakeOverrideBuilderStrategy;
import org.jetbrains.kotlin.backend.common.serialization.CompatibilityMode;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.overrides.IrExternalOverridabilityCondition;
import org.jetbrains.kotlin.ir.overrides.IrFakeOverrideBuilder;
import org.jetbrains.kotlin.ir.overrides.IrUnimplementedOverridesStrategy;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\r0\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001bH\u0002J\u001e\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+2\u0006\u0010'\u001a\u00020\u001bJ\u0006\u0010,\u001a\u00020)J\u0016\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001bR\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/backend/common/overrides/IrLinkerFakeOverrideProvider;", "", "linker", "Lorg/jetbrains/kotlin/backend/common/overrides/FileLocalAwareLinker;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "typeSystem", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "friendModules", "", "", "", "partialLinkageSupport", "Lorg/jetbrains/kotlin/backend/common/linkage/partial/PartialLinkageSupportForLinker;", "platformSpecificClassFilter", "Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideClassFilter;", "fakeOverrideDeclarationTable", "Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "externalOverridabilityConditions", "", "Lorg/jetbrains/kotlin/ir/overrides/IrExternalOverridabilityCondition;", "(Lorg/jetbrains/kotlin/backend/common/overrides/FileLocalAwareLinker;Lorg/jetbrains/kotlin/ir/util/SymbolTable;Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;Ljava/util/Map;Lorg/jetbrains/kotlin/backend/common/linkage/partial/PartialLinkageSupportForLinker;Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideClassFilter;Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;Ljava/util/List;)V", "fakeOverrideCandidates", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode;", "getFakeOverrideCandidates", "()Ljava/util/Map;", "haveFakeOverrides", "", "irFakeOverrideBuilder", "Lorg/jetbrains/kotlin/ir/overrides/IrFakeOverrideBuilder;", "getPlatformSpecificClassFilter", "()Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideClassFilter;", "buildFakeOverrideChainsForClass", "", "clazz", "compatibilityMode", "enqueueClass", "", "signature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "provideFakeOverrides", "klass", "ir.serialization.common"})
public final class IrLinkerFakeOverrideProvider {
    @NotNull
    private final PartialLinkageSupportForLinker partialLinkageSupport;
    @NotNull
    private final FakeOverrideClassFilter platformSpecificClassFilter;
    @NotNull
    private final DeclarationTable fakeOverrideDeclarationTable;
    @NotNull
    private final IrFakeOverrideBuilder irFakeOverrideBuilder;
    @NotNull
    private final Set<IrClass> haveFakeOverrides;
    @NotNull
    private final Map<IrClass, CompatibilityMode> fakeOverrideCandidates;

    public IrLinkerFakeOverrideProvider(@NotNull FileLocalAwareLinker linker, @NotNull SymbolTable symbolTable, @NotNull KotlinMangler.IrMangler mangler, @NotNull IrTypeSystemContext typeSystem, @NotNull Map<String, ? extends Collection<String>> friendModules, @NotNull PartialLinkageSupportForLinker partialLinkageSupport, @NotNull FakeOverrideClassFilter platformSpecificClassFilter, @NotNull DeclarationTable fakeOverrideDeclarationTable, @NotNull List<? extends IrExternalOverridabilityCondition> externalOverridabilityConditions) {
        Intrinsics.checkNotNullParameter(linker, "linker");
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(mangler, "mangler");
        Intrinsics.checkNotNullParameter(typeSystem, "typeSystem");
        Intrinsics.checkNotNullParameter(friendModules, "friendModules");
        Intrinsics.checkNotNullParameter(partialLinkageSupport, "partialLinkageSupport");
        Intrinsics.checkNotNullParameter(platformSpecificClassFilter, "platformSpecificClassFilter");
        Intrinsics.checkNotNullParameter(fakeOverrideDeclarationTable, "fakeOverrideDeclarationTable");
        Intrinsics.checkNotNullParameter(externalOverridabilityConditions, "externalOverridabilityConditions");
        this.partialLinkageSupport = partialLinkageSupport;
        this.platformSpecificClassFilter = platformSpecificClassFilter;
        this.fakeOverrideDeclarationTable = fakeOverrideDeclarationTable;
        this.irFakeOverrideBuilder = new IrFakeOverrideBuilder(typeSystem, new IrLinkerFakeOverrideBuilderStrategy(linker, symbolTable, typeSystem.getIrBuiltIns(), this.partialLinkageSupport, this.fakeOverrideDeclarationTable, friendModules, this.partialLinkageSupport.isEnabled() ? (IrUnimplementedOverridesStrategy)new ImplementAsErrorThrowingStubs(this.partialLinkageSupport) : (IrUnimplementedOverridesStrategy)IrUnimplementedOverridesStrategy.ProcessAsFakeOverrides.INSTANCE), externalOverridabilityConditions);
        this.haveFakeOverrides = new LinkedHashSet();
        this.fakeOverrideCandidates = new LinkedHashMap();
    }

    public /* synthetic */ IrLinkerFakeOverrideProvider(FileLocalAwareLinker fileLocalAwareLinker, SymbolTable symbolTable, KotlinMangler.IrMangler irMangler, IrTypeSystemContext irTypeSystemContext, Map map, PartialLinkageSupportForLinker partialLinkageSupportForLinker, FakeOverrideClassFilter fakeOverrideClassFilter, DeclarationTable declarationTable, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            fakeOverrideClassFilter = DefaultFakeOverrideClassFilter.INSTANCE;
        }
        if ((n & 0x80) != 0) {
            declarationTable = new FakeOverrideDeclarationTable(irMangler, null, 1.INSTANCE, 2, null);
        }
        if ((n & 0x100) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(fileLocalAwareLinker, symbolTable, irMangler, irTypeSystemContext, map, partialLinkageSupportForLinker, fakeOverrideClassFilter, declarationTable, list2);
    }

    @NotNull
    public final FakeOverrideClassFilter getPlatformSpecificClassFilter() {
        return this.platformSpecificClassFilter;
    }

    @NotNull
    public final Map<IrClass, CompatibilityMode> getFakeOverrideCandidates() {
        return this.fakeOverrideCandidates;
    }

    public final void enqueueClass(@NotNull IrClass clazz, @NotNull IdSignature signature, @NotNull CompatibilityMode compatibilityMode) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(signature, "signature");
        Intrinsics.checkNotNullParameter(compatibilityMode, "compatibilityMode");
        this.fakeOverrideDeclarationTable.assumeDeclarationSignature(clazz, signature);
        this.fakeOverrideCandidates.put(clazz, compatibilityMode);
    }

    private final boolean buildFakeOverrideChainsForClass(IrClass clazz, CompatibilityMode compatibilityMode) {
        if (this.haveFakeOverrides.contains(clazz)) {
            return true;
        }
        for (IrType supertype2 : clazz.getSuperTypes()) {
            CompatibilityMode mode;
            IrClass superClass;
            if (IrTypesKt.getClass(supertype2) == null) {
                throw new IllegalStateException(("Unexpected super type: " + RenderIrElementKt.render$default(supertype2, null, 1, null)).toString());
            }
            CompatibilityMode compatibilityMode2 = this.fakeOverrideCandidates.get(superClass);
            if (compatibilityMode2 == null) {
                compatibilityMode2 = compatibilityMode;
            }
            if (!this.buildFakeOverrideChainsForClass(superClass, mode = compatibilityMode2)) continue;
            this.haveFakeOverrides.add(superClass);
        }
        if (!this.platformSpecificClassFilter.needToConstructFakeOverrides(clazz)) {
            return false;
        }
        this.irFakeOverrideBuilder.buildFakeOverridesForClass(clazz, compatibilityMode.getOldSignatures());
        return true;
    }

    public final void provideFakeOverrides(@NotNull IrClass klass, @NotNull CompatibilityMode compatibilityMode) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(compatibilityMode, "compatibilityMode");
        this.buildFakeOverrideChainsForClass(klass, compatibilityMode);
        this.haveFakeOverrides.add(klass);
    }

    public final void provideFakeOverrides() {
        List entries = CollectionsKt.toMutableList((Collection)this.fakeOverrideCandidates.entrySet());
        while (!((Collection)entries).isEmpty()) {
            Map.Entry candidate2 = (Map.Entry)CollectionsKt.removeLast(entries);
            this.provideFakeOverrides((IrClass)candidate2.getKey(), (CompatibilityMode)candidate2.getValue());
        }
        this.fakeOverrideCandidates.clear();
    }
}

