/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.infos.ClassCandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.JavaClassSupers;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiUtil
extends PsiUtilCore {
    private static final Logger LOG = Logger.getInstance(PsiUtil.class);
    public static final int ACCESS_LEVEL_PUBLIC = 4;
    public static final int ACCESS_LEVEL_PROTECTED = 3;
    public static final int ACCESS_LEVEL_PACKAGE_LOCAL = 2;
    public static final int ACCESS_LEVEL_PRIVATE = 1;
    public static final Key<Boolean> VALID_VOID_TYPE_IN_CODE_FRAGMENT = Key.create("VALID_VOID_TYPE_IN_CODE_FRAGMENT");
    private static final Pattern IGNORED_NAMES = Pattern.compile("ignored?[A-Z]?[a-z]*\\d*");
    private static final String[] accessModifiers = new String[]{"private", "packageLocal", "protected", "public"};
    public static final Key<LanguageLevel> FILE_LANGUAGE_LEVEL_KEY = Key.create("FORCE_LANGUAGE_LEVEL");
    public static final Comparator<PsiElement> BY_POSITION = (o1, o2) -> PsiUtil.compareElementsByPosition(o1, o2);

    private PsiUtil() {
    }

    public static boolean isOnAssignmentLeftHand(@NotNull PsiExpression expr) {
        PsiElement parent2;
        if (expr == null) {
            PsiUtil.$$$reportNull$$$0(0);
        }
        return (parent2 = PsiTreeUtil.skipParentsOfType(expr, PsiParenthesizedExpression.class)) instanceof PsiAssignmentExpression && PsiTreeUtil.isAncestor(((PsiAssignmentExpression)parent2).getLExpression(), expr, false);
    }

    public static boolean isAccessibleFromPackage(@NotNull PsiModifierListOwner element2, @NotNull PsiPackage aPackage) {
        if (element2 == null) {
            PsiUtil.$$$reportNull$$$0(1);
        }
        if (aPackage == null) {
            PsiUtil.$$$reportNull$$$0(2);
        }
        if (element2.hasModifierProperty("public")) {
            return true;
        }
        return !element2.hasModifierProperty("private") && JavaPsiFacade.getInstance(element2.getProject()).isInPackage(element2, aPackage);
    }

    public static boolean isAccessedForWriting(@NotNull PsiExpression expr) {
        if (expr == null) {
            PsiUtil.$$$reportNull$$$0(3);
        }
        if (PsiUtil.isOnAssignmentLeftHand(expr)) {
            return true;
        }
        PsiElement parent2 = PsiUtil.skipParenthesizedExprUp(expr.getParent());
        return PsiUtil.isIncrementDecrementOperation(parent2);
    }

    public static boolean isAccessedForReading(@NotNull PsiExpression expr) {
        PsiElement parent2;
        if (expr == null) {
            PsiUtil.$$$reportNull$$$0(4);
        }
        return !((parent2 = PsiTreeUtil.skipParentsOfType(expr, PsiParenthesizedExpression.class)) instanceof PsiAssignmentExpression) || !PsiTreeUtil.isAncestor(((PsiAssignmentExpression)parent2).getLExpression(), expr, false) || ((PsiAssignmentExpression)parent2).getOperationTokenType() != JavaTokenType.EQ;
    }

    public static boolean isAccessible(@NotNull PsiMember member2, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass) {
        if (member2 == null) {
            PsiUtil.$$$reportNull$$$0(5);
        }
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(6);
        }
        return PsiUtil.isAccessible(place.getProject(), member2, place, accessObjectClass);
    }

    public static boolean isAccessible(@NotNull Project project, @NotNull PsiMember member2, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass) {
        if (project == null) {
            PsiUtil.$$$reportNull$$$0(7);
        }
        if (member2 == null) {
            PsiUtil.$$$reportNull$$$0(8);
        }
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(9);
        }
        return JavaPsiFacade.getInstance(project).getResolveHelper().isAccessible(member2, place, accessObjectClass);
    }

    public static boolean isMemberAccessibleAt(@NotNull PsiMember member2, @NotNull PsiElement place) {
        VirtualFile virtualFile2;
        if (member2 == null) {
            PsiUtil.$$$reportNull$$$0(10);
        }
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(11);
        }
        return ((virtualFile2 = PsiUtilCore.getVirtualFile(member2)) == null || place.getResolveScope().contains(virtualFile2)) && PsiUtil.isAccessible(member2, place, null);
    }

    @NotNull
    public static JavaResolveResult getAccessObjectClass(@NotNull PsiExpression expression2) {
        JavaResolveResult resolveResult;
        if (expression2 == null) {
            PsiUtil.$$$reportNull$$$0(12);
        }
        if (expression2 instanceof PsiSuperExpression) {
            JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
            if (javaResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(13);
            }
            return javaResolveResult;
        }
        PsiType type2 = expression2.getType();
        JavaResolveResult accessObject = PsiUtil.getAccessObjectClass(type2, expression2);
        if (accessObject != null) {
            JavaResolveResult javaResolveResult = accessObject;
            if (javaResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(14);
            }
            return javaResolveResult;
        }
        if (type2 == null && expression2 instanceof PsiReferenceExpression && (resolveResult = ((PsiReferenceExpression)expression2).advancedResolve(false)).getElement() instanceof PsiClass) {
            JavaResolveResult javaResolveResult = resolveResult;
            if (javaResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(15);
            }
            return javaResolveResult;
        }
        JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            PsiUtil.$$$reportNull$$$0(16);
        }
        return javaResolveResult;
    }

    @Nullable
    private static JavaResolveResult getAccessObjectClass(@Nullable PsiType type2, @NotNull PsiElement place) {
        PsiType upperBound;
        PsiType lub;
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(17);
        }
        if (type2 instanceof PsiClassType) {
            return ((PsiClassType)type2).resolveGenerics();
        }
        if (type2 instanceof PsiDisjunctionType && (lub = ((PsiDisjunctionType)type2).getLeastUpperBound()) instanceof PsiClassType) {
            return ((PsiClassType)lub).resolveGenerics();
        }
        if (type2 instanceof PsiCapturedWildcardType && (upperBound = ((PsiCapturedWildcardType)type2).getUpperBound()) instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)upperBound).resolve();
            PsiFile containingFile2 = resolved != null ? resolved.getContainingFile() : null;
            String packageName2 = containingFile2 instanceof PsiClassOwner ? ((PsiClassOwner)containingFile2).getPackageName() : null;
            String classText = StringUtil.isEmptyOrSpaces(packageName2) ? "" : "package " + packageName2 + ";\n ";
            classText = classText + "class I<T extends " + upperBound.getCanonicalText() + "> {}";
            PsiJavaFile file2 = (PsiJavaFile)PsiFileFactory.getInstance(place.getProject()).createFileFromText("inference_dummy.java", JavaLanguage.INSTANCE, (CharSequence)classText);
            PsiTypeParameter freshParameter = file2.getClasses()[0].getTypeParameters()[0];
            return new ClassCandidateInfo(freshParameter, PsiSubstitutor.EMPTY);
        }
        if (type2 instanceof PsiArrayType) {
            return PsiUtil.getAccessObjectClass(((PsiArrayType)type2).getComponentType(), place);
        }
        return null;
    }

    public static boolean isConstantExpression(@Nullable PsiExpression expression2) {
        return expression2 != null && JavaPsiFacade.getInstance(expression2.getProject()).isConstantExpression(expression2);
    }

    public static void addException(@NotNull PsiMethod method, @NotNull String exceptionFQName) throws IncorrectOperationException {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(18);
        }
        if (exceptionFQName == null) {
            PsiUtil.$$$reportNull$$$0(19);
        }
        PsiClass exceptionClass = JavaPsiFacade.getInstance(method.getProject()).findClass(exceptionFQName, method.getResolveScope());
        PsiUtil.addException(method, exceptionClass, exceptionFQName);
    }

    public static void addException(@NotNull PsiMethod method, @NotNull PsiClass exceptionClass) throws IncorrectOperationException {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(20);
        }
        if (exceptionClass == null) {
            PsiUtil.$$$reportNull$$$0(21);
        }
        PsiUtil.addException(method, exceptionClass, exceptionClass.getQualifiedName());
    }

    private static void addException(@NotNull PsiMethod method, @Nullable PsiClass exceptionClass, @Nullable String exceptionName) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement ref;
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(22);
        }
        if (exceptionClass == null && exceptionName == null) {
            throw new IllegalArgumentException("One of exceptionName, exceptionClass must be not null");
        }
        PsiReferenceList throwsList = method.getThrowsList();
        PsiJavaCodeReferenceElement[] refs = throwsList.getReferenceElements();
        boolean replaced = false;
        for (PsiJavaCodeReferenceElement ref2 : refs) {
            if (exceptionClass != null && ref2.isReferenceTo(exceptionClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)ref2.resolve();
            if (exceptionClass == null || aClass == null) continue;
            if (aClass.isInheritor(exceptionClass, true)) {
                PsiJavaCodeReferenceElement ref1;
                if (replaced) {
                    ref2.delete();
                    continue;
                }
                PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(method.getProject());
                if (exceptionName != null) {
                    ref1 = factory2.createReferenceElementByFQClassName(exceptionName, method.getResolveScope());
                } else {
                    PsiClassType type2 = factory2.createType(exceptionClass);
                    ref1 = factory2.createReferenceElementByType(type2);
                }
                ref2.replace(ref1);
                replaced = true;
                continue;
            }
            if (!exceptionClass.isInheritor(aClass, true)) continue;
            return;
        }
        if (replaced) {
            return;
        }
        PsiElementFactory factory3 = JavaPsiFacade.getElementFactory(method.getProject());
        if (exceptionName != null) {
            ref = factory3.createReferenceElementByFQClassName(exceptionName, method.getResolveScope());
        } else {
            PsiClass superClass;
            for (superClass = exceptionClass.getSuperClass(); superClass != null && PsiUtil.isLocalOrAnonymousClass(superClass); superClass = superClass.getSuperClass()) {
            }
            PsiClassType type3 = factory3.createType(superClass != null ? superClass : exceptionClass);
            ref = factory3.createReferenceElementByType(type3);
        }
        throwsList.add(ref);
    }

    public static void removeException(@NotNull PsiMethod method, String exceptionClass) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] refs;
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(23);
        }
        for (PsiJavaCodeReferenceElement ref : refs = method.getThrowsList().getReferenceElements()) {
            if (!ref.getCanonicalText().equals(exceptionClass)) continue;
            ref.delete();
        }
    }

    public static boolean isVariableNameUnique(@NotNull String name2, @NotNull PsiElement place) {
        PsiResolveHelper helper;
        if (name2 == null) {
            PsiUtil.$$$reportNull$$$0(24);
        }
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(25);
        }
        return (helper = JavaPsiFacade.getInstance(place.getProject()).getResolveHelper()).resolveAccessibleReferencedVariable(name2, place) == null;
    }

    @Nullable
    public static PsiElement getTopLevelEnclosingCodeBlock(@Nullable PsiElement element2, PsiElement scope) {
        PsiElement blockSoFar = null;
        while (element2 != null) {
            PsiElement parent2 = element2.getParent();
            if (!(parent2 instanceof PsiExpression) || parent2 instanceof PsiLambdaExpression) {
                if (element2 instanceof PsiCodeBlock || element2 instanceof PsiForStatement || element2 instanceof PsiForeachStatement) {
                    blockSoFar = element2;
                }
                if (parent2 instanceof PsiMethod && parent2.getParent() instanceof PsiClass && !PsiUtil.isLocalOrAnonymousClass((PsiClass)parent2.getParent()) || parent2 instanceof PsiClassInitializer && !(parent2.getParent() instanceof PsiAnonymousClass)) break;
                if (parent2 instanceof PsiField && ((PsiField)parent2).getInitializer() == element2) {
                    blockSoFar = element2;
                }
                if (parent2 instanceof PsiClassLevelDeclarationStatement) {
                    parent2 = parent2.getParent();
                }
                if (element2 instanceof PsiClass && !PsiUtil.isLocalOrAnonymousClass((PsiClass)element2)) break;
                if (element2 instanceof PsiFile && PsiUtilCore.getTemplateLanguageFile(element2) != null) {
                    return element2;
                }
            }
            if (element2 == scope) break;
            element2 = parent2;
        }
        return blockSoFar;
    }

    public static boolean isLocalOrAnonymousClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiUtil.$$$reportNull$$$0(26);
        }
        return psiClass instanceof PsiAnonymousClass || PsiUtil.isLocalClass(psiClass);
    }

    public static boolean isLocalClass(@NotNull PsiClass psiClass) {
        PsiElement parent2;
        if (psiClass == null) {
            PsiUtil.$$$reportNull$$$0(27);
        }
        if ((parent2 = psiClass.getParent()) instanceof PsiDeclarationStatement && parent2.getParent() instanceof PsiCodeBlock) {
            return true;
        }
        if (parent2 instanceof PsiClass) {
            return PsiUtil.isLocalOrAnonymousClass((PsiClass)parent2);
        }
        return false;
    }

    public static boolean isAbstractClass(@NotNull PsiClass clazz) {
        PsiModifierList modifierList2;
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(28);
        }
        return (modifierList2 = clazz.getModifierList()) != null && modifierList2.hasModifierProperty("abstract");
    }

    @Nullable
    public static PsiElement getVariableCodeBlock(@NotNull PsiVariable variable2, @Nullable PsiElement context2) {
        if (variable2 == null) {
            PsiUtil.$$$reportNull$$$0(29);
        }
        PsiElement codeBlock = null;
        if (variable2 instanceof PsiParameter) {
            PsiElement declarationScope = ((PsiParameter)variable2).getDeclarationScope();
            if (declarationScope instanceof PsiCatchSection) {
                codeBlock = ((PsiCatchSection)declarationScope).getCatchBlock();
            } else if (declarationScope instanceof PsiForeachStatement) {
                codeBlock = ((PsiForeachStatement)declarationScope).getBody();
            } else if (declarationScope instanceof PsiMethod) {
                codeBlock = ((PsiMethod)declarationScope).getBody();
            } else if (declarationScope instanceof PsiLambdaExpression) {
                codeBlock = ((PsiLambdaExpression)declarationScope).getBody();
            }
        } else {
            if (variable2 instanceof PsiResourceVariable) {
                PsiElement resourceList = variable2.getParent();
                return resourceList != null ? resourceList.getParent() : null;
            }
            if (variable2 instanceof PsiLocalVariable && variable2.getParent() instanceof PsiForStatement) {
                return variable2.getParent();
            }
            if (variable2 instanceof PsiField && context2 != null) {
                PsiClass aClass = ((PsiField)variable2).getContainingClass();
                while (context2 != null && context2.getParent() != aClass) {
                    if (!((context2 = context2.getParent()) instanceof PsiClassLevelDeclarationStatement)) continue;
                    return null;
                }
                return context2 instanceof PsiMethod ? ((PsiMethod)context2).getBody() : (context2 instanceof PsiClassInitializer ? ((PsiClassInitializer)context2).getBody() : null);
            }
            PsiElement scope = variable2.getParent() == null ? null : variable2.getParent().getParent();
            codeBlock = PsiUtil.getTopLevelEnclosingCodeBlock(variable2, scope);
            if (codeBlock != null && codeBlock.getParent() instanceof PsiSwitchStatement) {
                codeBlock = codeBlock.getParent().getParent();
            }
        }
        return codeBlock;
    }

    @Contract(value="null -> false")
    public static boolean isIncrementDecrementOperation(@Nullable PsiElement element2) {
        if (element2 instanceof PsiUnaryExpression) {
            IElementType sign = ((PsiUnaryExpression)element2).getOperationTokenType();
            return sign == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS;
        }
        return false;
    }

    public static List<PsiExpression> getSwitchResultExpressions(PsiSwitchExpression switchExpression) {
        PsiCodeBlock body2 = switchExpression.getBody();
        if (body2 != null) {
            PsiStatement[] statements2;
            ArrayList<PsiExpression> result2 = new ArrayList<PsiExpression>();
            for (PsiStatement statement2 : statements2 = body2.getStatements()) {
                if (statement2 instanceof PsiSwitchLabeledRuleStatement) {
                    PsiStatement ruleBody = ((PsiSwitchLabeledRuleStatement)statement2).getBody();
                    if (ruleBody instanceof PsiExpressionStatement) {
                        result2.add(((PsiExpressionStatement)ruleBody).getExpression());
                        continue;
                    }
                    if (!(ruleBody instanceof PsiBlockStatement)) continue;
                    PsiUtil.collectSwitchResultExpressions(result2, ruleBody);
                    continue;
                }
                PsiUtil.collectSwitchResultExpressions(result2, statement2);
            }
            return result2;
        }
        return Collections.emptyList();
    }

    private static void collectSwitchResultExpressions(@NotNull List<? super PsiExpression> result2, @NotNull PsiElement container2) {
        if (result2 == null) {
            PsiUtil.$$$reportNull$$$0(30);
        }
        if (container2 == null) {
            PsiUtil.$$$reportNull$$$0(31);
        }
        ArrayList yields = new ArrayList();
        PsiUtil.addStatements(yields, container2, PsiYieldStatement.class, element2 -> element2 instanceof PsiSwitchExpression);
        for (PsiYieldStatement statement2 : yields) {
            ContainerUtil.addIfNotNull(result2, statement2.getExpression());
        }
    }

    @AccessLevel
    public static int getAccessLevel(@NotNull PsiModifierList modifierList2) {
        if (modifierList2 == null) {
            PsiUtil.$$$reportNull$$$0(32);
        }
        if (modifierList2.hasModifierProperty("private")) {
            return 1;
        }
        if (modifierList2.hasModifierProperty("packageLocal")) {
            return 2;
        }
        if (modifierList2.hasModifierProperty("protected")) {
            return 3;
        }
        return 4;
    }

    @PsiModifier.ModifierConstant
    @NotNull
    public static String getAccessModifier(@AccessLevel int accessLevel) {
        String modifier;
        if (accessLevel <= 0 || accessLevel > accessModifiers.length) {
            throw new IllegalArgumentException("Unknown level:" + accessLevel);
        }
        String string2 = modifier = accessModifiers[accessLevel - 1];
        if (string2 == null) {
            PsiUtil.$$$reportNull$$$0(33);
        }
        return string2;
    }

    public static boolean isStatement(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiUtil.$$$reportNull$$$0(34);
        }
        PsiElement parent2 = element2.getParent();
        if (element2 instanceof PsiExpressionListStatement) {
            if (!(parent2 instanceof PsiForStatement)) {
                return false;
            }
            PsiForStatement forStatement = (PsiForStatement)parent2;
            if (element2 != forStatement.getInitialization() && element2 != forStatement.getUpdate()) {
                return false;
            }
            PsiExpressionList expressionList = ((PsiExpressionListStatement)element2).getExpressionList();
            for (PsiExpression expression2 : expressionList.getExpressions()) {
                if (PsiUtil.isStatement(expression2)) continue;
                return false;
            }
            return true;
        }
        if (element2 instanceof PsiExpressionStatement) {
            return parent2 instanceof PsiSwitchLabeledRuleStatement && ((PsiSwitchLabeledRuleStatement)parent2).getEnclosingSwitchBlock() instanceof PsiSwitchExpression || PsiUtil.isStatement(((PsiExpressionStatement)element2).getExpression());
        }
        if (element2 instanceof PsiDeclarationStatement) {
            if (parent2 instanceof PsiCodeBlock) {
                return true;
            }
            if (parent2 instanceof PsiCodeFragment) {
                return true;
            }
            if (!(parent2 instanceof PsiForStatement) || ((PsiForStatement)parent2).getBody() == element2) {
                return false;
            }
        }
        if (element2 instanceof PsiStatement) {
            return true;
        }
        if (element2 instanceof PsiAssignmentExpression) {
            return true;
        }
        if (PsiUtil.isIncrementDecrementOperation(element2)) {
            return true;
        }
        if (element2 instanceof PsiMethodCallExpression) {
            return true;
        }
        if (element2 instanceof PsiNewExpression) {
            return !(((PsiNewExpression)element2).getType() instanceof PsiArrayType);
        }
        return element2 instanceof PsiCodeBlock;
    }

    @Nullable
    public static PsiElement getEnclosingStatement(PsiElement element2) {
        while (element2 != null) {
            if (element2.getParent() instanceof PsiCodeBlock) {
                return element2;
            }
            element2 = element2.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiElement getElementInclusiveRange(@NotNull PsiElement scope, @NotNull TextRange range) {
        PsiElement psiElement;
        if (scope == null) {
            PsiUtil.$$$reportNull$$$0(35);
        }
        if (range == null) {
            PsiUtil.$$$reportNull$$$0(36);
        }
        for (psiElement = scope.findElementAt(range.getStartOffset()); psiElement != null && !psiElement.getTextRange().contains(range); psiElement = psiElement.getParent()) {
            if (psiElement != scope) continue;
            return null;
        }
        return psiElement;
    }

    @Nullable
    public static PsiClass resolveClassInType(@Nullable PsiType type2) {
        PsiType lub;
        if (type2 instanceof PsiClassType) {
            return ((PsiClassType)type2).resolve();
        }
        if (type2 instanceof PsiArrayType) {
            return PsiUtil.resolveClassInType(((PsiArrayType)type2).getComponentType());
        }
        if (type2 instanceof PsiDisjunctionType && (lub = ((PsiDisjunctionType)type2).getLeastUpperBound()) instanceof PsiClassType) {
            return ((PsiClassType)lub).resolve();
        }
        return null;
    }

    @Nullable
    public static PsiClass resolveClassInClassTypeOnly(@Nullable PsiType type2) {
        return type2 instanceof PsiClassType ? ((PsiClassType)type2).resolve() : null;
    }

    @NotNull
    public static PsiClassType.ClassResolveResult resolveGenericsClassInType(@Nullable PsiType type2) {
        PsiType lub;
        if (type2 instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type2;
            PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
            if (classResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(37);
            }
            return classResolveResult;
        }
        if (type2 instanceof PsiArrayType) {
            return PsiUtil.resolveGenericsClassInType(((PsiArrayType)type2).getComponentType());
        }
        if (type2 instanceof PsiDisjunctionType && (lub = ((PsiDisjunctionType)type2).getLeastUpperBound()) instanceof PsiClassType) {
            PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)lub).resolveGenerics();
            if (classResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(38);
            }
            return classResolveResult;
        }
        PsiClassType.ClassResolveResult classResolveResult = PsiClassType.ClassResolveResult.EMPTY;
        if (classResolveResult == null) {
            PsiUtil.$$$reportNull$$$0(39);
        }
        return classResolveResult;
    }

    @NotNull
    public static PsiType convertAnonymousToBaseType(@NotNull PsiType type2) {
        PsiClass psiClass;
        if (type2 == null) {
            PsiUtil.$$$reportNull$$$0(40);
        }
        if ((psiClass = PsiUtil.resolveClassInType(type2)) instanceof PsiAnonymousClass) {
            type2 = PsiTypesUtil.createArrayType(((PsiAnonymousClass)psiClass).getBaseClassType(), type2.getArrayDimensions());
        }
        PsiType psiType2 = type2;
        if (psiType2 == null) {
            PsiUtil.$$$reportNull$$$0(41);
        }
        return psiType2;
    }

    public static boolean isApplicable(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, @NotNull PsiExpressionList argList) {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(42);
        }
        if (substitutorForMethod == null) {
            PsiUtil.$$$reportNull$$$0(43);
        }
        if (argList == null) {
            PsiUtil.$$$reportNull$$$0(44);
        }
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, argList) != 1;
    }

    public static boolean isApplicable(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, PsiExpression @NotNull [] argList) {
        PsiType[] types2;
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(45);
        }
        if (substitutorForMethod == null) {
            PsiUtil.$$$reportNull$$$0(46);
        }
        if (argList == null) {
            PsiUtil.$$$reportNull$$$0(47);
        }
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, types2 = ContainerUtil.map2Array(argList, PsiType.class, PsiExpression.EXPRESSION_TO_TYPE), PsiUtil.getLanguageLevel(method)) != 1;
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public static int getApplicabilityLevel(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, @NotNull PsiExpressionList argList) {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(48);
        }
        if (substitutorForMethod == null) {
            PsiUtil.$$$reportNull$$$0(49);
        }
        if (argList == null) {
            PsiUtil.$$$reportNull$$$0(50);
        }
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, argList.getExpressionTypes(), PsiUtil.getLanguageLevel(argList));
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public static int getApplicabilityLevel(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, PsiType @NotNull [] args2, @NotNull LanguageLevel languageLevel) {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(51);
        }
        if (substitutorForMethod == null) {
            PsiUtil.$$$reportNull$$$0(52);
        }
        if (languageLevel == null) {
            PsiUtil.$$$reportNull$$$0(53);
        }
        if (args2 == null) {
            PsiUtil.$$$reportNull$$$0(54);
        }
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, args2, languageLevel, true, true, ApplicabilityChecker.ASSIGNABILITY_CHECKER);
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public static int getApplicabilityLevel(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, PsiType @NotNull [] args2, @NotNull LanguageLevel languageLevel, boolean allowUncheckedConversion, boolean checkVarargs, @NotNull ApplicabilityChecker function2) {
        boolean isRaw;
        PsiParameter[] parameters2;
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(55);
        }
        if (substitutorForMethod == null) {
            PsiUtil.$$$reportNull$$$0(56);
        }
        if (languageLevel == null) {
            PsiUtil.$$$reportNull$$$0(57);
        }
        if (function2 == null) {
            PsiUtil.$$$reportNull$$$0(58);
        }
        if (args2 == null) {
            PsiUtil.$$$reportNull$$$0(59);
        }
        if (args2.length < (parameters2 = method.getParameterList().getParameters()).length - 1) {
            return 1;
        }
        PsiClass containingClass = method.getContainingClass();
        boolean bl = isRaw = containingClass != null && PsiUtil.isRawSubstitutor(method, substitutorForMethod) && PsiUtil.isRawSubstitutor(containingClass, substitutorForMethod);
        if (!PsiUtil.areFirstArgumentsApplicable(args2, parameters2, languageLevel, substitutorForMethod, isRaw, allowUncheckedConversion, function2)) {
            return 1;
        }
        if (args2.length == parameters2.length) {
            PsiType erasedParamType;
            if (parameters2.length == 0) {
                return 3;
            }
            PsiType parmType = PsiUtil.getParameterType(parameters2[parameters2.length - 1], languageLevel, substitutorForMethod);
            PsiType argType = args2[args2.length - 1];
            if (argType == null) {
                return 1;
            }
            if (function2.isApplicable(parmType, argType, allowUncheckedConversion, parameters2.length - 1)) {
                return 3;
            }
            if (isRaw && (erasedParamType = TypeConversionUtil.erasure(parmType)) != null && function2.isApplicable(erasedParamType, argType, allowUncheckedConversion, parameters2.length - 1)) {
                return 3;
            }
        }
        if (checkVarargs && method.isVarArgs() && languageLevel.compareTo(LanguageLevel.JDK_1_5) >= 0) {
            PsiParameter lastParameter;
            if (args2.length < parameters2.length) {
                return 2;
            }
            PsiParameter psiParameter = lastParameter = parameters2.length == 0 ? null : parameters2[parameters2.length - 1];
            if (lastParameter == null || !lastParameter.isVarArgs()) {
                return 1;
            }
            PsiType lastParmType = PsiUtil.getParameterType(lastParameter, languageLevel, substitutorForMethod);
            if (!(lastParmType instanceof PsiArrayType)) {
                return 1;
            }
            if ((lastParmType = ((PsiArrayType)lastParmType).getComponentType()) instanceof PsiCapturedWildcardType && !JavaVersionService.getInstance().isAtLeast(((PsiCapturedWildcardType)lastParmType).getContext(), JavaSdkVersion.JDK_1_8)) {
                lastParmType = ((PsiCapturedWildcardType)lastParmType).getWildcard();
            }
            if (lastParmType instanceof PsiClassType) {
                lastParmType = ((PsiClassType)lastParmType).setLanguageLevel(languageLevel);
            }
            for (int i = parameters2.length - 1; i < args2.length; ++i) {
                PsiType argType = args2[i];
                if (argType != null && function2.isApplicable(lastParmType, argType, allowUncheckedConversion, i)) continue;
                return 1;
            }
            return 2;
        }
        return 1;
    }

    private static boolean areFirstArgumentsApplicable(PsiType @NotNull [] args2, PsiParameter @NotNull [] parameters2, @NotNull LanguageLevel languageLevel, @NotNull PsiSubstitutor substitutorForMethod, boolean isRaw, boolean allowUncheckedConversion, ApplicabilityChecker function2) {
        if (languageLevel == null) {
            PsiUtil.$$$reportNull$$$0(60);
        }
        if (substitutorForMethod == null) {
            PsiUtil.$$$reportNull$$$0(61);
        }
        if (args2 == null) {
            PsiUtil.$$$reportNull$$$0(62);
        }
        if (parameters2 == null) {
            PsiUtil.$$$reportNull$$$0(63);
        }
        for (int i = 0; i < parameters2.length - 1; ++i) {
            PsiType substErasure;
            PsiType type2 = args2[i];
            if (type2 == null) {
                return false;
            }
            PsiParameter parameter2 = parameters2[i];
            PsiType substitutedParmType = PsiUtil.getParameterType(parameter2, languageLevel, substitutorForMethod);
            if (!(isRaw ? (substErasure = TypeConversionUtil.erasure(substitutedParmType)) != null && !function2.isApplicable(substErasure, type2, allowUncheckedConversion, i) : !function2.isApplicable(substitutedParmType, type2, allowUncheckedConversion, i))) continue;
            return false;
        }
        return true;
    }

    private static PsiType getParameterType(@NotNull PsiParameter parameter2, @NotNull LanguageLevel languageLevel, @NotNull PsiSubstitutor substitutor2) {
        PsiType parmType;
        if (parameter2 == null) {
            PsiUtil.$$$reportNull$$$0(64);
        }
        if (languageLevel == null) {
            PsiUtil.$$$reportNull$$$0(65);
        }
        if (substitutor2 == null) {
            PsiUtil.$$$reportNull$$$0(66);
        }
        if ((parmType = parameter2.getType()) instanceof PsiClassType) {
            parmType = ((PsiClassType)parmType).setLanguageLevel(languageLevel);
        }
        return substitutor2.substitute(parmType);
    }

    public static boolean equalOnEquivalentClasses(@NotNull PsiClassType thisClassType, @NotNull PsiClass aClass, @NotNull PsiClassType otherClassType, @NotNull PsiClass bClass) {
        if (thisClassType == null) {
            PsiUtil.$$$reportNull$$$0(67);
        }
        if (aClass == null) {
            PsiUtil.$$$reportNull$$$0(68);
        }
        if (otherClassType == null) {
            PsiUtil.$$$reportNull$$$0(69);
        }
        if (bClass == null) {
            PsiUtil.$$$reportNull$$$0(70);
        }
        PsiClassType capture1 = !PsiCapturedWildcardType.isCapture() ? thisClassType : (PsiClassType)PsiUtil.captureToplevelWildcards(thisClassType, aClass);
        PsiClassType capture2 = !PsiCapturedWildcardType.isCapture() ? otherClassType : (PsiClassType)PsiUtil.captureToplevelWildcards(otherClassType, bClass);
        PsiClassType.ClassResolveResult result1 = capture1.resolveGenerics();
        PsiClassType.ClassResolveResult result2 = capture2.resolveGenerics();
        return PsiUtil.equalOnEquivalentClasses(result1.getSubstitutor(), aClass, result2.getSubstitutor(), bClass);
    }

    private static boolean equalOnEquivalentClasses(@NotNull PsiSubstitutor s1, @NotNull PsiClass aClass, @NotNull PsiSubstitutor s2, @NotNull PsiClass bClass) {
        PsiTypeParameter[] typeParameters2;
        if (s1 == null) {
            PsiUtil.$$$reportNull$$$0(71);
        }
        if (aClass == null) {
            PsiUtil.$$$reportNull$$$0(72);
        }
        if (s2 == null) {
            PsiUtil.$$$reportNull$$$0(73);
        }
        if (bClass == null) {
            PsiUtil.$$$reportNull$$$0(74);
        }
        if (s1 == s2 && aClass == bClass) {
            return true;
        }
        if (aClass.hasTypeParameters() != bClass.hasTypeParameters()) {
            return true;
        }
        PsiTypeParameter[] typeParameters1 = aClass.getTypeParameters();
        if (typeParameters1.length != (typeParameters2 = bClass.getTypeParameters()).length) {
            return false;
        }
        for (int i = 0; i < typeParameters1.length; ++i) {
            PsiType substituted2 = s2.substitute(typeParameters2[i]);
            PsiType substituted1 = s1.substitute(typeParameters1[i]);
            if (Comparing.equal(substituted1, substituted2)) continue;
            return false;
        }
        if (aClass.hasModifierProperty("static")) {
            return true;
        }
        PsiClass containingClass1 = aClass.getContainingClass();
        PsiClass containingClass2 = bClass.getContainingClass();
        if (containingClass1 != null && containingClass2 != null) {
            return PsiUtil.equalOnEquivalentClasses(s1, containingClass1, s2, containingClass2);
        }
        if (containingClass1 == null && containingClass2 == null) {
            if (aClass == bClass && PsiUtil.isLocalClass(aClass)) {
                PsiClass containingClass = PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class);
                return containingClass != null && PsiUtil.equalOnEquivalentClasses(s1, containingClass, s2, containingClass);
            }
            return true;
        }
        return false;
    }

    public static boolean isCompileTimeConstant(@NotNull PsiVariable field2) {
        if (field2 == null) {
            PsiUtil.$$$reportNull$$$0(75);
        }
        if (!field2.hasModifierProperty("final")) {
            return false;
        }
        PsiType type2 = field2.getType();
        return (TypeConversionUtil.isPrimitiveAndNotNull(type2) || type2.equalsToText("java.lang.String")) && field2.hasInitializer() && PsiUtil.isConstantExpression(field2.getInitializer());
    }

    public static boolean allMethodsHaveSameSignature(PsiMethod @NotNull [] methods2) {
        if (methods2 == null) {
            PsiUtil.$$$reportNull$$$0(76);
        }
        if (methods2.length == 0) {
            return true;
        }
        MethodSignature methodSignature = methods2[0].getSignature(PsiSubstitutor.EMPTY);
        for (int i = 1; i < methods2.length; ++i) {
            PsiMethod method = methods2[i];
            if (methodSignature.equals(method.getSignature(PsiSubstitutor.EMPTY))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    @Contract(value="null -> null")
    public static PsiExpression deparenthesizeExpression(PsiExpression expression2) {
        while (true) {
            if (expression2 instanceof PsiParenthesizedExpression) {
                expression2 = ((PsiParenthesizedExpression)expression2).getExpression();
                continue;
            }
            if (!(expression2 instanceof PsiTypeCastExpression)) break;
            expression2 = ((PsiTypeCastExpression)expression2).getOperand();
        }
        return expression2;
    }

    public static boolean isInnerClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiUtil.$$$reportNull$$$0(77);
        }
        return !aClass.hasModifierProperty("static") && aClass.getContainingClass() != null;
    }

    @Nullable
    public static PsiElement findModifierInList(@NotNull PsiModifierList modifierList2, String modifier) {
        PsiElement[] children2;
        if (modifierList2 == null) {
            PsiUtil.$$$reportNull$$$0(78);
        }
        for (PsiElement child : children2 = modifierList2.getChildren()) {
            if (!child.getText().equals(modifier)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static PsiClass getTopLevelClass(@NotNull PsiElement element2) {
        PsiClass topClass;
        if (element2 == null) {
            PsiUtil.$$$reportNull$$$0(79);
        }
        return (topClass = JBIterable.generate(element2, PsiElement::getParent).takeWhile(e -> !(e instanceof PsiFile)).filter(PsiClass.class).last()) instanceof PsiTypeParameter ? null : topClass;
    }

    @NlsSafe
    @Nullable
    public static String getPackageName(@NotNull PsiClass aClass) {
        String fqName2;
        PsiClass topClass;
        if (aClass == null) {
            PsiUtil.$$$reportNull$$$0(80);
        }
        if ((topClass = PsiUtil.getTopLevelClass(aClass)) != null && (fqName2 = topClass.getQualifiedName()) != null) {
            return StringUtil.getPackageName(fqName2);
        }
        PsiFile file2 = aClass.getContainingFile();
        if (file2 instanceof PsiClassOwner) {
            return ((PsiClassOwner)file2).getPackageName();
        }
        return null;
    }

    @Nullable
    public static PsiModifierListOwner getEnclosingStaticElement(@NotNull PsiElement place, @Nullable PsiClass aClass) {
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(81);
        }
        LOG.assertTrue(aClass == null || !place.isPhysical() || PsiTreeUtil.isContextAncestor(aClass, place, false));
        for (PsiElement parent2 = place; parent2 != aClass && !(parent2 instanceof PsiFile); parent2 = parent2.getParent()) {
            if (!(parent2 instanceof PsiModifierListOwner) || !((PsiModifierListOwner)parent2).hasModifierProperty("static")) continue;
            return (PsiModifierListOwner)parent2;
        }
        return null;
    }

    @Nullable
    public static PsiType getTypeByPsiElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiUtil.$$$reportNull$$$0(82);
        }
        if (element2 instanceof PsiVariable) {
            return ((PsiVariable)element2).getType();
        }
        if (element2 instanceof PsiMethod) {
            return ((PsiMethod)element2).getReturnType();
        }
        return null;
    }

    @NotNull
    public static PsiType captureToplevelWildcards(@NotNull PsiType type2, @NotNull PsiElement context2) {
        PsiClassType.ClassResolveResult result2;
        PsiClass aClass;
        if (type2 == null) {
            PsiUtil.$$$reportNull$$$0(83);
        }
        if (context2 == null) {
            PsiUtil.$$$reportNull$$$0(84);
        }
        if (type2 instanceof PsiClassType && (aClass = (result2 = ((PsiClassType)type2).resolveGenerics()).getElement()) != null) {
            PsiSubstitutor substitutor2;
            PsiSubstitutor captureSubstitutor = substitutor2 = result2.getSubstitutor();
            for (PsiTypeParameter psiTypeParameter : PsiUtil.typeParametersIterable(aClass)) {
                PsiType substituted = substitutor2.substitute(psiTypeParameter);
                if (!(substituted instanceof PsiWildcardType)) continue;
                captureSubstitutor = captureSubstitutor.put(psiTypeParameter, PsiCapturedWildcardType.create((PsiWildcardType)substituted, context2, psiTypeParameter));
            }
            if (captureSubstitutor != substitutor2) {
                HashMap<PsiTypeParameter, PsiType> substitutionMap = null;
                for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass)) {
                    PsiCapturedWildcardType capturedWildcard;
                    PsiType substituted = substitutor2.substitute(typeParameter);
                    if (!(substituted instanceof PsiWildcardType)) continue;
                    if (substitutionMap == null) {
                        substitutionMap = new HashMap<PsiTypeParameter, PsiType>(substitutor2.getSubstitutionMap());
                    }
                    LOG.assertTrue((capturedWildcard = (PsiCapturedWildcardType)captureSubstitutor.substitute(typeParameter)) != null);
                    PsiType upperBound = PsiCapturedWildcardType.captureUpperBound(typeParameter, (PsiWildcardType)substituted, captureSubstitutor);
                    if (upperBound != null) {
                        capturedWildcard.setUpperBound(upperBound);
                    }
                    substitutionMap.put(typeParameter, capturedWildcard);
                }
                if (substitutionMap != null) {
                    PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory(aClass.getProject());
                    PsiSubstitutor newSubstitutor = psiElementFactory.createSubstitutor(substitutionMap);
                    PsiClassType psiClassType = psiElementFactory.createType(aClass, newSubstitutor);
                    if (psiClassType == null) {
                        PsiUtil.$$$reportNull$$$0(85);
                    }
                    return psiClassType;
                }
            }
        }
        PsiType psiType2 = type2;
        if (psiType2 == null) {
            PsiUtil.$$$reportNull$$$0(86);
        }
        return psiType2;
    }

    public static boolean isInsideJavadocComment(PsiElement element2) {
        return PsiTreeUtil.getParentOfType(element2, PsiDocComment.class, true) != null;
    }

    @NotNull
    public static List<PsiTypeElement> getParameterTypeElements(@NotNull PsiParameter parameter2) {
        PsiTypeElement typeElement;
        if (parameter2 == null) {
            PsiUtil.$$$reportNull$$$0(87);
        }
        List<PsiTypeElement> list2 = (typeElement = parameter2.getTypeElement()) != null && typeElement.getType() instanceof PsiDisjunctionType ? PsiTreeUtil.getChildrenOfTypeAsList(typeElement, PsiTypeElement.class) : Collections.singletonList(typeElement);
        if (list2 == null) {
            PsiUtil.$$$reportNull$$$0(88);
        }
        return list2;
    }

    public static void checkIsIdentifier(@NotNull PsiManager manager, String text) throws IncorrectOperationException {
        if (manager == null) {
            PsiUtil.$$$reportNull$$$0(89);
        }
        if (!PsiNameHelper.getInstance(manager.getProject()).isIdentifier(text)) {
            throw new IncorrectOperationException(JavaPsiBundle.message("0.is.not.an.identifier", text));
        }
    }

    @Nullable
    public static VirtualFile getJarFile(@NotNull PsiElement candidate2) {
        VirtualFile file2;
        if (candidate2 == null) {
            PsiUtil.$$$reportNull$$$0(90);
        }
        if ((file2 = candidate2.getContainingFile().getVirtualFile()) != null && file2.getFileSystem().getProtocol().equals("jar")) {
            return VfsUtilCore.getVirtualFileForJar(file2);
        }
        return file2;
    }

    public static boolean isAnnotationMethod(PsiElement element2) {
        if (!(element2 instanceof PsiAnnotationMethod)) {
            return false;
        }
        PsiClass psiClass = ((PsiAnnotationMethod)element2).getContainingClass();
        return psiClass != null && psiClass.isAnnotationType();
    }

    @PsiModifier.ModifierConstant
    public static String getMaximumModifierForMember(PsiClass aClass, boolean allowPublicAbstract) {
        String modifier = "public";
        if (!allowPublicAbstract && aClass.hasModifierProperty("abstract") && !aClass.isEnum()) {
            modifier = "protected";
        } else if (aClass.hasModifierProperty("packageLocal") || aClass.isEnum()) {
            modifier = "packageLocal";
        } else if (aClass.hasModifierProperty("private")) {
            modifier = "private";
        }
        return modifier;
    }

    @NotNull
    public static Iterator<PsiTypeParameter> typeParametersIterator(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            PsiUtil.$$$reportNull$$$0(91);
        }
        Iterator<PsiTypeParameter> iterator2 = PsiUtil.typeParametersIterable(owner).iterator();
        if (iterator2 == null) {
            PsiUtil.$$$reportNull$$$0(92);
        }
        return iterator2;
    }

    @NotNull
    public static Iterable<PsiTypeParameter> typeParametersIterable(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            PsiUtil.$$$reportNull$$$0(93);
        }
        Iterable result2 = null;
        PsiTypeParameterListOwner currentOwner = owner;
        while (currentOwner != null) {
            final PsiTypeParameter[] typeParameters2 = currentOwner.getTypeParameters();
            if (typeParameters2.length > 0) {
                Iterable iterable = () -> new Iterator<PsiTypeParameter>(){
                    int idx;
                    {
                        this.idx = typeParameters2.length - 1;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.idx >= 0;
                    }

                    @Override
                    public PsiTypeParameter next() {
                        if (this.idx < 0) {
                            throw new NoSuchElementException();
                        }
                        return typeParameters2[this.idx--];
                    }
                };
                result2 = result2 == null ? iterable : ContainerUtil.concat(result2, iterable);
            }
            if (currentOwner.hasModifierProperty("static")) break;
            if (currentOwner instanceof PsiClass && PsiUtil.isLocalClass((PsiClass)currentOwner)) {
                currentOwner = PsiTreeUtil.getParentOfType((PsiElement)currentOwner, PsiTypeParameterListOwner.class);
                continue;
            }
            currentOwner = currentOwner.getContainingClass();
        }
        if (result2 == null) {
            List<PsiTypeParameter> list2 = Collections.emptyList();
            if (list2 == null) {
                PsiUtil.$$$reportNull$$$0(94);
            }
            return list2;
        }
        Iterable iterable = result2;
        if (iterable == null) {
            PsiUtil.$$$reportNull$$$0(95);
        }
        return iterable;
    }

    public static boolean canBeOverridden(@NotNull PsiMethod method) {
        PsiClass parentClass;
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(96);
        }
        return (parentClass = method.getContainingClass()) != null && !method.isConstructor() && !method.hasModifierProperty("static") && !method.hasModifierProperty("final") && !method.hasModifierProperty("private") && !(parentClass instanceof PsiAnonymousClass) && !parentClass.hasModifierProperty("final");
    }

    public static PsiElement @NotNull [] mapElements(ResolveResult @NotNull [] candidates2) {
        if (candidates2 == null) {
            PsiUtil.$$$reportNull$$$0(97);
        }
        PsiElement[] result2 = new PsiElement[candidates2.length];
        for (int i = 0; i < candidates2.length; ++i) {
            result2[i] = candidates2[i].getElement();
        }
        if (result2 == null) {
            PsiUtil.$$$reportNull$$$0(98);
        }
        return result2;
    }

    @Nullable
    public static PsiMember findEnclosingConstructorOrInitializer(PsiElement expression2) {
        PsiMember parent2 = (PsiMember)PsiTreeUtil.getParentOfType(expression2, PsiClassInitializer.class, PsiEnumConstantInitializer.class, PsiMethod.class, PsiField.class);
        if (parent2 instanceof PsiMethod && !((PsiMethod)parent2).isConstructor()) {
            return null;
        }
        return parent2;
    }

    public static boolean checkName(@NotNull PsiElement element2, @NotNull String name2, @NotNull PsiElement context2) {
        PsiMetaData data2;
        if (element2 == null) {
            PsiUtil.$$$reportNull$$$0(99);
        }
        if (name2 == null) {
            PsiUtil.$$$reportNull$$$0(100);
        }
        if (context2 == null) {
            PsiUtil.$$$reportNull$$$0(101);
        }
        if (element2 instanceof PsiMetaOwner && (data2 = ((PsiMetaOwner)((Object)element2)).getMetaData()) != null) {
            return name2.equals(data2.getName(context2));
        }
        return element2 instanceof PsiNamedElement && name2.equals(((PsiNamedElement)element2).getName());
    }

    public static boolean isRawSubstitutor(@NotNull PsiTypeParameterListOwner owner, @NotNull PsiSubstitutor substitutor2) {
        if (owner == null) {
            PsiUtil.$$$reportNull$$$0(102);
        }
        if (substitutor2 == null) {
            PsiUtil.$$$reportNull$$$0(103);
        }
        if (substitutor2 == PsiSubstitutor.EMPTY) {
            return false;
        }
        for (PsiTypeParameter parameter2 : PsiUtil.typeParametersIterable(owner)) {
            if (substitutor2.substitute(parameter2) != null) continue;
            return true;
        }
        return false;
    }

    public static boolean isLanguageLevel5OrHigher(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiUtil.$$$reportNull$$$0(104);
        }
        return PsiUtil.getLanguageLevel(element2).isAtLeast(LanguageLevel.JDK_1_5);
    }

    public static boolean isLanguageLevel6OrHigher(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiUtil.$$$reportNull$$$0(105);
        }
        return PsiUtil.getLanguageLevel(element2).isAtLeast(LanguageLevel.JDK_1_6);
    }

    public static boolean isLanguageLevel7OrHigher(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiUtil.$$$reportNull$$$0(106);
        }
        return PsiUtil.getLanguageLevel(element2).isAtLeast(LanguageLevel.JDK_1_7);
    }

    public static boolean isLanguageLevel8OrHigher(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiUtil.$$$reportNull$$$0(107);
        }
        return PsiUtil.getLanguageLevel(element2).isAtLeast(LanguageLevel.JDK_1_8);
    }

    public static boolean isLanguageLevel9OrHigher(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiUtil.$$$reportNull$$$0(108);
        }
        return PsiUtil.getLanguageLevel(element2).isAtLeast(LanguageLevel.JDK_1_9);
    }

    public static boolean isLanguageLevel10OrHigher(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiUtil.$$$reportNull$$$0(109);
        }
        return PsiUtil.getLanguageLevel(element2).isAtLeast(LanguageLevel.JDK_10);
    }

    public static boolean isLanguageLevel11OrHigher(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiUtil.$$$reportNull$$$0(110);
        }
        return PsiUtil.getLanguageLevel(element2).isAtLeast(LanguageLevel.JDK_11);
    }

    public static boolean isLanguageLevel14OrHigher(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiUtil.$$$reportNull$$$0(111);
        }
        return PsiUtil.getLanguageLevel(element2).isAtLeast(LanguageLevel.JDK_14);
    }

    public static boolean isLanguageLevel16OrHigher(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiUtil.$$$reportNull$$$0(112);
        }
        return PsiUtil.getLanguageLevel(element2).isAtLeast(LanguageLevel.JDK_16);
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(@NotNull PsiElement element2) {
        PsiElement context2;
        if (element2 == null) {
            PsiUtil.$$$reportNull$$$0(113);
        }
        if (element2 instanceof PsiDirectory) {
            LanguageLevel languageLevel = JavaDirectoryService.getInstance().getLanguageLevel((PsiDirectory)element2);
            if (languageLevel == null) {
                PsiUtil.$$$reportNull$$$0(114);
            }
            return languageLevel;
        }
        PsiFile file2 = element2.getContainingFile();
        if (file2 instanceof PsiJavaFile) {
            LanguageLevel languageLevel = ((PsiJavaFile)file2).getLanguageLevel();
            if (languageLevel == null) {
                PsiUtil.$$$reportNull$$$0(115);
            }
            return languageLevel;
        }
        if (file2 != null && (context2 = file2.getContext()) != null) {
            if (!context2.isValid()) {
                throw new PsiInvalidElementAccessException(context2, "Invalid context in " + file2 + " of " + file2.getClass());
            }
            return PsiUtil.getLanguageLevel(context2);
        }
        PsiResolveHelper instance2 = element2.getProject().getService(PsiResolveHelper.class);
        LanguageLevel languageLevel = instance2 != null ? instance2.getEffectiveLanguageLevel(PsiUtil.getVirtualFile(file2)) : LanguageLevel.HIGHEST;
        if (languageLevel == null) {
            PsiUtil.$$$reportNull$$$0(116);
        }
        return languageLevel;
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(@NotNull Project project) {
        LanguageLevelProjectExtension instance2;
        if (project == null) {
            PsiUtil.$$$reportNull$$$0(117);
        }
        LanguageLevel languageLevel = (instance2 = LanguageLevelProjectExtension.getInstance(project)) != null ? instance2.getLanguageLevel() : LanguageLevel.HIGHEST;
        if (languageLevel == null) {
            PsiUtil.$$$reportNull$$$0(118);
        }
        return languageLevel;
    }

    public static boolean isInstantiatable(@NotNull PsiClass clazz) {
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(119);
        }
        return !clazz.hasModifierProperty("abstract") && clazz.hasModifierProperty("public") && PsiUtil.hasDefaultConstructor(clazz);
    }

    public static boolean hasDefaultConstructor(@NotNull PsiClass clazz) {
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(120);
        }
        return PsiUtil.hasDefaultConstructor(clazz, false);
    }

    public static boolean hasDefaultConstructor(@NotNull PsiClass clazz, boolean allowProtected) {
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(121);
        }
        return PsiUtil.hasDefaultConstructor(clazz, allowProtected, false);
    }

    public static boolean hasDefaultConstructor(@NotNull PsiClass clazz, boolean allowProtected, boolean allowPrivateAndPackagePrivate) {
        PsiMethod[] constructors2;
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(122);
        }
        if ((constructors2 = clazz.getConstructors()).length == 0) {
            return true;
        }
        for (PsiMethod cls : constructors2) {
            if (!cls.hasModifierProperty("public") && (!allowProtected || !cls.hasModifierProperty("protected")) && (!allowPrivateAndPackagePrivate || cls.hasModifierProperty("protected")) || !cls.getParameterList().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiType extractIterableTypeParameter(@Nullable PsiType psiType2, boolean eraseTypeParameter) {
        PsiType type2 = PsiUtil.substituteTypeParameter(psiType2, "java.lang.Iterable", 0, eraseTypeParameter);
        return type2 != null ? type2 : PsiUtil.substituteTypeParameter(psiType2, "java.util.Collection", 0, eraseTypeParameter);
    }

    @Contract(value="null, _, _, _ -> null")
    @Nullable
    public static PsiType substituteTypeParameter(@Nullable PsiType psiType2, @NotNull String superClass, int typeParamIndex, boolean eraseTypeParameter) {
        PsiClassType.ClassResolveResult classResolveResult;
        PsiClass psiClass;
        if (superClass == null) {
            PsiUtil.$$$reportNull$$$0(123);
        }
        if ((psiClass = (classResolveResult = PsiUtil.resolveClass(psiType2)).getElement()) == null) {
            return null;
        }
        PsiClass baseClass = JavaPsiFacade.getInstance(psiClass.getProject()).findClass(superClass, psiClass.getResolveScope());
        if (baseClass == null) {
            return null;
        }
        return PsiUtil.substituteType(typeParamIndex, eraseTypeParameter, classResolveResult, psiClass, baseClass);
    }

    @Contract(value="null, _, _, _ -> null")
    @Nullable
    public static PsiType substituteTypeParameter(@Nullable PsiType psiType2, @NotNull PsiClass superClass, int typeParamIndex, boolean eraseTypeParameter) {
        PsiClassType.ClassResolveResult classResolveResult;
        PsiClass psiClass;
        if (superClass == null) {
            PsiUtil.$$$reportNull$$$0(124);
        }
        if ((psiClass = (classResolveResult = PsiUtil.resolveClass(psiType2)).getElement()) == null) {
            return null;
        }
        return PsiUtil.substituteType(typeParamIndex, eraseTypeParameter, classResolveResult, psiClass, superClass);
    }

    private static PsiClassType.ClassResolveResult resolveClass(@Nullable PsiType psiType2) {
        return psiType2 instanceof PsiClassType ? ((PsiClassType)psiType2).resolveGenerics() : PsiClassType.ClassResolveResult.EMPTY;
    }

    @Nullable
    private static PsiType substituteType(int typeParamIndex, boolean eraseTypeParameter, PsiClassType.ClassResolveResult classResolveResult, PsiClass psiClass, PsiClass baseClass) {
        if (!psiClass.isEquivalentTo(baseClass) && !psiClass.isInheritor(baseClass, true)) {
            return null;
        }
        PsiTypeParameter[] parameters2 = baseClass.getTypeParameters();
        if (parameters2.length <= typeParamIndex) {
            return PsiType.getJavaLangObject(psiClass.getManager(), psiClass.getResolveScope());
        }
        PsiSubstitutor substitutor2 = TypeConversionUtil.getSuperClassSubstitutor(baseClass, psiClass, classResolveResult.getSubstitutor());
        PsiType type2 = substitutor2.substitute(parameters2[typeParamIndex]);
        if (type2 == null && eraseTypeParameter) {
            return TypeConversionUtil.typeParameterErasure(parameters2[typeParamIndex]);
        }
        return type2;
    }

    public static void setModifierProperty(@NotNull PsiModifierListOwner owner, @NotNull @PsiModifier.ModifierConstant String property, boolean value2) {
        if (owner == null) {
            PsiUtil.$$$reportNull$$$0(125);
        }
        if (property == null) {
            PsiUtil.$$$reportNull$$$0(126);
        }
        PsiModifierList modifierList2 = owner.getModifierList();
        assert (modifierList2 != null) : owner;
        modifierList2.setModifierProperty(property, value2);
    }

    public static boolean isElseBlock(@Nullable PsiElement element2) {
        if (element2 == null) {
            return false;
        }
        PsiElement parent2 = element2.getParent();
        return parent2 instanceof PsiIfStatement && element2 == ((PsiIfStatement)parent2).getElseBranch();
    }

    public static boolean isJavaToken(@Nullable PsiElement element2, IElementType type2) {
        return element2 instanceof PsiJavaToken && ((PsiJavaToken)element2).getTokenType() == type2;
    }

    public static boolean isJavaToken(@Nullable PsiElement element2, @NotNull TokenSet types2) {
        if (types2 == null) {
            PsiUtil.$$$reportNull$$$0(127);
        }
        return element2 instanceof PsiJavaToken && types2.contains(((PsiJavaToken)element2).getTokenType());
    }

    public static boolean isCatchParameter(@Nullable PsiElement element2) {
        return element2 instanceof PsiParameter && element2.getParent() instanceof PsiCatchSection;
    }

    public static boolean isIgnoredName(@Nullable String name2) {
        return name2 != null && IGNORED_NAMES.matcher(name2).matches();
    }

    public static PsiMethod @Nullable [] getResourceCloserMethodsForType(@NotNull PsiClassType resourceType) {
        PsiClass resourceClass;
        if (resourceType == null) {
            PsiUtil.$$$reportNull$$$0(128);
        }
        if ((resourceClass = resourceType.resolve()) == null) {
            return null;
        }
        Project project = resourceClass.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
        PsiClass autoCloseable = facade.findClass("java.lang.AutoCloseable", ProjectScope.getLibrariesScope(project));
        if (autoCloseable == null) {
            return null;
        }
        if (JavaClassSupers.getInstance().getSuperClassSubstitutor(autoCloseable, resourceClass, resourceType.getResolveScope(), PsiSubstitutor.EMPTY) == null) {
            return null;
        }
        PsiMethod[] closes = autoCloseable.findMethodsByName("close", false);
        if (closes.length == 1) {
            return resourceClass.findMethodsBySignature(closes[0], true);
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiExpression skipParenthesizedExprDown(@Nullable PsiExpression expression2) {
        while (expression2 instanceof PsiParenthesizedExpression) {
            expression2 = ((PsiParenthesizedExpression)expression2).getExpression();
        }
        return expression2;
    }

    public static PsiElement skipParenthesizedExprUp(@Nullable PsiElement parent2) {
        while (parent2 instanceof PsiParenthesizedExpression) {
            parent2 = parent2.getParent();
        }
        return parent2;
    }

    public static void ensureValidType(@NotNull PsiType type2) {
        if (type2 == null) {
            PsiUtil.$$$reportNull$$$0(129);
        }
        PsiUtil.ensureValidType(type2, (String)null);
    }

    public static void ensureValidType(@NotNull PsiType type2, @Nullable PsiElement sourceOfType) {
        if (type2 == null) {
            PsiUtil.$$$reportNull$$$0(130);
        }
        try {
            PsiUtil.ensureValidType(type2);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            if (sourceOfType == null) {
                throw e;
            }
            PsiUtilCore.ensureValid(sourceOfType);
            throw new RuntimeException("Via " + sourceOfType.getClass() + " #" + sourceOfType.getLanguage(), e);
        }
    }

    public static void ensureValidType(@NotNull PsiType type2, @Nullable String customMessage) {
        if (type2 == null) {
            PsiUtil.$$$reportNull$$$0(131);
        }
        if (!type2.isValid()) {
            TimeoutUtil.sleep(1L);
            if (type2.isValid()) {
                LOG.error("PsiType resurrected: " + type2 + " of " + type2.getClass() + " " + customMessage);
                return;
            }
            if (type2 instanceof PsiClassType) {
                try {
                    PsiClass psiClass = ((PsiClassType)type2).resolve();
                    if (psiClass != null) {
                        PsiUtil.ensureValid(psiClass);
                    }
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (customMessage == null) {
                        throw e;
                    }
                    throw new RuntimeException(customMessage, e);
                }
            }
            throw new AssertionError((Object)("Invalid type: " + type2 + " of class " + type2.getClass() + " " + customMessage));
        }
    }

    @Nullable
    public static String getMemberQualifiedName(@NotNull PsiMember member2) {
        if (member2 == null) {
            PsiUtil.$$$reportNull$$$0(132);
        }
        if (member2 instanceof PsiClass) {
            return ((PsiClass)member2).getQualifiedName();
        }
        PsiClass containingClass = member2.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        String className = containingClass.getQualifiedName();
        if (className == null) {
            return null;
        }
        return className + "." + member2.getName();
    }

    public static boolean isFromDefaultPackage(PsiClass aClass) {
        return PsiUtil.isFromDefaultPackage((PsiElement)aClass);
    }

    public static boolean isFromDefaultPackage(PsiElement element2) {
        PsiFile containingFile2 = element2.getContainingFile();
        if (containingFile2 instanceof PsiClassOwner) {
            return StringUtil.isEmpty(((PsiClassOwner)containingFile2).getPackageName());
        }
        if (containingFile2 instanceof JavaCodeFragment) {
            PsiElement context2 = containingFile2.getContext();
            if (context2 instanceof PsiPackage) {
                return StringUtil.isEmpty(((PsiPackage)context2).getName());
            }
            if (context2 != null && context2 != containingFile2) {
                return PsiUtil.isFromDefaultPackage(context2);
            }
        }
        return false;
    }

    static boolean checkSameExpression(PsiElement templateExpr, PsiExpression expression2) {
        return templateExpr.equals(PsiUtil.skipParenthesizedExprDown(expression2));
    }

    public static boolean isCondition(PsiElement expr, PsiElement parent2) {
        if (parent2 instanceof PsiIfStatement) {
            return PsiUtil.checkSameExpression(expr, ((PsiIfStatement)parent2).getCondition());
        }
        if (parent2 instanceof PsiConditionalLoopStatement) {
            return PsiUtil.checkSameExpression(expr, ((PsiConditionalLoopStatement)parent2).getCondition());
        }
        if (parent2 instanceof PsiConditionalExpression) {
            return PsiUtil.checkSameExpression(expr, ((PsiConditionalExpression)parent2).getCondition());
        }
        return false;
    }

    public static PsiReturnStatement @NotNull [] findReturnStatements(@NotNull PsiMethod method) {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(133);
        }
        return PsiUtil.findReturnStatements(method.getBody());
    }

    public static PsiReturnStatement @NotNull [] findReturnStatements(@Nullable PsiCodeBlock body2) {
        ArrayList vector = new ArrayList();
        if (body2 != null) {
            PsiUtil.addStatements(vector, body2, PsiReturnStatement.class, statement2 -> false);
        }
        PsiReturnStatement[] psiReturnStatementArray = vector.toArray(PsiReturnStatement.EMPTY_ARRAY);
        if (psiReturnStatementArray == null) {
            PsiUtil.$$$reportNull$$$0(134);
        }
        return psiReturnStatementArray;
    }

    private static <T extends PsiElement> void addStatements(@NotNull List<? super T> vector, @NotNull PsiElement element2, @NotNull Class<? extends T> clazz, @NotNull Predicate<? super PsiElement> stopAt) {
        if (vector == null) {
            PsiUtil.$$$reportNull$$$0(135);
        }
        if (element2 == null) {
            PsiUtil.$$$reportNull$$$0(136);
        }
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(137);
        }
        if (stopAt == null) {
            PsiUtil.$$$reportNull$$$0(138);
        }
        if (PsiTreeUtil.instanceOf(element2, clazz)) {
            vector.add(element2);
        } else if (!(element2 instanceof PsiClass || element2 instanceof PsiLambdaExpression || stopAt.test(element2))) {
            PsiElement[] children2;
            for (PsiElement child : children2 = element2.getChildren()) {
                PsiUtil.addStatements(vector, child, clazz, stopAt);
            }
        }
    }

    public static boolean isModuleFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiUtil.$$$reportNull$$$0(139);
        }
        return file2 instanceof PsiJavaFile && ((PsiJavaFile)file2).getModuleDeclaration() != null;
    }

    public static boolean isPackageEmpty(PsiDirectory @NotNull [] directories2, @NotNull String packageName2) {
        if (packageName2 == null) {
            PsiUtil.$$$reportNull$$$0(140);
        }
        if (directories2 == null) {
            PsiUtil.$$$reportNull$$$0(141);
        }
        for (PsiDirectory directory : directories2) {
            for (PsiFile file2 : directory.getFiles()) {
                if (!(file2 instanceof PsiClassOwner) || !packageName2.equals(((PsiClassOwner)file2).getPackageName()) || ((PsiClassOwner)file2).getClasses().length <= 0) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static PsiModifierListOwner preferCompiledElement(@NotNull PsiModifierListOwner element2) {
        PsiElement original;
        if (element2 == null) {
            PsiUtil.$$$reportNull$$$0(142);
        }
        PsiModifierListOwner psiModifierListOwner = (original = element2.getOriginalElement()) instanceof PsiModifierListOwner ? (PsiModifierListOwner)original : element2;
        if (psiModifierListOwner == null) {
            PsiUtil.$$$reportNull$$$0(143);
        }
        return psiModifierListOwner;
    }

    public static PsiElement addModuleStatement(@NotNull PsiJavaModule module2, @NotNull String text) {
        if (module2 == null) {
            PsiUtil.$$$reportNull$$$0(144);
        }
        if (text == null) {
            PsiUtil.$$$reportNull$$$0(145);
        }
        PsiJavaParserFacade facade = JavaPsiFacade.getInstance(module2.getProject()).getParserFacade();
        PsiStatement statement2 = facade.createModuleStatementFromText(text, null);
        return PsiUtil.addModuleStatement(module2, statement2);
    }

    public static PsiElement addModuleStatement(@NotNull PsiJavaModule module2, @NotNull PsiStatement moduleStatement) {
        PsiElement anchor2;
        if (module2 == null) {
            PsiUtil.$$$reportNull$$$0(146);
        }
        if (moduleStatement == null) {
            PsiUtil.$$$reportNull$$$0(147);
        }
        if ((anchor2 = (PsiElement)SyntaxTraverser.psiTraverser().children(module2).filter(moduleStatement.getClass()).last()) == null) {
            anchor2 = SyntaxTraverser.psiTraverser().children(module2).filter(e -> PsiUtil.isJavaToken(e, JavaTokenType.LBRACE)).first();
        }
        if (anchor2 == null) {
            throw new IllegalStateException("No anchor in " + Arrays.toString(module2.getChildren()));
        }
        return module2.addAfter(moduleStatement, anchor2);
    }

    public static boolean isArrayClass(@Nullable PsiElement psiClass) {
        return psiClass != null && psiClass.getManager().areElementsEquivalent(psiClass, JavaPsiFacade.getElementFactory(psiClass.getProject()).getArrayClass(PsiUtil.getLanguageLevel(psiClass)));
    }

    @Contract(value="null -> false")
    public static boolean isJvmLocalVariable(PsiElement variable2) {
        return variable2 instanceof PsiLocalVariable || variable2 instanceof PsiParameter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 85: 
            case 86: 
            case 88: 
            case 92: 
            case 94: 
            case 95: 
            case 98: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 134: 
            case 143: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 85: 
            case 86: 
            case 88: 
            case 92: 
            case 94: 
            case 95: 
            case 98: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 134: 
            case 143: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: 
            case 34: 
            case 79: 
            case 82: 
            case 99: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 136: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 17: 
            case 25: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 85: 
            case 86: 
            case 88: 
            case 92: 
            case 94: 
            case 95: 
            case 98: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 134: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiUtil";
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 42: 
            case 45: 
            case 48: 
            case 51: 
            case 55: 
            case 96: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionFQName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass";
                break;
            }
            case 24: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 28: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 32: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 40: 
            case 83: 
            case 129: 
            case 130: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 43: 
            case 46: 
            case 49: 
            case 52: 
            case 56: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutorForMethod";
                break;
            }
            case 44: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argList";
                break;
            }
            case 53: 
            case 57: 
            case 60: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 54: 
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 64: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 66: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisClassType";
                break;
            }
            case 68: 
            case 72: 
            case 77: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherClassType";
                break;
            }
            case 70: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bClass";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 84: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 91: 
            case 93: 
            case 102: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 123: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vector";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 144: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiUtil";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessObjectClass";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessModifier";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGenericsClassInType";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "convertAnonymousToBaseType";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "captureToplevelWildcards";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypeElements";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "typeParametersIterator";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "typeParametersIterable";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "mapElements";
                break;
            }
            case 114: 
            case 115: 
            case 116: 
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "findReturnStatements";
                break;
            }
            case 143: {
                objectArray = objectArray2;
                objectArray2[1] = "preferCompiledElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isOnAssignmentLeftHand";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleFromPackage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAccessedForWriting";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAccessedForReading";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isMemberAccessibleAt";
                break;
            }
            case 12: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAccessObjectClass";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 85: 
            case 86: 
            case 88: 
            case 92: 
            case 94: 
            case 95: 
            case 98: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 134: 
            case 143: {
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addException";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeException";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isVariableNameUnique";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isLocalOrAnonymousClass";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isLocalClass";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isAbstractClass";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getVariableCodeBlock";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "collectSwitchResultExpressions";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getAccessLevel";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isStatement";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getElementInclusiveRange";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "convertAnonymousToBaseType";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getApplicabilityLevel";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "areFirstArgumentsApplicable";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "equalOnEquivalentClasses";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isCompileTimeConstant";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "allMethodsHaveSameSignature";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "isInnerClass";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "findModifierInList";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelClass";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingStaticElement";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getTypeByPsiElement";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "captureToplevelWildcards";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypeElements";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "checkIsIdentifier";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getJarFile";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "typeParametersIterator";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "typeParametersIterable";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "canBeOverridden";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "mapElements";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "checkName";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "isRawSubstitutor";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel5OrHigher";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel6OrHigher";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel7OrHigher";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel8OrHigher";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel9OrHigher";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel10OrHigher";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel11OrHigher";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel14OrHigher";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel16OrHigher";
                break;
            }
            case 113: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevel";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "isInstantiatable";
                break;
            }
            case 120: 
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "hasDefaultConstructor";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "substituteTypeParameter";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "setModifierProperty";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "isJavaToken";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "getResourceCloserMethodsForType";
                break;
            }
            case 129: 
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "ensureValidType";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "getMemberQualifiedName";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "findReturnStatements";
                break;
            }
            case 135: 
            case 136: 
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "addStatements";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "isModuleFile";
                break;
            }
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "isPackageEmpty";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "preferCompiledElement";
                break;
            }
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "addModuleStatement";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 85: 
            case 86: 
            case 88: 
            case 92: 
            case 94: 
            case 95: 
            case 98: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 134: 
            case 143: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface ApplicabilityChecker {
        public static final ApplicabilityChecker ASSIGNABILITY_CHECKER = (left, right, allowUncheckedConversion, argId) -> TypeConversionUtil.isAssignable(left, right, allowUncheckedConversion);

        public boolean isApplicable(PsiType var1, PsiType var2, boolean var3, int var4);
    }

    public static @interface AccessLevel {
    }
}

