/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.javadoc;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaFileCodeStyleFacade;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaDocUtil {
    private static final Logger LOG = Logger.getInstance(JavaDocUtil.class);
    @NonNls
    private static final Pattern ourTypePattern = Pattern.compile("[ ]+[^ ^\\[^\\]]");

    private JavaDocUtil() {
    }

    @Nullable
    public static PsiClass resolveClassInTagValue(@Nullable PsiDocTagValue value2) {
        PsiElement target;
        PsiElement refElement;
        if (value2 == null) {
            return null;
        }
        PsiElement refHolder = value2.getFirstChild();
        if (refHolder != null && (refElement = refHolder.getFirstChild()) instanceof PsiJavaCodeReferenceElement && (target = ((PsiJavaCodeReferenceElement)refElement).resolve()) instanceof PsiClass) {
            return (PsiClass)target;
        }
        return null;
    }

    public static int extractReference(String text) {
        int lparenthIndex = text.indexOf(40);
        int spaceIndex = text.indexOf(32);
        if (spaceIndex < 0) {
            spaceIndex = text.length();
        }
        if (lparenthIndex < 0) {
            return spaceIndex;
        }
        if (spaceIndex < lparenthIndex) {
            return spaceIndex;
        }
        int rparenthIndex = text.indexOf(41, lparenthIndex);
        if (rparenthIndex < 0) {
            rparenthIndex = text.length() - 1;
        }
        return rparenthIndex + 1;
    }

    @Nullable
    public static PsiElement findReferenceTarget(@NotNull PsiManager manager, @NotNull String refText, PsiElement context2) {
        if (manager == null) {
            JavaDocUtil.$$$reportNull$$$0(0);
        }
        if (refText == null) {
            JavaDocUtil.$$$reportNull$$$0(1);
        }
        return JavaDocUtil.findReferenceTarget(manager, refText, context2, true);
    }

    @Nullable
    public static PsiElement findReferenceTarget(@NotNull PsiManager manager, @NotNull String refText, PsiElement context2, boolean useNavigationElement) {
        if (manager == null) {
            JavaDocUtil.$$$reportNull$$$0(2);
        }
        if (refText == null) {
            JavaDocUtil.$$$reportNull$$$0(3);
        }
        LOG.assertTrue(context2 == null || context2.isValid());
        if (context2 != null) {
            context2 = context2.getNavigationElement();
        }
        int poundIndex = refText.indexOf(35);
        JavaPsiFacade facade = JavaPsiFacade.getInstance(manager.getProject());
        if (poundIndex < 0) {
            PsiClass aClass = JavaDocUtil.findClassFromRef(manager, facade, refText, context2);
            if (aClass != null) {
                return useNavigationElement ? aClass.getNavigationElement() : aClass;
            }
            PsiPackage aPackage = facade.findPackage(refText);
            if (aPackage != null) {
                return aPackage;
            }
            return null;
        }
        String classRef = refText.substring(0, poundIndex).trim();
        if (!classRef.isEmpty()) {
            PsiClass aClass = JavaDocUtil.findClassFromRef(manager, facade, classRef, context2);
            if (aClass == null) {
                return null;
            }
            PsiElement member2 = JavaDocUtil.findReferencedMember(aClass, refText.substring(poundIndex + 1), context2);
            return useNavigationElement && member2 != null ? member2.getNavigationElement() : member2;
        }
        String memberRefText = refText.substring(1);
        for (PsiElement scope = context2; scope != null && !(scope instanceof PsiFile); scope = scope.getParent()) {
            PsiElement member3;
            if (!(scope instanceof PsiClass) || (member3 = JavaDocUtil.findReferencedMember((PsiClass)scope, memberRefText, context2)) == null) continue;
            return useNavigationElement ? member3.getNavigationElement() : member3;
        }
        return null;
    }

    private static PsiClass findClassFromRef(@NotNull PsiManager manager, @NotNull JavaPsiFacade facade, @NotNull String refText, PsiElement context2) {
        if (manager == null) {
            JavaDocUtil.$$$reportNull$$$0(4);
        }
        if (facade == null) {
            JavaDocUtil.$$$reportNull$$$0(5);
        }
        if (refText == null) {
            JavaDocUtil.$$$reportNull$$$0(6);
        }
        PsiClass aClass = facade.getResolveHelper().resolveReferencedClass(refText, context2);
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope(manager.getProject());
        if (aClass == null) {
            aClass = facade.findClass(refText, projectScope);
        }
        if (aClass == null && refText.indexOf(46) == -1 && context2 != null) {
            PsiFile file2 = context2.getContainingFile();
            PsiDirectory directory = file2 == null ? null : file2.getContainingDirectory();
            PsiPackage aPackage = directory == null ? null : JavaDirectoryService.getInstance().getPackage(directory);
            aClass = aPackage == null ? null : ArrayUtil.getFirstElement(aPackage.findClassByShortName(refText, projectScope));
        }
        return aClass;
    }

    @Nullable
    private static PsiElement findReferencedMember(@NotNull PsiClass aClass, @NotNull String memberRefText, PsiElement context2) {
        PsiMethod[] allMethods;
        int parenthIndex;
        if (aClass == null) {
            JavaDocUtil.$$$reportNull$$$0(7);
        }
        if (memberRefText == null) {
            JavaDocUtil.$$$reportNull$$$0(8);
        }
        if ((parenthIndex = memberRefText.indexOf(40)) < 0) {
            PsiMethod[] methods2;
            String name2 = memberRefText;
            PsiField field2 = aClass.findFieldByName(name2, true);
            if (field2 != null) {
                return field2;
            }
            PsiClass inner = aClass.findInnerClassByName(name2, true);
            if (inner != null) {
                return inner;
            }
            for (PsiMethod method : methods2 = aClass.getAllMethods()) {
                if (!method.getName().equals(name2)) continue;
                return method;
            }
            return null;
        }
        String name3 = memberRefText.substring(0, parenthIndex).trim();
        int rparenIndex = memberRefText.lastIndexOf(41);
        if (rparenIndex == -1) {
            return null;
        }
        String parmsText = memberRefText.substring(parenthIndex + 1, rparenIndex).trim();
        StringTokenizer tokenizer = new StringTokenizer(parmsText.replaceAll("[*]", ""), ",");
        PsiType[] types2 = PsiType.createArray(tokenizer.countTokens());
        int i = 0;
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(aClass.getProject());
        while (tokenizer.hasMoreTokens()) {
            String parmText = tokenizer.nextToken().trim();
            try {
                Matcher typeMatcher = ourTypePattern.matcher(parmText);
                String typeText = parmText;
                if (typeMatcher.find()) {
                    typeText = parmText.substring(0, typeMatcher.start());
                }
                PsiType type2 = factory2.createTypeFromText(typeText, context2);
                types2[i++] = type2;
            }
            catch (IncorrectOperationException e) {
                LOG.info(e);
            }
        }
        MethodSignature methodSignature = MethodSignatureUtil.createMethodSignature(name3, types2, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY, name3.equals(aClass.getName()));
        PsiMethod[] methods3 = PsiDocMethodOrFieldRef.findMethods(methodSignature, aClass, name3, allMethods = context2 != null ? PsiDocMethodOrFieldRef.getAllMethods(aClass, context2) : aClass.findMethodsByName(name3, true));
        if (methods3.length == 0) {
            return null;
        }
        PsiMethod found = methods3[0];
        int hashIndex = memberRefText.indexOf(35, rparenIndex);
        if (hashIndex != -1) {
            PsiParameter[] params = found.getParameterList().getParameters();
            int parameterNumber = Integer.parseInt(memberRefText.substring(hashIndex + 1));
            if (parameterNumber < params.length) {
                return params[parameterNumber];
            }
        }
        return found;
    }

    @Nullable
    public static String getReferenceText(Project project, PsiElement element2) {
        if (element2 instanceof PsiPackage) {
            return ((PsiPackage)element2).getQualifiedName();
        }
        if (element2 instanceof PsiClass) {
            String refText = ((PsiClass)element2).getQualifiedName();
            if (refText != null) {
                return refText;
            }
            return ((PsiClass)element2).getName();
        }
        if (element2 instanceof PsiField) {
            PsiField field2 = (PsiField)element2;
            String name2 = field2.getName();
            PsiClass aClass = field2.getContainingClass();
            if (aClass != null) {
                return JavaDocUtil.getReferenceText(project, aClass) + "#" + name2;
            }
            return "#" + name2;
        }
        if (element2 instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element2;
            String name3 = method.getName();
            StringBuilder buffer = new StringBuilder();
            PsiClass aClass = method.getContainingClass();
            if (aClass != null) {
                buffer.append(JavaDocUtil.getReferenceText(project, aClass));
            }
            buffer.append("#");
            buffer.append(name3);
            buffer.append("(");
            PsiParameter[] parms = method.getParameterList().getParameters();
            boolean spaceBeforeComma = JavaFileCodeStyleFacade.forContext(element2.getContainingFile()).isSpaceBeforeComma();
            boolean spaceAfterComma = JavaFileCodeStyleFacade.forContext(element2.getContainingFile()).isSpaceAfterComma();
            for (int i = 0; i < parms.length; ++i) {
                PsiParameter parm = parms[i];
                String typeText = TypeConversionUtil.erasure(parm.getType()).getCanonicalText();
                buffer.append(typeText);
                if (i >= parms.length - 1) continue;
                if (spaceBeforeComma) {
                    buffer.append(" ");
                }
                buffer.append(",");
                if (!spaceAfterComma) continue;
                buffer.append(" ");
            }
            buffer.append(")");
            return buffer.toString();
        }
        if (element2 instanceof PsiParameter) {
            PsiElement method = ((PsiParameter)element2).getDeclarationScope();
            if (method instanceof PsiMethod) {
                return JavaDocUtil.getReferenceText(project, method) + "#" + ((PsiParameterList)element2.getParent()).getParameterIndex((PsiParameter)element2);
            }
        } else if (element2 instanceof PsiNamedElement) {
            return ((PsiNamedElement)element2).getName();
        }
        return null;
    }

    @NlsSafe
    public static String getShortestClassName(PsiClass aClass, PsiElement context2) {
        @NonNls String shortName2 = aClass.getName();
        if (shortName2 == null) {
            shortName2 = "null";
        }
        for (PsiClass containingClass = aClass.getContainingClass(); containingClass != null && containingClass.isPhysical() && !PsiUtil.isLocalOrAnonymousClass(containingClass); containingClass = containingClass.getContainingClass()) {
            shortName2 = containingClass.getName() + "." + shortName2;
        }
        String qName = aClass.getQualifiedName();
        if (qName == null) {
            return shortName2;
        }
        PsiManager manager = aClass.getManager();
        PsiClass resolvedClass = null;
        try {
            resolvedClass = JavaPsiFacade.getInstance(manager.getProject()).getResolveHelper().resolveReferencedClass(shortName2, context2);
        }
        catch (IndexNotReadyException e) {
            LOG.debug(e);
        }
        return manager.areElementsEquivalent(aClass, resolvedClass) ? shortName2 : StringUtil.trimStart(qName, "java.lang.");
    }

    public static String getLabelText(Project project, PsiManager manager, String refText, PsiElement context2) {
        PsiElement refElement = null;
        try {
            refElement = JavaDocUtil.findReferenceTarget(manager, refText, context2, false);
        }
        catch (IndexNotReadyException e) {
            LOG.debug(e);
        }
        if (refElement == null) {
            return refText.replaceFirst("^#", "").replaceAll("#", ".");
        }
        int poundIndex = refText.indexOf(35);
        if (poundIndex < 0) {
            if (refElement instanceof PsiClass) {
                return JavaDocUtil.getShortestClassName((PsiClass)refElement, context2);
            }
            return refText;
        }
        PsiClass aClass = null;
        if (refElement instanceof PsiField) {
            aClass = ((PsiField)refElement).getContainingClass();
        } else if (refElement instanceof PsiMethod) {
            aClass = ((PsiMethod)refElement).getContainingClass();
        } else if (refElement instanceof PsiClass) {
            return refText.replaceAll("#", ".");
        }
        if (aClass == null) {
            return refText;
        }
        String classRef = refText.substring(0, poundIndex).trim();
        String memberText = refText.substring(poundIndex + 1);
        String memberLabel = JavaDocUtil.getMemberLabelText(project, manager, memberText, context2);
        if (!classRef.isEmpty()) {
            PsiElement refClass = null;
            try {
                refClass = JavaDocUtil.findReferenceTarget(manager, classRef, context2);
            }
            catch (IndexNotReadyException e) {
                LOG.debug(e);
            }
            if (refClass instanceof PsiClass) {
                for (PsiElement scope = context2; scope != null && !(scope instanceof PsiFile); scope = scope.getParent()) {
                    if (!scope.equals(refClass)) continue;
                    return memberLabel;
                }
            }
            return JavaDocUtil.getLabelText(project, manager, classRef, context2) + "." + memberLabel;
        }
        return memberLabel;
    }

    private static String getMemberLabelText(Project project, PsiManager manager, String memberText, PsiElement context2) {
        int parenthIndex = memberText.indexOf(40);
        if (parenthIndex < 0) {
            return memberText;
        }
        if (!StringUtil.endsWithChar(memberText, ')')) {
            return memberText;
        }
        String parms = memberText.substring(parenthIndex + 1, memberText.length() - 1);
        StringBuilder buffer = new StringBuilder();
        boolean spaceBeforeComma = JavaFileCodeStyleFacade.forContext(context2.getContainingFile()).isSpaceBeforeComma();
        boolean spaceAfterComma = JavaFileCodeStyleFacade.forContext(context2.getContainingFile()).isSpaceAfterComma();
        StringTokenizer tokenizer = new StringTokenizer(parms, ",");
        while (tokenizer.hasMoreTokens()) {
            int index2;
            String param = tokenizer.nextToken().trim();
            int index1 = param.indexOf(91);
            if (index1 < 0) {
                index1 = param.length();
            }
            if ((index2 = param.indexOf(32)) < 0) {
                index2 = param.length();
            }
            int index3 = Math.min(index1, index2);
            String className = param.substring(0, index3).trim();
            String shortClassName = JavaDocUtil.getLabelText(project, manager, className, context2);
            buffer.append(shortClassName);
            buffer.append(param.substring(className.length()));
            if (!tokenizer.hasMoreElements()) continue;
            if (spaceBeforeComma) {
                buffer.append(" ");
            }
            buffer.append(",");
            if (!spaceAfterComma) continue;
            buffer.append(" ");
        }
        return memberText.substring(0, parenthIndex + 1) + buffer + ")";
    }

    public static PsiClassType[] getImplementsList(PsiClass aClass) {
        if (aClass instanceof PsiAnonymousClass) {
            return new PsiClassType[]{((PsiAnonymousClass)aClass).getBaseClassType()};
        }
        PsiReferenceList list2 = aClass.getImplementsList();
        return list2 == null ? PsiClassType.EMPTY_ARRAY : list2.getReferencedTypes();
    }

    public static PsiClassType[] getExtendsList(PsiClass aClass) {
        if (aClass instanceof PsiAnonymousClass) {
            return new PsiClassType[]{((PsiAnonymousClass)aClass).getBaseClassType()};
        }
        PsiReferenceList list2 = aClass.getExtendsList();
        return list2 == null ? PsiClassType.EMPTY_ARRAY : list2.getReferencedTypes();
    }

    public static boolean isInsidePackageInfo(@Nullable PsiDocComment containingComment) {
        return containingComment != null && containingComment.getOwner() == null && containingComment.getParent() instanceof PsiJavaFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberRefText";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/javadoc/JavaDocUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findReferenceTarget";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findClassFromRef";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findReferencedMember";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

