/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirModuleResolveComponents;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.ClassDiagnosticRetriever;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnostics;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FirElementsRecorder;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.KtToFirMapping;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.NonReanalyzableDeclarationStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.NonReanalyzableNonClassDeclarationStructureElement;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.impl.FirErrorConstructor;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0017B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/NonReanalyzableClassDeclarationStructureElement;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/NonReanalyzableDeclarationStructureElement;", "firFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "fir", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "psi", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "moduleComponents", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;)V", "diagnostics", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/FileStructureElementDiagnostics;", "getDiagnostics", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/FileStructureElementDiagnostics;", "getFir", "()Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "mappings", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/KtToFirMapping;", "getMappings", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/KtToFirMapping;", "getPsi", "()Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Recorder", "low-level-api-fir"})
public final class NonReanalyzableClassDeclarationStructureElement
extends NonReanalyzableDeclarationStructureElement {
    @NotNull
    private final FirRegularClass fir;
    @NotNull
    private final KtClassOrObject psi;
    @NotNull
    private final KtToFirMapping mappings;
    @NotNull
    private final FileStructureElementDiagnostics diagnostics;

    public NonReanalyzableClassDeclarationStructureElement(@NotNull FirFile firFile, @NotNull FirRegularClass fir, @NotNull KtClassOrObject psi2, @NotNull LLFirModuleResolveComponents moduleComponents) {
        Intrinsics.checkNotNullParameter(firFile, "firFile");
        Intrinsics.checkNotNullParameter(fir, "fir");
        Intrinsics.checkNotNullParameter(psi2, "psi");
        Intrinsics.checkNotNullParameter(moduleComponents, "moduleComponents");
        super(firFile, moduleComponents, null);
        this.fir = fir;
        this.psi = psi2;
        this.mappings = new KtToFirMapping(this.fir, new Recorder());
        this.diagnostics = new FileStructureElementDiagnostics(firFile, new ClassDiagnosticRetriever(this.fir), moduleComponents);
    }

    @NotNull
    public final FirRegularClass getFir() {
        return this.fir;
    }

    @Override
    @NotNull
    public KtClassOrObject getPsi() {
        return this.psi;
    }

    @Override
    @NotNull
    public KtToFirMapping getMappings() {
        return this.mappings;
    }

    @Override
    @NotNull
    public FileStructureElementDiagnostics getDiagnostics() {
        return this.diagnostics;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0016J$\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0016J$\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0016J$\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0016J$\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0016J$\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/NonReanalyzableClassDeclarationStructureElement$Recorder;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FirElementsRecorder;", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/NonReanalyzableClassDeclarationStructureElement;)V", "visitAnonymousInitializer", "", "anonymousInitializer", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousInitializer;", "data", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "low-level-api-fir"})
    private final class Recorder
    extends FirElementsRecorder {
        @Override
        public void visitProperty(@NotNull FirProperty property, @NotNull Map<KtElement, FirElement> data2) {
            Intrinsics.checkNotNullParameter(property, "property");
            Intrinsics.checkNotNullParameter(data2, "data");
            KtSourceElement ktSourceElement = property.getSource();
            if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) {
                super.visitProperty(property, data2);
            }
        }

        @Override
        public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull Map<KtElement, FirElement> data2) {
            Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
            Intrinsics.checkNotNullParameter(data2, "data");
        }

        @Override
        public void visitConstructor(@NotNull FirConstructor constructor2, @NotNull Map<KtElement, FirElement> data2) {
            Intrinsics.checkNotNullParameter(constructor2, "constructor");
            Intrinsics.checkNotNullParameter(data2, "data");
            if (constructor2 instanceof FirPrimaryConstructor || constructor2 instanceof FirErrorConstructor) {
                KtSourceElement ktSourceElement = constructor2.getSource();
                if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.ImplicitConstructor.INSTANCE)) {
                    NonReanalyzableNonClassDeclarationStructureElement.Recorder.INSTANCE.visitConstructor(constructor2, data2);
                }
            }
        }

        @Override
        public void visitAnonymousInitializer(@NotNull FirAnonymousInitializer anonymousInitializer, @NotNull Map<KtElement, FirElement> data2) {
            Intrinsics.checkNotNullParameter(anonymousInitializer, "anonymousInitializer");
            Intrinsics.checkNotNullParameter(data2, "data");
        }

        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull Map<KtElement, FirElement> data2) {
            Intrinsics.checkNotNullParameter(regularClass, "regularClass");
            Intrinsics.checkNotNullParameter(data2, "data");
            if (!Intrinsics.areEqual(regularClass, NonReanalyzableClassDeclarationStructureElement.this.getFir())) {
                return;
            }
            super.visitRegularClass(regularClass, data2);
        }

        @Override
        public void visitTypeAlias(@NotNull FirTypeAlias typeAlias, @NotNull Map<KtElement, FirElement> data2) {
            Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
            Intrinsics.checkNotNullParameter(data2, "data");
        }
    }
}

