/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import com.intellij.lang.ASTNode;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public abstract class AbstractTracingStrategy
implements TracingStrategy {
    protected final KtExpression reference;
    protected final Call call;

    protected AbstractTracingStrategy(@NotNull KtExpression reference2, @NotNull Call call2) {
        if (reference2 == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(0);
        }
        if (call2 == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(1);
        }
        this.reference = reference2;
        this.call = call2;
    }

    @Override
    public <D extends CallableDescriptor> void recordAmbiguity(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> candidates2) {
        if (trace == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(2);
        }
        if (candidates2 == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(3);
        }
        HashSet<D> descriptors = new HashSet<D>();
        for (ResolvedCall<D> candidate2 : candidates2) {
            descriptors.add(candidate2.getCandidateDescriptor());
        }
        trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, this.reference, descriptors);
    }

    @Override
    public void noValueForParameter(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor valueParameter2) {
        if (trace == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(4);
        }
        if (valueParameter2 == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(5);
        }
        KtElement reportOn = CallUtilKt.getValueArgumentListOrElement(this.call);
        trace.report(Errors.NO_VALUE_FOR_PARAMETER.on(reportOn, valueParameter2));
    }

    @Override
    public void missingReceiver(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor expectedReceiver) {
        if (trace == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(6);
        }
        if (expectedReceiver == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(7);
        }
        trace.report(Errors.MISSING_RECEIVER.on(this.reference, expectedReceiver.getType()));
    }

    @Override
    public void wrongReceiverType(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, @NotNull ResolutionContext<?> c) {
        KtExpression reportOn;
        if (trace == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(8);
        }
        if (receiverParameter == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(9);
        }
        if (receiverArgument == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(10);
        }
        if (c == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(11);
        }
        KtExpression ktExpression = reportOn = receiverArgument instanceof ExpressionReceiver ? ((ExpressionReceiver)receiverArgument).getExpression() : this.reference;
        if (!DiagnosticUtilsKt.reportTypeMismatchDueToTypeProjection(c, reportOn, receiverParameter.getType(), receiverArgument.getType())) {
            trace.report(Errors.TYPE_MISMATCH.on(reportOn, receiverParameter.getType(), receiverArgument.getType()));
        }
    }

    @Override
    public void noReceiverAllowed(@NotNull BindingTrace trace) {
        if (trace == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(12);
        }
        trace.report(Errors.NO_RECEIVER_ALLOWED.on(this.reference));
    }

    @Override
    public void wrongNumberOfTypeArguments(@NotNull BindingTrace trace, int expectedTypeArgumentCount, @NotNull CallableDescriptor descriptor2) {
        KtTypeArgumentList typeArgumentList;
        if (trace == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(13);
        }
        if (descriptor2 == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(14);
        }
        trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on((typeArgumentList = this.call.getTypeArgumentList()) != null ? typeArgumentList : this.reference, expectedTypeArgumentCount, descriptor2));
    }

    @Override
    public <D extends CallableDescriptor> void ambiguity(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> resolvedCalls) {
        if (trace == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(15);
        }
        if (resolvedCalls == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(16);
        }
        trace.report(Errors.OVERLOAD_RESOLUTION_AMBIGUITY.on(this.reference, resolvedCalls));
    }

    @Override
    public <D extends CallableDescriptor> void noneApplicable(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
        if (trace == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(17);
        }
        if (descriptors == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(18);
        }
        trace.report(Errors.NONE_APPLICABLE.on(this.reference, descriptors));
    }

    @Override
    public <D extends CallableDescriptor> void cannotCompleteResolve(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
        if (trace == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(19);
        }
        if (descriptors == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(20);
        }
        trace.report(Errors.CANNOT_COMPLETE_RESOLVE.on(this.reference, descriptors));
    }

    @Override
    public void instantiationOfAbstractClass(@NotNull BindingTrace trace) {
        if (trace == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(21);
        }
        trace.report(Errors.CREATING_AN_INSTANCE_OF_ABSTRACT_CLASS.on(this.call.getCallElement()));
    }

    @Override
    public void recursiveType(@NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings2, boolean insideAugmentedAssignment) {
        KtExpression expression2;
        if (trace == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(22);
        }
        if (languageVersionSettings2 == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(23);
        }
        if ((expression2 = this.call.getCalleeExpression()) == null) {
            return;
        }
        if (insideAugmentedAssignment) {
            trace.report(Errors.TYPECHECKER_HAS_RUN_INTO_RECURSIVE_PROBLEM_IN_AUGMENTED_ASSIGNMENT.on(languageVersionSettings2, expression2));
        } else {
            trace.report(Errors.TYPECHECKER_HAS_RUN_INTO_RECURSIVE_PROBLEM.on(languageVersionSettings2, expression2));
        }
    }

    @Override
    public void abstractSuperCall(@NotNull BindingTrace trace) {
        if (trace == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(24);
        }
        trace.report(Errors.ABSTRACT_SUPER_CALL.on(this.reference));
    }

    @Override
    public void abstractSuperCallWarning(@NotNull BindingTrace trace) {
        if (trace == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(25);
        }
        trace.report(Errors.ABSTRACT_SUPER_CALL_WARNING.on(this.reference));
    }

    @Override
    public void nestedClassAccessViaInstanceReference(@NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor2, @NotNull ExplicitReceiverKind explicitReceiverKind) {
        DeclarationDescriptor importableDescriptor;
        if (trace == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(26);
        }
        if (classDescriptor2 == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(27);
        }
        if (explicitReceiverKind == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(28);
        }
        if (explicitReceiverKind == ExplicitReceiverKind.NO_EXPLICIT_RECEIVER && DescriptorUtils.getFqName(importableDescriptor = DescriptorUtilsKt.getImportableDescriptor(classDescriptor2)).isSafe()) {
            FqName fqName2 = DescriptorUtils.getFqNameFromTopLevelClass(importableDescriptor);
            String qualifiedName2 = this.reference.getParent() instanceof KtCallableReferenceExpression ? fqName2.parent() + "::" + classDescriptor2.getName() : fqName2.asString();
            trace.report(Errors.NESTED_CLASS_SHOULD_BE_QUALIFIED.on(this.reference, classDescriptor2, qualifiedName2));
            return;
        }
        trace.report(Errors.NESTED_CLASS_ACCESSED_VIA_INSTANCE_REFERENCE.on(this.reference, classDescriptor2));
    }

    @Override
    public void unsafeCall(@NotNull BindingTrace trace, @NotNull KotlinType type2, boolean isCallForImplicitInvoke) {
        ASTNode callOperationNode;
        if (trace == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(29);
        }
        if (type2 == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(30);
        }
        if ((callOperationNode = this.call.getCallOperationNode()) != null && !isCallForImplicitInvoke) {
            trace.report(Errors.UNSAFE_CALL.on(callOperationNode.getPsi(), type2));
        } else {
            KtElement callElement = this.call.getCallElement();
            if (callElement instanceof KtBinaryExpression) {
                this.reportUnsafeCallOnBinaryExpression(trace, (KtBinaryExpression)callElement);
            } else if (isCallForImplicitInvoke) {
                trace.report(Errors.UNSAFE_IMPLICIT_INVOKE_CALL.on(this.reference, type2));
            } else {
                trace.report(Errors.UNSAFE_CALL.on(this.reference, type2));
            }
        }
    }

    private void reportUnsafeCallOnBinaryExpression(@NotNull BindingTrace trace, @NotNull KtBinaryExpression binaryExpression) {
        Name operationString;
        KtOperationReferenceExpression operationReference;
        if (trace == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(31);
        }
        if (binaryExpression == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(32);
        }
        boolean isInfixCall = (operationReference = binaryExpression.getOperationReference()).getReferencedNameElementType() == KtTokens.IDENTIFIER;
        Name name2 = operationString = isInfixCall ? Name.identifier(operationReference.getText()) : OperatorConventions.getNameForOperationSymbol((KtToken)operationReference.getReferencedNameElementType());
        if (operationString == null) {
            return;
        }
        KtExpression left = binaryExpression.getLeft();
        KtExpression right = binaryExpression.getRight();
        if (left == null || right == null) {
            return;
        }
        if (isInfixCall) {
            trace.report(Errors.UNSAFE_INFIX_CALL.on(this.reference, left, operationString.asString(), right));
        } else {
            boolean inOperation = KtPsiUtil.isInOrNotInOperation(binaryExpression);
            KtExpression receiver = inOperation ? right : left;
            KtExpression argument2 = inOperation ? left : right;
            trace.report(Errors.UNSAFE_OPERATOR_CALL.on(this.reference, receiver, operationString.asString(), argument2));
        }
    }

    @Override
    public void invisibleMember(@NotNull BindingTrace trace, @NotNull DeclarationDescriptorWithVisibility descriptor2) {
        if (trace == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(33);
        }
        if (descriptor2 == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(34);
        }
        trace.report(Errors.INVISIBLE_MEMBER.on(this.call.getCallElement(), descriptor2, descriptor2.getVisibility(), descriptor2));
    }

    @Override
    public void typeInferenceFailed(@NotNull ResolutionContext<?> context2, @NotNull InferenceErrorData data2) {
        Diagnostic diagnostic;
        if (context2 == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(35);
        }
        if (data2 == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(36);
        }
        if ((diagnostic = AbstractTracingStrategy.typeInferenceFailedDiagnostic(context2, data2, this.reference, this.call)) != null) {
            context2.trace.report(diagnostic);
        }
    }

    @Nullable
    public static Diagnostic typeInferenceFailedDiagnostic(@NotNull ResolutionContext<?> context2, @NotNull InferenceErrorData data2, @NotNull KtExpression reference2, @NotNull Call call2) {
        if (context2 == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(37);
        }
        if (data2 == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(38);
        }
        if (reference2 == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(39);
        }
        if (call2 == null) {
            AbstractTracingStrategy.$$$reportNull$$$0(40);
        }
        ConstraintSystem constraintSystem = data2.constraintSystem;
        ConstraintSystemStatus status2 = constraintSystem.getStatus();
        assert (!status2.isSuccessful()) : "Report error only for not successful constraint system";
        if (status2.hasErrorInConstrainingTypes()) {
            return null;
        }
        if (status2.hasOnlyErrorsDerivedFrom(ConstraintPositionKind.EXPECTED_TYPE_POSITION)) {
            KotlinType declaredReturnType = data2.descriptor.getReturnType();
            if (declaredReturnType == null) {
                return null;
            }
            ConstraintSystem systemWithoutExpectedTypeConstraint = ConstraintSystemUtilsKt.filterConstraintsOut(constraintSystem, ConstraintPositionKind.EXPECTED_TYPE_POSITION);
            KotlinType substitutedReturnType = systemWithoutExpectedTypeConstraint.getResultingSubstitutor().substitute(declaredReturnType, Variance.OUT_VARIANCE);
            assert (substitutedReturnType != null);
            assert (!TypeUtils.noExpectedType(data2.expectedType)) : "Expected type doesn't exist, but there is an expected type mismatch error";
            if (!DiagnosticUtilsKt.reportTypeMismatchDueToTypeProjection(context2, call2.getCallElement(), data2.expectedType, substitutedReturnType)) {
                return Errors.TYPE_INFERENCE_EXPECTED_TYPE_MISMATCH.on(call2.getCallElement(), data2.expectedType, substitutedReturnType);
            }
        } else {
            if (status2.hasCannotCaptureTypesError()) {
                return Errors.TYPE_INFERENCE_CANNOT_CAPTURE_TYPES.on(reference2, data2);
            }
            if (status2.hasViolatedUpperBound()) {
                return Errors.TYPE_INFERENCE_UPPER_BOUND_VIOLATED.on(reference2, data2);
            }
            if (status2.hasParameterConstraintError()) {
                return Errors.TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR.on(reference2, data2);
            }
            if (status2.hasConflictingConstraints()) {
                return Errors.TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS.on(reference2, data2);
            }
            if (status2.hasTypeInferenceIncorporationError()) {
                return Errors.TYPE_INFERENCE_INCORPORATION_ERROR.on(reference2);
            }
            if (status2.hasTypeParameterWithUnsatisfiedOnlyInputTypesError()) {
                return ((DiagnosticFactory1)Errors.TYPE_INFERENCE_ONLY_INPUT_TYPES.getErrorFactory()).on(reference2, data2.descriptor.getTypeParameters().get(0));
            }
            assert (status2.hasUnknownParameters());
            return Errors.TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER.on(reference2, data2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParameter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedReceiver";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverParameter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverArgument";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 14: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCalls";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitReceiverKind";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "recordAmbiguity";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "noValueForParameter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "missingReceiver";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "wrongReceiverType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "noReceiverAllowed";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "wrongNumberOfTypeArguments";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "ambiguity";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "noneApplicable";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "cannotCompleteResolve";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "instantiationOfAbstractClass";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "recursiveType";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "abstractSuperCall";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "abstractSuperCallWarning";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "nestedClassAccessViaInstanceReference";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "unsafeCall";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "reportUnsafeCallOnBinaryExpression";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "invisibleMember";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "typeInferenceFailed";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "typeInferenceFailedDiagnostic";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

