/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.sessions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.resolve.extensions.LLFirResolveExtensionTool;
import org.jetbrains.kotlin.analysis.low.level.api.fir.resolve.extensions.LLFirResolveExtensionToolKt;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtNotUnderContentRootModule;
import org.jetbrains.kotlin.analysis.project.structure.KtScriptDependencyModule;
import org.jetbrains.kotlin.analysis.project.structure.KtScriptModule;
import org.jetbrains.kotlin.analysis.project.structure.KtSourceModule;
import org.jetbrains.kotlin.analysis.providers.KotlinModificationTrackerFactory;
import org.jetbrains.kotlin.analysis.providers.KtModuleStateTracker;
import org.jetbrains.kotlin.analysis.utils.trackers.CompositeModificationTracker;
import org.jetbrains.kotlin.fir.BuiltinTypes;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0003!\"#B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001d\u001a\u00020\u001eH&J\u0006\u0010\u001f\u001a\u00020 R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "Lorg/jetbrains/kotlin/fir/FirSession;", "ktModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "dependencyTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "builtinTypes", "Lorg/jetbrains/kotlin/fir/BuiltinTypes;", "kind", "Lorg/jetbrains/kotlin/fir/FirSession$Kind;", "(Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;Lcom/intellij/openapi/util/ModificationTracker;Lorg/jetbrains/kotlin/fir/BuiltinTypes;Lorg/jetbrains/kotlin/fir/FirSession$Kind;)V", "getBuiltinTypes", "()Lorg/jetbrains/kotlin/fir/BuiltinTypes;", "initialModificationCount", "", "isExplicitlyInvalidated", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isValid", "", "()Z", "getKtModule", "()Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "modificationTracker", "getModificationTracker", "()Lcom/intellij/openapi/util/ModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getScopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "invalidate", "", "ExplicitInvalidationTracker", "FileModificationTracker", "ModuleStateModificationTracker", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nLLFirSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirSession.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public abstract class LLFirSession
extends FirSession {
    @NotNull
    private final KtModule ktModule;
    @NotNull
    private final BuiltinTypes builtinTypes;
    private final long initialModificationCount;
    @NotNull
    private final AtomicBoolean isExplicitlyInvalidated;
    @NotNull
    private final ModificationTracker modificationTracker;

    /*
     * WARNING - void declaration
     */
    public LLFirSession(@NotNull KtModule ktModule, @NotNull ModificationTracker dependencyTracker, @NotNull BuiltinTypes builtinTypes, @NotNull FirSession.Kind kind) {
        void $this$_init__u24lambda_u242;
        Object p0;
        ModificationTracker modificationTracker;
        Intrinsics.checkNotNullParameter(ktModule, "ktModule");
        Intrinsics.checkNotNullParameter(dependencyTracker, "dependencyTracker");
        Intrinsics.checkNotNullParameter(builtinTypes, "builtinTypes");
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        super(null, kind);
        this.ktModule = ktModule;
        this.builtinTypes = builtinTypes;
        this.isExplicitlyInvalidated = new AtomicBoolean(false);
        KotlinModificationTrackerFactory trackerFactory = KotlinModificationTrackerFactory.Companion.getService(this.ktModule.getProject());
        KtModuleStateTracker validityTracker = trackerFactory.createModuleStateTracker(this.ktModule);
        Object object = this.ktModule;
        if (object instanceof KtSourceModule) {
            modificationTracker = trackerFactory.createModuleWithoutDependenciesOutOfBlockModificationTracker((KtSourceModule)this.ktModule);
        } else if (object instanceof KtNotUnderContentRootModule) {
            FileModificationTracker fileModificationTracker;
            PsiFile psiFile = ((KtNotUnderContentRootModule)this.ktModule).getFile();
            if (psiFile != null) {
                p0 = psiFile;
                boolean bl = false;
                fileModificationTracker = new FileModificationTracker((PsiFile)p0);
            } else {
                fileModificationTracker = null;
            }
            modificationTracker = fileModificationTracker;
        } else if (object instanceof KtScriptModule) {
            modificationTracker = new FileModificationTracker(((KtScriptModule)this.ktModule).getFile());
        } else if (object instanceof KtScriptDependencyModule) {
            FileModificationTracker fileModificationTracker;
            KtFile ktFile = ((KtScriptDependencyModule)this.ktModule).getFile();
            if (ktFile != null) {
                p0 = ktFile;
                boolean bl = false;
                fileModificationTracker = new FileModificationTracker((PsiFile)p0);
            } else {
                fileModificationTracker = null;
            }
            modificationTracker = fileModificationTracker;
        } else {
            modificationTracker = null;
        }
        ModificationTracker outOfBlockTracker = modificationTracker;
        Object object2 = object = kotlin.collections.CollectionsKt.createListBuilder();
        CompositeModificationTracker.Companion companion = CompositeModificationTracker.Companion;
        LLFirSession lLFirSession = this;
        boolean bl = false;
        $this$_init__u24lambda_u242.add(new ExplicitInvalidationTracker(this.ktModule, this.isExplicitlyInvalidated));
        $this$_init__u24lambda_u242.add(new ModuleStateModificationTracker(this.ktModule, validityTracker));
        CollectionsKt.addIfNotNull((Collection)$this$_init__u24lambda_u242, outOfBlockTracker);
        $this$_init__u24lambda_u242.add(dependencyTracker);
        Object object3 = LLFirResolveExtensionToolKt.getLlResolveExtensionTool(this);
        if (object3 != null && (object3 = ((LLFirResolveExtensionTool)object3).getModificationTrackers()) != null) {
            p0 = (Collection)object3;
            boolean bl2 = false;
            $this$_init__u24lambda_u242.addAll(p0);
        }
        Unit unit2 = Unit.INSTANCE;
        lLFirSession.modificationTracker = companion.createFlattened(kotlin.collections.CollectionsKt.build(object));
        this.initialModificationCount = this.modificationTracker.getModificationCount();
    }

    @NotNull
    public final KtModule getKtModule() {
        return this.ktModule;
    }

    @Override
    @NotNull
    public BuiltinTypes getBuiltinTypes() {
        return this.builtinTypes;
    }

    @NotNull
    public abstract ScopeSession getScopeSession();

    @NotNull
    public final ModificationTracker getModificationTracker() {
        return this.modificationTracker;
    }

    @NotNull
    public final Project getProject() {
        return this.ktModule.getProject();
    }

    public final void invalidate() {
        this.isExplicitlyInvalidated.set(true);
    }

    public final boolean isValid() {
        return this.modificationTracker.getModificationCount() == this.initialModificationCount;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession$ExplicitInvalidationTracker;", "Lcom/intellij/openapi/util/ModificationTracker;", "module", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "isExplicitlyInvalidated", "Ljava/util/concurrent/atomic/AtomicBoolean;", "(Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;Ljava/util/concurrent/atomic/AtomicBoolean;)V", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "getModule", "()Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "getModificationCount", "", "toString", "", "low-level-api-fir"})
    private static final class ExplicitInvalidationTracker
    implements ModificationTracker {
        @NotNull
        private final KtModule module;
        @NotNull
        private final AtomicBoolean isExplicitlyInvalidated;

        public ExplicitInvalidationTracker(@NotNull KtModule module2, @NotNull AtomicBoolean isExplicitlyInvalidated) {
            Intrinsics.checkNotNullParameter(module2, "module");
            Intrinsics.checkNotNullParameter(isExplicitlyInvalidated, "isExplicitlyInvalidated");
            this.module = module2;
            this.isExplicitlyInvalidated = isExplicitlyInvalidated;
        }

        @NotNull
        public final KtModule getModule() {
            return this.module;
        }

        @NotNull
        public final AtomicBoolean isExplicitlyInvalidated() {
            return this.isExplicitlyInvalidated;
        }

        @Override
        public long getModificationCount() {
            return this.isExplicitlyInvalidated.get() ? 1L : 0L;
        }

        @NotNull
        public String toString() {
            return "Explicit invalidation tracker for module '" + this.module.getModuleDescription() + '\'';
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u00030\u0006\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession$FileModificationTracker;", "Lcom/intellij/openapi/util/ModificationTracker;", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getModificationCount", "", "toString", "", "low-level-api-fir"})
    private static final class FileModificationTracker
    implements ModificationTracker {
        @NotNull
        private final SmartPsiElementPointer<PsiFile> pointer;

        public FileModificationTracker(@NotNull PsiFile file2) {
            Intrinsics.checkNotNullParameter(file2, "file");
            SmartPsiElementPointer<PsiElement> smartPsiElementPointer = SmartPointerManager.getInstance(file2.getProject()).createSmartPsiElementPointer((PsiElement)file2);
            Intrinsics.checkNotNullExpressionValue(smartPsiElementPointer, "createSmartPsiElementPointer(...)");
            this.pointer = smartPsiElementPointer;
        }

        @Override
        public long getModificationCount() {
            PsiFile psiFile = this.pointer.getElement();
            if (psiFile == null) {
                return Long.MAX_VALUE;
            }
            PsiFile file2 = psiFile;
            return file2.getModificationStamp();
        }

        @NotNull
        public String toString() {
            PsiFile psiFile = this.pointer.getElement();
            if (psiFile == null) {
                return "File tracker for a collected file";
            }
            PsiFile file2 = psiFile;
            VirtualFile virtualFile = file2.getVirtualFile();
            if (virtualFile == null) {
                return "File tracker for a non-physical file '" + file2.getName() + '\'';
            }
            VirtualFile virtualFile2 = virtualFile;
            return "File tracker for path '" + virtualFile2.getPath() + '\'';
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession$ModuleStateModificationTracker;", "Lcom/intellij/openapi/util/ModificationTracker;", "module", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "tracker", "Lorg/jetbrains/kotlin/analysis/providers/KtModuleStateTracker;", "(Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;Lorg/jetbrains/kotlin/analysis/providers/KtModuleStateTracker;)V", "getModule", "()Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "getTracker", "()Lorg/jetbrains/kotlin/analysis/providers/KtModuleStateTracker;", "getModificationCount", "", "toString", "", "low-level-api-fir"})
    private static final class ModuleStateModificationTracker
    implements ModificationTracker {
        @NotNull
        private final KtModule module;
        @NotNull
        private final KtModuleStateTracker tracker;

        public ModuleStateModificationTracker(@NotNull KtModule module2, @NotNull KtModuleStateTracker tracker) {
            Intrinsics.checkNotNullParameter(module2, "module");
            Intrinsics.checkNotNullParameter(tracker, "tracker");
            this.module = module2;
            this.tracker = tracker;
        }

        @NotNull
        public final KtModule getModule() {
            return this.module;
        }

        @NotNull
        public final KtModuleStateTracker getTracker() {
            return this.tracker;
        }

        @Override
        public long getModificationCount() {
            return this.tracker.getRootModificationCount();
        }

        @NotNull
        public String toString() {
            return "Module state tracker for module '" + this.module.getModuleDescription() + '\'';
        }
    }
}

