/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.NotNullizer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeTraversal {
    private static final NotNullizer ourNotNullizer = new NotNullizer("TreeTraversal.NotNull");
    private final String debugName;
    @NotNull
    public static final TreeTraversal BI_ORDER_DFS = new TreeTraversal("BI_ORDER_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                6.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                6.$$$reportNull$$$0(1);
            }
            return new BiOrderIt<T>(roots2, tree, BiOrderIt.Order.BOTH);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/containers/TreeTraversal$6";
            objectArray[2] = "createIterator";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    @NotNull
    public static final TreeTraversal PRE_ORDER_DFS = new TreeTraversal("PRE_ORDER_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                7.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                7.$$$reportNull$$$0(1);
            }
            return new BiOrderIt<T>(roots2, tree, BiOrderIt.Order.PRE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/containers/TreeTraversal$7";
            objectArray[2] = "createIterator";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    @NotNull
    public static final TreeTraversal POST_ORDER_DFS = new TreeTraversal("POST_ORDER_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                8.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                8.$$$reportNull$$$0(1);
            }
            return new BiOrderIt<T>(roots2, tree, BiOrderIt.Order.POST);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/containers/TreeTraversal$8";
            objectArray[2] = "createIterator";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    @NotNull
    public static final TreeTraversal LEAVES_DFS = new TreeTraversal("LEAVES_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                9.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                9.$$$reportNull$$$0(1);
            }
            return new LeavesDfsIt<T>(roots2, tree);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/containers/TreeTraversal$9";
            objectArray[2] = "createIterator";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    @NotNull
    public static final TreeTraversal INTERLEAVED_DFS = new TreeTraversal("INTERLEAVED_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                10.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                10.$$$reportNull$$$0(1);
            }
            return new InterleavedIt<T>(roots2, tree);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/containers/TreeTraversal$10";
            objectArray[2] = "createIterator";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    @NotNull
    public static final TreeTraversal PLAIN_BFS = new TreeTraversal("PLAIN_BFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                11.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                11.$$$reportNull$$$0(1);
            }
            return new PlainBfsIt<T>(roots2, tree);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/containers/TreeTraversal$11";
            objectArray[2] = "createIterator";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    @NotNull
    public static final TreeTraversal TRACING_BFS = new TreeTraversal("TRACING_BFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                12.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                12.$$$reportNull$$$0(1);
            }
            return new TracingBfsIt<T>(roots2, tree);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/containers/TreeTraversal$12";
            objectArray[2] = "createIterator";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    @NotNull
    public static final TreeTraversal LEAVES_BFS = new TreeTraversal("LEAVES_BFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                13.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                13.$$$reportNull$$$0(1);
            }
            return new LeavesBfsIt<T>(roots2, tree);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/containers/TreeTraversal$13";
            objectArray[2] = "createIterator";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    protected TreeTraversal(@NotNull String debugName) {
        if (debugName == null) {
            TreeTraversal.$$$reportNull$$$0(0);
        }
        this.debugName = debugName;
    }

    @NotNull
    public abstract <T> It<T> createIterator(@NotNull Iterable<? extends T> var1, @NotNull Function<? super T, ? extends Iterable<? extends T>> var2);

    @NotNull
    public final <T> JBIterable<T> traversal(final @NotNull Iterable<? extends T> roots2, final @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
        if (roots2 == null) {
            TreeTraversal.$$$reportNull$$$0(1);
        }
        if (tree == null) {
            TreeTraversal.$$$reportNull$$$0(2);
        }
        return new JBIterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                It it = TreeTraversal.this.createIterator(roots2, tree);
                if (it == null) {
                    1.$$$reportNull$$$0(0);
                }
                return it;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal$1", "iterator"));
            }
        };
    }

    @NotNull
    public final <T> JBIterable<T> traversal(@Nullable T root, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
        if (tree == null) {
            TreeTraversal.$$$reportNull$$$0(3);
        }
        return this.traversal((T)JBIterable.of(root), tree);
    }

    @NotNull
    public final <T> Function<T, JBIterable<T>> traversal(@NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
        if (tree == null) {
            TreeTraversal.$$$reportNull$$$0(4);
        }
        Function<Object, JBIterable> function2 = t -> this.traversal(t, tree);
        if (function2 == null) {
            TreeTraversal.$$$reportNull$$$0(5);
        }
        return function2;
    }

    @NotNull
    public final TreeTraversal unique() {
        return this.unique(Functions.identity());
    }

    @NotNull
    public final TreeTraversal unique(final @NotNull Function<?, ?> identity) {
        if (identity == null) {
            TreeTraversal.$$$reportNull$$$0(6);
        }
        return this.intercept("UNIQUE", new TraversalInterceptor(){

            @NotNull
            public <TT> TraversalArgs<TT> intercept(@NotNull TraversalArgs<TT> args2) {
                Function tree;
                if (args2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((tree = args2.tree) instanceof WrappedTree && Comparing.equal(identity, ((WrappedTree)tree).inner)) {
                    TraversalArgs<TT> traversalArgs = args2;
                    if (traversalArgs == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return traversalArgs;
                }
                class WrappedTree
                implements Condition<TT>,
                Function<TT, Iterable<? extends TT>> {
                    final Function<?, ?> inner;
                    HashSet<Object> visited;

                    WrappedTree() {
                        this.inner = identity;
                    }

                    @Override
                    public boolean value(TT e) {
                        if (this.visited == null) {
                            this.visited = new HashSet();
                        }
                        return this.visited.add(this.inner.fun(e));
                    }

                    @Override
                    public Iterable<? extends TT> fun(TT t) {
                        return JBIterable.from((Iterable)tree.fun(t)).filter(this);
                    }
                }
                WrappedTree wrappedTree = new WrappedTree();
                return new TraversalArgs(JBIterable.from(args2.roots).filter(wrappedTree), wrappedTree);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "args";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/containers/TreeTraversal$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/containers/TreeTraversal$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "intercept";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "intercept";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @NotNull
    public final TreeTraversal cached(final Map<Object, Object> cache2) {
        return this.intercept("CACHED", new TraversalInterceptor(){

            @NotNull
            public <TT> TraversalArgs<TT> intercept(@NotNull TraversalArgs<TT> args2) {
                Function tree;
                if (args2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((tree = args2.tree) instanceof WrappedTree) {
                    TraversalArgs<TT> traversalArgs = args2;
                    if (traversalArgs == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return traversalArgs;
                }
                class WrappedTree
                implements Function<TT, Iterable<? extends TT>> {
                    WrappedTree() {
                    }

                    @Override
                    public Iterable<? extends TT> fun(TT t) {
                        return (Iterable)cache2.computeIfAbsent(t, o -> JBIterable.from((Iterable)tree.fun(o)).collect());
                    }
                }
                WrappedTree wrappedTree = new WrappedTree();
                return new TraversalArgs(args2.roots, wrappedTree);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "args";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/containers/TreeTraversal$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/containers/TreeTraversal$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "intercept";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "intercept";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @NotNull
    public final <T> TreeTraversal onRange(final @NotNull Condition<? super T> rangeCondition) {
        if (rangeCondition == null) {
            TreeTraversal.$$$reportNull$$$0(7);
        }
        return this.intercept("ON_RANGE", new TraversalInterceptor(){

            @NotNull
            public <TT> TraversalArgs<TT> intercept(@NotNull TraversalArgs<TT> args2) {
                if (args2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                final Function tree = args2.tree;
                final Condition inRangeCondition = rangeCondition;
                final Condition notInRangeCondition = Conditions.not(rangeCondition);
                if (tree instanceof WrappedTree && Comparing.equal(rangeCondition, ((WrappedTree)tree).inner)) {
                    TraversalArgs<TT> traversalArgs = args2;
                    if (traversalArgs == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return traversalArgs;
                }
                class WrappedTree
                implements Function<TT, Iterable<? extends TT>> {
                    final Condition<? super T> inner;

                    WrappedTree() {
                        this.inner = rangeCondition;
                    }

                    @Override
                    public Iterable<? extends TT> fun(TT t) {
                        return JBIterable.from((Iterable)tree.fun(t)).skipWhile(notInRangeCondition).takeWhile(inRangeCondition);
                    }
                }
                WrappedTree wrappedTree = new WrappedTree();
                return new TraversalArgs(JBIterable.from(args2.roots).filter(inRangeCondition), wrappedTree);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "args";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/containers/TreeTraversal$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/containers/TreeTraversal$4";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "intercept";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "intercept";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @NotNull
    public final TreeTraversal intercept(@NotNull String debugName, @NotNull TraversalInterceptor interceptor) {
        if (debugName == null) {
            TreeTraversal.$$$reportNull$$$0(8);
        }
        if (interceptor == null) {
            TreeTraversal.$$$reportNull$$$0(9);
        }
        String nextName = debugName + "." + this.debugName;
        if (this instanceof Intercepted) {
            Intercepted intercepted = (Intercepted)this;
            return new Intercepted(nextName, intercepted.original, TraversalInterceptor.compose(intercepted.interceptor, interceptor));
        }
        return new Intercepted(nextName, this, interceptor);
    }

    public final String toString() {
        return this.debugName;
    }

    @NotNull
    public static TreeTraversal GUIDED_TRAVERSAL(final @NotNull GuidedIt.Guide<?> guide) {
        if (guide == null) {
            TreeTraversal.$$$reportNull$$$0(10);
        }
        return new TreeTraversal("GUIDED_TRAVERSAL"){

            @Override
            @NotNull
            public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
                if (roots2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (tree == null) {
                    5.$$$reportNull$$$0(1);
                }
                return new GuidedItImpl<T>(roots2, tree, guide);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "roots";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "tree";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/util/containers/TreeTraversal$5";
                objectArray[2] = "createIterator";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/TreeTraversal";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeCondition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interceptor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "guide";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/TreeTraversal";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "traversal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "traversal";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unique";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onRange";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "intercept";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "GUIDED_TRAVERSAL";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class P2<T>
    extends P<T, P2<T>> {
        P2<T> next;
        P2<T> prev;

        private P2() {
        }

        static <T> P2<T> create(T node) {
            return P2.create(new P2<T>(), node);
        }

        static <T> P2<T> create(Iterable<? extends T> it) {
            return P2.create(new P2<T>(), it);
        }

        P2<T> add(@NotNull P2<T> next) {
            if (next == null) {
                P2.$$$reportNull$$$0(0);
            }
            next.next = this.next;
            next.prev = this;
            this.next = next;
            return next;
        }

        P2<T> remove() {
            P2<T> p = this.prev;
            P2<T> n = this.next;
            this.next = null;
            this.prev = null;
            if (p != null) {
                p.next = n;
            }
            if (n != null) {
                n.prev = p;
            }
            return p;
        }

        public String toString() {
            int h = 0;
            int t = 0;
            P2<T> p = this.prev;
            while (p != null) {
                ++h;
                p = p.prev;
            }
            p = this.next;
            while (p != null) {
                ++t;
                p = p.next;
            }
            return h + " of " + (h + t + 1) + ": " + this.node;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/util/containers/TreeTraversal$P2", "add"));
        }
    }

    private static final class P1<T>
    extends P<T, P1<T>> {
        private P1() {
        }

        static <T> P1<T> create(T node) {
            return P1.create(new P1<T>(), node);
        }

        static <T> P1<T> create(Iterable<? extends T> it) {
            return P1.create(new P1<T>(), it);
        }

        P1<T> add(@NotNull P1<T> next) {
            if (next == null) {
                P1.$$$reportNull$$$0(0);
            }
            next.parent = this;
            return next;
        }

        P1<T> addBefore(@NotNull P1<T> next) {
            if (next == null) {
                P1.$$$reportNull$$$0(1);
            }
            next.parent = null;
            this.parent = next;
            return next;
        }

        P1<T> remove() {
            return (P1)this.parent;
        }

        public String toString() {
            int h = 0;
            P1 p = (P1)this.parent;
            while (p != null) {
                ++h;
                p = (P1)p.parent;
            }
            return h + ": " + this.node;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "next";
            objectArray2[1] = "com/intellij/util/containers/TreeTraversal$P1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addBefore";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class P<T, Self extends P<T, Self>> {
        T node;
        Iterable<? extends T> itle;
        Iterator<? extends T> it;
        boolean empty;
        Self parent;
        static final Function TO_NODE = tp -> tp.node;
        static final Function TO_PREV = new Function.Mono<P<?, ?>>(){

            @Override
            public P<?, ?> fun(P<?, ?> tp) {
                return tp.parent;
            }
        };

        private P() {
        }

        static <T, Self extends P<T, Self>> Self create(Self p, T node) {
            p.node = node;
            return p;
        }

        static <T, Self extends P<T, Self>> Self create(Self p, Iterable<? extends T> it) {
            p.itle = it;
            return p;
        }

        final Iterator<? extends T> iterator(@NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (tree == null) {
                P.$$$reportNull$$$0(0);
            }
            if (this.it != null) {
                return this.it;
            }
            this.it = this.iterable(tree).iterator();
            this.empty = this.itle == null || !this.it.hasNext();
            return this.it;
        }

        final Iterable<? extends T> iterable(@NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (tree == null) {
                P.$$$reportNull$$$0(1);
            }
            return this.itle != null ? this.itle : ((this.itle = tree.fun(this.node)) != null ? this.itle : JBIterable.empty());
        }

        static <T> Function<P<T, ?>, T> toNode() {
            return TO_NODE;
        }

        static <T> Function<P<T, ?>, P<T, ?>> toPrev() {
            return TO_PREV;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "tree";
            objectArray2[1] = "com/intellij/util/containers/TreeTraversal$P";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "iterator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "iterable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class GuidedItImpl<T>
    extends GuidedIt<T> {
        final GuidedIt.Guide<T> guide;
        P1<T> first;
        P1<T> last;
        T curResult;

        GuidedItImpl(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree, @NotNull GuidedIt.Guide<T> guide) {
            if (roots2 == null) {
                GuidedItImpl.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                GuidedItImpl.$$$reportNull$$$0(1);
            }
            if (guide == null) {
                GuidedItImpl.$$$reportNull$$$0(2);
            }
            super(tree);
            this.last = P1.create(roots2);
            this.first = this.last;
            this.guide = guide;
        }

        @Override
        public GuidedIt<T> queueNext(T child) {
            if (child != null) {
                this.last = this.last.add(P1.create(child));
            }
            return this;
        }

        @Override
        public GuidedIt<T> queueLast(T child) {
            if (child != null) {
                this.first = this.first.addBefore(P1.create(child));
            }
            return this;
        }

        @Override
        public GuidedIt<T> result(T node) {
            this.curResult = node;
            return this;
        }

        @Override
        public T nextImpl() {
            if (this.guide == null) {
                return (T)this.stop();
            }
            while (this.last != null) {
                P1<T> top = this.last;
                Iterator it = top.iterator(this.tree);
                boolean hasNext = it.hasNext();
                this.curResult = null;
                if (top.node != null || hasNext) {
                    this.curChild = hasNext ? it.next() : null;
                    this.curParent = top.node;
                    this.curChildren = top.itle;
                    this.curNoChildren = top.empty;
                    this.guide.guide(this);
                }
                if (!hasNext) {
                    this.last = this.last.remove();
                }
                if (this.curResult == null) continue;
                return this.curResult;
            }
            return (T)this.stop();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "guide";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/containers/TreeTraversal$GuidedItImpl";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class TracingBfsIt<T>
    extends TracingIt<T> {
        final ArrayDeque<T> queue;
        final Map<T, T> paths;
        P1<T> top;
        P1<T> cur;

        TracingBfsIt(@NotNull Iterable<? extends T> roots2, Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                TracingBfsIt.$$$reportNull$$$0(0);
            }
            super(tree);
            this.queue = new ArrayDeque();
            this.paths = new IdentityHashMap<T, T>();
            JBIterable.from(roots2).map(ourNotNullizer::notNullize).addAllTo(this.queue);
        }

        @Override
        protected void currentChanged() {
            this.cur = this.top;
        }

        @Override
        public T nextImpl() {
            if (this.top != null) {
                for (Object t : this.top.iterable(this.tree)) {
                    if (this.paths.containsKey(t)) continue;
                    this.queue.add(ourNotNullizer.notNullize(t));
                    this.paths.put(t, this.top.node);
                }
                this.top = null;
            }
            if (this.queue.isEmpty()) {
                return (T)this.stop();
            }
            this.top = P1.create(ourNotNullizer.nullize(this.queue.remove()));
            return (T)this.top.node;
        }

        @Override
        public T parent() {
            if (this.cur == null) {
                throw new NoSuchElementException();
            }
            return this._transform(this.paths.get(this.cur.node));
        }

        @Override
        @NotNull
        public JBIterable<T> backtrace() {
            if (this.cur == null) {
                throw new NoSuchElementException();
            }
            JBIterable jBIterable = this._transform(JBIterable.generate(this.cur.node, Functions.fromMap(this.paths)));
            if (jBIterable == null) {
                TracingBfsIt.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/TreeTraversal$TracingBfsIt";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/TreeTraversal$TracingBfsIt";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "backtrace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class LeavesBfsIt<T>
    extends TracingIt<T> {
        final ArrayDeque<T> queue;

        LeavesBfsIt(@NotNull Iterable<? extends T> roots2, Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                LeavesBfsIt.$$$reportNull$$$0(0);
            }
            super(tree);
            this.queue = new ArrayDeque();
            JBIterable.from(roots2).map(ourNotNullizer::notNullize).addAllTo(this.queue);
        }

        @Override
        public T nextImpl() {
            while (!this.queue.isEmpty()) {
                Iterator it;
                T result2 = ourNotNullizer.nullize(this.queue.remove());
                Iterable children2 = (Iterable)this.tree.fun(result2);
                Iterator iterator2 = it = children2 == null ? null : children2.iterator();
                if (it == null || !it.hasNext()) {
                    return result2;
                }
                while (it.hasNext()) {
                    this.queue.add(ourNotNullizer.notNullize(it.next()));
                }
            }
            return (T)this.stop();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$LeavesBfsIt", "<init>"));
        }
    }

    private static final class PlainBfsIt<T>
    extends It<T> {
        final ArrayDeque<T> queue;
        P1<T> top;

        PlainBfsIt(@NotNull Iterable<? extends T> roots2, Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                PlainBfsIt.$$$reportNull$$$0(0);
            }
            super(tree);
            this.queue = new ArrayDeque();
            JBIterable.from(roots2).map(ourNotNullizer::notNullize).addAllTo(this.queue);
        }

        @Override
        public T nextImpl() {
            if (this.top != null) {
                JBIterable.from(this.top.iterable(this.tree)).map(ourNotNullizer::notNullize).addAllTo(this.queue);
                this.top = null;
            }
            if (this.queue.isEmpty()) {
                return (T)this.stop();
            }
            this.top = P1.create(ourNotNullizer.nullize(this.queue.remove()));
            return (T)this.top.node;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$PlainBfsIt", "<init>"));
        }
    }

    private static final class InterleavedIt<T>
    extends DfsIt<T, P2<T>> {
        P2<T> cur;
        P2<T> max;

        InterleavedIt(@NotNull Iterable<? extends T> roots2, Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                InterleavedIt.$$$reportNull$$$0(0);
            }
            super(tree);
            this.last = P2.create(roots2);
            this.cur = this.max = (P2)this.last;
        }

        @Override
        public T nextImpl() {
            while (this.last != null) {
                Iterator it;
                if (this.cur == null) {
                    this.cur = this.max;
                    this.max = this.max.next;
                }
                if ((it = this.cur.iterator(this.tree)).hasNext()) {
                    Object result2 = it.next();
                    this.last = ((P2)this.last).add(P2.create(result2));
                    ((P2)this.last).parent = this.cur;
                    this.cur = this.cur.prev;
                    if (this.max == null) {
                        this.max = (P2)this.last;
                    }
                    return result2;
                }
                if (this.cur == this.last) {
                    this.last = this.cur.prev;
                }
                this.cur = this.cur.remove();
            }
            return (T)this.stop();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$InterleavedIt", "<init>"));
        }
    }

    private static final class LeavesDfsIt<T>
    extends DfsIt<T, P1<T>> {
        LeavesDfsIt(@NotNull Iterable<? extends T> roots2, Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                LeavesDfsIt.$$$reportNull$$$0(0);
            }
            super(tree);
            this.last = P1.create(roots2);
        }

        @Override
        public T nextImpl() {
            while (this.last != null) {
                P1 top = (P1)this.last;
                if (top.iterator(this.tree).hasNext() && !top.empty) {
                    Object child = top.iterator(this.tree).next();
                    this.last = ((P1)this.last).add(P1.create(child));
                    continue;
                }
                this.last = ((P1)this.last).remove();
                if (!top.empty) continue;
                return (T)(this.last == null ? this.stop() : top.node);
            }
            return (T)this.stop();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$LeavesDfsIt", "<init>"));
        }
    }

    private static final class BiOrderIt<T>
    extends DfsIt<T, P1<T>> {
        private final Order order;
        private boolean curDescending;
        private boolean descending;

        BiOrderIt(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree, @NotNull Order order) {
            if (roots2 == null) {
                BiOrderIt.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                BiOrderIt.$$$reportNull$$$0(1);
            }
            if (order == null) {
                BiOrderIt.$$$reportNull$$$0(2);
            }
            super(tree);
            this.descending = true;
            this.order = order;
            this.last = P1.create(roots2);
        }

        @Override
        protected void currentChanged() {
            super.currentChanged();
            this.curDescending = this.descending;
        }

        @Override
        @Nullable
        public T parent() {
            return (T)(this.curDescending || this.cur == null ? super.parent() : (((P1)this.cur).node == null ? null : this._transform(((P1)this.cur).node)));
        }

        @Override
        @NotNull
        public JBIterable<T> backtrace() {
            JBIterable<Object> jBIterable = this.curDescending ? super.backtrace() : JBIterable.of(this.current()).append(super.backtrace());
            if (jBIterable == null) {
                BiOrderIt.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        @Override
        public boolean isDescending() {
            return this.curDescending;
        }

        @Override
        public T nextImpl() {
            while (this.last != null) {
                Object result2;
                Iterator it = ((P1)this.last).iterator(this.tree);
                if (it.hasNext()) {
                    result2 = it.next();
                    this.last = ((P1)this.last).add(P1.create(result2));
                    this.descending = true;
                    if (this.order == Order.POST) continue;
                    return result2;
                }
                result2 = ((P1)this.last).node;
                this.last = ((P1)this.last).remove();
                this.descending = false;
                if (this.order == Order.PRE || this.last == null) continue;
                return result2;
            }
            this.descending = true;
            return (T)this.stop();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "order";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/TreeTraversal$BiOrderIt";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/TreeTraversal$BiOrderIt";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "backtrace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }

        private static enum Order {
            PRE,
            POST,
            BOTH;

        }
    }

    private static abstract class DfsIt<T, H extends P<T, H>>
    extends TracingIt<T> {
        H last;
        H cur;

        protected DfsIt(Function<? super T, ? extends Iterable<? extends T>> tree) {
            super(tree);
        }

        @Override
        protected void currentChanged() {
            this.cur = this.last;
        }

        @Override
        @Nullable
        public T parent() {
            if (this.cur == null) {
                throw new NoSuchElementException();
            }
            Object p = ((P)this.cur).parent;
            return p == null ? null : (((P)p).node == null ? null : this._transform(((P)p).node));
        }

        @Override
        @NotNull
        public JBIterable<T> backtrace() {
            if (this.cur == null) {
                throw new NoSuchElementException();
            }
            JBIterable jBIterable = this._transform(JBIterable.generate(this.cur, P.toPrev()).filterMap(P.toNode()));
            if (jBIterable == null) {
                DfsIt.$$$reportNull$$$0(0);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal$DfsIt", "backtrace"));
        }
    }

    public static abstract class GuidedIt<T>
    extends It<T> {
        @Nullable
        public T curChild;
        @Nullable
        public T curParent;
        @Nullable
        public Iterable<? extends T> curChildren;
        public boolean curNoChildren;

        public abstract GuidedIt<T> queueNext(@Nullable T var1);

        public abstract GuidedIt<T> result(@Nullable T var1);

        public abstract GuidedIt<T> queueLast(@Nullable T var1);

        protected GuidedIt(Function<? super T, ? extends Iterable<? extends T>> tree) {
            super(tree);
        }

        public static interface Guide<T> {
            public void guide(@NotNull GuidedIt<T> var1);
        }
    }

    public static abstract class TracingIt<T>
    extends It<T> {
        private JBIterable<Function<Object, Object>> cachedTransform;

        @Nullable
        public T parent() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public JBIterable<T> backtrace() {
            throw new UnsupportedOperationException();
        }

        public boolean isDescending() {
            return true;
        }

        protected TracingIt(Function<? super T, ? extends Iterable<? extends T>> tree) {
            super(tree);
        }

        protected JBIterable<T> _transform(JBIterable<?> original) {
            JBIterable<Object> result2 = original;
            for (Function function2 : this._transformations()) {
                result2 = result2.map(function2);
            }
            return result2;
        }

        protected T _transform(Object original) {
            Object result2 = original;
            for (Function function2 : this._transformations()) {
                result2 = function2.fun(result2);
            }
            return (T)result2;
        }

        @NotNull
        private JBIterable<Function<Object, Object>> _transformations() {
            JBIterable<Function<Object, Object>> jBIterable = this.cachedTransform == null ? (this.cachedTransform = this.getTransformations()) : this.cachedTransform;
            if (jBIterable == null) {
                TracingIt.$$$reportNull$$$0(0);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal$TracingIt", "_transformations"));
        }
    }

    public static abstract class It<T>
    extends JBIterator<T> {
        protected final Function<? super T, ? extends Iterable<? extends T>> tree;

        protected It(Function<? super T, ? extends Iterable<? extends T>> tree) {
            this.tree = tree;
        }
    }

    private static class Intercepted
    extends TreeTraversal {
        final TreeTraversal original;
        final TraversalInterceptor interceptor;

        protected Intercepted(@NotNull String debugName, @NotNull TreeTraversal original, @NotNull TraversalInterceptor interceptor) {
            if (debugName == null) {
                Intercepted.$$$reportNull$$$0(0);
            }
            if (original == null) {
                Intercepted.$$$reportNull$$$0(1);
            }
            if (interceptor == null) {
                Intercepted.$$$reportNull$$$0(2);
            }
            super(debugName);
            this.original = original;
            this.interceptor = interceptor;
        }

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                Intercepted.$$$reportNull$$$0(3);
            }
            if (tree == null) {
                Intercepted.$$$reportNull$$$0(4);
            }
            TraversalArgs<? super T> adjusted = this.interceptor.intercept(new TraversalArgs<T>(roots2, tree));
            It it = this.original.createIterator(adjusted.roots, adjusted.tree);
            if (it == null) {
                Intercepted.$$$reportNull$$$0(5);
            }
            return it;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interceptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/TreeTraversal$Intercepted";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/TreeTraversal$Intercepted";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createIterator";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class TraversalArgs<T> {
        public final Iterable<? extends T> roots;
        public final Function<? super T, ? extends Iterable<? extends T>> tree;

        public TraversalArgs(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                TraversalArgs.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                TraversalArgs.$$$reportNull$$$0(1);
            }
            this.roots = roots2;
            this.tree = tree;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/containers/TreeTraversal$TraversalArgs";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface TraversalInterceptor {
        @NotNull
        public <T> TraversalArgs<T> intercept(@NotNull TraversalArgs<T> var1);

        @NotNull
        public static TraversalInterceptor compose(final @NotNull TraversalInterceptor interceptor1, final @NotNull TraversalInterceptor interceptor2) {
            if (interceptor1 == null) {
                TraversalInterceptor.$$$reportNull$$$0(0);
            }
            if (interceptor2 == null) {
                TraversalInterceptor.$$$reportNull$$$0(1);
            }
            return new TraversalInterceptor(){

                @NotNull
                public <TT> TraversalArgs<TT> intercept(@NotNull TraversalArgs<TT> args2) {
                    if (args2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    TraversalArgs<TT> traversalArgs = interceptor2.intercept(interceptor1.intercept(args2));
                    if (traversalArgs == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return traversalArgs;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string2;
                    switch (n) {
                        default: {
                            string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string2 = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "args";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/util/containers/TreeTraversal$TraversalInterceptor$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/util/containers/TreeTraversal$TraversalInterceptor$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "intercept";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "intercept";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string3 = String.format(string2, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string3);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string3);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "interceptor1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "interceptor2";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/containers/TreeTraversal$TraversalInterceptor";
            objectArray[2] = "compose";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

