/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.core.JavaPsiBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PsiMethodReferenceCompatibilityConstraint
implements ConstraintFormula {
    private static final Logger LOG = Logger.getInstance(PsiMethodReferenceCompatibilityConstraint.class);
    private final PsiMethodReferenceExpression myExpression;
    private PsiType myT;

    public PsiMethodReferenceCompatibilityConstraint(PsiMethodReferenceExpression expression2, PsiType t) {
        this.myExpression = expression2;
        this.myT = t;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean reduce(InferenceSession session, List<? super ConstraintFormula> constraints) {
        if (!LambdaUtil.isFunctionalType(this.myT)) {
            session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.not.a.functional.interface", session.getPresentableText(this.myT)));
            return false;
        }
        PsiType groundTargetType = this.myExpression.getGroundTargetType(this.myT);
        PsiClassType.ClassResolveResult classResolveResult = PsiUtil.resolveGenericsClassInType(groundTargetType);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(classResolveResult);
        if (interfaceMethod == null) {
            session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.no.valid.function.type.found", session.getPresentableText(this.myT)));
            return false;
        }
        PsiSubstitutor substitutor2 = LambdaUtil.getSubstitutor(interfaceMethod, classResolveResult);
        MethodSignature signature = interfaceMethod.getSignature(substitutor2);
        PsiParameter[] targetParameters = interfaceMethod.getParameterList().getParameters();
        PsiType interfaceMethodReturnType = interfaceMethod.getReturnType();
        PsiType returnType2 = substitutor2.substitute(interfaceMethodReturnType);
        PsiType[] typeParameters2 = this.myExpression.getTypeParameters();
        PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(this.myExpression);
        if (this.myExpression.isExact()) {
            PsiParameter[] parameters2;
            void var20_33;
            PsiMember applicableMember = this.myExpression.getPotentiallyApplicableMember();
            LOG.assertTrue(applicableMember != null);
            PsiClass applicableMemberContainingClass = applicableMember.getContainingClass();
            PsiClass containingClass = qualifierResolveResult.getContainingClass();
            PsiSubstitutor psiSubstitutor = PsiMethodReferenceCompatibilityConstraint.getSubstitutor(signature, qualifierResolveResult, applicableMember, applicableMemberContainingClass, this.myExpression);
            int idx = 0;
            PsiTypeParameter[] psiTypeParameterArray = ((PsiTypeParameterListOwner)applicableMember).getTypeParameters();
            int n = psiTypeParameterArray.length;
            boolean bl = false;
            while (var20_33 < n) {
                PsiTypeParameter param = psiTypeParameterArray[var20_33];
                if (idx < typeParameters2.length) {
                    psiSubstitutor = psiSubstitutor.put(param, typeParameters2[idx++]);
                }
                ++var20_33;
            }
            PsiParameter[] psiParameterArray = parameters2 = applicableMember instanceof PsiMethod ? ((PsiMethod)applicableMember).getParameterList().getParameters() : PsiParameter.EMPTY_ARRAY;
            if (targetParameters.length == parameters2.length + 1) {
                PsiType qualifierType = PsiMethodReferenceUtil.getQualifierType(this.myExpression);
                PsiClass psiClass = PsiUtil.resolveClassInType(qualifierType);
                if (psiClass != null) {
                    PsiType pType = signature.getParameterTypes()[0];
                    constraints.add(new StrictSubtypingConstraint(session.substituteWithInferenceVariables(qualifierType), pType));
                }
                for (int i = 1; i < targetParameters.length; ++i) {
                    constraints.add(new TypeCompatibilityConstraint(session.substituteWithInferenceVariables(psiSubstitutor.substitute(parameters2[i - 1].getType())), PsiUtil.captureToplevelWildcards(signature.getParameterTypes()[i], this.myExpression)));
                }
            } else if (targetParameters.length == parameters2.length) {
                for (int i = 0; i < targetParameters.length; ++i) {
                    constraints.add(new TypeCompatibilityConstraint(session.substituteWithInferenceVariables(psiSubstitutor.substitute(parameters2[i].getType())), PsiUtil.captureToplevelWildcards(signature.getParameterTypes()[i], this.myExpression)));
                }
            } else {
                session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.incompatible.parameter.types.in.method.reference", new Object[0]));
                return false;
            }
            if (!PsiType.VOID.equals(returnType2) && returnType2 != null) {
                PsiType applicableMethodReturnType = null;
                if (applicableMember instanceof PsiMethod) {
                    PsiType psiType2 = PsiTypesUtil.patchMethodGetClassReturnType(this.myExpression, (PsiMethod)applicableMember);
                    PsiType psiType3 = applicableMethodReturnType = psiType2 != null ? psiType2 : ((PsiMethod)applicableMember).getReturnType();
                }
                if (PsiType.VOID.equals(applicableMethodReturnType)) {
                    session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.incompatible.types.expected.not.void.got.void.method.reference", new Object[0]));
                    return false;
                }
                if (applicableMethodReturnType == null && (applicableMember instanceof PsiClass || applicableMember instanceof PsiMethod && ((PsiMethod)applicableMember).isConstructor()) && containingClass != null) {
                    applicableMethodReturnType = JavaPsiFacade.getElementFactory(applicableMember.getProject()).createType(containingClass, PsiSubstitutor.EMPTY);
                }
                if (applicableMethodReturnType != null) {
                    applicableMethodReturnType = psiSubstitutor.substitute(applicableMethodReturnType);
                    applicableMethodReturnType = Registry.is("unsound.capture.conversion.java.spec.change") ? applicableMethodReturnType : PsiUtil.captureToplevelWildcards(applicableMethodReturnType, this.myExpression);
                    constraints.add(new TypeCompatibilityConstraint(returnType2, session.substituteWithInferenceVariables(applicableMethodReturnType)));
                }
            }
            return true;
        }
        for (PsiType paramType : signature.getParameterTypes()) {
            if (session.isProperType(paramType)) continue;
            return false;
        }
        JavaResolveResult resolve2 = this.myExpression.advancedResolve(false);
        PsiElement element2 = resolve2.getElement();
        if (element2 == null || resolve2 instanceof MethodCandidateInfo && !((MethodCandidateInfo)resolve2).isApplicable()) {
            session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.declaration.for.the.method.reference.not.found", new Object[0]));
            return false;
        }
        if (PsiType.VOID.equals(returnType2) || returnType2 == null) {
            return true;
        }
        if (element2 instanceof PsiMethod) {
            PsiType getClassReturnType;
            PsiMethod method = (PsiMethod)element2;
            PsiClass containingClass = method.getContainingClass();
            LOG.assertTrue(containingClass != null, method);
            PsiSubstitutor psiSubstitutor = PsiMethodReferenceCompatibilityConstraint.getSubstitutor(signature, qualifierResolveResult, method, containingClass, this.myExpression);
            PsiType referencedMethodReturnType = method.isConstructor() ? JavaPsiFacade.getElementFactory(method.getProject()).createType(containingClass, PsiSubstitutor.EMPTY) : ((getClassReturnType = PsiTypesUtil.patchMethodGetClassReturnType(this.myExpression, method)) != null ? getClassReturnType : method.getReturnType());
            LOG.assertTrue(referencedMethodReturnType != null, method);
            if (typeParameters2.length == 0) {
                PsiTypeParameter[] methodTypeParameters;
                PsiTypeParameter[] psiTypeParameterArray = methodTypeParameters = method.isConstructor() ? containingClass.getTypeParameters() : method.getTypeParameters();
                if (methodTypeParameters.length > 0) {
                    PsiClass psiClass = classResolveResult.getElement();
                    LOG.assertTrue(psiClass != null);
                    if (PsiTypesUtil.mentionsTypeParameters(referencedMethodReturnType, ContainerUtil.newHashSet(methodTypeParameters))) {
                        session.initBounds((PsiElement)this.myExpression, psiSubstitutor, methodTypeParameters);
                        session.collectApplicabilityConstraints(this.myExpression, (MethodCandidateInfo)resolve2, groundTargetType);
                        session.registerReturnTypeConstraints(psiSubstitutor.substitute(referencedMethodReturnType), returnType2, this.myExpression);
                        return true;
                    }
                }
            }
            if (PsiType.VOID.equals(referencedMethodReturnType)) {
                session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.expected.non.void.got.void.method.reference", new Object[0]));
                return false;
            }
            int idx = 0;
            for (PsiTypeParameter param : method.getTypeParameters()) {
                if (idx >= typeParameters2.length) continue;
                psiSubstitutor = psiSubstitutor.put(param, typeParameters2[idx++]);
            }
            PsiClass psiClass = qualifierResolveResult.getContainingClass();
            if (psiClass != null && PsiUtil.isRawSubstitutor(psiClass, qualifierResolveResult.getSubstitutor()) && PsiMethodReferenceCompatibilityConstraint.getParameterization(signature, qualifierResolveResult, method, this.myExpression, psiClass) == null) {
                if (!PsiMethodReferenceUtil.isSecondSearchPossible(signature.getParameterTypes(), qualifierResolveResult, this.myExpression)) {
                    session.initBounds((PsiElement)this.myExpression, psiClass.getTypeParameters());
                } else {
                    referencedMethodReturnType = TypeConversionUtil.erasure(referencedMethodReturnType);
                }
            }
            referencedMethodReturnType = psiSubstitutor.substitute(referencedMethodReturnType);
            referencedMethodReturnType = Registry.is("unsound.capture.conversion.java.spec.change") ? referencedMethodReturnType : PsiUtil.captureToplevelWildcards(referencedMethodReturnType, this.myExpression);
            constraints.add(new TypeCompatibilityConstraint(returnType2, session.substituteWithInferenceVariables(referencedMethodReturnType)));
        }
        return true;
    }

    public static PsiSubstitutor getSubstitutor(MethodSignature signature, PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, PsiMember member2, @Nullable PsiClass containingClass, PsiMethodReferenceExpression methodReferenceExpression) {
        PsiClass qContainingClass = qualifierResolveResult.getContainingClass();
        PsiSubstitutor psiSubstitutor = qualifierResolveResult.getSubstitutor();
        if (qContainingClass != null && containingClass != null) {
            if (PsiUtil.isRawSubstitutor(qContainingClass, psiSubstitutor)) {
                PsiClassType parameterization = PsiMethodReferenceCompatibilityConstraint.getParameterization(signature, qualifierResolveResult, member2, methodReferenceExpression, qContainingClass);
                if (parameterization != null) {
                    PsiType pType = PsiUtil.captureToplevelWildcards(parameterization, methodReferenceExpression);
                    psiSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(qContainingClass, (PsiClassType)pType);
                } else {
                    psiSubstitutor = PsiSubstitutor.EMPTY;
                }
            }
            if (qContainingClass.isInheritor(containingClass, true)) {
                LOG.assertTrue((psiSubstitutor = TypeConversionUtil.getClassSubstitutor(containingClass, qContainingClass, psiSubstitutor)) != null);
            }
        }
        return psiSubstitutor;
    }

    private static PsiClassType getParameterization(MethodSignature signature, PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, PsiMember member2, PsiMethodReferenceExpression methodReferenceExpression, PsiClass qContainingClass) {
        PsiClassType subclassType;
        if (member2 instanceof PsiMethod && PsiMethodReferenceUtil.isSecondSearchPossible(signature.getParameterTypes(), qualifierResolveResult, methodReferenceExpression) && (subclassType = StrictSubtypingConstraint.getSubclassType(qContainingClass, signature.getParameterTypes()[0], true)) != null && !subclassType.isRaw()) {
            return subclassType;
        }
        return null;
    }

    @Override
    public void apply(PsiSubstitutor substitutor2, boolean cache2) {
        this.myT = substitutor2.substitute(this.myT);
    }

    public String toString() {
        return this.myExpression.getText() + " -> " + this.myT.getPresentableText();
    }
}

