/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.expressions;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IdSignature;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0012\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\t\u001a\u0012\u0010\u001c\u001a\u00020\u0019*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f\u001a(\u0010 \u001a\u00020\u0019*\u0006\u0012\u0002\b\u00030!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0014H\u0000\u001a$\u0010&\u001a\u00020\u0019*\u0006\u0012\u0002\b\u00030!2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030!2\b\b\u0002\u0010(\u001a\u00020\u0014\u001a\n\u0010)\u001a\u00020\u0001*\u00020\t\u001a\u0014\u0010*\u001a\u00020\t*\u00020\t2\b\u0010+\u001a\u0004\u0018\u00010,\u001a\n\u0010-\u001a\u00020\u0001*\u00020\t\u001a\u001a\u0010.\u001a\u00020\u0019*\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\t\u001a&\u0010.\u001a\u00020\u0019*\u0006\u0012\u0002\b\u00030!2\u0006\u00102\u001a\u0002032\u0006\u00100\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\t\u001a\u001a\u00104\u001a\u00020\u0019*\u00020\u001d2\u0006\u00105\u001a\u00020\u00142\u0006\u00106\u001a\u00020\u001f\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0003\"(\u0010\n\u001a\u00020\t*\u00020\u000b2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\"(\u0010\u0010\u001a\u00020\t*\u00020\u000b2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000f\"\u0015\u0010\u0013\u001a\u00020\u0014*\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00067"}, d2={"isAdapterWithReflection", "", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;)Z", "isTransparentScope", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "(Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;)Z", "isWithReflection", "value", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "left", "Lorg/jetbrains/kotlin/ir/expressions/IrDynamicOperatorExpression;", "getLeft", "(Lorg/jetbrains/kotlin/ir/expressions/IrDynamicOperatorExpression;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "setLeft", "(Lorg/jetbrains/kotlin/ir/expressions/IrDynamicOperatorExpression;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "right", "getRight", "setRight", "typeParametersCount", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getTypeParametersCount", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)I", "addArgument", "", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "argument", "addElement", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "varargElement", "Lorg/jetbrains/kotlin/ir/expressions/IrVarargElement;", "checkArgumentSlotAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "kind", "", "index", "total", "copyTypeArgumentsFrom", "other", "shift", "hasNoSideEffects", "implicitCastTo", "expectedType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isUnchanging", "putArgument", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "callee", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "putElement", "i", "element", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nIrExpressions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrExpressions.kt\norg/jetbrains/kotlin/ir/expressions/IrExpressionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public final class IrExpressionsKt {
    public static final boolean isWithReflection(@NotNull IrFunctionReference $this$isWithReflection) {
        Intrinsics.checkNotNullParameter($this$isWithReflection, "<this>");
        return $this$isWithReflection.getReflectionTarget() != null;
    }

    public static final boolean isAdapterWithReflection(@NotNull IrFunctionReference $this$isAdapterWithReflection) {
        Intrinsics.checkNotNullParameter($this$isAdapterWithReflection, "<this>");
        return $this$isAdapterWithReflection.getReflectionTarget() != null && !Intrinsics.areEqual($this$isAdapterWithReflection.getReflectionTarget(), $this$isAdapterWithReflection.getSymbol());
    }

    @NotNull
    public static final IrExpression getLeft(@NotNull IrDynamicOperatorExpression $this$left) {
        Intrinsics.checkNotNullParameter($this$left, "<this>");
        return $this$left.getReceiver();
    }

    public static final void setLeft(@NotNull IrDynamicOperatorExpression $this$left, @NotNull IrExpression value2) {
        Intrinsics.checkNotNullParameter($this$left, "<this>");
        Intrinsics.checkNotNullParameter(value2, "value");
        $this$left.setReceiver(value2);
    }

    @NotNull
    public static final IrExpression getRight(@NotNull IrDynamicOperatorExpression $this$right) {
        Intrinsics.checkNotNullParameter($this$right, "<this>");
        return $this$right.getArguments().get(0);
    }

    public static final void setRight(@NotNull IrDynamicOperatorExpression $this$right, @NotNull IrExpression value2) {
        Intrinsics.checkNotNullParameter($this$right, "<this>");
        Intrinsics.checkNotNullParameter(value2, "value");
        if ($this$right.getArguments().isEmpty()) {
            $this$right.getArguments().add(value2);
        } else {
            $this$right.getArguments().set(0, value2);
        }
    }

    public static final void putArgument(@NotNull IrFunctionAccessExpression $this$putArgument, @NotNull IrValueParameter parameter2, @NotNull IrExpression argument2) {
        Intrinsics.checkNotNullParameter($this$putArgument, "<this>");
        Intrinsics.checkNotNullParameter(parameter2, "parameter");
        Intrinsics.checkNotNullParameter(argument2, "argument");
        IrExpressionsKt.putArgument($this$putArgument, ((IrFunctionSymbol)$this$putArgument.getSymbol()).getOwner(), parameter2, argument2);
    }

    public static final void putElement(@NotNull IrVararg $this$putElement, int i, @NotNull IrVarargElement element2) {
        Intrinsics.checkNotNullParameter($this$putElement, "<this>");
        Intrinsics.checkNotNullParameter(element2, "element");
        $this$putElement.getElements().set(i, element2);
    }

    public static final void addElement(@NotNull IrVararg $this$addElement, @NotNull IrVarargElement varargElement) {
        Intrinsics.checkNotNullParameter($this$addElement, "<this>");
        Intrinsics.checkNotNullParameter(varargElement, "varargElement");
        $this$addElement.getElements().add(varargElement);
    }

    public static final void addArgument(@NotNull IrStringConcatenation $this$addArgument, @NotNull IrExpression argument2) {
        Intrinsics.checkNotNullParameter($this$addArgument, "<this>");
        Intrinsics.checkNotNullParameter(argument2, "argument");
        $this$addArgument.getArguments().add(argument2);
    }

    public static final boolean isTransparentScope(@NotNull IrContainerExpression $this$isTransparentScope) {
        Intrinsics.checkNotNullParameter($this$isTransparentScope, "<this>");
        return $this$isTransparentScope instanceof IrComposite;
    }

    @NotNull
    public static final IrExpression implicitCastTo(@NotNull IrExpression $this$implicitCastTo, @Nullable IrType expectedType) {
        Intrinsics.checkNotNullParameter($this$implicitCastTo, "<this>");
        if (expectedType == null) {
            return $this$implicitCastTo;
        }
        return new IrTypeOperatorCallImpl($this$implicitCastTo.getStartOffset(), $this$implicitCastTo.getEndOffset(), expectedType, IrTypeOperator.IMPLICIT_CAST, expectedType, $this$implicitCastTo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isUnchanging(@NotNull IrExpression $this$isUnchanging) {
        Intrinsics.checkNotNullParameter($this$isUnchanging, "<this>");
        if ($this$isUnchanging instanceof IrFunctionExpression) return true;
        if ($this$isUnchanging instanceof IrCallableReference && ((IrCallableReference)$this$isUnchanging).getDispatchReceiver() == null) {
            if (((IrCallableReference)$this$isUnchanging).getExtensionReceiver() == null) return true;
        }
        if ($this$isUnchanging instanceof IrClassReference) return true;
        if ($this$isUnchanging instanceof IrConst) return true;
        if (!($this$isUnchanging instanceof IrGetValue)) return false;
        IrValueDeclaration it = ((IrGetValue)$this$isUnchanging).getSymbol().getOwner();
        boolean bl = false;
        if (!(it instanceof IrVariable)) return true;
        if (!((IrVariable)it).isVar()) return true;
        return false;
    }

    public static final boolean hasNoSideEffects(@NotNull IrExpression $this$hasNoSideEffects) {
        Intrinsics.checkNotNullParameter($this$hasNoSideEffects, "<this>");
        return IrExpressionsKt.isUnchanging($this$hasNoSideEffects) || $this$hasNoSideEffects instanceof IrGetValue;
    }

    /*
     * WARNING - void declaration
     */
    public static final void checkArgumentSlotAccess(@NotNull IrMemberAccessExpression<?> $this$checkArgumentSlotAccess, @NotNull String kind, int index2, int total) {
        block2: {
            Object object;
            StringBuilder stringBuilder;
            block4: {
                block3: {
                    void it;
                    Intrinsics.checkNotNullParameter($this$checkArgumentSlotAccess, "<this>");
                    Intrinsics.checkNotNullParameter(kind, "kind");
                    if (index2 < total) break block2;
                    stringBuilder = new StringBuilder().append("No such ").append(kind).append(" argument slot in ").append($this$checkArgumentSlotAccess.getClass().getSimpleName()).append(": ").append(index2).append(" (total=").append(total).append(')');
                    object = $this$checkArgumentSlotAccess.getSymbol().getSignature();
                    if (object == null) break block3;
                    IdSignature idSignature = object;
                    StringBuilder stringBuilder2 = stringBuilder;
                    boolean bl = false;
                    String string2 = ".\nSymbol: " + it;
                    stringBuilder = stringBuilder2;
                    object = string2;
                    if (string2 != null) break block4;
                }
                object = "";
            }
            String string3 = stringBuilder.append((String)object).toString();
            throw new AssertionError((Object)string3);
        }
    }

    public static final void copyTypeArgumentsFrom(@NotNull IrMemberAccessExpression<?> $this$copyTypeArgumentsFrom, @NotNull IrMemberAccessExpression<?> other, int shift) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$copyTypeArgumentsFrom, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        boolean bl2 = bl = $this$copyTypeArgumentsFrom.getTypeArgumentsCount() == other.getTypeArgumentsCount() + shift;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Mismatching type arguments: " + $this$copyTypeArgumentsFrom.getTypeArgumentsCount() + " vs " + other.getTypeArgumentsCount() + " + " + shift;
            throw new AssertionError((Object)string2);
        }
        int n = other.getTypeArgumentsCount();
        for (int i = 0; i < n; ++i) {
            $this$copyTypeArgumentsFrom.putTypeArgument(i + shift, other.getTypeArgument(i));
        }
    }

    public static /* synthetic */ void copyTypeArgumentsFrom$default(IrMemberAccessExpression irMemberAccessExpression, IrMemberAccessExpression irMemberAccessExpression2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        IrExpressionsKt.copyTypeArgumentsFrom(irMemberAccessExpression, irMemberAccessExpression2, n);
    }

    public static final int getTypeParametersCount(@NotNull CallableDescriptor $this$typeParametersCount) {
        Intrinsics.checkNotNullParameter($this$typeParametersCount, "<this>");
        return $this$typeParametersCount instanceof PropertyAccessorDescriptor ? ((PropertyAccessorDescriptor)$this$typeParametersCount).getCorrespondingProperty().getTypeParameters().size() : $this$typeParametersCount.getTypeParameters().size();
    }

    public static final void putArgument(@NotNull IrMemberAccessExpression<?> $this$putArgument, @NotNull IrFunction callee, @NotNull IrValueParameter parameter2, @NotNull IrExpression argument2) {
        Intrinsics.checkNotNullParameter($this$putArgument, "<this>");
        Intrinsics.checkNotNullParameter(callee, "callee");
        Intrinsics.checkNotNullParameter(parameter2, "parameter");
        Intrinsics.checkNotNullParameter(argument2, "argument");
        IrValueParameter irValueParameter = parameter2;
        if (Intrinsics.areEqual(irValueParameter, callee.getDispatchReceiverParameter())) {
            $this$putArgument.setDispatchReceiver(argument2);
        } else if (Intrinsics.areEqual(irValueParameter, callee.getExtensionReceiverParameter())) {
            $this$putArgument.setExtensionReceiver(argument2);
        } else {
            $this$putArgument.putValueArgument(parameter2.getIndex(), argument2);
        }
    }
}

