/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeObjCNameChecker;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J2\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\u0012\u001a\u00020\u0013*\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00140\u0014H\u0002J\u001c\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u000f*\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameOverridesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "firTypeScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "memberSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "declarationToReport", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "allNamesEquals", "", "", "Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameChecker$ObjCName;", "getFirstBaseSymbol", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeObjCNameOverridesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeObjCNameOverridesChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameOverridesChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1549#2:76\n1620#2,3:77\n1603#2,9:80\n1855#2:89\n1856#2:91\n1612#2:92\n1#3:90\n*S KotlinDebug\n*F\n+ 1 FirNativeObjCNameOverridesChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameOverridesChecker\n*L\n47#1:76\n47#1:77,3\n49#1:80,9\n49#1:89\n49#1:91\n49#1:92\n49#1:90\n*E\n"})
public final class FirNativeObjCNameOverridesChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirNativeObjCNameOverridesChecker INSTANCE = new FirNativeObjCNameOverridesChecker();

    private FirNativeObjCNameOverridesChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirTypeScope firTypeScope = FirHelpersKt.unsubstitutedScope(declaration2, context2);
        FirContainingNamesAwareScopeKt.processAllFunctions(firTypeScope, (Function1<? super FirNamedFunctionSymbol, Unit>)new Function1<FirNamedFunctionSymbol, Unit>(firTypeScope, declaration2, context2, reporter){
            final /* synthetic */ FirTypeScope $firTypeScope;
            final /* synthetic */ FirClass $declaration;
            final /* synthetic */ CheckerContext $context;
            final /* synthetic */ DiagnosticReporter $reporter;
            {
                this.$firTypeScope = $firTypeScope;
                this.$declaration = $declaration;
                this.$context = $context;
                this.$reporter = $reporter;
                super(1);
            }

            public final void invoke(@NotNull FirNamedFunctionSymbol symbol2) {
                Intrinsics.checkNotNullParameter(symbol2, "symbol");
                if (!ClassMembersKt.isIntersectionOverride(symbol2)) {
                    return;
                }
                FirNativeObjCNameOverridesChecker.INSTANCE.check(this.$firTypeScope, symbol2, this.$declaration, this.$context, this.$reporter);
            }
        });
        FirContainingNamesAwareScopeKt.processAllProperties(firTypeScope, new Function1<FirVariableSymbol<?>, Unit>(firTypeScope, declaration2, context2, reporter){
            final /* synthetic */ FirTypeScope $firTypeScope;
            final /* synthetic */ FirClass $declaration;
            final /* synthetic */ CheckerContext $context;
            final /* synthetic */ DiagnosticReporter $reporter;
            {
                this.$firTypeScope = $firTypeScope;
                this.$declaration = $declaration;
                this.$context = $context;
                this.$reporter = $reporter;
                super(1);
            }

            public final void invoke(@NotNull FirVariableSymbol<?> symbol2) {
                Intrinsics.checkNotNullParameter(symbol2, "symbol");
                if (!ClassMembersKt.isIntersectionOverride((FirCallableSymbol)symbol2)) {
                    return;
                }
                FirNativeObjCNameOverridesChecker.INSTANCE.check(this.$firTypeScope, (FirCallableSymbol)symbol2, this.$declaration, this.$context, this.$reporter);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final void check(@NotNull FirTypeScope firTypeScope, @NotNull FirCallableSymbol<?> memberSymbol, @NotNull FirDeclaration declarationToReport, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(firTypeScope, "firTypeScope");
        Intrinsics.checkNotNullParameter(memberSymbol, "memberSymbol");
        Intrinsics.checkNotNullParameter(declarationToReport, "declarationToReport");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        List<FirCallableSymbol<?>> overriddenSymbols2 = FirTypeScopeKt.retrieveDirectOverriddenOf(firTypeScope, memberSymbol);
        if (overriddenSymbols2.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = overriddenSymbols2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirCallableSymbol firCallableSymbol = (FirCallableSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FirNativeObjCNameChecker.INSTANCE.getObjCNames((FirBasedSymbol)INSTANCE.getFirstBaseSymbol((FirCallableSymbol<?>)it, firTypeScope), context2.getSession()));
        }
        List objCNames = (List)destination$iv$iv;
        if (!this.allNamesEquals(objCNames)) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = overriddenSymbols2;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FirRegularClassSymbol it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                FirCallableSymbol it = (FirCallableSymbol)element$iv$iv;
                boolean bl2 = false;
                ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(it);
                if ((coneClassLikeLookupTag != null ? LookupTagUtilsKt.toFirRegularClassSymbol(coneClassLikeLookupTag, context2.getSession()) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List containingDeclarations2 = (List)destination$iv$iv2;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declarationToReport.getSource(), FirNativeErrors.INSTANCE.getINCOMPATIBLE_OBJC_NAME_OVERRIDE(), declarationToReport.getSymbol(), (Object)containingDeclarations2, (DiagnosticContext)context2, null, 32, null);
        }
    }

    private final FirCallableSymbol<?> getFirstBaseSymbol(FirCallableSymbol<?> $this$getFirstBaseSymbol, FirTypeScope firTypeScope) {
        List<FirCallableSymbol<?>> overriddenMemberSymbols = FirTypeScopeKt.retrieveDirectOverriddenOf(firTypeScope, $this$getFirstBaseSymbol);
        return overriddenMemberSymbols.isEmpty() ? $this$getFirstBaseSymbol : this.getFirstBaseSymbol(CollectionsKt.first(overriddenMemberSymbols), firTypeScope);
    }

    private final boolean allNamesEquals(List<? extends List<FirNativeObjCNameChecker.ObjCName>> $this$allNamesEquals) {
        List<FirNativeObjCNameChecker.ObjCName> first = $this$allNamesEquals.get(0);
        int n = $this$allNamesEquals.size();
        for (int i = 1; i < n; ++i) {
            if (Intrinsics.areEqual(first, $this$allNamesEquals.get(i))) continue;
            return false;
        }
        return true;
    }
}

