/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsModuleCheckUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsModuleChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkSuperClass", "isEitherModuleOrNonModule", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsModuleChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsModuleChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsModuleChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n288#2,2:60\n*S KotlinDebug\n*F\n+ 1 FirJsModuleChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsModuleChecker\n*L\n50#1:60,2\n*E\n"})
public final class FirJsModuleChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsModuleChecker INSTANCE = new FirJsModuleChecker();

    private FirJsModuleChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object object;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        this.checkSuperClass(declaration2, context2, reporter);
        if (declaration2 instanceof FirFile || !this.isEitherModuleOrNonModule(declaration2, context2.getSession())) {
            return;
        }
        if (declaration2 instanceof FirProperty && ((FirProperty)declaration2).isVar()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJsErrors.INSTANCE.getJS_MODULE_PROHIBITED_ON_VAR(), (DiagnosticContext)context2, null, 8, null);
        }
        if ((object = FirHelpersKt.closestNonLocalWith(context2, declaration2)) == null || (object = ((FirDeclaration)object).getSymbol()) == null) {
            return;
        }
        Object closestNonLocal = object;
        if (!FirJsHelpersKt.isNativeObject(closestNonLocal, context2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJsErrors.INSTANCE.getJS_MODULE_PROHIBITED_ON_NON_NATIVE(), (DiagnosticContext)context2, null, 8, null);
        }
        if (FirHelpersKt.isTopLevel(context2)) {
            FirFile firFile = context2.getContainingFile();
            boolean bl = firFile != null ? this.isEitherModuleOrNonModule(firFile, context2.getSession()) : false;
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJsErrors.INSTANCE.getNESTED_JS_MODULE_PROHIBITED(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    private final void checkSuperClass(FirDeclaration declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        Object v3;
        Object superClassSymbol;
        block4: {
            FirClass firClass = declaration2 instanceof FirClass ? (FirClass)declaration2 : null;
            if (firClass == null) {
                return;
            }
            FirClass classDeclaration = firClass;
            Object object = FirJsHelpersKt.superClassNotAny(classDeclaration, context2.getSession());
            if (object == null || (object = TypeUtilsKt.toSymbol((ConeClassLikeType)object, context2.getSession())) == null) {
                return;
            }
            superClassSymbol = object;
            Iterable $this$firstOrNull$iv = classDeclaration.getSuperTypeRefs();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirTypeRef it = (FirTypeRef)element$iv;
                boolean bl = false;
                ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeTypeOrNull(it);
                if (!Intrinsics.areEqual(coneKotlinType != null ? TypeUtilsKt.toSymbol(coneKotlinType, context2.getSession()) : null, superClassSymbol)) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        FirTypeRef superClassRef = v3;
        FirBasedSymbol firBasedSymbol = (FirBasedSymbol)superClassSymbol;
        Object object = superClassRef;
        if (object == null || (object = ((FirTypeRef)object).getSource()) == null) {
            object = declaration2.getSource();
        }
        FirJsModuleCheckUtilsKt.checkJsModuleUsage(firBasedSymbol, context2, reporter, (AbstractKtSourceElement)object);
    }

    private final boolean isEitherModuleOrNonModule(FirDeclaration $this$isEitherModuleOrNonModule, FirSession session) {
        return FirAnnotationUtilsKt.hasAnnotation($this$isEitherModuleOrNonModule, JsStandardClassIds.Annotations.JsModule, session) || FirAnnotationUtilsKt.hasAnnotation($this$isEitherModuleOrNonModule, JsStandardClassIds.Annotations.JsNonModule, session);
    }
}

