/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.diagnostics.PositioningStrategies$DOT_BY_QUALIFIED$1$mark$lambda$1$;
import org.jetbrains.kotlin.diagnostics.PositioningStrategy;
import org.jetbrains.kotlin.diagnostics.PositioningStrategyKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBackingField;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImpl;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\b\u009d\u0001\u009e\u0001\u009f\u0001\u00a0\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0095\u0001\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0016\u0010\u0096\u0001\u001a\f\u0012\u0007\b\u0001\u0012\u00030\u0098\u00010\u0097\u0001\"\u00030\u0098\u0001H\u0007\u00a2\u0006\u0003\u0010\u0099\u0001J\u000f\u0010\u009a\u0001\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007J\u0010\u0010\u009b\u0001\u001a\u0004\u0018\u00010\u0019*\u00030\u009c\u0001H\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0002\u001a\u0004\b\u0015\u0010\tR\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\tR\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\tR\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00102\u001a\b\u0012\u0004\u0012\u0002030\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00105\u001a\b\u0012\u0004\u0012\u0002060\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00107\u001a\b\u0012\u0004\u0012\u0002080\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010?\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\tR\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00190\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010\tR\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00190\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010J\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010\tR\u0016\u0010L\u001a\b\u0012\u0004\u0012\u00020M0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010\tR\u0016\u0010P\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010Q\u001a\b\u0012\u0004\u0012\u00020R0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010S\u001a\b\u0012\u0004\u0012\u00020T0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010V\u001a\b\u0012\u0004\u0012\u00020W0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010\tR\u0016\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010[\u001a\b\u0012\u0004\u0012\u00020\\0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010]\u001a\b\u0012\u0004\u0012\u00020\\0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010^\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010_\u001a\b\u0012\u0004\u0012\u00020`0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bb\u0010\tR\u0016\u0010c\u001a\b\u0012\u0004\u0012\u00020'0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010d\u001a\b\u0012\u0004\u0012\u00020e0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010f\u001a\b\u0012\u0004\u0012\u00020'0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010g\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bh\u0010\tR\u0017\u0010i\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bj\u0010\tR\u0017\u0010k\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bl\u0010\tR\u0016\u0010m\u001a\b\u0012\u0004\u0012\u00020n0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010o\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010p\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010q\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\br\u0010\tR\u0016\u0010s\u001a\b\u0012\u0004\u0012\u00020W0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010t\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bu\u0010\tR\u0016\u0010v\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010w\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010x\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010y\u001a\b\u0012\u0004\u0012\u00020z0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010{\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b|\u0010\tR\u0016\u0010}\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010~\u001a\b\u0012\u0004\u0012\u00020\u007f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0080\u0001\u001a\b\u0012\u0004\u0012\u00020\u007f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u00020\u00190\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0082\u0001\u001a\b\u0012\u0004\u0012\u00020\u00190\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0083\u0001\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0084\u0001\u001a\t\u0012\u0005\u0012\u00030\u0085\u00010\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0086\u0001\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0087\u0001\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0088\u0001\u001a\t\u0012\u0005\u0012\u00030\u0089\u00010\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u008a\u0001\u001a\t\u0012\u0005\u0012\u00030\u008b\u00010\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u008c\u0001\u001a\b\u0012\u0004\u0012\u00020\u00190\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008d\u0001\u0010\tR\u001b\u0010\u008e\u0001\u001a\t0\u008f\u0001\u00a2\u0006\u0003\b\u0090\u0001\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0091\u0001\u0010\u0092\u0001R\u001b\u0010\u0093\u0001\u001a\t0\u008f\u0001\u00a2\u0006\u0003\b\u0090\u0001\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0094\u0001\u0010\u0092\u0001\u00a8\u0006\u00a1\u0001"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies;", "", "()V", "ABSTRACT_MODIFIER", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "ANNOTATION_USE_SITE", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "getANNOTATION_USE_SITE", "()Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "ARRAY_ACCESS", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "AS_TYPE", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "CALL_ELEMENT", "Lcom/intellij/psi/PsiElement;", "CALL_ELEMENT_WITH_DOT", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "CALL_EXPRESSION", "COMMAS", "getCOMMAS$annotations", "getCOMMAS", "COMPANION_OBJECT", "CONST_MODIFIER", "CUT_CHAR_QUOTES", "Lorg/jetbrains/kotlin/psi/KtElement;", "DATA_MODIFIER", "DECLARATION_NAME", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "DECLARATION_NAME_ONLY", "DECLARATION_RETURN_TYPE", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "DECLARATION_SIGNATURE", "DECLARATION_SIGNATURE_OR_DEFAULT", "DECLARATION_START_TO_NAME", "DECLARATION_WITH_BODY", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "DEFAULT", "DELEGATED_SUPERTYPE_BY_KEYWORD", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "getDELEGATED_SUPERTYPE_BY_KEYWORD", "DELEGATOR_SUPER_CALL", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "DOT_BY_QUALIFIED", "getDOT_BY_QUALIFIED", "ELSE_ENTRY", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "ENUM_MODIFIER", "EXPECT_ACTUAL_MODIFIER", "EXTERNAL_MODIFIER", "FIELD_KEYWORD", "Lorg/jetbrains/kotlin/psi/KtBackingField;", "FOR_REDECLARATION", "FOR_UNRESOLVED_REFERENCE", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "FUNCTION_PARAMETERS", "Lorg/jetbrains/kotlin/psi/KtFunction;", "FUN_INTERFACE", "FUN_MODIFIER", "IF_EXPRESSION", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "IMPORT_ALIAS", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "IMPORT_LAST_NAME", "getIMPORT_LAST_NAME", "INLINE_FUN_MODIFIER", "INLINE_OR_VALUE_MODIFIER", "INLINE_PARAMETER_MODIFIER", "INNER_MODIFIER", "LABEL", "getLABEL", "LATEINIT_MODIFIER", "LONG_LITERAL_SUFFIX", "MODALITY_MODIFIER", "NAME_IDENTIFIER", "getNAME_IDENTIFIER", "NAME_OF_NAMED_ARGUMENT", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "NON_FINAL_MODIFIER_OR_NAME", "getNON_FINAL_MODIFIER_OR_NAME", "NOT_SUPPORTED_IN_INLINE_MOST_RELEVANT", "NULLABLE_TYPE", "Lorg/jetbrains/kotlin/psi/KtNullableType;", "OBJECT_KEYWORD", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "OPEN_MODIFIER", "OPERATOR", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getOPERATOR", "OPERATOR_MODIFIER", "OVERRIDE_MODIFIER", "PARAMETER_DEFAULT_VALUE", "Lorg/jetbrains/kotlin/psi/KtParameter;", "PARAMETER_VARARG_MODIFIER", "PRIVATE_MODIFIER", "PROPERTY_DELEGATE", "Lorg/jetbrains/kotlin/psi/KtProperty;", "PROPERTY_INITIALIZER", "getPROPERTY_INITIALIZER", "QUESTION_MARK_BY_TYPE", "RECEIVER", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "REDUNDANT_NULLABLE", "REFERENCED_NAME_BY_QUALIFIED", "getREFERENCED_NAME_BY_QUALIFIED", "REFERENCE_BY_QUALIFIED", "getREFERENCE_BY_QUALIFIED", "REIFIED_MODIFIER", "getREIFIED_MODIFIER", "RETURN_WITH_LABEL", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "SAFE_ACCESS", "SECONDARY_CONSTRUCTOR_DELEGATION_CALL", "SELECTOR_BY_QUALIFIED", "getSELECTOR_BY_QUALIFIED", "SPECIAL_CONSTRUCT_TOKEN", "SPREAD_OPERATOR", "getSPREAD_OPERATOR", "SUPERTYPES_LIST", "SUSPEND_MODIFIER", "TAILREC_MODIFIER", "TYPEALIAS_TYPE_REFERENCE", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "TYPE_PARAMETERS_LIST", "getTYPE_PARAMETERS_LIST", "TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE", "UNUSED_VALUE", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "USELESS_ELVIS", "VALUE_ARGUMENTS", "VALUE_ARGUMENTS_LIST", "VAL_OR_VAR_NODE", "VARIANCE_IN_PROJECTION", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "VARIANCE_MODIFIER", "VISIBILITY_MODIFIER", "WHEN_CONDITION_IN_RANGE", "Lorg/jetbrains/kotlin/psi/KtWhenConditionInRange;", "WHEN_EXPRESSION", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "WHOLE_ELEMENT", "getWHOLE_ELEMENT", "classKindTokens", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getClassKindTokens", "()Lcom/intellij/psi/tree/TokenSet;", "propertyKindTokens", "getPropertyKindTokens", "modifierSetPosition", "tokens", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "([Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "projectionPosition", "getReferencedTypeExpression", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "DeclarationHeader", "FindReferencePositioningStrategy", "InlineFunPositioningStrategy", "ModifierSetBasedPositioningStrategy", "frontend.common-psi"})
public final class PositioningStrategies {
    @NotNull
    public static final PositioningStrategies INSTANCE = new PositioningStrategies();
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> DEFAULT = new PositioningStrategy<PsiElement>(){

        @NotNull
        public List<TextRange> mark(@NotNull PsiElement element2) {
            Intrinsics.checkNotNullParameter(element2, "element");
            PsiElement psiElement = element2;
            if (psiElement instanceof KtObjectLiteralExpression) {
                KtObjectDeclaration ktObjectDeclaration = ((KtObjectLiteralExpression)element2).getObjectDeclaration();
                Intrinsics.checkNotNullExpressionValue(ktObjectDeclaration, "getObjectDeclaration(...)");
                KtObjectDeclaration objectDeclaration = ktObjectDeclaration;
                PsiElement psiElement2 = objectDeclaration.getObjectKeyword();
                Intrinsics.checkNotNull(psiElement2);
                PsiElement objectKeyword = psiElement2;
                KtSuperTypeList ktSuperTypeList = objectDeclaration.getSuperTypeList();
                if (ktSuperTypeList == null) {
                    return PositioningStrategyKt.markElement(objectKeyword);
                }
                KtSuperTypeList delegationSpecifierList = ktSuperTypeList;
                return PositioningStrategyKt.markRange(objectKeyword, delegationSpecifierList);
            }
            if (psiElement instanceof KtObjectDeclaration) {
                PsiElement psiElement3 = ((KtObjectDeclaration)element2).getObjectKeyword();
                Intrinsics.checkNotNull(psiElement3);
                PsiElement psiElement4 = ((KtObjectDeclaration)element2).getNameIdentifier();
                if (psiElement4 == null) {
                    PsiElement psiElement5 = ((KtObjectDeclaration)element2).getObjectKeyword();
                    psiElement4 = psiElement5;
                    Intrinsics.checkNotNull(psiElement5);
                }
                PsiElement psiElement6 = psiElement4;
                Intrinsics.checkNotNull(psiElement6);
                return PositioningStrategyKt.markRange(psiElement3, psiElement6);
            }
            if (psiElement instanceof KtConstructorDelegationCall) {
                return PositioningStrategies.SECONDARY_CONSTRUCTOR_DELEGATION_CALL.mark(element2);
            }
            return super.mark(element2);
        }
    };
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> SUPERTYPES_LIST = new PositioningStrategy<PsiElement>(){

        @NotNull
        public List<TextRange> mark(@NotNull PsiElement element2) {
            Intrinsics.checkNotNullParameter(element2, "element");
            KtClass ktClass = element2 instanceof KtClass ? (KtClass)element2 : null;
            if (ktClass == null) {
                return PositioningStrategyKt.markElement(element2);
            }
            List<KtSuperTypeListEntry> supertypes2 = ktClass.getSuperTypeListEntries();
            return supertypes2.isEmpty() ? PositioningStrategyKt.markElement(element2) : PositioningStrategyKt.markRange(supertypes2.get(0), CollectionsKt.last(supertypes2));
        }
    };
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_RETURN_TYPE = new PositioningStrategy<KtDeclaration>(){

        @NotNull
        public List<TextRange> mark(@NotNull KtDeclaration element2) {
            Intrinsics.checkNotNullParameter(element2, "element");
            return PositioningStrategyKt.markElement(this.getElementToMark(element2));
        }

        public boolean isValid(@NotNull KtDeclaration element2) {
            Intrinsics.checkNotNullParameter(element2, "element");
            return !PositioningStrategyKt.hasSyntaxErrors(this.getElementToMark(element2));
        }

        private final PsiElement getElementToMark(KtDeclaration declaration2) {
            KtDeclaration ktDeclaration2 = declaration2;
            Pair<KtTypeReference, PsiElement> pair = ktDeclaration2 instanceof KtCallableDeclaration ? new Pair<KtTypeReference, PsiElement>(((KtCallableDeclaration)declaration2).getTypeReference(), ((KtCallableDeclaration)declaration2).getNameIdentifier()) : (ktDeclaration2 instanceof KtPropertyAccessor ? new Pair<KtTypeReference, PsiElement>(((KtPropertyAccessor)declaration2).getReturnTypeReference(), ((KtPropertyAccessor)declaration2).getNamePlaceholder()) : new Pair<Object, Object>(null, null));
            KtTypeReference returnTypeRef = pair.component1();
            PsiElement nameIdentifierOrPlaceholder = pair.component2();
            if (returnTypeRef != null) {
                return returnTypeRef;
            }
            if (nameIdentifierOrPlaceholder != null) {
                return nameIdentifierOrPlaceholder;
            }
            return declaration2;
        }
    };
    @NotNull
    private static final TokenSet propertyKindTokens;
    @NotNull
    private static final TokenSet classKindTokens;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_START_TO_NAME;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> DECLARATION_NAME;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> DECLARATION_NAME_ONLY;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_SIGNATURE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> DECLARATION_SIGNATURE_OR_DEFAULT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> NOT_SUPPORTED_IN_INLINE_MOST_RELEVANT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> ABSTRACT_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> OPEN_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> OVERRIDE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> PRIVATE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> LATEINIT_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> VARIANCE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> CONST_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> FUN_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> SUSPEND_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> DATA_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> OPERATOR_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> ENUM_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> TAILREC_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> EXTERNAL_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> EXPECT_ACTUAL_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtObjectDeclaration> OBJECT_KEYWORD;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBackingField> FIELD_KEYWORD;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtProperty> PROPERTY_DELEGATE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> FOR_REDECLARATION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtReferenceExpression> FOR_UNRESOLVED_REFERENCE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtArrayAccessExpression> ARRAY_ACCESS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> SAFE_ACCESS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> VISIBILITY_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> MODALITY_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> INLINE_OR_VALUE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> INNER_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> INLINE_PARAMETER_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> INLINE_FUN_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtTypeProjection> VARIANCE_IN_PROJECTION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtParameter> PARAMETER_DEFAULT_VALUE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtParameter> PARAMETER_VARARG_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtValueArgument> NAME_OF_NAMED_ARGUMENT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> CALL_ELEMENT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtQualifiedExpression> CALL_ELEMENT_WITH_DOT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclarationWithBody> DECLARATION_WITH_BODY;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> VAL_OR_VAR_NODE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenEntry> ELSE_ENTRY;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenExpression> WHEN_EXPRESSION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtIfExpression> IF_EXPRESSION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenConditionInRange> WHEN_CONDITION_IN_RANGE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtExpression> SPECIAL_CONSTRUCT_TOKEN;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtTypeReference> REDUNDANT_NULLABLE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNullableType> NULLABLE_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtTypeReference> QUESTION_MARK_BY_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> CALL_EXPRESSION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> VALUE_ARGUMENTS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> VALUE_ARGUMENTS_LIST;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtFunction> FUNCTION_PARAMETERS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> CUT_CHAR_QUOTES;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> LONG_LITERAL_SUFFIX;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpressionWithTypeRHS> AS_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> COMPANION_OBJECT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> SECONDARY_CONSTRUCTOR_DELEGATION_CALL;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtEnumEntry> DELEGATOR_SUPER_CALL;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpression> UNUSED_VALUE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpression> USELESS_ELVIS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtImportDirective> IMPORT_ALIAS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtReturnExpression> RETURN_WITH_LABEL;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtCallableDeclaration> RECEIVER;
    @NotNull
    private static final PositioningStrategy<KtExpression> OPERATOR;
    @NotNull
    private static final PositioningStrategy<PsiElement> DOT_BY_QUALIFIED;
    @NotNull
    private static final PositioningStrategy<PsiElement> SELECTOR_BY_QUALIFIED;
    @NotNull
    private static final PositioningStrategy<PsiElement> NAME_IDENTIFIER;
    @NotNull
    private static final PositioningStrategy<PsiElement> SPREAD_OPERATOR;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> FUN_INTERFACE;
    @NotNull
    private static final PositioningStrategy<PsiElement> REFERENCE_BY_QUALIFIED;
    @NotNull
    private static final PositioningStrategy<PsiElement> REFERENCED_NAME_BY_QUALIFIED;
    @NotNull
    private static final PositioningStrategy<KtModifierListOwner> REIFIED_MODIFIER;
    @NotNull
    private static final PositioningStrategy<KtNamedDeclaration> PROPERTY_INITIALIZER;
    @NotNull
    private static final PositioningStrategy<KtElement> WHOLE_ELEMENT;
    @NotNull
    private static final PositioningStrategy<KtDeclaration> TYPE_PARAMETERS_LIST;
    @NotNull
    private static final PositioningStrategy<KtAnnotationEntry> ANNOTATION_USE_SITE;
    @NotNull
    private static final PositioningStrategy<PsiElement> IMPORT_LAST_NAME;
    @NotNull
    private static final PositioningStrategy<KtElement> LABEL;
    @NotNull
    private static final PositioningStrategy<PsiElement> COMMAS;
    @NotNull
    private static final PositioningStrategy<KtModifierListOwner> NON_FINAL_MODIFIER_OR_NAME;
    @NotNull
    private static final PositioningStrategy<KtTypeReference> DELEGATED_SUPERTYPE_BY_KEYWORD;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtTypeAlias> TYPEALIAS_TYPE_REFERENCE;

    private PositioningStrategies() {
    }

    @NotNull
    public final TokenSet getPropertyKindTokens() {
        return propertyKindTokens;
    }

    @NotNull
    public final TokenSet getClassKindTokens() {
        return classKindTokens;
    }

    @JvmStatic
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> modifierSetPosition(KtModifierKeywordToken ... tokens) {
        Intrinsics.checkNotNullParameter(tokens, "tokens");
        return new PositioningStrategy<KtModifierListOwner>(tokens){
            final /* synthetic */ KtModifierKeywordToken[] $tokens;
            {
                this.$tokens = $tokens;
            }

            @NotNull
            public List<TextRange> mark(@NotNull KtModifierListOwner element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                KtModifierList ktModifierList = element2.getModifierList();
                if (ktModifierList == null) {
                    return PositioningStrategies.DEFAULT.mark(element2);
                }
                KtModifierList modifierList2 = ktModifierList;
                for (KtModifierKeywordToken token : this.$tokens) {
                    PsiElement modifier = modifierList2.getModifier(token);
                    if (modifier == null) continue;
                    return PositioningStrategyKt.markElement(modifier);
                }
                return PositioningStrategies.DEFAULT.mark(element2);
            }
        };
    }

    @JvmStatic
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> projectionPosition() {
        return new PositioningStrategy<KtModifierListOwner>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtModifierListOwner element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                if (element2 instanceof KtTypeProjection && ((KtTypeProjection)element2).getProjectionKind() == KtProjectionKind.STAR) {
                    return PositioningStrategyKt.markElement(element2);
                }
                KtModifierList $this$sure$iv = element2.getModifierList();
                boolean $i$f$sure = false;
                KtModifierList ktModifierList = $this$sure$iv;
                if (ktModifierList == null) {
                    boolean bl = false;
                    String string2 = "No modifier list, but modifier has been found by the analyzer";
                    throw new AssertionError((Object)string2);
                }
                Intrinsics.checkNotNullExpressionValue(ktModifierList, "sure(...)");
                KtModifierList modifierList2 = ktModifierList;
                PsiElement psiElement = modifierList2.getModifier(KtTokens.IN_KEYWORD);
                if (psiElement != null) {
                    PsiElement it = psiElement;
                    boolean bl = false;
                    return PositioningStrategyKt.markElement(it);
                }
                psiElement = modifierList2.getModifier(KtTokens.OUT_KEYWORD);
                if (psiElement != null) {
                    PsiElement it = psiElement;
                    boolean bl = false;
                    return PositioningStrategyKt.markElement(it);
                }
                throw new IllegalStateException("None of the modifiers is found: in, out");
            }
        };
    }

    @NotNull
    public final PositioningStrategy<KtExpression> getOPERATOR() {
        return OPERATOR;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getDOT_BY_QUALIFIED() {
        return DOT_BY_QUALIFIED;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getSELECTOR_BY_QUALIFIED() {
        return SELECTOR_BY_QUALIFIED;
    }

    private final KtElement getReferencedTypeExpression(KtTypeElement $this$getReferencedTypeExpression) {
        KtElement ktElement;
        KtTypeElement ktTypeElement = $this$getReferencedTypeExpression;
        if (ktTypeElement instanceof KtUserType) {
            ktElement = ((KtUserType)$this$getReferencedTypeExpression).getReferenceExpression();
        } else if (ktTypeElement instanceof KtNullableType) {
            KtTypeElement ktTypeElement2 = ((KtNullableType)$this$getReferencedTypeExpression).getInnerType();
            ktElement = ktTypeElement2 != null ? this.getReferencedTypeExpression(ktTypeElement2) : null;
        } else {
            ktElement = null;
        }
        return ktElement;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getNAME_IDENTIFIER() {
        return NAME_IDENTIFIER;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getSPREAD_OPERATOR() {
        return SPREAD_OPERATOR;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getREFERENCE_BY_QUALIFIED() {
        return REFERENCE_BY_QUALIFIED;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getREFERENCED_NAME_BY_QUALIFIED() {
        return REFERENCED_NAME_BY_QUALIFIED;
    }

    @NotNull
    public final PositioningStrategy<KtModifierListOwner> getREIFIED_MODIFIER() {
        return REIFIED_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<KtNamedDeclaration> getPROPERTY_INITIALIZER() {
        return PROPERTY_INITIALIZER;
    }

    @NotNull
    public final PositioningStrategy<KtElement> getWHOLE_ELEMENT() {
        return WHOLE_ELEMENT;
    }

    @NotNull
    public final PositioningStrategy<KtDeclaration> getTYPE_PARAMETERS_LIST() {
        return TYPE_PARAMETERS_LIST;
    }

    @NotNull
    public final PositioningStrategy<KtAnnotationEntry> getANNOTATION_USE_SITE() {
        return ANNOTATION_USE_SITE;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getIMPORT_LAST_NAME() {
        return IMPORT_LAST_NAME;
    }

    @NotNull
    public final PositioningStrategy<KtElement> getLABEL() {
        return LABEL;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getCOMMAS() {
        return COMMAS;
    }

    public static /* synthetic */ void getCOMMAS$annotations() {
    }

    @NotNull
    public final PositioningStrategy<KtModifierListOwner> getNON_FINAL_MODIFIER_OR_NAME() {
        return NON_FINAL_MODIFIER_OR_NAME;
    }

    @NotNull
    public final PositioningStrategy<KtTypeReference> getDELEGATED_SUPERTYPE_BY_KEYWORD() {
        return DELEGATED_SUPERTYPE_BY_KEYWORD;
    }

    public static final /* synthetic */ KtElement access$getReferencedTypeExpression(PositioningStrategies $this, KtTypeElement $receiver) {
        return $this.getReferencedTypeExpression($receiver);
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD};
        TokenSet tokenSet = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(tokenSet, "create(...)");
        propertyKindTokens = tokenSet;
        iElementTypeArray = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD, KtTokens.INTERFACE_KEYWORD};
        TokenSet tokenSet2 = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(tokenSet2, "create(...)");
        classKindTokens = tokenSet2;
        DECLARATION_START_TO_NAME = new DeclarationHeader<KtDeclaration>(){

            private final PsiElement firstNonCommentNonAnnotationLeaf(PsiElement $this$firstNonCommentNonAnnotationLeaf) {
                PsiElement leaf;
                PsiElement psiElement = $this$firstNonCommentNonAnnotationLeaf.getFirstChild();
                if (psiElement == null) {
                    return $this$firstNonCommentNonAnnotationLeaf;
                }
                PsiElement child = psiElement;
                while (true) {
                    if (child instanceof PsiComment || child instanceof PsiWhiteSpace || child instanceof KtAnnotationEntry) {
                        child = child.getNextSibling();
                        continue;
                    }
                    if (child == null) {
                        return null;
                    }
                    leaf = this.firstNonCommentNonAnnotationLeaf(child);
                    if (leaf != null) break;
                    child = child.getNextSibling();
                }
                return leaf;
            }

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element2) {
                List<TextRange> list2;
                PsiElement nameIdentifier;
                Intrinsics.checkNotNullParameter(element2, "element");
                PsiElement psiElement = this.firstNonCommentNonAnnotationLeaf(element2);
                if (psiElement == null) {
                    psiElement = element2;
                }
                PsiElement startElement = psiElement;
                KtNamedDeclaration ktNamedDeclaration = element2 instanceof KtNamedDeclaration ? (KtNamedDeclaration)element2 : null;
                PsiElement psiElement2 = nameIdentifier = ktNamedDeclaration != null ? ktNamedDeclaration.getNameIdentifier() : null;
                if (nameIdentifier != null) {
                    list2 = PositioningStrategyKt.markRange(startElement, nameIdentifier);
                } else {
                    KtDeclaration ktDeclaration2 = element2;
                    if (ktDeclaration2 instanceof KtConstructor) {
                        PsiElement psiElement3 = ((KtConstructor)element2).getConstructorKeyword();
                        if (psiElement3 == null) {
                            psiElement3 = element2;
                        }
                        list2 = PositioningStrategyKt.markRange(startElement, psiElement3);
                    } else if (ktDeclaration2 instanceof KtObjectDeclaration) {
                        PsiElement psiElement4 = ((KtObjectDeclaration)element2).getObjectKeyword();
                        if (psiElement4 == null) {
                            psiElement4 = element2;
                        }
                        list2 = PositioningStrategyKt.markRange(startElement, psiElement4);
                    } else {
                        list2 = PositioningStrategies.DEFAULT.mark(element2);
                    }
                }
                return list2;
            }
        };
        DECLARATION_NAME = new DeclarationHeader<KtNamedDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtNamedDeclaration element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                PsiElement nameIdentifier = element2.getNameIdentifier();
                if (nameIdentifier != null) {
                    if (element2 instanceof KtClassOrObject) {
                        PsiElement psiElement = element2.getModifierList();
                        if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.ENUM_KEYWORD)) == null) {
                            IElementType[] iElementTypeArray = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD};
                            ASTNode aSTNode = ((KtClassOrObject)element2).getNode().findChildByType(TokenSet.create(iElementTypeArray));
                            psiElement = aSTNode != null ? aSTNode.getPsi() : null;
                            if (psiElement == null) {
                                psiElement = element2;
                            }
                        }
                        PsiElement startElement = psiElement;
                        return PositioningStrategyKt.markRange(startElement, nameIdentifier);
                    }
                    return PositioningStrategyKt.markElement(nameIdentifier);
                }
                if (element2 instanceof KtNamedFunction) {
                    return PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)((PsiElement)element2));
                }
                return PositioningStrategies.DEFAULT.mark(element2);
            }
        };
        DECLARATION_NAME_ONLY = new DeclarationHeader<KtNamedDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtNamedDeclaration element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                PsiElement nameIdentifier = element2.getNameIdentifier();
                if (nameIdentifier != null) {
                    return PositioningStrategyKt.markElement(nameIdentifier);
                }
                if (element2 instanceof KtNamedFunction) {
                    return PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)((PsiElement)element2));
                }
                return PositioningStrategies.DEFAULT.mark(element2);
            }
        };
        DECLARATION_SIGNATURE = new DeclarationHeader<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                KtDeclaration ktDeclaration2 = element2;
                if (ktDeclaration2 instanceof KtConstructor) {
                    PsiElement psiElement;
                    PsiElement psiElement2 = ((KtConstructor)element2).getConstructorKeyword();
                    if (psiElement2 == null) {
                        KtParameterList ktParameterList = ((KtConstructor)element2).getValueParameterList();
                        if (ktParameterList != null) {
                            psiElement2 = ktParameterList;
                        } else {
                            return PositioningStrategyKt.markElement(element2);
                        }
                    }
                    PsiElement begin = psiElement2;
                    KtParameterList ktParameterList = ((KtConstructor)element2).getValueParameterList();
                    if (ktParameterList != null) {
                        psiElement = ktParameterList;
                    } else {
                        psiElement = ((KtConstructor)element2).getConstructorKeyword();
                        if (psiElement == null) {
                            return PositioningStrategyKt.markElement(element2);
                        }
                    }
                    PsiElement end = psiElement;
                    return PositioningStrategyKt.markRange(begin, end);
                }
                if (ktDeclaration2 instanceof KtFunction) {
                    KtElement ktElement;
                    PsiElement endOfSignatureElement;
                    PsiElement psiElement;
                    KtTypeReference ktTypeReference = ((KtFunction)element2).getTypeReference();
                    if (ktTypeReference != null) {
                        psiElement = ktTypeReference;
                    } else {
                        KtParameterList ktParameterList = ((KtFunction)element2).getValueParameterList();
                        if (ktParameterList != null) {
                            psiElement = ktParameterList;
                        } else {
                            psiElement = ((KtFunction)element2).getNameIdentifier();
                            if (psiElement == null) {
                                psiElement = endOfSignatureElement = (PsiElement)element2;
                            }
                        }
                    }
                    if (element2 instanceof KtFunctionLiteral) {
                        NavigatablePsiElement navigatablePsiElement;
                        KtTypeReference ktTypeReference2 = ((KtFunction)element2).getReceiverTypeReference();
                        if (ktTypeReference2 != null) {
                            navigatablePsiElement = ktTypeReference2;
                        } else {
                            KtParameterList ktParameterList = ((KtFunction)element2).getValueParameterList();
                            navigatablePsiElement = ktParameterList != null ? (NavigatablePsiElement)ktParameterList : (NavigatablePsiElement)element2;
                        }
                        ktElement = (KtElement)navigatablePsiElement;
                    } else {
                        ktElement = element2;
                    }
                    KtElement startElement = ktElement;
                    return PositioningStrategyKt.markRange(startElement, endOfSignatureElement);
                }
                if (ktDeclaration2 instanceof KtProperty) {
                    PsiElement psiElement;
                    KtTypeReference ktTypeReference = ((KtProperty)element2).getTypeReference();
                    if (ktTypeReference != null) {
                        psiElement = ktTypeReference;
                    } else {
                        psiElement = ((KtProperty)element2).getNameIdentifier();
                        if (psiElement == null) {
                            psiElement = element2;
                        }
                    }
                    PsiElement endOfSignatureElement = psiElement;
                    return PositioningStrategyKt.markRange(element2, endOfSignatureElement);
                }
                if (ktDeclaration2 instanceof KtPropertyAccessor) {
                    PsiElement psiElement;
                    KtTypeReference ktTypeReference = ((KtPropertyAccessor)element2).getReturnTypeReference();
                    if (ktTypeReference != null) {
                        psiElement = ktTypeReference;
                    } else {
                        psiElement = ((KtPropertyAccessor)element2).getRightParenthesis();
                        if (psiElement == null) {
                            psiElement = ((KtPropertyAccessor)element2).getNamePlaceholder();
                        }
                    }
                    PsiElement startElement = psiElement;
                    Intrinsics.checkNotNull(startElement);
                    PsiElement endOfSignatureElement = startElement;
                    return PositioningStrategyKt.markRange(element2, endOfSignatureElement);
                }
                if (ktDeclaration2 instanceof KtClass) {
                    PsiElement psiElement = ((KtClass)element2).getNameIdentifier();
                    if (psiElement == null) {
                        return PositioningStrategyKt.markElement(element2);
                    }
                    PsiElement nameAsDeclaration = psiElement;
                    KtParameterList ktParameterList = ((KtClass)element2).getPrimaryConstructorParameterList();
                    if (ktParameterList == null) {
                        return PositioningStrategyKt.markElement(nameAsDeclaration);
                    }
                    KtParameterList primaryConstructorParameterList = ktParameterList;
                    return PositioningStrategyKt.markRange(nameAsDeclaration, primaryConstructorParameterList);
                }
                if (ktDeclaration2 instanceof KtObjectDeclaration) {
                    return PositioningStrategies.DECLARATION_NAME.mark((KtNamedDeclaration)element2);
                }
                if (ktDeclaration2 instanceof KtClassInitializer) {
                    TextRange textRange = ((KtClassInitializer)element2).getInitKeyword().getTextRange();
                    Intrinsics.checkNotNullExpressionValue(textRange, "getTextRange(...)");
                    return PositioningStrategyKt.markRange(textRange);
                }
                return super.mark((PsiElement)element2);
            }
        };
        DECLARATION_SIGNATURE_OR_DEFAULT = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                return element2 instanceof KtDeclaration ? PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)element2) : PositioningStrategies.DEFAULT.mark(element2);
            }

            public boolean isValid(@NotNull PsiElement element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                return element2 instanceof KtDeclaration ? PositioningStrategies.DECLARATION_SIGNATURE.isValid((KtDeclaration)element2) : PositioningStrategies.DEFAULT.isValid(element2);
            }
        };
        NOT_SUPPORTED_IN_INLINE_MOST_RELEVANT = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element2) {
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter(element2, "element");
                KtDeclaration ktDeclaration2 = element2;
                if (ktDeclaration2 instanceof KtClassOrObject) {
                    psiElement = ((KtClassOrObject)element2).getDeclarationKeyword();
                    if (psiElement == null && (psiElement = ((KtClassOrObject)element2).getNameIdentifier()) == null) {
                        psiElement = element2;
                    }
                } else if (ktDeclaration2 instanceof KtNamedFunction) {
                    psiElement = ((KtNamedFunction)element2).getModifierList();
                    if ((psiElement == null || (psiElement = ((KtModifierList)psiElement).getModifier(KtTokens.INLINE_KEYWORD)) == null) && (psiElement = ((KtNamedFunction)element2).getFunKeyword()) == null) {
                        psiElement = element2;
                    }
                } else {
                    psiElement = element2;
                }
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element2) {
                KtTypeParameterList ktTypeParameterList;
                Intrinsics.checkNotNullParameter(element2, "element");
                if (element2 instanceof KtTypeParameterListOwner && (ktTypeParameterList = ((KtTypeParameterListOwner)element2).getTypeParameterList()) != null) {
                    return PositioningStrategyKt.markElement(ktTypeParameterList);
                }
                return PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)((PsiElement)element2));
            }
        };
        IElementType[] iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.ABSTRACT_KEYWORD, "ABSTRACT_KEYWORD");
        ABSTRACT_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.OPEN_KEYWORD, "OPEN_KEYWORD");
        OPEN_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.OVERRIDE_KEYWORD, "OVERRIDE_KEYWORD");
        OVERRIDE_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.PRIVATE_KEYWORD, "PRIVATE_KEYWORD");
        PRIVATE_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.LATEINIT_KEYWORD, "LATEINIT_KEYWORD");
        LATEINIT_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        VARIANCE_MODIFIER = PositioningStrategies.projectionPosition();
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.CONST_KEYWORD, "CONST_KEYWORD");
        CONST_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.FUN_KEYWORD, "FUN_KEYWORD");
        FUN_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.SUSPEND_KEYWORD, "SUSPEND_KEYWORD");
        SUSPEND_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.DATA_KEYWORD, "DATA_KEYWORD");
        DATA_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.OPERATOR_KEYWORD, "OPERATOR_KEYWORD");
        OPERATOR_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.ENUM_KEYWORD, "ENUM_KEYWORD");
        ENUM_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.TAILREC_KEYWORD, "TAILREC_KEYWORD");
        TAILREC_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.EXTERNAL_KEYWORD, "EXTERNAL_KEYWORD");
        EXTERNAL_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[2];
        Intrinsics.checkNotNullExpressionValue(KtTokens.EXPECT_KEYWORD, "EXPECT_KEYWORD");
        Intrinsics.checkNotNullExpressionValue(KtTokens.ACTUAL_KEYWORD, "ACTUAL_KEYWORD");
        EXPECT_ACTUAL_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        OBJECT_KEYWORD = new PositioningStrategy<KtObjectDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtObjectDeclaration element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                PsiElement psiElement = element2.getObjectKeyword();
                if (psiElement == null) {
                    psiElement = element2;
                }
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        FIELD_KEYWORD = new DeclarationHeader<KtBackingField>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtBackingField element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                PsiElement psiElement = element2.getFieldKeyword();
                Intrinsics.checkNotNullExpressionValue(psiElement, "getFieldKeyword(...)");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        PROPERTY_DELEGATE = new DeclarationHeader<KtProperty>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtProperty element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                KtPropertyDelegate delegate = element2.getDelegate();
                return delegate != null ? PositioningStrategyKt.markElement(delegate) : PositioningStrategies.DEFAULT.mark(element2);
            }
        };
        FOR_REDECLARATION = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element2) {
                PsiElement nameIdentifier;
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter(element2, "element");
                PsiElement psiElement2 = element2;
                if (psiElement2 instanceof KtNamedDeclaration) {
                    psiElement = ((KtNamedDeclaration)element2).getNameIdentifier();
                } else if (psiElement2 instanceof KtFile) {
                    KtPackageDirective ktPackageDirective = ((KtFile)element2).getPackageDirective();
                    Intrinsics.checkNotNull(ktPackageDirective);
                    psiElement = ktPackageDirective.getNameIdentifier();
                } else {
                    psiElement = nameIdentifier = null;
                }
                if (nameIdentifier == null && element2 instanceof KtObjectDeclaration) {
                    return PositioningStrategies.DEFAULT.mark(element2);
                }
                PsiElement psiElement3 = nameIdentifier;
                if (psiElement3 == null) {
                    psiElement3 = element2;
                }
                return PositioningStrategyKt.markElement(psiElement3);
            }
        };
        FOR_UNRESOLVED_REFERENCE = new PositioningStrategy<KtReferenceExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtReferenceExpression element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                if (element2 instanceof KtArrayAccessExpression) {
                    List<TextRange> list2 = ((KtArrayAccessExpression)element2).getBracketRanges();
                    Intrinsics.checkNotNullExpressionValue(list2, "getBracketRanges(...)");
                    List<TextRange> ranges = list2;
                    if (!ranges.isEmpty()) {
                        return ranges;
                    }
                }
                return CollectionsKt.listOf(element2.getTextRange());
            }
        };
        ARRAY_ACCESS = new PositioningStrategy<KtArrayAccessExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtArrayAccessExpression element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                KtContainerNode ktContainerNode = element2.getIndicesNode();
                Intrinsics.checkNotNullExpressionValue(ktContainerNode, "getIndicesNode(...)");
                return PositioningStrategyKt.markElement(ktContainerNode);
            }
        };
        SAFE_ACCESS = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                ASTNode aSTNode = element2.getNode().findChildByType(KtTokens.SAFE_ACCESS);
                PsiElement psiElement = aSTNode != null ? aSTNode.getPsi() : null;
                if (psiElement == null) {
                    psiElement = element2;
                }
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        TokenSet tokenSet3 = KtTokens.VISIBILITY_MODIFIERS;
        Intrinsics.checkNotNullExpressionValue(tokenSet3, "VISIBILITY_MODIFIERS");
        VISIBILITY_MODIFIER = new ModifierSetBasedPositioningStrategy(tokenSet3);
        TokenSet tokenSet4 = KtTokens.MODALITY_MODIFIERS;
        Intrinsics.checkNotNullExpressionValue(tokenSet4, "MODALITY_MODIFIERS");
        MODALITY_MODIFIER = new ModifierSetBasedPositioningStrategy(tokenSet4);
        iElementTypeArray2 = new IElementType[2];
        Intrinsics.checkNotNullExpressionValue(KtTokens.INLINE_KEYWORD, "INLINE_KEYWORD");
        Intrinsics.checkNotNullExpressionValue(KtTokens.VALUE_KEYWORD, "VALUE_KEYWORD");
        INLINE_OR_VALUE_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.INNER_KEYWORD, "INNER_KEYWORD");
        INNER_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[2];
        Intrinsics.checkNotNullExpressionValue(KtTokens.NOINLINE_KEYWORD, "NOINLINE_KEYWORD");
        Intrinsics.checkNotNullExpressionValue(KtTokens.CROSSINLINE_KEYWORD, "CROSSINLINE_KEYWORD");
        INLINE_PARAMETER_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        INLINE_FUN_MODIFIER = new InlineFunPositioningStrategy();
        VARIANCE_IN_PROJECTION = new PositioningStrategy<KtTypeProjection>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtTypeProjection element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                PsiElement psiElement = element2.getProjectionToken();
                Intrinsics.checkNotNull(psiElement);
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        PARAMETER_DEFAULT_VALUE = new PositioningStrategy<KtParameter>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtParameter element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                KtExpression ktExpression = element2.getDefaultValue();
                Intrinsics.checkNotNull(ktExpression);
                ASTNode aSTNode = ktExpression.getNode();
                Intrinsics.checkNotNullExpressionValue(aSTNode, "getNode(...)");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        PARAMETER_VARARG_MODIFIER = new PositioningStrategy<KtParameter>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtParameter element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                KtModifierList ktModifierList = element2.getModifierList();
                Intrinsics.checkNotNull(ktModifierList);
                PsiElement psiElement = ktModifierList.getModifier(KtTokens.VARARG_KEYWORD);
                Intrinsics.checkNotNull(psiElement);
                PsiElement varargModifier = psiElement;
                ASTNode aSTNode = varargModifier.getNode();
                Intrinsics.checkNotNullExpressionValue(aSTNode, "getNode(...)");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        NAME_OF_NAMED_ARGUMENT = new PositioningStrategy<KtValueArgument>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtValueArgument element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                KtValueArgumentName ktValueArgumentName = element2.getArgumentName();
                return PositioningStrategyKt.markElement(ktValueArgumentName == null ? (KtElementImplStub)element2 : (KtElementImplStub)ktValueArgumentName);
            }
        };
        CALL_ELEMENT = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                KtCallElement ktCallElement = element2 instanceof KtCallElement ? (KtCallElement)element2 : null;
                KtExpression ktExpression = ktCallElement != null ? ktCallElement.getCalleeExpression() : null;
                return PositioningStrategyKt.markElement(ktExpression == null ? element2 : (PsiElement)ktExpression);
            }
        };
        CALL_ELEMENT_WITH_DOT = new PositioningStrategy<KtQualifiedExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtQualifiedExpression element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                List<TextRange> callElementRanges = PositioningStrategies.INSTANCE.getSELECTOR_BY_QUALIFIED().mark(element2);
                if (callElementRanges.size() != 1) {
                    return callElementRanges;
                }
                TextRange callElementRange = CollectionsKt.first(callElementRanges);
                List<TextRange> dotRanges = PositioningStrategies.SAFE_ACCESS.mark(element2);
                if (dotRanges.size() != 1) {
                    return dotRanges;
                }
                TextRange dotRange = CollectionsKt.first(dotRanges);
                return CollectionsKt.listOf(new TextRange(dotRange.getStartOffset(), callElementRange.getEndOffset()));
            }
        };
        DECLARATION_WITH_BODY = new PositioningStrategy<KtDeclarationWithBody>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclarationWithBody element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                KtBlockExpression ktBlockExpression = element2.getBodyBlockExpression();
                TextRange lastBracketRange = ktBlockExpression != null ? ktBlockExpression.getLastBracketRange() : null;
                return lastBracketRange != null ? PositioningStrategyKt.markRange(lastBracketRange) : PositioningStrategyKt.markElement(element2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isValid(@NotNull KtDeclarationWithBody element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                if (!super.isValid((PsiElement)element2)) return false;
                KtBlockExpression ktBlockExpression = element2.getBodyBlockExpression();
                if (ktBlockExpression == null) return false;
                TextRange textRange = ktBlockExpression.getLastBracketRange();
                if (textRange == null) return false;
                return true;
            }
        };
        VAL_OR_VAR_NODE = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element2) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter(element2, "element");
                KtDeclaration ktDeclaration2 = element2;
                if (ktDeclaration2 instanceof KtParameter) {
                    PsiElement psiElement = ((KtParameter)element2).getValOrVarKeyword();
                    if (psiElement == null) {
                        psiElement = element2;
                    }
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktDeclaration2 instanceof KtProperty) {
                    PsiElement psiElement = ((KtProperty)element2).getValOrVarKeyword();
                    Intrinsics.checkNotNullExpressionValue(psiElement, "getValOrVarKeyword(...)");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktDeclaration2 instanceof KtDestructuringDeclaration) {
                    PsiElement psiElement = ((KtDestructuringDeclaration)element2).getValOrVarKeyword();
                    if (psiElement == null) {
                        psiElement = element2;
                    }
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else {
                    throw new IllegalStateException(("Declaration is neither a parameter nor a property: " + PsiUtilsKt.getElementTextWithContext(element2)).toString());
                }
                return list2;
            }
        };
        ELSE_ENTRY = new PositioningStrategy<KtWhenEntry>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtWhenEntry element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                PsiElement psiElement = element2.getElseKeyword();
                Intrinsics.checkNotNull(psiElement);
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        WHEN_EXPRESSION = new PositioningStrategy<KtWhenExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtWhenExpression element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                PsiElement psiElement = element2.getWhenKeyword();
                Intrinsics.checkNotNullExpressionValue(psiElement, "getWhenKeyword(...)");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        IF_EXPRESSION = new PositioningStrategy<KtIfExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtIfExpression element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                PsiElement psiElement = element2.getIfKeyword();
                Intrinsics.checkNotNullExpressionValue(psiElement, "getIfKeyword(...)");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        WHEN_CONDITION_IN_RANGE = new PositioningStrategy<KtWhenConditionInRange>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtWhenConditionInRange element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                KtOperationReferenceExpression ktOperationReferenceExpression = element2.getOperationReference();
                Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "getOperationReference(...)");
                return PositioningStrategyKt.markElement(ktOperationReferenceExpression);
            }
        };
        SPECIAL_CONSTRUCT_TOKEN = new PositioningStrategy<KtExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtExpression element2) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter(element2, "element");
                KtExpression ktExpression = element2;
                if (ktExpression instanceof KtWhenExpression) {
                    PsiElement psiElement = ((KtWhenExpression)element2).getWhenKeyword();
                    Intrinsics.checkNotNullExpressionValue(psiElement, "getWhenKeyword(...)");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktExpression instanceof KtIfExpression) {
                    PsiElement psiElement = ((KtIfExpression)element2).getIfKeyword();
                    Intrinsics.checkNotNullExpressionValue(psiElement, "getIfKeyword(...)");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktExpression instanceof KtOperationExpression) {
                    KtSimpleNameExpression ktSimpleNameExpression = ((KtOperationExpression)element2).getOperationReference();
                    Intrinsics.checkNotNullExpressionValue(ktSimpleNameExpression, "getOperationReference(...)");
                    list2 = PositioningStrategyKt.markElement(ktSimpleNameExpression);
                } else {
                    throw new IllegalStateException(("Expression is not an if, when or operation expression: " + PsiUtilsKt.getElementTextWithContext(element2)).toString());
                }
                return list2;
            }
        };
        REDUNDANT_NULLABLE = new PositioningStrategy<KtTypeReference>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtTypeReference element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                KtTypeElement typeElement = element2.getTypeElement();
                ASTNode question = null;
                ASTNode prevQuestion = null;
                ASTNode lastQuestion = null;
                while (typeElement instanceof KtNullableType) {
                    prevQuestion = question;
                    question = ((KtNullableType)typeElement).getQuestionMarkNode();
                    if (lastQuestion == null) {
                        lastQuestion = question;
                    }
                    typeElement = ((KtNullableType)typeElement).getInnerType();
                }
                if (lastQuestion != null) {
                    ASTNode aSTNode = prevQuestion;
                    if (aSTNode == null) {
                        aSTNode = lastQuestion;
                    }
                    PsiElement psiElement = aSTNode.getPsi();
                    Intrinsics.checkNotNullExpressionValue(psiElement, "getPsi(...)");
                    PsiElement psiElement2 = lastQuestion.getPsi();
                    Intrinsics.checkNotNullExpressionValue(psiElement2, "getPsi(...)");
                    return PositioningStrategyKt.markRange(psiElement, psiElement2);
                }
                return super.mark((PsiElement)element2);
            }
        };
        NULLABLE_TYPE = new PositioningStrategy<KtNullableType>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtNullableType element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                ASTNode aSTNode = element2.getQuestionMarkNode();
                Intrinsics.checkNotNullExpressionValue(aSTNode, "getQuestionMarkNode(...)");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        QUESTION_MARK_BY_TYPE = new PositioningStrategy<KtTypeReference>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtTypeReference element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                KtTypeElement typeElement = element2.getTypeElement();
                if (typeElement instanceof KtNullableType) {
                    ASTNode aSTNode = ((KtNullableType)typeElement).getQuestionMarkNode();
                    Intrinsics.checkNotNullExpressionValue(aSTNode, "getQuestionMarkNode(...)");
                    return PositioningStrategyKt.markNode(aSTNode);
                }
                return super.mark((PsiElement)element2);
            }
        };
        CALL_EXPRESSION = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                if (element2 instanceof KtCallExpression) {
                    KtElement ktElement;
                    KtTypeArgumentList ktTypeArgumentList = ((KtCallExpression)element2).getTypeArgumentList();
                    if (ktTypeArgumentList != null) {
                        ktElement = ktTypeArgumentList;
                    } else {
                        KtExpression ktExpression = ((KtCallExpression)element2).getCalleeExpression();
                        ktElement = ktExpression != null ? (KtElement)ktExpression : (KtElement)element2;
                    }
                    return PositioningStrategyKt.markRange(element2, ktElement);
                }
                return PositioningStrategyKt.markElement(element2);
            }
        };
        VALUE_ARGUMENTS = new PositioningStrategy<KtElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtElement element2) {
                List<TextRange> list2;
                boolean $i$f$getChildOfType;
                PsiElement $this$getChildOfType$iv;
                KtValueArgumentList ktValueArgumentList;
                KtElement qualifiedAccess;
                KtElement ktElement;
                KtElement left;
                Intrinsics.checkNotNullParameter(element2, "element");
                if (element2 instanceof KtBinaryExpression && KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)element2).getOperationToken())) {
                    left = ((KtBinaryExpression)element2).getLeft();
                    boolean bl = false;
                    PsiElement psiElement = PsiUtilsKt.unwrapParenthesesLabelsAndAnnotations(left);
                    if (psiElement != null) {
                        PsiElement it = psiElement;
                        boolean bl2 = false;
                        return PositioningStrategyKt.markElement(it);
                    }
                }
                if ((left = element2) instanceof KtQualifiedExpression) {
                    KtExpression ktExpression = ((KtQualifiedExpression)element2).getSelectorExpression();
                    if (ktExpression == null) {
                        ktExpression = (KtExpression)element2;
                    }
                    ktElement = ktExpression;
                } else if (left instanceof KtClassOrObject) {
                    KtSuperTypeList ktSuperTypeList = ((KtClassOrObject)element2).getSuperTypeList();
                    ktElement = ktSuperTypeList != null ? (KtElementImplStub)ktSuperTypeList : (KtElementImplStub)element2;
                } else {
                    ktElement = qualifiedAccess = element2;
                }
                if ((ktValueArgumentList = qualifiedAccess instanceof KtValueArgumentList ? (KtValueArgumentList)qualifiedAccess : null) == null) {
                    $this$getChildOfType$iv = qualifiedAccess;
                    $i$f$getChildOfType = false;
                    ktValueArgumentList = PsiTreeUtil.getChildOfType($this$getChildOfType$iv, KtValueArgumentList.class);
                }
                KtValueArgumentList argumentList2 = ktValueArgumentList;
                if (argumentList2 != null) {
                    Object object;
                    PsiElement rightParenthesis;
                    block18: {
                        PsiElement psiElement = argumentList2.getRightParenthesis();
                        if (psiElement == null) {
                            return PositioningStrategyKt.markElement(qualifiedAccess);
                        }
                        rightParenthesis = psiElement;
                        PsiElement[] psiElementArray = argumentList2.getChildren();
                        Intrinsics.checkNotNullExpressionValue(psiElementArray, "getChildren(...)");
                        Object[] objectArray = psiElementArray;
                        int n = objectArray.length + -1;
                        if (0 <= n) {
                            do {
                                int n2 = n--;
                                Object object2 = objectArray[n2];
                                PsiElement it = (PsiElement)object2;
                                boolean bl = false;
                                if (!(it instanceof KtValueArgument)) continue;
                                object = object2;
                                break block18;
                            } while (0 <= n);
                        }
                        object = null;
                    }
                    PsiElement lastArgument = (PsiElement)object;
                    if (lastArgument != null) {
                        list2 = PositioningStrategyKt.markRange(lastArgument, rightParenthesis);
                    } else {
                        PsiElement leftParenthesis = argumentList2.getLeftParenthesis();
                        PsiElement psiElement = leftParenthesis;
                        if (psiElement == null) {
                            psiElement = qualifiedAccess;
                        }
                        list2 = PositioningStrategyKt.markRange(psiElement, rightParenthesis);
                    }
                } else if (qualifiedAccess instanceof KtCallExpression) {
                    $this$getChildOfType$iv = qualifiedAccess;
                    $i$f$getChildOfType = false;
                    KtNameReferenceExpression ktNameReferenceExpression = PsiTreeUtil.getChildOfType($this$getChildOfType$iv, KtNameReferenceExpression.class);
                    list2 = PositioningStrategyKt.markElement(ktNameReferenceExpression != null ? (NavigatablePsiElement)ktNameReferenceExpression : (NavigatablePsiElement)qualifiedAccess);
                } else {
                    list2 = PositioningStrategyKt.markElement(qualifiedAccess);
                }
                return list2;
            }
        };
        VALUE_ARGUMENTS_LIST = new PositioningStrategy<KtElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtElement element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                PsiElement $this$getChildOfType$iv = element2;
                boolean $i$f$getChildOfType = false;
                KtValueArgumentList ktValueArgumentList = PsiTreeUtil.getChildOfType($this$getChildOfType$iv, KtValueArgumentList.class);
                return PositioningStrategyKt.markElement(ktValueArgumentList != null ? (KtElement)ktValueArgumentList : element2);
            }
        };
        FUNCTION_PARAMETERS = new PositioningStrategy<KtFunction>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtFunction element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                KtParameterList valueParameterList = element2.getValueParameterList();
                if (valueParameterList != null) {
                    return PositioningStrategyKt.markElement(valueParameterList);
                }
                if (element2 instanceof KtFunctionLiteral) {
                    ASTNode aSTNode = ((KtFunctionLiteral)element2).getLBrace().getNode();
                    Intrinsics.checkNotNullExpressionValue(aSTNode, "getNode(...)");
                    return PositioningStrategyKt.markNode(aSTNode);
                }
                return PositioningStrategies.DECLARATION_SIGNATURE_OR_DEFAULT.mark(element2);
            }
        };
        CUT_CHAR_QUOTES = new PositioningStrategy<KtElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtElement element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                if (element2 instanceof KtConstantExpression && Intrinsics.areEqual(((KtConstantExpression)element2).getNode().getElementType(), KtNodeTypes.CHARACTER_CONSTANT)) {
                    TextRange elementTextRange = element2.getTextRange();
                    TextRange textRange = TextRange.create(elementTextRange.getStartOffset() + 1, elementTextRange.getEndOffset() - 1);
                    Intrinsics.checkNotNullExpressionValue(textRange, "create(...)");
                    return CollectionsKt.listOf(textRange);
                }
                return PositioningStrategyKt.markElement(element2);
            }
        };
        LONG_LITERAL_SUFFIX = new PositioningStrategy<KtElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtElement element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                if (element2 instanceof KtConstantExpression && Intrinsics.areEqual(((KtConstantExpression)element2).getNode().getElementType(), KtNodeTypes.INTEGER_CONSTANT)) {
                    int endOffset = PsiUtilsKt.getEndOffset(element2);
                    TextRange textRange = TextRange.create(endOffset - 1, endOffset);
                    Intrinsics.checkNotNullExpressionValue(textRange, "create(...)");
                    return CollectionsKt.listOf(textRange);
                }
                return PositioningStrategyKt.markElement(element2);
            }
        };
        AS_TYPE = new PositioningStrategy<KtBinaryExpressionWithTypeRHS>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtBinaryExpressionWithTypeRHS element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                KtSimpleNameExpression ktSimpleNameExpression = element2.getOperationReference();
                Intrinsics.checkNotNullExpressionValue(ktSimpleNameExpression, "getOperationReference(...)");
                return PositioningStrategyKt.markRange(ktSimpleNameExpression, element2);
            }
        };
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.COMPANION_KEYWORD, "COMPANION_KEYWORD");
        COMPANION_OBJECT = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        SECONDARY_CONSTRUCTOR_DELEGATION_CALL = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element2) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter(element2, "element");
                PsiElement psiElement = element2;
                if (psiElement instanceof KtSecondaryConstructor) {
                    KtParameterList ktParameterList = ((KtSecondaryConstructor)element2).getValueParameterList();
                    if (ktParameterList == null) {
                        return PositioningStrategyKt.markElement(element2);
                    }
                    KtParameterList valueParameterList = ktParameterList;
                    PsiElement psiElement2 = ((KtSecondaryConstructor)element2).getConstructorKeyword();
                    PsiElement psiElement3 = valueParameterList.getLastChild();
                    Intrinsics.checkNotNullExpressionValue(psiElement3, "getLastChild(...)");
                    list2 = PositioningStrategyKt.markRange(psiElement2, psiElement3);
                } else if (psiElement instanceof KtConstructorDelegationCall) {
                    if (((KtConstructorDelegationCall)element2).isImplicit()) {
                        PsiElement $this$getStrictParentOfType$iv = element2;
                        boolean $i$f$getStrictParentOfType = false;
                        KtSecondaryConstructor ktSecondaryConstructor = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtSecondaryConstructor.class, true);
                        Intrinsics.checkNotNull(ktSecondaryConstructor);
                        KtSecondaryConstructor constructor2 = ktSecondaryConstructor;
                        KtParameterList ktParameterList = constructor2.getValueParameterList();
                        if (ktParameterList == null) {
                            return PositioningStrategyKt.markElement(constructor2);
                        }
                        KtParameterList valueParameterList = ktParameterList;
                        PsiElement psiElement4 = constructor2.getConstructorKeyword();
                        PsiElement psiElement5 = valueParameterList.getLastChild();
                        Intrinsics.checkNotNullExpressionValue(psiElement5, "getLastChild(...)");
                        return PositioningStrategyKt.markRange(psiElement4, psiElement5);
                    }
                    KtConstructorDelegationReferenceExpression ktConstructorDelegationReferenceExpression = ((KtConstructorDelegationCall)element2).getCalleeExpression();
                    list2 = PositioningStrategyKt.markElement(ktConstructorDelegationReferenceExpression == null ? (KtElementImpl)element2 : (KtElementImpl)ktConstructorDelegationReferenceExpression);
                } else {
                    list2 = PositioningStrategyKt.markElement(element2);
                }
                return list2;
            }
        };
        DELEGATOR_SUPER_CALL = new PositioningStrategy<KtEnumEntry>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtEnumEntry element2) {
                KtElementImplStub ktElementImplStub;
                Intrinsics.checkNotNullParameter(element2, "element");
                List<KtSuperTypeListEntry> list2 = element2.getSuperTypeListEntries();
                Intrinsics.checkNotNullExpressionValue(list2, "getSuperTypeListEntries(...)");
                List<KtSuperTypeListEntry> specifiers = list2;
                if (specifiers.isEmpty()) {
                    ktElementImplStub = element2;
                } else {
                    KtSuperTypeListEntry ktSuperTypeListEntry = specifiers.get(0);
                    Intrinsics.checkNotNullExpressionValue(ktSuperTypeListEntry, "get(...)");
                    ktElementImplStub = ktSuperTypeListEntry;
                }
                return PositioningStrategyKt.markElement(ktElementImplStub);
            }
        };
        UNUSED_VALUE = new PositioningStrategy<KtBinaryExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtBinaryExpression element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                KtExpression ktExpression = element2.getLeft();
                Intrinsics.checkNotNull(ktExpression);
                int n = PsiUtilsKt.getStartOffset(ktExpression);
                KtOperationReferenceExpression ktOperationReferenceExpression = element2.getOperationReference();
                Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "getOperationReference(...)");
                return CollectionsKt.listOf(new TextRange(n, PsiUtilsKt.getEndOffset(ktOperationReferenceExpression)));
            }
        };
        USELESS_ELVIS = new PositioningStrategy<KtBinaryExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtBinaryExpression element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                KtOperationReferenceExpression ktOperationReferenceExpression = element2.getOperationReference();
                Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "getOperationReference(...)");
                return CollectionsKt.listOf(new TextRange(PsiUtilsKt.getStartOffset(ktOperationReferenceExpression), PsiUtilsKt.getEndOffset(element2)));
            }
        };
        IMPORT_ALIAS = new PositioningStrategy<KtImportDirective>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtImportDirective element2) {
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter(element2, "element");
                KtElement ktElement = element2.getAlias();
                if (ktElement != null && (psiElement = ktElement.getNameIdentifier()) != null) {
                    PsiElement it = psiElement;
                    boolean bl = false;
                    return PositioningStrategyKt.markElement(it);
                }
                ktElement = element2.getImportedReference();
                if (ktElement != null) {
                    KtElement it = ktElement;
                    boolean bl = false;
                    if (it instanceof KtQualifiedExpression) {
                        KtExpression ktExpression = ((KtQualifiedExpression)it).getSelectorExpression();
                        if (ktExpression != null) {
                            KtExpression it2 = ktExpression;
                            boolean bl2 = false;
                            return PositioningStrategyKt.markElement(it2);
                        }
                    }
                    return PositioningStrategyKt.markElement(it);
                }
                return PositioningStrategyKt.markElement(element2);
            }
        };
        RETURN_WITH_LABEL = new PositioningStrategy<KtReturnExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtReturnExpression element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                PsiElement labeledExpression = element2.getLabeledExpression();
                if (labeledExpression != null) {
                    return PositioningStrategyKt.markRange(element2, labeledExpression);
                }
                PsiElement psiElement = element2.getReturnKeyword();
                Intrinsics.checkNotNullExpressionValue(psiElement, "getReturnKeyword(...)");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        RECEIVER = new DeclarationHeader<KtCallableDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtCallableDeclaration element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                KtTypeReference ktTypeReference = element2.getReceiverTypeReference();
                if (ktTypeReference != null) {
                    KtTypeReference it = ktTypeReference;
                    boolean bl = false;
                    return PositioningStrategyKt.markElement(it);
                }
                return PositioningStrategies.DEFAULT.mark(element2);
            }
        };
        OPERATOR = new PositioningStrategy<KtExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtExpression element2) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter(element2, "element");
                KtExpression ktExpression = element2;
                if (ktExpression instanceof KtBinaryExpression) {
                    KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)element2).getOperationReference();
                    Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "getOperationReference(...)");
                    list2 = this.mark(ktOperationReferenceExpression);
                } else if (ktExpression instanceof KtBinaryExpressionWithTypeRHS) {
                    KtSimpleNameExpression ktSimpleNameExpression = ((KtBinaryExpressionWithTypeRHS)element2).getOperationReference();
                    Intrinsics.checkNotNullExpressionValue(ktSimpleNameExpression, "getOperationReference(...)");
                    list2 = this.mark(ktSimpleNameExpression);
                } else if (ktExpression instanceof KtUnaryExpression) {
                    KtSimpleNameExpression ktSimpleNameExpression = ((KtUnaryExpression)element2).getOperationReference();
                    Intrinsics.checkNotNullExpressionValue(ktSimpleNameExpression, "getOperationReference(...)");
                    list2 = this.mark(ktSimpleNameExpression);
                } else {
                    list2 = super.mark((PsiElement)element2);
                }
                return list2;
            }
        };
        DOT_BY_QUALIFIED = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                if (element2 instanceof KtBinaryExpression && KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)element2).getOperationToken())) {
                    KtExpression ktExpression = ((KtBinaryExpression)element2).getLeft();
                    if (ktExpression != null) {
                        KtExpression left = ktExpression;
                        boolean bl = false;
                        PsiElement $this$findDescendantOfType_u24default$iv = left;
                        Function1 predicate$iv = DOT_BY_QUALIFIED$1$mark$lambda$1$$inlined$findDescendantOfType$default$1.INSTANCE;
                        boolean $i$f$findDescendantOfType = false;
                        PsiElement $this$findDescendantOfType$iv$iv = $this$findDescendantOfType_u24default$iv;
                        boolean $i$f$findDescendantOfType2 = false;
                        PsiUtilsKt.checkDecompiledText($this$findDescendantOfType$iv$iv);
                        Ref.ObjectRef<T> result$iv$iv = new Ref.ObjectRef<T>();
                        $this$findDescendantOfType$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv){
                            final /* synthetic */ Function1 $predicate;
                            final /* synthetic */ Ref.ObjectRef $result;
                            {
                                this.$predicate = $predicate;
                                this.$result = $result;
                            }

                            public void visitElement(@NotNull PsiElement element2) {
                                Intrinsics.checkNotNullParameter(element2, "element");
                                if (element2 instanceof KtDotQualifiedExpression && ((Boolean)this.$predicate.invoke(element2)).booleanValue()) {
                                    this.$result.element = element2;
                                    this.stopWalking();
                                    return;
                                }
                                PsiElement it = element2;
                                boolean bl = false;
                                super.visitElement(element2);
                            }
                        });
                        KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)((PsiElement)result$iv$iv.element);
                        if (ktDotQualifiedExpression != null) {
                            KtDotQualifiedExpression it = ktDotQualifiedExpression;
                            boolean bl2 = false;
                            return this.mark(it);
                        }
                    }
                }
                if (element2 instanceof KtDotQualifiedExpression) {
                    PsiElement psiElement = ((KtDotQualifiedExpression)element2).getOperationTokenNode().getPsi();
                    Intrinsics.checkNotNullExpressionValue(psiElement, "getPsi(...)");
                    return this.mark(psiElement);
                }
                return PositioningStrategies.INSTANCE.getREFERENCE_BY_QUALIFIED().mark(element2);
            }
        };
        SELECTOR_BY_QUALIFIED = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element2) {
                PsiElement psiElement;
                KtExpression selectorExpression;
                KtElement ktElement;
                Intrinsics.checkNotNullParameter(element2, "element");
                if (element2 instanceof KtBinaryExpression && KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)element2).getOperationToken()) && (ktElement = ((KtBinaryExpression)element2).getLeft()) != null) {
                    KtElement it = ktElement;
                    boolean bl = false;
                    return this.mark(it);
                }
                if (element2 instanceof KtQualifiedExpression && (selectorExpression = ((KtQualifiedExpression)element2).getSelectorExpression()) instanceof KtElement) {
                    return this.mark(selectorExpression);
                }
                if (element2 instanceof KtImportDirective) {
                    ktElement = ((KtImportDirective)element2).getAlias();
                    if (ktElement != null && (psiElement = ((KtImportAlias)ktElement).getNameIdentifier()) != null) {
                        PsiElement it = psiElement;
                        boolean bl = false;
                        return this.mark(it);
                    }
                    ktElement = ((KtImportDirective)element2).getImportedReference();
                    if (ktElement != null) {
                        KtElement it = ktElement;
                        boolean bl = false;
                        return this.mark(it);
                    }
                }
                if (element2 instanceof KtTypeReference && (ktElement = ((KtTypeReference)element2).getTypeElement()) != null && (psiElement = PositioningStrategies.access$getReferencedTypeExpression(PositioningStrategies.INSTANCE, (KtTypeElement)ktElement)) != null) {
                    PsiElement it = psiElement;
                    boolean bl = false;
                    return this.mark(it);
                }
                return super.mark(element2);
            }
        };
        NAME_IDENTIFIER = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                if (element2 instanceof PsiNameIdentifierOwner) {
                    PsiElement nameIdentifier = ((PsiNameIdentifierOwner)element2).getNameIdentifier();
                    if (nameIdentifier != null) {
                        return super.mark(nameIdentifier);
                    }
                } else {
                    PsiElement nameIdentifier;
                    if (element2 instanceof KtLabelReferenceExpression) {
                        return super.mark(((KtLabelReferenceExpression)element2).getReferencedNameElement());
                    }
                    if (element2 instanceof KtPackageDirective && (nameIdentifier = ((KtPackageDirective)element2).getNameIdentifier()) != null) {
                        return super.mark(nameIdentifier);
                    }
                }
                return PositioningStrategies.DEFAULT.mark(element2);
            }
        };
        SPREAD_OPERATOR = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element2) {
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter(element2, "element");
                UserDataHolder userDataHolder = element2 instanceof KtValueArgument ? (KtValueArgument)element2 : null;
                if ((userDataHolder != null && (userDataHolder = ((KtValueArgument)userDataHolder).getSpreadElement()) != null && (userDataHolder = ((LeafPsiElement)userDataHolder).getNode()) != null ? userDataHolder.getPsi() : (psiElement = null)) == null) {
                    psiElement = element2;
                }
                return super.mark(psiElement);
            }
        };
        FUN_INTERFACE = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element2) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter(element2, "element");
                KtDeclaration ktDeclaration2 = element2;
                if (ktDeclaration2 instanceof KtClass) {
                    list2 = PositioningStrategies.FUN_MODIFIER.mark((KtModifierListOwner)((PsiElement)element2));
                } else if (ktDeclaration2 instanceof KtProperty) {
                    PsiElement psiElement = ((KtProperty)element2).getValOrVarKeyword();
                    Intrinsics.checkNotNullExpressionValue(psiElement, "getValOrVarKeyword(...)");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktDeclaration2 instanceof KtNamedFunction) {
                    KtTypeParameterList typeParameterList = ((KtNamedFunction)element2).getTypeParameterList();
                    KtTypeParameterList ktTypeParameterList = typeParameterList;
                    if (ktTypeParameterList != null) {
                        list2 = PositioningStrategyKt.markElement(ktTypeParameterList);
                    } else if (element2.hasModifier(KtTokens.SUSPEND_KEYWORD)) {
                        list2 = PositioningStrategies.SUSPEND_MODIFIER.mark((KtModifierListOwner)((PsiElement)element2));
                    } else {
                        PsiElement psiElement = ((KtNamedFunction)element2).getFunKeyword();
                        if (psiElement == null) {
                            psiElement = element2;
                        }
                        list2 = PositioningStrategyKt.markElement(psiElement);
                    }
                } else {
                    list2 = PositioningStrategyKt.markElement(element2);
                }
                return list2;
            }
        };
        REFERENCE_BY_QUALIFIED = new FindReferencePositioningStrategy(false);
        REFERENCED_NAME_BY_QUALIFIED = new FindReferencePositioningStrategy(true);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.REIFIED_KEYWORD, "REIFIED_KEYWORD");
        REIFIED_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        PROPERTY_INITIALIZER = new PositioningStrategy<KtNamedDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtNamedDeclaration element2) {
                KtElement ktElement;
                Intrinsics.checkNotNullParameter(element2, "element");
                KtNamedDeclaration ktNamedDeclaration = element2;
                if (ktNamedDeclaration instanceof KtProperty) {
                    KtExpression ktExpression = ((KtProperty)element2).getInitializer();
                    if (ktExpression == null) {
                        ktExpression = element2;
                    }
                    ktElement = ktExpression;
                } else if (ktNamedDeclaration instanceof KtParameter) {
                    KtExpression ktExpression = ((KtParameter)element2).getDefaultValue();
                    if (ktExpression != null) {
                        ktElement = ktExpression;
                    } else {
                        KtTypeReference ktTypeReference = ((KtParameter)element2).getTypeReference();
                        ktElement = ktTypeReference != null ? (KtElement)ktTypeReference : (KtElement)element2;
                    }
                } else {
                    ktElement = element2;
                }
                return PositioningStrategyKt.markElement(ktElement);
            }
        };
        WHOLE_ELEMENT = new PositioningStrategy<KtElement>(){};
        TYPE_PARAMETERS_LIST = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                if (element2 instanceof KtTypeParameterListOwner) {
                    KtTypeParameterList ktTypeParameterList = ((KtTypeParameterListOwner)element2).getTypeParameterList();
                    return PositioningStrategyKt.markElement(ktTypeParameterList == null ? (KtElement)element2 : (KtElement)ktTypeParameterList);
                }
                return PositioningStrategyKt.markElement(element2);
            }
        };
        ANNOTATION_USE_SITE = new PositioningStrategy<KtAnnotationEntry>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtAnnotationEntry element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = element2.getUseSiteTarget();
                return PositioningStrategyKt.markElement(ktAnnotationUseSiteTarget == null ? (KtElementImplStub)element2 : (KtElementImplStub)ktAnnotationUseSiteTarget);
            }
        };
        IMPORT_LAST_NAME = new PositioningStrategy<PsiElement>(){

            public boolean isValid(@NotNull PsiElement element2) {
                boolean bl;
                block2: {
                    Intrinsics.checkNotNullParameter(element2, "element");
                    if (element2 instanceof PsiErrorElement) {
                        return false;
                    }
                    PsiElement[] psiElementArray = element2.getChildren();
                    Intrinsics.checkNotNullExpressionValue(psiElementArray, "getChildren(...)");
                    Object[] $this$any$iv = psiElementArray;
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull(it);
                        if (!(!this.isValid(it))) continue;
                        bl = true;
                        break block2;
                    }
                    bl = false;
                }
                return !bl;
            }

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                if (element2 instanceof KtImportDirective) {
                    KtExpression ktExpression;
                    KtExpression importedReference = ((KtImportDirective)element2).getImportedReference();
                    if (importedReference instanceof KtDotQualifiedExpression && (ktExpression = ((KtDotQualifiedExpression)importedReference).getSelectorExpression()) != null) {
                        KtExpression it = ktExpression;
                        boolean bl = false;
                        return super.mark((PsiElement)it);
                    }
                    KtExpression ktExpression2 = ((KtImportDirective)element2).getImportedReference();
                    return super.mark((PsiElement)(ktExpression2 == null ? (KtElement)element2 : (KtElement)ktExpression2));
                }
                return super.mark(element2);
            }
        };
        LABEL = new PositioningStrategy<KtElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtElement element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                KtElementImpl ktElementImpl = element2 instanceof KtExpressionWithLabel ? (KtExpressionWithLabel)element2 : null;
                return super.mark((PsiElement)(ktElementImpl != null && (ktElementImpl = ktElementImpl.getLabelQualifier()) != null ? (KtElement)ktElementImpl : element2));
            }
        };
        COMMAS = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element2) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter(element2, "element");
                List<TextRange> $this$mark_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
                boolean bl = false;
                Iterator<PsiElement> iterator2 = PsiUtilsKt.getAllChildren(element2).iterator();
                while (iterator2.hasNext()) {
                    PsiElement child = iterator2.next();
                    if (!Intrinsics.areEqual(child.getNode().getElementType(), KtTokens.COMMA)) continue;
                    $this$mark_u24lambda_u240.add(PositioningStrategyKt.markSingleElement(child));
                }
                return CollectionsKt.build(list2);
            }

            public boolean isValid(@NotNull PsiElement element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                return true;
            }
        };
        iElementTypeArray2 = new IElementType[3];
        Intrinsics.checkNotNullExpressionValue(KtTokens.ABSTRACT_KEYWORD, "ABSTRACT_KEYWORD");
        Intrinsics.checkNotNullExpressionValue(KtTokens.OPEN_KEYWORD, "OPEN_KEYWORD");
        Intrinsics.checkNotNullExpressionValue(KtTokens.SEALED_KEYWORD, "SEALED_KEYWORD");
        NON_FINAL_MODIFIER_OR_NAME = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        DELEGATED_SUPERTYPE_BY_KEYWORD = new PositioningStrategy<KtTypeReference>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtTypeReference element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                PsiElement psiElement = element2.getParent();
                KtDelegatedSuperTypeEntry ktDelegatedSuperTypeEntry = psiElement instanceof KtDelegatedSuperTypeEntry ? (KtDelegatedSuperTypeEntry)psiElement : null;
                if (ktDelegatedSuperTypeEntry == null) {
                    return super.mark((PsiElement)element2);
                }
                KtDelegatedSuperTypeEntry parent2 = ktDelegatedSuperTypeEntry;
                PsiElement psiElement2 = parent2.getByKeywordNode().getPsi();
                if (psiElement2 == null) {
                    psiElement2 = element2;
                }
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        TYPEALIAS_TYPE_REFERENCE = new PositioningStrategy<KtTypeAlias>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtTypeAlias element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                KtTypeReference ktTypeReference = element2.getTypeReference();
                return PositioningStrategyKt.markElement(ktTypeReference != null ? (KtModifierListOwnerStub)ktTypeReference : (KtModifierListOwnerStub)element2);
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$DeclarationHeader;", "T", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "()V", "isValid", "", "element", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)Z", "frontend.common-psi"})
    public static class DeclarationHeader<T extends KtDeclaration>
    extends PositioningStrategy<T> {
        @Override
        public boolean isValid(@NotNull T element2) {
            Intrinsics.checkNotNullParameter(element2, "element");
            if (element2 instanceof KtNamedDeclaration && !(element2 instanceof KtObjectDeclaration) && !(element2 instanceof KtSecondaryConstructor) && !(element2 instanceof KtFunction) && ((KtNamedDeclaration)element2).getNameIdentifier() == null) {
                return false;
            }
            return super.isValid((PsiElement)element2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$FindReferencePositioningStrategy;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lcom/intellij/psi/PsiElement;", "locateReferencedName", "", "(Z)V", "getLocateReferencedName", "()Z", "mark", "", "Lcom/intellij/openapi/util/TextRange;", "element", "frontend.common-psi"})
    @SourceDebugExtension(value={"SMAP\nPositioningStrategies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PositioningStrategies.kt\norg/jetbrains/kotlin/diagnostics/PositioningStrategies$FindReferencePositioningStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1087:1\n1#2:1088\n*E\n"})
    public static final class FindReferencePositioningStrategy
    extends PositioningStrategy<PsiElement> {
        private final boolean locateReferencedName;

        public FindReferencePositioningStrategy(boolean locateReferencedName) {
            this.locateReferencedName = locateReferencedName;
        }

        public final boolean getLocateReferencedName() {
            return this.locateReferencedName;
        }

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull PsiElement element2) {
            PsiElement result2;
            PsiElement psiElement;
            KtExpression ktExpression;
            Intrinsics.checkNotNullParameter(element2, "element");
            if (element2 instanceof KtBinaryExpression && Intrinsics.areEqual(((KtBinaryExpression)element2).getOperationToken(), KtTokens.EQ) && (ktExpression = ((KtBinaryExpression)element2).getLeft()) != null) {
                KtExpression it = ktExpression;
                boolean bl = false;
                return this.mark(it);
            }
            PsiElement psiElement2 = element2;
            if (psiElement2 instanceof KtQualifiedExpression) {
                KtExpression ktExpression2;
                KtExpression selectorExpression = ((KtQualifiedExpression)element2).getSelectorExpression();
                if (selectorExpression instanceof KtCallExpression) {
                    ktExpression2 = ((KtCallExpression)selectorExpression).getCalleeExpression();
                    if (ktExpression2 == null) {
                        ktExpression2 = selectorExpression;
                    }
                } else {
                    ktExpression2 = selectorExpression instanceof KtReferenceExpression ? selectorExpression : (KtExpression)element2;
                }
                psiElement = ktExpression2;
            } else if (psiElement2 instanceof KtCallableReferenceExpression) {
                KtSimpleNameExpression ktSimpleNameExpression = ((KtCallableReferenceExpression)element2).getCallableReference();
                Intrinsics.checkNotNullExpressionValue(ktSimpleNameExpression, "getCallableReference(...)");
                psiElement = ktSimpleNameExpression;
            } else if (psiElement2 instanceof KtCallExpression) {
                KtExpression ktExpression3 = ((KtCallExpression)element2).getCalleeExpression();
                if (ktExpression3 == null) {
                    ktExpression3 = (KtExpression)element2;
                }
                psiElement = ktExpression3;
            } else if (psiElement2 instanceof KtConstructorDelegationCall) {
                KtConstructorDelegationReferenceExpression ktConstructorDelegationReferenceExpression = ((KtConstructorDelegationCall)element2).getCalleeExpression();
                psiElement = ktConstructorDelegationReferenceExpression == null ? (KtElementImpl)element2 : (KtElementImpl)ktConstructorDelegationReferenceExpression;
            } else if (psiElement2 instanceof KtSuperTypeCallEntry) {
                KtConstructorCalleeExpression ktConstructorCalleeExpression = ((KtSuperTypeCallEntry)element2).getCalleeExpression();
                Intrinsics.checkNotNullExpressionValue(ktConstructorCalleeExpression, "getCalleeExpression(...)");
                psiElement = ktConstructorCalleeExpression;
            } else if (psiElement2 instanceof KtOperationExpression) {
                KtSimpleNameExpression ktSimpleNameExpression = ((KtOperationExpression)element2).getOperationReference();
                Intrinsics.checkNotNullExpressionValue(ktSimpleNameExpression, "getOperationReference(...)");
                psiElement = ktSimpleNameExpression;
            } else if (psiElement2 instanceof KtWhenConditionInRange) {
                KtOperationReferenceExpression ktOperationReferenceExpression = ((KtWhenConditionInRange)element2).getOperationReference();
                Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "getOperationReference(...)");
                psiElement = ktOperationReferenceExpression;
            } else if (psiElement2 instanceof KtAnnotationEntry) {
                KtConstructorCalleeExpression ktConstructorCalleeExpression = ((KtAnnotationEntry)element2).getCalleeExpression();
                psiElement = ktConstructorCalleeExpression == null ? (KtElementImplStub)element2 : (KtElementImplStub)ktConstructorCalleeExpression;
            } else if (psiElement2 instanceof KtTypeReference) {
                KtTypeElement ktTypeElement = ((KtTypeReference)element2).getTypeElement();
                KtNullableType ktNullableType = ktTypeElement instanceof KtNullableType ? (KtNullableType)ktTypeElement : null;
                KtTypeElement ktTypeElement2 = ktNullableType != null ? ktNullableType.getInnerType() : null;
                psiElement = ktTypeElement2 == null ? (KtElement)element2 : (KtElement)ktTypeElement2;
            } else if (psiElement2 instanceof KtImportDirective) {
                KtExpression ktExpression4 = ((KtImportDirective)element2).getImportedReference();
                psiElement = ktExpression4 == null ? (KtElement)element2 : (KtElement)ktExpression4;
            } else {
                psiElement = result2 = element2;
            }
            while (this.locateReferencedName && result2 instanceof KtParenthesizedExpression) {
                KtExpression ktExpression5 = ((KtParenthesizedExpression)result2).getExpression();
                if (ktExpression5 == null) break;
                result2 = ktExpression5;
            }
            return super.mark(result2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$InlineFunPositioningStrategy;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$ModifierSetBasedPositioningStrategy;", "()V", "mark", "", "Lcom/intellij/openapi/util/TextRange;", "element", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "frontend.common-psi"})
    private static final class InlineFunPositioningStrategy
    extends ModifierSetBasedPositioningStrategy {
        public InlineFunPositioningStrategy() {
            IElementType[] iElementTypeArray = new IElementType[1];
            Intrinsics.checkNotNullExpressionValue(KtTokens.INLINE_KEYWORD, "INLINE_KEYWORD");
            super(iElementTypeArray);
        }

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull KtModifierListOwner element2) {
            Intrinsics.checkNotNullParameter(element2, "element");
            if (element2 instanceof KtProperty) {
                List<TextRange> list2 = this.markModifier(((KtProperty)element2).getGetter());
                if (list2 == null && (list2 = this.markModifier(((KtProperty)element2).getSetter())) == null) {
                    list2 = super.mark(element2);
                }
                return list2;
            }
            return super.mark(element2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0012\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\b\u0016\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001a\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0004R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$ModifierSetBasedPositioningStrategy;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "tokens", "", "Lcom/intellij/psi/tree/IElementType;", "([Lcom/intellij/psi/tree/IElementType;)V", "modifierSet", "Lcom/intellij/psi/tree/TokenSet;", "(Lcom/intellij/psi/tree/TokenSet;)V", "mark", "", "Lcom/intellij/openapi/util/TextRange;", "element", "markModifier", "frontend.common-psi"})
    @SourceDebugExtension(value={"SMAP\nPositioningStrategies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PositioningStrategies.kt\norg/jetbrains/kotlin/diagnostics/PositioningStrategies$ModifierSetBasedPositioningStrategy\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1087:1\n11383#2,9:1088\n13309#2:1097\n13310#2:1099\n11392#2:1100\n1#3:1098\n1#3:1101\n*S KotlinDebug\n*F\n+ 1 PositioningStrategies.kt\norg/jetbrains/kotlin/diagnostics/PositioningStrategies$ModifierSetBasedPositioningStrategy\n*L\n441#1:1088,9\n441#1:1097\n441#1:1099\n441#1:1100\n441#1:1098\n*E\n"})
    private static class ModifierSetBasedPositioningStrategy
    extends PositioningStrategy<KtModifierListOwner> {
        @NotNull
        private final TokenSet modifierSet;

        public ModifierSetBasedPositioningStrategy(@NotNull TokenSet modifierSet) {
            Intrinsics.checkNotNullParameter(modifierSet, "modifierSet");
            this.modifierSet = modifierSet;
        }

        public ModifierSetBasedPositioningStrategy(IElementType ... tokens) {
            Intrinsics.checkNotNullParameter(tokens, "tokens");
            TokenSet tokenSet = TokenSet.create(Arrays.copyOf(tokens, tokens.length));
            Intrinsics.checkNotNullExpressionValue(tokenSet, "create(...)");
            this(tokenSet);
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        protected final List<TextRange> markModifier(@Nullable KtModifierListOwner element) {
            v0 = this.modifierSet.getTypes();
            Intrinsics.checkNotNullExpressionValue(v0, "getTypes(...)");
            $this$mapNotNull$iv = v0;
            $i$f$mapNotNull = false;
            var4_5 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var10_12 = ((void)$this$forEach$iv$iv$iv).length;
            for (var9_11 = 0; var9_11 < var10_12; ++var9_11) {
                element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[var9_11];
                $i$a$-forEach-ArraysKt___ArraysKt$mapNotNullTo$1$iv$iv = false;
                it = (IElementType)element$iv$iv;
                $i$a$-mapNotNull-PositioningStrategies$ModifierSetBasedPositioningStrategy$markModifier$1 = false;
                v1 = element;
                if (v1 == null || (v1 = v1.getModifierList()) == null) ** GOTO lbl-1000
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
                if ((v1 = v1.getModifier((KtModifierKeywordToken)it)) != null) {
                    v2 = v1.getTextRange();
                } else lbl-1000:
                // 2 sources

                {
                    v2 = null;
                }
                if (v2 == null) continue;
                it$iv$iv = v2;
                $i$a$-let-ArraysKt___ArraysKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            it = var2_2 = (List<E>)destination$iv$iv;
            $i$a$-takeIf-PositioningStrategies$ModifierSetBasedPositioningStrategy$markModifier$2 = false;
            return !((Collection)it).isEmpty() != false ? var2_2 : null;
        }

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull KtModifierListOwner element2) {
            PsiElement psiElement;
            PsiElement nameIdentifier;
            List<TextRange> result2;
            Intrinsics.checkNotNullParameter(element2, "element");
            List<TextRange> list2 = result2 = this.markModifier(element2);
            if (list2 != null) {
                return list2;
            }
            if (element2 instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)((Object)element2)).getNameIdentifier()) != null) {
                return PositioningStrategyKt.markElement(nameIdentifier);
            }
            KtModifierListOwner ktModifierListOwner = element2;
            if (ktModifierListOwner instanceof KtObjectDeclaration) {
                PsiElement psiElement2 = ((KtObjectDeclaration)element2).getObjectKeyword();
                psiElement = psiElement2;
                Intrinsics.checkNotNull(psiElement2);
            } else if (ktModifierListOwner instanceof KtPropertyAccessor) {
                PsiElement psiElement3 = ((KtPropertyAccessor)element2).getNamePlaceholder();
                psiElement = psiElement3;
                Intrinsics.checkNotNullExpressionValue(psiElement3, "getNamePlaceholder(...)");
            } else if (ktModifierListOwner instanceof KtAnonymousInitializer) {
                psiElement = element2;
            } else {
                throw new IllegalArgumentException("Can't find text range for element '" + element2.getClass().getCanonicalName() + "' with the text '" + element2.getText() + '\'');
            }
            PsiElement elementToMark = psiElement;
            return PositioningStrategyKt.markElement(elementToMark);
        }
    }
}

