/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.evaluate;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationApplicationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationApplicationWithArgumentsInfo;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtArrayAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtConstantAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtEnumEntryAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtKClassAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtNamedAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtUnsupportedAnnotationValue;
import org.jetbrains.kotlin.analysis.api.base.KtConstantValue;
import org.jetbrains.kotlin.analysis.api.base.KtConstantValueFactory;
import org.jetbrains.kotlin.analysis.api.components.KtConstantEvaluationMode;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirCompileTimeConstantEvaluator;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArrayOfCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedTypeQualifierError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.ArrayFqNames;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ(\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u0010\"\u0004\b\u0000\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00110\u0012H\u0002J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0004*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J.\u0010\u0013\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0014*\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/evaluate/FirAnnotationValueConverter;", "", "()V", "toConstantValue", "Lorg/jetbrains/kotlin/analysis/api/annotations/KtAnnotationValue;", "firExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "toNamedConstantValue", "", "Lorg/jetbrains/kotlin/analysis/api/annotations/KtNamedAnnotationValue;", "argumentMapping", "", "Lorg/jetbrains/kotlin/name/Name;", "convertConstantExpression", "Lorg/jetbrains/kotlin/analysis/api/annotations/KtConstantAnnotationValue;", "T", "Lorg/jetbrains/kotlin/fir/expressions/FirConstExpression;", "convertVarargsExpression", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nFirAnnotationValueConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnnotationValueConverter.kt\norg/jetbrains/kotlin/analysis/api/fir/evaluate/FirAnnotationValueConverter\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,213:1\n125#2:214\n152#2,3:215\n1#3:218\n60#4,4:219\n1855#5,2:223\n73#6:225\n*S KotlinDebug\n*F\n+ 1 FirAnnotationValueConverter.kt\norg/jetbrains/kotlin/analysis/api/fir/evaluate/FirAnnotationValueConverter\n*L\n39#1:214\n39#1:215,3\n130#1:219,4\n130#1:223,2\n199#1:225\n*E\n"})
public final class FirAnnotationValueConverter {
    @NotNull
    public static final FirAnnotationValueConverter INSTANCE = new FirAnnotationValueConverter();

    private FirAnnotationValueConverter() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KtNamedAnnotationValue> toNamedConstantValue(@NotNull Map<Name, ? extends FirExpression> argumentMapping, @NotNull FirSession session) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(argumentMapping, "argumentMapping");
        Intrinsics.checkNotNullParameter(session, "session");
        Map<Name, ? extends FirExpression> $this$map$iv = argumentMapping;
        boolean $i$f$map = false;
        Map<Name, ? extends FirExpression> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Name name2 = (Name)entry.getKey();
            FirExpression expression2 = (FirExpression)entry.getValue();
            KtAnnotationValue ktAnnotationValue = INSTANCE.convertConstantExpression(expression2, session);
            if (ktAnnotationValue == null) {
                ktAnnotationValue = KtUnsupportedAnnotationValue.INSTANCE;
            }
            collection.add(new KtNamedAnnotationValue(name2, ktAnnotationValue));
        }
        return (List)destination$iv$iv;
    }

    private final <T> KtConstantAnnotationValue convertConstantExpression(FirConstExpression<T> $this$convertConstantExpression) {
        KtConstantAnnotationValue ktConstantAnnotationValue;
        KtConstantValue constantValue;
        KtConstantValue ktConstantValue;
        PsiElement psiElement = UtilsKt.getPsi($this$convertConstantExpression);
        KtElement expression2 = psiElement instanceof KtElement ? (KtElement)psiElement : null;
        Object object = $this$convertConstantExpression.getTypeRef();
        FirResolvedTypeRef firResolvedTypeRef = object instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)object : null;
        ConeKotlinType type2 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if ($this$convertConstantExpression.getValue() == null) {
            ktConstantValue = new KtConstantValue.KtNullConstantValue(expression2);
        } else if (type2 == null) {
            ktConstantValue = KtConstantValueFactory.INSTANCE.createConstantValue($this$convertConstantExpression.getValue(), (object = UtilsKt.getPsi($this$convertConstantExpression)) instanceof KtElement ? (KtElement)object : null);
        } else if (ConeBuiltinTypeUtilsKt.isBoolean(type2)) {
            T t = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.Boolean");
            ktConstantValue = new KtConstantValue.KtBooleanConstantValue((Boolean)t, expression2);
        } else if (ConeBuiltinTypeUtilsKt.isChar(type2)) {
            char c;
            T t = $this$convertConstantExpression.getValue();
            Character c2 = t instanceof Character ? (Character)t : null;
            if (c2 != null) {
                c = c2.charValue();
            } else {
                T t2 = $this$convertConstantExpression.getValue();
                Intrinsics.checkNotNull(t2, "null cannot be cast to non-null type kotlin.Number");
                c = (char)((Number)t2).intValue();
            }
            ktConstantValue = new KtConstantValue.KtCharConstantValue(c, expression2);
        } else if (ConeBuiltinTypeUtilsKt.isByte(type2)) {
            T t = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.Number");
            ktConstantValue = new KtConstantValue.KtByteConstantValue(((Number)t).byteValue(), expression2);
        } else if (ConeBuiltinTypeUtilsKt.isUByte(type2)) {
            T t = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.Number");
            ktConstantValue = new KtConstantValue.KtUnsignedByteConstantValue(UByte.constructor-impl(((Number)t).byteValue()), expression2, null);
        } else if (ConeBuiltinTypeUtilsKt.isShort(type2)) {
            T t = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.Number");
            ktConstantValue = new KtConstantValue.KtShortConstantValue(((Number)t).shortValue(), expression2);
        } else if (ConeBuiltinTypeUtilsKt.isUShort(type2)) {
            T t = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.Number");
            ktConstantValue = new KtConstantValue.KtUnsignedShortConstantValue(UShort.constructor-impl(((Number)t).shortValue()), expression2, null);
        } else if (ConeBuiltinTypeUtilsKt.isInt(type2)) {
            T t = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.Number");
            ktConstantValue = new KtConstantValue.KtIntConstantValue(((Number)t).intValue(), expression2);
        } else if (ConeBuiltinTypeUtilsKt.isUInt(type2)) {
            T t = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.Number");
            ktConstantValue = new KtConstantValue.KtUnsignedIntConstantValue(UInt.constructor-impl(((Number)t).intValue()), expression2, null);
        } else if (ConeBuiltinTypeUtilsKt.isLong(type2)) {
            T t = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.Number");
            ktConstantValue = new KtConstantValue.KtLongConstantValue(((Number)t).longValue(), expression2);
        } else if (ConeBuiltinTypeUtilsKt.isULong(type2)) {
            T t = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.Number");
            ktConstantValue = new KtConstantValue.KtUnsignedLongConstantValue(ULong.constructor-impl(((Number)t).longValue()), expression2, null);
        } else if (ConeBuiltinTypeUtilsKt.isString(type2)) {
            ktConstantValue = new KtConstantValue.KtStringConstantValue(String.valueOf($this$convertConstantExpression.getValue()), expression2);
        } else if (ConeBuiltinTypeUtilsKt.isFloat(type2)) {
            T t = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.Number");
            ktConstantValue = new KtConstantValue.KtFloatConstantValue(((Number)t).floatValue(), expression2);
        } else if (ConeBuiltinTypeUtilsKt.isDouble(type2)) {
            T t = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.Number");
            ktConstantValue = new KtConstantValue.KtDoubleConstantValue(((Number)t).doubleValue(), expression2);
        } else {
            ktConstantValue = null;
        }
        KtConstantValue ktConstantValue2 = constantValue = ktConstantValue;
        if (ktConstantValue2 != null) {
            KtConstantValue p0 = ktConstantValue2;
            boolean bl = false;
            ktConstantAnnotationValue = new KtConstantAnnotationValue(p0);
        } else {
            ktConstantAnnotationValue = null;
        }
        return ktConstantAnnotationValue;
    }

    private final Pair<Collection<KtAnnotationValue>, KtElement> convertVarargsExpression(Collection<? extends FirExpression> $this$convertVarargsExpression, FirSession session) {
        List<KtAnnotationValue> list2;
        KtElement representativePsi = null;
        List<KtAnnotationValue> $this$convertVarargsExpression_u24lambda_u241 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (FirExpression firExpression2 : $this$convertVarargsExpression) {
            KtElement ktElement;
            KtAnnotationValue converted;
            if (INSTANCE.convertConstantExpression(firExpression2, session) == null) continue;
            if (firExpression2 instanceof FirSpreadArgumentExpression || firExpression2 instanceof FirNamedArgumentExpression) {
                Intrinsics.checkNotNull(converted, "null cannot be cast to non-null type org.jetbrains.kotlin.analysis.api.annotations.KtArrayAnnotationValue");
                $this$convertVarargsExpression_u24lambda_u241.addAll(((KtArrayAnnotationValue)converted).getValues());
            } else {
                $this$convertVarargsExpression_u24lambda_u241.add(converted);
            }
            if ((ktElement = representativePsi) == null) {
                ktElement = converted.getSourcePsi();
            }
            representativePsi = ktElement;
        }
        List flattenedVarargs = CollectionsKt.build(list2);
        return TuplesKt.to(flattenedVarargs, representativePsi);
    }

    @Nullable
    public final KtAnnotationValue toConstantValue(@NotNull FirExpression firExpression2, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(firExpression2, "firExpression");
        Intrinsics.checkNotNullParameter(session, "session");
        return this.convertConstantExpression(firExpression2, session);
    }

    private final KtAnnotationValue convertConstantExpression(FirExpression $this$convertConstantExpression, FirSession session) {
        KtAnnotationValue ktAnnotationValue;
        KtAnnotationValue ktAnnotationValue2;
        PsiElement psiElement = UtilsKt.getPsi($this$convertConstantExpression);
        KtElement sourcePsi = psiElement instanceof KtElement ? (KtElement)psiElement : null;
        FirConstExpression<?> firConstExpression = $this$convertConstantExpression;
        if (firConstExpression instanceof FirConstExpression) {
            ktAnnotationValue2 = this.convertConstantExpression($this$convertConstantExpression);
        } else if (firConstExpression instanceof FirNamedArgumentExpression) {
            ktAnnotationValue2 = this.convertConstantExpression(((FirNamedArgumentExpression)((Object)$this$convertConstantExpression)).getExpression(), session);
        } else if (firConstExpression instanceof FirSpreadArgumentExpression) {
            ktAnnotationValue2 = this.convertConstantExpression(((FirSpreadArgumentExpression)((Object)$this$convertConstantExpression)).getExpression(), session);
        } else if (firConstExpression instanceof FirVarargArgumentsExpression) {
            Pair<Collection<KtAnnotationValue>, KtElement> pair = this.convertVarargsExpression((Collection<? extends FirExpression>)((FirVarargArgumentsExpression)((Object)$this$convertConstantExpression)).getArguments(), session);
            Collection<KtAnnotationValue> annotationValues = pair.component1();
            KtElement representativePsi = pair.component2();
            KtElement ktElement = representativePsi;
            if (ktElement == null) {
                ktElement = sourcePsi;
            }
            ktAnnotationValue2 = new KtArrayAnnotationValue(annotationValues, ktElement);
        } else if (firConstExpression instanceof FirArrayOfCall) {
            ktAnnotationValue2 = new KtArrayAnnotationValue(this.convertVarargsExpression((Collection<? extends FirExpression>)((FirArrayOfCall)((Object)$this$convertConstantExpression)).getArgumentList().getArguments(), session).getFirst(), sourcePsi);
        } else if (firConstExpression instanceof FirFunctionCall) {
            FirNamedReference representativePsi = ((FirFunctionCall)((Object)$this$convertConstantExpression)).getCalleeReference();
            FirResolvedNamedReference firResolvedNamedReference = representativePsi instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)representativePsi : null;
            if (firResolvedNamedReference == null) {
                return null;
            }
            FirResolvedNamedReference reference2 = firResolvedNamedReference;
            FirBasedSymbol<?> resolvedSymbol = reference2.getResolvedSymbol();
            if (resolvedSymbol instanceof FirConstructorSymbol) {
                KtAnnotationApplicationValue ktAnnotationApplicationValue;
                FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol(resolvedSymbol, session);
                if (firClassLikeSymbol == null) {
                    return null;
                }
                FirClassLikeSymbol<?> classSymbol2 = firClassLikeSymbol;
                Object object = classSymbol2.getFir();
                FirClass firClass = object instanceof FirClass ? (FirClass)object : null;
                if ((firClass != null ? firClass.getClassKind() : null) == ClassKind.ANNOTATION_CLASS) {
                    Map resultMap = new LinkedHashMap();
                    FirCall $this$resolvedArgumentMapping$iv = (FirCall)((Object)$this$convertConstantExpression);
                    boolean $i$f$getResolvedArgumentMapping = false;
                    FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
                    LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
                    Object object2 = linkedHashMap;
                    if (linkedHashMap != null && (object2 = ((LinkedHashMap)object2).entrySet()) != null) {
                        Iterable $this$forEach$iv = (Iterable)object2;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Map.Entry entry = (Map.Entry)element$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNull(entry);
                            FirExpression arg = (FirExpression)entry.getKey();
                            FirValueParameter param = (FirValueParameter)entry.getValue();
                            Name name2 = param.getName();
                            Intrinsics.checkNotNull(arg);
                            resultMap.put(name2, arg);
                        }
                    }
                    ktAnnotationApplicationValue = new KtAnnotationApplicationValue(new KtAnnotationApplicationWithArgumentsInfo(((FirConstructorSymbol)resolvedSymbol).getCallableId().getClassId(), (object = UtilsKt.getPsi($this$convertConstantExpression)) instanceof KtCallElement ? (KtCallElement)object : null, null, this.toNamedConstantValue(resultMap, session), null));
                } else {
                    ktAnnotationApplicationValue = null;
                }
                ktAnnotationValue2 = ktAnnotationApplicationValue;
            } else {
                ktAnnotationValue2 = resolvedSymbol instanceof FirNamedFunctionSymbol ? (ArrayFqNames.ARRAY_CALL_FQ_NAMES.contains(((FirNamedFunctionSymbol)resolvedSymbol).getCallableId().asSingleFqName()) ? this.convertConstantExpression(CollectionsKt.single(((FirFunctionCall)((Object)$this$convertConstantExpression)).getArgumentList().getArguments()), session) : null) : (resolvedSymbol instanceof FirEnumEntrySymbol ? (KtAnnotationValue)new KtEnumEntryAnnotationValue(((FirEnumEntrySymbol)resolvedSymbol).getCallableId(), sourcePsi) : null);
            }
        } else if (firConstExpression instanceof FirPropertyAccessExpression) {
            FirReference classSymbol2 = ((FirPropertyAccessExpression)((Object)$this$convertConstantExpression)).getCalleeReference();
            FirResolvedNamedReference firResolvedNamedReference = classSymbol2 instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)classSymbol2 : null;
            if (firResolvedNamedReference == null) {
                return null;
            }
            FirResolvedNamedReference reference3 = firResolvedNamedReference;
            FirBasedSymbol<?> resolvedSymbol = reference3.getResolvedSymbol();
            ktAnnotationValue2 = resolvedSymbol instanceof FirEnumEntrySymbol ? new KtEnumEntryAnnotationValue(((FirEnumEntrySymbol)resolvedSymbol).getCallableId(), sourcePsi) : null;
        } else if (firConstExpression instanceof FirGetClassCall) {
            KtKClassAnnotationValue ktKClassAnnotationValue;
            FirClassLikeSymbol<?> symbol2;
            FirExpression classSymbol2 = ((FirGetClassCall)((Object)$this$convertConstantExpression)).getArgument();
            FirResolvedQualifier firResolvedQualifier = classSymbol2 instanceof FirResolvedQualifier ? (FirResolvedQualifier)classSymbol2 : null;
            FirClassLikeSymbol<Object> firClassLikeSymbol = symbol2 = firResolvedQualifier != null ? firResolvedQualifier.getSymbol() : null;
            if (symbol2 instanceof FirTypeAliasSymbol) {
                FirRegularClassSymbol firRegularClassSymbol = DeclarationUtilsKt.fullyExpandedClass(symbol2, session);
                symbol2 = firRegularClassSymbol != null ? (FirClassLikeSymbol<?>)firRegularClassSymbol : symbol2;
            }
            if (symbol2 == null) {
                List list2;
                List qualifierParts = new ArrayList();
                FirAnnotationValueConverter.convertConstantExpression$process(qualifierParts, ((FirGetClassCall)((Object)$this$convertConstantExpression)).getArgument());
                List it = list2 = CollectionsKt.filterNotNull(CollectionsKt.asReversedMutable(qualifierParts));
                boolean bl = false;
                List<Object> list3 = !((Collection)it).isEmpty() ? list2 : null;
                String unresolvedName = list3 != null ? CollectionsKt.joinToString$default(list3, ".", null, null, 0, null, null, 62, null) : null;
                ktKClassAnnotationValue = new KtKClassAnnotationValue.KtErrorClassAnnotationValue(sourcePsi, unresolvedName);
            } else {
                FirClassLikeSymbol<?> $this$isLocal$iv = symbol2;
                boolean $i$f$isLocal = false;
                if ($this$isLocal$iv.getClassId().isLocal()) {
                    PsiElement psiElement2 = UtilsKt.getPsi((FirElement)symbol2.getFir());
                    Intrinsics.checkNotNull(psiElement2, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
                    ktKClassAnnotationValue = new KtKClassAnnotationValue.KtLocalKClassAnnotationValue((KtClassOrObject)psiElement2, sourcePsi);
                } else {
                    ktKClassAnnotationValue = new KtKClassAnnotationValue.KtNonLocalKClassAnnotationValue(symbol2.getClassId(), sourcePsi);
                }
            }
            ktAnnotationValue2 = ktKClassAnnotationValue;
        } else {
            ktAnnotationValue2 = ktAnnotationValue = null;
        }
        if (ktAnnotationValue2 == null) {
            firConstExpression = FirCompileTimeConstantEvaluator.INSTANCE.evaluate((FirElement)$this$convertConstantExpression, KtConstantEvaluationMode.CONSTANT_EXPRESSION_EVALUATION);
            ktAnnotationValue = firConstExpression != null ? this.convertConstantExpression(firConstExpression) : null;
        }
        return ktAnnotationValue;
    }

    private static final void convertConstantExpression$process(List<String> qualifierParts, FirExpression expression2) {
        block1: {
            ConeDiagnostic diagnostic;
            ConeErrorType errorType;
            ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType(expression2.getTypeRef());
            ConeErrorType coneErrorType = errorType = coneKotlinType instanceof ConeErrorType ? (ConeErrorType)coneKotlinType : null;
            ConeDiagnostic coneDiagnostic = diagnostic = coneErrorType != null ? coneErrorType.getDiagnostic() : null;
            String unresolvedName = diagnostic instanceof ConeUnresolvedTypeQualifierError ? ((ConeUnresolvedTypeQualifierError)diagnostic).getQualifier() : (diagnostic instanceof ConeUnresolvedNameError ? ((ConeUnresolvedNameError)diagnostic).getQualifier() : null);
            ((Collection)qualifierParts).add(unresolvedName);
            if (errorType == null || !(expression2 instanceof FirPropertyAccessExpression)) break block1;
            FirExpression firExpression2 = ((FirPropertyAccessExpression)expression2).getExplicitReceiver();
            if (firExpression2 != null) {
                FirExpression it = firExpression2;
                boolean bl = false;
                FirAnnotationValueConverter.convertConstantExpression$process(qualifierParts, it);
            }
        }
    }
}

