/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.CachingSemiGraph;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.ModuleDependenciesDescriptor;
import com.intellij.ide.plugins.PluginContentDescriptor;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginLoadingError;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.PluginSetBuilder;
import com.intellij.ide.plugins.PluginSetBuilderKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.lang.Java11Shim;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001a\u0010\u001e\u001a\u00020\u00182\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0!0 J\u0018\u0010\"\u001a\u00020\u00002\u0010\b\u0002\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010$J\u0016\u0010%\u001a\u00020&2\u000e\b\u0002\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040(J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0013\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0002\u00a2\u0006\u0002\u0010+JY\u0010,\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u00042\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0004002\f\u00101\u001a\b\u0012\u0004\u0012\u00020\n022\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020403H\u0000\u00a2\u0006\u0002\b5R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00040\u00040\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00066"}, d2={"Lcom/intellij/ide/plugins/PluginSetBuilder;", "", "unsortedPlugins", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "(Ljava/util/List;)V", "enabledModuleV2Ids", "Ljava/util/HashMap;", "", "enabledPluginIds", "Lcom/intellij/openapi/extensions/PluginId;", "graph", "Lcom/intellij/ide/plugins/CachingSemiGraph;", "sortedModules", "", "[Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "topologicalComparator", "Ljava/util/Comparator;", "topologicalSorter", "Lcom/intellij/util/graph/DFSTBuilder;", "kotlin.jvm.PlatformType", "getUnsortedPlugins", "()Ljava/util/List;", "checkModules", "", "descriptor", "isDebugLogEnabled", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "checkPluginCycles", "errors", "", "Ljava/util/function/Supplier;", "computeEnabledModuleMap", "disabler", "Ljava/util/function/Predicate;", "createPluginSet", "Lcom/intellij/ide/plugins/PluginSet;", "incompletePlugins", "", "getEnabledModules", "getSortedPlugins", "()[Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "initEnableState", "idMap", "", "disabledRequired", "", "disabledPlugins", "", "", "Lcom/intellij/ide/plugins/PluginLoadingError;", "initEnableState$intellij_platform_core_impl", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class PluginSetBuilder {
    private final CachingSemiGraph<IdeaPluginDescriptorImpl> graph;
    private final IdeaPluginDescriptorImpl[] sortedModules;
    private final DFSTBuilder<IdeaPluginDescriptorImpl> topologicalSorter;
    private final Comparator<IdeaPluginDescriptorImpl> topologicalComparator;
    private final HashMap<PluginId, IdeaPluginDescriptorImpl> enabledPluginIds;
    private final HashMap<String, IdeaPluginDescriptorImpl> enabledModuleV2Ids;
    @NotNull
    private final List<IdeaPluginDescriptorImpl> unsortedPlugins;

    /*
     * WARNING - void declaration
     */
    public final void checkPluginCycles(@NotNull List<Supplier<String>> errors) {
        Intrinsics.checkNotNullParameter(errors, "errors");
        if (this.topologicalSorter.isAcyclic()) {
            return;
        }
        for (Collection<IdeaPluginDescriptorImpl> component : this.topologicalSorter.getComponents()) {
            void $this$forEach$iv;
            if (component.size() < 2) continue;
            Iterator<IdeaPluginDescriptorImpl> iterator2 = component.iterator();
            while (iterator2.hasNext()) {
                IdeaPluginDescriptorImpl plugin;
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = plugin = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(ideaPluginDescriptorImpl, "plugin");
                ideaPluginDescriptorImpl.setEnabled(false);
            }
            Collection<IdeaPluginDescriptorImpl> collection = component;
            Intrinsics.checkNotNullExpressionValue(collection, "component");
            String pluginsString2 = CollectionsKt.joinToString$default(collection, ", ", null, null, 0, null, checkPluginCycles.pluginsString.1.INSTANCE, 30, null);
            errors.add(PluginSetBuilderKt.access$message("plugin.loading.error.plugins.cannot.be.loaded.because.they.form.a.dependency.cycle", pluginsString2));
            StringBuilder detailedMessage = new StringBuilder();
            Function1 pluginToString2 = checkPluginCycles.pluginToString.1.INSTANCE;
            detailedMessage.append("Detected plugin dependencies cycle details (only related dependencies are included):\n");
            Sequence sequence2 = SequencesKt.map(CollectionsKt.asSequence((Iterable)component), (Function1)new Function1<IdeaPluginDescriptorImpl, Pair<? extends IdeaPluginDescriptorImpl, ? extends String>>(pluginToString2){
                final /* synthetic */ Function1 $pluginToString;

                @NotNull
                public final Pair<IdeaPluginDescriptorImpl, String> invoke(IdeaPluginDescriptorImpl it) {
                    IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = it;
                    Intrinsics.checkNotNullExpressionValue(ideaPluginDescriptorImpl, "it");
                    return new Pair<IdeaPluginDescriptorImpl, String>(it, (String)this.$pluginToString.invoke(ideaPluginDescriptorImpl));
                }
                {
                    this.$pluginToString = function1;
                    super(1);
                }
            });
            Comparator comparator = Comparator.comparing(checkPluginCycles.2.INSTANCE, StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
            Intrinsics.checkNotNullExpressionValue(comparator, "Comparator.comparing({ i\u2026g.CASE_INSENSITIVE_ORDER)");
            Sequence sequence3 = SequencesKt.sortedWith(sequence2, comparator);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                Pair it = (Pair)element$iv;
                boolean bl = false;
                detailedMessage.append("  ").append((String)it.getSecond()).append(" depends on:\n");
                Object a = it.getFirst();
                Intrinsics.checkNotNullExpressionValue(a, "it.first");
                Sequence sequence4 = SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.graph.getIn((IdeaPluginDescriptorImpl)a)), (Function1)new Function1<IdeaPluginDescriptorImpl, Boolean>(this, detailedMessage, component, pluginToString2){
                    final /* synthetic */ PluginSetBuilder this$0;
                    final /* synthetic */ StringBuilder $detailedMessage$inlined;
                    final /* synthetic */ Collection $component$inlined;
                    final /* synthetic */ Function1 $pluginToString$inlined;
                    {
                        this.this$0 = pluginSetBuilder;
                        this.$detailedMessage$inlined = stringBuilder;
                        this.$component$inlined = collection;
                        this.$pluginToString$inlined = function1;
                        super(1);
                    }

                    public final boolean invoke(@NotNull IdeaPluginDescriptorImpl o) {
                        Intrinsics.checkNotNullParameter(o, "o");
                        return this.$component$inlined.contains(o);
                    }
                }), pluginToString2);
                Comparator comparator2 = String.CASE_INSENSITIVE_ORDER;
                Intrinsics.checkNotNullExpressionValue(comparator2, "java.lang.String.CASE_INSENSITIVE_ORDER");
                Sequence sequence5 = SequencesKt.sortedWith(sequence4, comparator2);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String dep = (String)element$iv2;
                    boolean bl2 = false;
                    detailedMessage.append("    ").append(dep).append("\n");
                }
            }
            PluginManagerCore.getLogger().info(detailedMessage.toString());
        }
    }

    private final IdeaPluginDescriptorImpl[] getSortedPlugins() {
        Object2IntOpenHashMap<PluginId> pluginToNumber = new Object2IntOpenHashMap<PluginId>(this.unsortedPlugins.size());
        pluginToNumber.put(PluginManagerCore.CORE_ID, 0);
        int number = 0;
        for (IdeaPluginDescriptorImpl module2 : this.sortedModules) {
            if (module2.descriptorPath == null && !module2.content.modules.isEmpty()) continue;
            pluginToNumber.putIfAbsent(module2.getPluginId(), number++);
        }
        Collection $this$toTypedArray$iv = this.unsortedPlugins;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray = thisCollection$iv.toArray(new IdeaPluginDescriptorImpl[0]);
        if (ideaPluginDescriptorImplArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        IdeaPluginDescriptorImpl[] sorted2 = ideaPluginDescriptorImplArray;
        Arrays.sort(sorted2, new Comparator(pluginToNumber){
            final /* synthetic */ Object2IntOpenHashMap $pluginToNumber;

            public final int compare(IdeaPluginDescriptorImpl o1, IdeaPluginDescriptorImpl o2) {
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = o1;
                Intrinsics.checkNotNullExpressionValue(ideaPluginDescriptorImpl, "o1");
                int n = this.$pluginToNumber.getInt(ideaPluginDescriptorImpl.getPluginId());
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl2 = o2;
                Intrinsics.checkNotNullExpressionValue(ideaPluginDescriptorImpl2, "o2");
                return n - this.$pluginToNumber.getInt(ideaPluginDescriptorImpl2.getPluginId());
            }
            {
                this.$pluginToNumber = object2IntOpenHashMap;
            }
        });
        return sorted2;
    }

    private final List<IdeaPluginDescriptorImpl> getEnabledModules() {
        ArrayList<IdeaPluginDescriptorImpl> result2 = new ArrayList<IdeaPluginDescriptorImpl>(this.sortedModules.length);
        for (IdeaPluginDescriptorImpl module2 : this.sortedModules) {
            if (!(module2.moduleName == null ? module2.isEnabled() : this.enabledModuleV2Ids.containsKey(module2.moduleName))) continue;
            result2.add(module2);
        }
        return result2;
    }

    @NotNull
    public final PluginSetBuilder computeEnabledModuleMap(@Nullable Predicate<IdeaPluginDescriptorImpl> disabler) {
        ArrayList<String> logMessages = new ArrayList<String>();
        block0: for (IdeaPluginDescriptorImpl module2 : this.sortedModules) {
            if (module2.moduleName == null ? Intrinsics.areEqual(module2.getPluginId(), PluginManagerCore.CORE_ID) ^ true && (!module2.isEnabled() || disabler != null && disabler.test(module2)) : !this.enabledPluginIds.containsKey(module2.getPluginId())) continue;
            for (ModuleDependenciesDescriptor.ModuleReference moduleReference : module2.dependencies.modules) {
                if (this.enabledModuleV2Ids.containsKey(moduleReference.name)) continue;
                String string2 = module2.moduleName;
                logMessages.add("Module " + (string2 != null ? (Comparable)((Object)string2) : (Comparable)module2.getPluginId()) + " is not enabled because dependency " + moduleReference.name + " is not available");
                continue block0;
            }
            for (ModuleDependenciesDescriptor.PluginReference pluginReference : module2.dependencies.plugins) {
                if (this.enabledPluginIds.containsKey(pluginReference.id)) continue;
                String string3 = module2.moduleName;
                logMessages.add("Module " + (string3 != null ? (Comparable)((Object)string3) : (Comparable)module2.getPluginId()) + " is not enabled because dependency " + pluginReference.id + " is not available");
                continue block0;
            }
            if (module2.moduleName == null) {
                this.enabledPluginIds.put(module2.getPluginId(), module2);
                for (PluginId pluginId : module2.modules) {
                    this.enabledPluginIds.put(pluginId, module2);
                }
                if (module2.packagePrefix == null) continue;
                this.enabledModuleV2Ids.put(module2.getPluginId().getIdString(), module2);
                continue;
            }
            this.enabledModuleV2Ids.put(module2.moduleName, module2);
        }
        if (!logMessages.isEmpty()) {
            PluginManagerCore.getLogger().info(CollectionsKt.joinToString$default(logMessages, "\n", null, null, 0, null, null, 62, null));
        }
        return this;
    }

    public static /* synthetic */ PluginSetBuilder computeEnabledModuleMap$default(PluginSetBuilder pluginSetBuilder, Predicate predicate, int n, Object object) {
        if ((n & 1) != 0) {
            predicate = null;
        }
        return pluginSetBuilder.computeEnabledModuleMap(predicate);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PluginSet createPluginSet(@NotNull Collection<IdeaPluginDescriptorImpl> incompletePlugins) {
        void destination$iv;
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter(incompletePlugins, "incompletePlugins");
        Java11Shim java11Shim = Java11Shim.INSTANCE;
        Intrinsics.checkNotNullExpressionValue(java11Shim, "Java11Shim.INSTANCE");
        Java11Shim java11Shim2 = java11Shim;
        List<IdeaPluginDescriptorImpl> allPlugins = null;
        IdeaPluginDescriptorImpl[] sortedPlugins = this.getSortedPlugins();
        if (incompletePlugins.isEmpty()) {
            ImmutableList<IdeaPluginDescriptorImpl> immutableList = ContainerUtil.immutableList(Arrays.copyOf(sortedPlugins, sortedPlugins.length));
            Intrinsics.checkNotNullExpressionValue(immutableList, "ContainerUtil.immutableList(*sortedPlugins)");
            allPlugins = (List<IdeaPluginDescriptorImpl>)immutableList;
        } else {
            ArrayList<IdeaPluginDescriptorImpl> result2 = new ArrayList<IdeaPluginDescriptorImpl>(sortedPlugins.length + incompletePlugins.size());
            CollectionsKt.addAll((Collection)result2, sortedPlugins);
            result2.addAll(incompletePlugins);
            List<IdeaPluginDescriptorImpl> list2 = java11Shim2.copyOfCollection((Collection)result2);
            Intrinsics.checkNotNullExpressionValue(list2, "java11Shim.copyOfCollection(result)");
            allPlugins = list2;
        }
        IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray = sortedPlugins;
        Collection collection = new ArrayList(sortedPlugins.length);
        Java11Shim java11Shim3 = java11Shim2;
        boolean $i$f$filterTo = false;
        void var9_10 = $this$filterTo$iv;
        int n = ((void)var9_10).length;
        for (int i = 0; i < n; ++i) {
            void element$iv;
            void it = element$iv = var9_10[i];
            boolean bl = false;
            if (!it.isEnabled()) continue;
            destination$iv.add(element$iv);
        }
        void var16_16 = destination$iv;
        List<IdeaPluginDescriptorImpl> list3 = java11Shim3.copyOfCollection(var16_16);
        Intrinsics.checkNotNullExpressionValue(list3, "java11Shim.copyOfCollect\u2026.size)) { it.isEnabled })");
        List<IdeaPluginDescriptorImpl> enabledPlugins = list3;
        IdentityHashMap moduleToSortedDirectDependencies = new IdentityHashMap(this.graph.moduleToDirectDependencies.size());
        this.graph.moduleToDirectDependencies.forEach(new BiConsumer(this, moduleToSortedDirectDependencies){
            final /* synthetic */ PluginSetBuilder this$0;
            final /* synthetic */ IdentityHashMap $moduleToSortedDirectDependencies;

            public final void accept(@NotNull IdeaPluginDescriptorImpl k, @NotNull List<IdeaPluginDescriptorImpl> v) {
                Intrinsics.checkNotNullParameter(k, "k");
                Intrinsics.checkNotNullParameter(v, "v");
                Collection $this$toTypedArray$iv = v;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray = thisCollection$iv.toArray(new IdeaPluginDescriptorImpl[0]);
                if (ideaPluginDescriptorImplArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                IdeaPluginDescriptorImpl[] list2 = ideaPluginDescriptorImplArray;
                Arrays.sort(list2, PluginSetBuilder.access$getTopologicalComparator$p(this.this$0));
                this.$moduleToSortedDirectDependencies.put(k, list2);
            }
            {
                this.this$0 = pluginSetBuilder;
                this.$moduleToSortedDirectDependencies = identityHashMap;
            }
        });
        Map<String, IdeaPluginDescriptorImpl> map = java11Shim2.copyOf((Map)this.enabledModuleV2Ids);
        Intrinsics.checkNotNullExpressionValue(map, "java11Shim.copyOf(enabledModuleV2Ids)");
        Map<PluginId, IdeaPluginDescriptorImpl> map2 = java11Shim2.copyOf((Map)this.enabledPluginIds);
        Intrinsics.checkNotNullExpressionValue(map2, "java11Shim.copyOf(enabledPluginIds)");
        List<IdeaPluginDescriptorImpl> list4 = java11Shim2.copyOfCollection((Collection)this.getEnabledModules());
        Intrinsics.checkNotNullExpressionValue(list4, "java11Shim.copyOfCollection(getEnabledModules())");
        Map<IdeaPluginDescriptorImpl, IdeaPluginDescriptorImpl[]> map3 = java11Shim2.copyOf(moduleToSortedDirectDependencies);
        Intrinsics.checkNotNullExpressionValue(map3, "java11Shim.copyOf(module\u2026SortedDirectDependencies)");
        return new PluginSet(allPlugins, enabledPlugins, map, map2, list4, map3);
    }

    public static /* synthetic */ PluginSet createPluginSet$default(PluginSetBuilder pluginSetBuilder, Collection collection, int n, Object object) {
        if ((n & 1) != 0) {
            List list2 = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list2, "Collections.emptyList()");
            collection = list2;
        }
        return pluginSetBuilder.createPluginSet(collection);
    }

    public final void checkModules(@NotNull IdeaPluginDescriptorImpl descriptor2, boolean isDebugLogEnabled, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(log, "log");
        block0: for (PluginContentDescriptor.ModuleItem item : descriptor2.content.modules) {
            for (ModuleDependenciesDescriptor.ModuleReference moduleReference : item.requireDescriptor().dependencies.modules) {
                if (this.enabledModuleV2Ids.containsKey(moduleReference.name)) continue;
                if (!isDebugLogEnabled) continue block0;
                log.info("Module " + item.name + " is not enabled because dependency " + moduleReference.name + " is not available");
                continue block0;
            }
            for (ModuleDependenciesDescriptor.PluginReference pluginReference : item.requireDescriptor().dependencies.plugins) {
                if (this.enabledPluginIds.containsKey(pluginReference.id)) continue;
                if (!isDebugLogEnabled) continue block0;
                log.info("Module " + item.name + " is not enabled because dependency " + pluginReference.id + " is not available");
                continue block0;
            }
            this.enabledModuleV2Ids.put(item.name, descriptor2);
        }
    }

    public final boolean initEnableState$intellij_platform_core_impl(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @NotNull Set<IdeaPluginDescriptorImpl> disabledRequired, @NotNull Set<PluginId> disabledPlugins, @NotNull Map<PluginId, PluginLoadingError> errors) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(idMap, "idMap");
        Intrinsics.checkNotNullParameter(disabledRequired, "disabledRequired");
        Intrinsics.checkNotNullParameter(disabledPlugins, "disabledPlugins");
        Intrinsics.checkNotNullParameter(errors, "errors");
        boolean notifyUser = !descriptor2.isImplementationDetail();
        for (PluginId pluginId : descriptor2.incompatibilities) {
            if (!this.enabledPluginIds.containsKey(pluginId) || disabledPlugins.contains(pluginId)) continue;
            String string2 = pluginId.getIdString();
            Intrinsics.checkNotNullExpressionValue(string2, "incompatibleId.idString");
            String presentableName2 = string2;
            errors.put(descriptor2.getPluginId(), new PluginLoadingError(descriptor2, PluginSetBuilderKt.access$message("plugin.loading.error.long.ide.contains.conflicting.module", descriptor2.getName(), presentableName2), PluginSetBuilderKt.access$message("plugin.loading.error.short.ide.contains.conflicting.module", presentableName2), notifyUser, null, 16, null));
            return false;
        }
        for (PluginDependency pluginDependency : descriptor2.pluginDependencies) {
            PluginId depId = pluginDependency.getPluginId();
            if (pluginDependency.isOptional() || this.enabledPluginIds.containsKey(depId)) continue;
            IdeaPluginDescriptorImpl dep = idMap.get(depId);
            if (dep != null && disabledPlugins.contains(depId)) {
                disabledRequired.add(dep);
            }
            PluginSetBuilderKt.access$addCannotLoadError(descriptor2, errors, notifyUser, depId, dep);
            return false;
        }
        for (ModuleDependenciesDescriptor.PluginReference pluginReference : descriptor2.dependencies.plugins) {
            if (this.enabledPluginIds.containsKey(pluginReference.id)) continue;
            IdeaPluginDescriptorImpl dep = idMap.get(pluginReference.id);
            if (dep != null && disabledPlugins.contains(pluginReference.id)) {
                disabledRequired.add(dep);
            }
            PluginSetBuilderKt.access$addCannotLoadError(descriptor2, errors, notifyUser, pluginReference.id, dep);
            return false;
        }
        for (ModuleDependenciesDescriptor.ModuleReference moduleReference : descriptor2.dependencies.modules) {
            if (this.enabledModuleV2Ids.containsKey(moduleReference.name)) continue;
            errors.put(descriptor2.getPluginId(), new PluginLoadingError(descriptor2, PluginSetBuilderKt.access$message("plugin.loading.error.long.depends.on.not.installed.plugin", descriptor2.getName(), moduleReference.name), PluginSetBuilderKt.access$message("plugin.loading.error.short.depends.on.not.installed.plugin", moduleReference.name), notifyUser, null, 16, null));
            return false;
        }
        return true;
    }

    @NotNull
    public final List<IdeaPluginDescriptorImpl> getUnsortedPlugins() {
        return this.unsortedPlugins;
    }

    public PluginSetBuilder(@NotNull List<IdeaPluginDescriptorImpl> unsortedPlugins) {
        Intrinsics.checkNotNullParameter(unsortedPlugins, "unsortedPlugins");
        this.unsortedPlugins = unsortedPlugins;
        this.graph = CachingSemiGraph.Companion.createModuleGraph(this.unsortedPlugins);
        Collection $this$toTypedArray$iv = this.graph.nodes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray = thisCollection$iv.toArray(new IdeaPluginDescriptorImpl[0]);
        if (ideaPluginDescriptorImplArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        this.sortedModules = ideaPluginDescriptorImplArray;
        this.topologicalSorter = new DFSTBuilder<Object>((Object[])this.sortedModules.clone(), null, true, (DFSTBuilder.DFSTBuilderAwareGraph)this.graph);
        this.topologicalComparator = CachingSemiGraph.Companion.getTopologicalComparator(this.topologicalSorter);
        this.enabledPluginIds = new HashMap(this.unsortedPlugins.size());
        this.enabledModuleV2Ids = new HashMap(this.unsortedPlugins.size() * 2);
        Arrays.sort(this.sortedModules, this.topologicalComparator);
    }

    public static final /* synthetic */ Comparator access$getTopologicalComparator$p(PluginSetBuilder $this) {
        return $this.topologicalComparator;
    }
}

