/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.ksp;

import com.google.devtools.ksp.MemoizedSequence;
import com.google.devtools.ksp.PsiUtilsKt;
import com.google.devtools.ksp.symbol.ClassKind;
import com.google.devtools.ksp.symbol.Modifier;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u001a\u001a\u0010\u0011\u001a\u00020\u000f*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u001c\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\u0006\b\u0000\u0010\u0018\u0018\u0001*\u00020\u0019H\u0086\b\u00a2\u0006\u0002\u0010\u001a\u001a\n\u0010\u001b\u001a\u00020\u001c*\u00020\u001d\u001a\f\u0010\u001e\u001a\u0004\u0018\u00010\u000f*\u00020\u0019\u001a\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00180 \"\u0004\b\u0000\u0010\u0018*\b\u0012\u0004\u0012\u0002H\u00180!\u001a\u0010\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020#\u001a\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u0004\u0018\u00010$\u001a\u0010\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020%\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"%\u0010\n\u001a\u0016\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006&"}, d2={"javaModifiers", "", "Lcom/google/devtools/ksp/symbol/Modifier;", "getJavaModifiers", "()Ljava/util/Set;", "jvmModifierMap", "", "Lcom/intellij/lang/jvm/JvmModifier;", "getJvmModifierMap", "()Ljava/util/Map;", "modifierMap", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "kotlin.jvm.PlatformType", "getModifierMap", "parseDocString", "", "raw", "findLocationString", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "findParentOfType", "T", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Object;", "getClassType", "Lcom/google/devtools/ksp/symbol/ClassKind;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getDocString", "memoized", "Lcom/google/devtools/ksp/MemoizedSequence;", "Lkotlin/sequences/Sequence;", "toKSModifiers", "Lcom/intellij/psi/PsiModifierListOwner;", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "common-util"})
@SourceDebugExtension(value={"SMAP\nPsiUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiUtils.kt\ncom/google/devtools/ksp/PsiUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,176:1\n766#2:177\n857#2,2:178\n1549#2:180\n1620#2,3:181\n766#2:184\n857#2,2:185\n1549#2:187\n1620#2,3:188\n179#3,2:191\n*S KotlinDebug\n*F\n+ 1 PsiUtils.kt\ncom/google/devtools/ksp/PsiUtilsKt\n*L\n106#1:177\n106#1:178,2\n107#1:180\n107#1:181,3\n120#1:184\n120#1:185,2\n121#1:187\n121#1:188,3\n149#1:191,2\n*E\n"})
public final class PsiUtilsKt {
    @NotNull
    private static final Map<JvmModifier, Modifier> jvmModifierMap;
    @NotNull
    private static final Set<Modifier> javaModifiers;
    @NotNull
    private static final Map<KtModifierKeywordToken, Modifier> modifierMap;

    @NotNull
    public static final Map<JvmModifier, Modifier> getJvmModifierMap() {
        return jvmModifierMap;
    }

    @NotNull
    public static final Set<Modifier> getJavaModifiers() {
        return javaModifiers;
    }

    @NotNull
    public static final Map<KtModifierKeywordToken, Modifier> getModifierMap() {
        return modifierMap;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<Modifier> toKSModifiers(@Nullable KtModifierList $this$toKSModifiers) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        if ($this$toKSModifiers == null) {
            return SetsKt.emptySet();
        }
        Set modifiers2 = new LinkedHashSet();
        Iterable iterable = modifierMap.entrySet();
        Set set = modifiers2;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!$this$toKSModifiers.hasModifier((KtModifierKeywordToken)it.getKey())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Modifier)((Object)it.getValue()));
        }
        set.addAll((List)destination$iv$iv);
        return modifiers2;
    }

    @NotNull
    public static final Set<Modifier> toKSModifiers(@NotNull KtModifierListOwner $this$toKSModifiers) {
        Intrinsics.checkNotNullParameter($this$toKSModifiers, "<this>");
        KtModifierList modifierList2 = $this$toKSModifiers.getModifierList();
        return PsiUtilsKt.toKSModifiers(modifierList2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<Modifier> toKSModifiers(@NotNull PsiModifierListOwner $this$toKSModifiers) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter($this$toKSModifiers, "<this>");
        Set modifiers2 = new LinkedHashSet();
        Iterable iterable = jvmModifierMap.entrySet();
        Set set = modifiers2;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!$this$toKSModifiers.hasModifier((JvmModifier)((Object)it.getKey()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Modifier)((Object)it.getValue()));
        }
        set.addAll(CollectionsKt.toSet((List)destination$iv$iv));
        PsiModifierList psiModifierList = $this$toKSModifiers.getModifierList();
        boolean bl = psiModifierList != null ? psiModifierList.hasExplicitModifier("default") : false;
        if (bl) {
            modifiers2.add(Modifier.JAVA_DEFAULT);
        }
        return modifiers2;
    }

    @NotNull
    public static final String findLocationString(@NotNull Project $this$findLocationString, @NotNull PsiFile file2, int offset) {
        Intrinsics.checkNotNullParameter($this$findLocationString, "<this>");
        Intrinsics.checkNotNullParameter(file2, "file");
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance($this$findLocationString);
        Document document2 = psiDocumentManager.getDocument(file2);
        if (document2 == null) {
            return "<unknown>";
        }
        Document document3 = document2;
        int lineNumber = document3.getLineNumber(offset);
        int offsetInLine = offset - document3.getLineStartOffset(lineNumber);
        return file2.getVirtualFile().getPath() + ": (" + (lineNumber + 1) + ", " + (offsetInLine + 1) + ')';
    }

    private static final String parseDocString(String raw) {
        String t1 = ((Object)StringsKt.trim((CharSequence)raw)).toString();
        if (!StringsKt.startsWith$default(t1, "/**", false, 2, null) || !StringsKt.endsWith$default(t1, "*/", false, 2, null)) {
            return null;
        }
        String[] stringArray = new String[]{"\r\n", "\n", "\r"};
        Object object = StringsKt.findAnyOf$default(t1, CollectionsKt.listOf(stringArray), 0, false, 6, null);
        if (object == null || (object = (String)((Pair)object).getSecond()) == null) {
            object = "";
        }
        Object lineSep = object;
        char[] cArray = new char[]{'/'};
        String string2 = StringsKt.trim(t1, cArray);
        cArray = new char[]{'*'};
        return CollectionsKt.joinToString$default(StringsKt.lines(StringsKt.trim(string2, cArray)), (CharSequence)lineSep, null, null, 0, null, parseDocString.1.INSTANCE, 30, null);
    }

    @Nullable
    public static final String getDocString(@NotNull PsiElement $this$getDocString) {
        String string2;
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter($this$getDocString, "<this>");
            PsiElement psiElement = $this$getDocString.getFirstChild();
            Intrinsics.checkNotNullExpressionValue(psiElement, "this.firstChild");
            Sequence $this$firstOrNull$iv = org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt.siblings$default(psiElement, false, false, 3, null);
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof PsiComment)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        PsiElement psiElement = v1;
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            String string3 = it.getText();
            Intrinsics.checkNotNullExpressionValue(string3, "it.text");
            string2 = PsiUtilsKt.parseDocString(string3);
        } else {
            string2 = null;
        }
        return string2;
    }

    @NotNull
    public static final ClassKind getClassType(@NotNull KtClassOrObject $this$getClassType) {
        ClassKind classKind2;
        Intrinsics.checkNotNullParameter($this$getClassType, "<this>");
        KtClassOrObject ktClassOrObject = $this$getClassType;
        if (ktClassOrObject instanceof KtObjectDeclaration) {
            classKind2 = ClassKind.OBJECT;
        } else if (ktClassOrObject instanceof KtEnumEntry) {
            classKind2 = ClassKind.ENUM_ENTRY;
        } else if (ktClassOrObject instanceof KtClass) {
            classKind2 = ((KtClass)$this$getClassType).isEnum() ? ClassKind.ENUM_CLASS : (((KtClass)$this$getClassType).isInterface() ? ClassKind.INTERFACE : ($this$getClassType.isAnnotation() ? ClassKind.ANNOTATION_CLASS : ClassKind.CLASS));
        } else {
            throw new IllegalStateException("Unexpected psi type " + $this$getClassType.getClass() + ", please file a bug at https://github.com/google/ksp/issues/new");
        }
        return classKind2;
    }

    public static final /* synthetic */ <T> T findParentOfType(PsiElement $this$findParentOfType) {
        PsiElement parent2;
        Intrinsics.checkNotNullParameter($this$findParentOfType, "<this>");
        boolean $i$f$findParentOfType = false;
        for (parent2 = $this$findParentOfType.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            Intrinsics.reifiedOperationMarker(3, "T");
            if (parent2 instanceof Object) break;
        }
        Intrinsics.reifiedOperationMarker(2, "T");
        return (T)parent2;
    }

    @NotNull
    public static final <T> MemoizedSequence<T> memoized(@NotNull Sequence<? extends T> $this$memoized) {
        Intrinsics.checkNotNullParameter($this$memoized, "<this>");
        return new MemoizedSequence<T>($this$memoized);
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to(JvmModifier.PUBLIC, Modifier.PUBLIC), TuplesKt.to(JvmModifier.PRIVATE, Modifier.PRIVATE), TuplesKt.to(JvmModifier.ABSTRACT, Modifier.ABSTRACT), TuplesKt.to(JvmModifier.FINAL, Modifier.FINAL), TuplesKt.to(JvmModifier.PROTECTED, Modifier.PROTECTED), TuplesKt.to(JvmModifier.STATIC, Modifier.JAVA_STATIC), TuplesKt.to(JvmModifier.STRICTFP, Modifier.JAVA_STRICT), TuplesKt.to(JvmModifier.NATIVE, Modifier.JAVA_NATIVE), TuplesKt.to(JvmModifier.SYNCHRONIZED, Modifier.JAVA_SYNCHRONIZED), TuplesKt.to(JvmModifier.TRANSIENT, Modifier.JAVA_TRANSIENT), TuplesKt.to(JvmModifier.VOLATILE, Modifier.JAVA_VOLATILE)};
        jvmModifierMap = MapsKt.mapOf(objectArray);
        objectArray = new Modifier[]{Modifier.ABSTRACT, Modifier.FINAL, Modifier.JAVA_DEFAULT, Modifier.JAVA_NATIVE, Modifier.JAVA_STATIC, Modifier.JAVA_STRICT, Modifier.JAVA_SYNCHRONIZED, Modifier.JAVA_TRANSIENT, Modifier.JAVA_VOLATILE, Modifier.PRIVATE, Modifier.PROTECTED, Modifier.PUBLIC};
        javaModifiers = SetsKt.setOf(objectArray);
        objectArray = new Pair[]{TuplesKt.to(KtTokens.PUBLIC_KEYWORD, Modifier.PUBLIC), TuplesKt.to(KtTokens.PRIVATE_KEYWORD, Modifier.PRIVATE), TuplesKt.to(KtTokens.INTERNAL_KEYWORD, Modifier.INTERNAL), TuplesKt.to(KtTokens.PROTECTED_KEYWORD, Modifier.PROTECTED), TuplesKt.to(KtTokens.IN_KEYWORD, Modifier.IN), TuplesKt.to(KtTokens.OUT_KEYWORD, Modifier.OUT), TuplesKt.to(KtTokens.OVERRIDE_KEYWORD, Modifier.OVERRIDE), TuplesKt.to(KtTokens.LATEINIT_KEYWORD, Modifier.LATEINIT), TuplesKt.to(KtTokens.ENUM_KEYWORD, Modifier.ENUM), TuplesKt.to(KtTokens.SEALED_KEYWORD, Modifier.SEALED), TuplesKt.to(KtTokens.ANNOTATION_KEYWORD, Modifier.ANNOTATION), TuplesKt.to(KtTokens.DATA_KEYWORD, Modifier.DATA), TuplesKt.to(KtTokens.INNER_KEYWORD, Modifier.INNER), TuplesKt.to(KtTokens.FUN_KEYWORD, Modifier.FUN), TuplesKt.to(KtTokens.VALUE_KEYWORD, Modifier.VALUE), TuplesKt.to(KtTokens.SUSPEND_KEYWORD, Modifier.SUSPEND), TuplesKt.to(KtTokens.TAILREC_KEYWORD, Modifier.TAILREC), TuplesKt.to(KtTokens.OPERATOR_KEYWORD, Modifier.OPERATOR), TuplesKt.to(KtTokens.INFIX_KEYWORD, Modifier.INFIX), TuplesKt.to(KtTokens.INLINE_KEYWORD, Modifier.INLINE), TuplesKt.to(KtTokens.EXTERNAL_KEYWORD, Modifier.EXTERNAL), TuplesKt.to(KtTokens.ABSTRACT_KEYWORD, Modifier.ABSTRACT), TuplesKt.to(KtTokens.FINAL_KEYWORD, Modifier.FINAL), TuplesKt.to(KtTokens.OPEN_KEYWORD, Modifier.OPEN), TuplesKt.to(KtTokens.VARARG_KEYWORD, Modifier.VARARG), TuplesKt.to(KtTokens.NOINLINE_KEYWORD, Modifier.NOINLINE), TuplesKt.to(KtTokens.CROSSINLINE_KEYWORD, Modifier.CROSSINLINE), TuplesKt.to(KtTokens.REIFIED_KEYWORD, Modifier.REIFIED), TuplesKt.to(KtTokens.EXPECT_KEYWORD, Modifier.EXPECT), TuplesKt.to(KtTokens.ACTUAL_KEYWORD, Modifier.ACTUAL), TuplesKt.to(KtTokens.CONST_KEYWORD, Modifier.CONST)};
        modifierMap = MapsKt.mapOf(objectArray);
    }
}

