/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuperReferenceChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirSuperReferenceChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSuperReferenceChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuperReferenceChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,36:1\n1#2:37\n12271#3,2:38\n*S KotlinDebug\n*F\n+ 1 FirSuperReferenceChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuperReferenceChecker\n*L\n30#1:38,2\n*E\n"})
public final class FirSuperReferenceChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirSuperReferenceChecker INSTANCE = new FirSuperReferenceChecker();

    private FirSuperReferenceChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirPureAbstractElement it;
        FirSuperReference firSuperReference;
        block11: {
            block10: {
                FirSuperReference firSuperReference2;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                Intrinsics.checkNotNullParameter(context2, "context");
                Intrinsics.checkNotNullParameter(reporter, "reporter");
                FirReference firReference = expression2.getCalleeReference();
                firSuperReference = firReference instanceof FirSuperReference ? (FirSuperReference)firReference : null;
                if (firSuperReference == null) break block10;
                it = firSuperReference2 = firSuperReference;
                boolean bl = false;
                firSuperReference = ReferenceUtilsKt.hadExplicitTypeInSource(it) ? firSuperReference2 : null;
                if (firSuperReference != null) break block11;
            }
            return;
        }
        FirSuperReference superReference = firSuperReference;
        FirTypeRef superTypeRef = superReference.getSuperTypeRef();
        FirResolvedTypeRef firResolvedTypeRef = superTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)superTypeRef : null;
        it = firResolvedTypeRef != null ? firResolvedTypeRef.getDelegatedTypeRef() : null;
        FirUserTypeRef firUserTypeRef = it instanceof FirUserTypeRef ? (FirUserTypeRef)it : null;
        if (firUserTypeRef == null) {
            return;
        }
        FirUserTypeRef delegatedTypeRef = firUserTypeRef;
        Object object = CollectionsKt.firstOrNull(delegatedTypeRef.getQualifier());
        if (object == null || (object = object.getTypeArgumentList()) == null) {
            return;
        }
        Object typeArgumentList = object;
        ConeKotlinType superType2 = FirTypeUtilsKt.getConeType(superTypeRef);
        if (!(superType2 instanceof ConeErrorType) && !((Collection)typeArgumentList.getTypeArguments()).isEmpty()) {
            boolean bl;
            block9: {
                ConeTypeProjection[] $this$all$iv = superType2.getTypeArguments();
                boolean $i$f$all = false;
                int n = $this$all$iv.length;
                for (int i = 0; i < n; ++i) {
                    ConeTypeProjection element$iv;
                    ConeTypeProjection it2 = element$iv = $this$all$iv[i];
                    boolean bl2 = false;
                    if (!(it2 instanceof ConeErrorType)) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeArgumentList.getSource(), FirErrors.INSTANCE.getTYPE_ARGUMENTS_REDUNDANT_IN_SUPER_QUALIFIER(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }
}

