/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import com.google.common.collect.LinkedListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.CoveringTryCatchNodeProcessor;
import org.jetbrains.kotlin.codegen.inline.Interval;
import org.jetbrains.kotlin.codegen.inline.SplitPair;
import org.jetbrains.kotlin.codegen.inline.SplittableInterval;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001aJ<\u0010\u001b\u001a&\u0012\f\u0012\n \u0012*\u0004\u0018\u00018\u00008\u0000 \u0012*\u0012\u0012\f\u0012\n \u0012*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010!\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020 J\u001d\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010&J\u001d\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u00112\u0006\u0010%\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010&J)\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000*2\u0006\u0010+\u001a\u00028\u00002\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020 \u00a2\u0006\u0002\u0010/J\u0016\u00100\u001a\u00020\u00182\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020 J)\u00101\u001a\b\u0012\u0004\u0012\u00028\u00000*2\u0006\u0010+\u001a\u00028\u00002\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020 \u00a2\u0006\u0002\u0010/J\"\u00102\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000*0\u001d2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020 R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eRQ\u0010\u000f\u001aB\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0012\f\u0012\n \u0012*\u0004\u0018\u00018\u00008\u0000 \u0012* \u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0012\f\u0012\n \u0012*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\u00100\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014RQ\u0010\u0015\u001aB\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0012\f\u0012\n \u0012*\u0004\u0018\u00018\u00008\u0000 \u0012* \u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0012\f\u0012\n \u0012*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\u00100\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/codegen/inline/IntervalMetaInfo;", "T", "Lorg/jetbrains/kotlin/codegen/inline/SplittableInterval;", "", "processor", "Lorg/jetbrains/kotlin/codegen/inline/CoveringTryCatchNodeProcessor;", "(Lorg/jetbrains/kotlin/codegen/inline/CoveringTryCatchNodeProcessor;)V", "allIntervals", "Ljava/util/ArrayList;", "getAllIntervals", "()Ljava/util/ArrayList;", "currentIntervals", "", "getCurrentIntervals", "()Ljava/util/Set;", "intervalEnds", "Lcom/google/common/collect/LinkedListMultimap;", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "kotlin.jvm.PlatformType", "getIntervalEnds", "()Lcom/google/common/collect/LinkedListMultimap;", "intervalStarts", "getIntervalStarts", "addNewInterval", "", "newInfo", "(Lorg/jetbrains/kotlin/codegen/inline/SplittableInterval;)V", "getInterval", "", "", "curIns", "isOpen", "", "processCurrent", "directOrder", "remapEndLabel", "oldEnd", "remapped", "(Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;Lorg/jetbrains/kotlin/codegen/inline/SplittableInterval;)V", "remapStartLabel", "oldStart", "split", "Lorg/jetbrains/kotlin/codegen/inline/SplitPair;", "interval", "by", "Lorg/jetbrains/kotlin/codegen/inline/Interval;", "keepStart", "(Lorg/jetbrains/kotlin/codegen/inline/SplittableInterval;Lorg/jetbrains/kotlin/codegen/inline/Interval;Z)Lorg/jetbrains/kotlin/codegen/inline/SplitPair;", "splitAndRemoveCurrentIntervals", "splitAndRemoveIntervalFromCurrents", "splitCurrentIntervals", "backend"})
@SourceDebugExtension(value={"SMAP\nCoveringTryCatchNodeProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoveringTryCatchNodeProcessor.kt\norg/jetbrains/kotlin/codegen/inline/IntervalMetaInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n1549#2:210\n1620#2,3:211\n1855#2,2:214\n1855#2:216\n1856#2:218\n1855#2,2:219\n1#3:217\n*S KotlinDebug\n*F\n+ 1 CoveringTryCatchNodeProcessor.kt\norg/jetbrains/kotlin/codegen/inline/IntervalMetaInfo\n*L\n116#1:210\n116#1:211,3\n120#1:214,2\n124#1:216\n124#1:218\n129#1:219,2\n*E\n"})
public final class IntervalMetaInfo<T extends SplittableInterval<? extends T>> {
    @NotNull
    private final CoveringTryCatchNodeProcessor processor;
    private final LinkedListMultimap<LabelNode, T> intervalStarts;
    private final LinkedListMultimap<LabelNode, T> intervalEnds;
    @NotNull
    private final ArrayList<T> allIntervals;
    @NotNull
    private final Set<T> currentIntervals;

    public IntervalMetaInfo(@NotNull CoveringTryCatchNodeProcessor processor2) {
        Intrinsics.checkNotNullParameter(processor2, "processor");
        this.processor = processor2;
        this.intervalStarts = LinkedListMultimap.create();
        this.intervalEnds = LinkedListMultimap.create();
        this.allIntervals = new ArrayList();
        this.currentIntervals = new LinkedHashSet();
    }

    public final LinkedListMultimap<LabelNode, T> getIntervalStarts() {
        return this.intervalStarts;
    }

    public final LinkedListMultimap<LabelNode, T> getIntervalEnds() {
        return this.intervalEnds;
    }

    @NotNull
    public final ArrayList<T> getAllIntervals() {
        return this.allIntervals;
    }

    @NotNull
    public final Set<T> getCurrentIntervals() {
        return this.currentIntervals;
    }

    public final void addNewInterval(@NotNull T newInfo) {
        Intrinsics.checkNotNullParameter(newInfo, "newInfo");
        newInfo.verify(this.processor);
        this.intervalStarts.put(newInfo.getStartLabel(), newInfo);
        this.intervalEnds.put(newInfo.getEndLabel(), newInfo);
        this.allIntervals.add(newInfo);
    }

    private final void remapStartLabel(LabelNode oldStart, T remapped) {
        remapped.verify(this.processor);
        this.intervalStarts.remove(oldStart, remapped);
        this.intervalStarts.put(remapped.getStartLabel(), remapped);
    }

    private final void remapEndLabel(LabelNode oldEnd, T remapped) {
        remapped.verify(this.processor);
        this.intervalEnds.remove(oldEnd, remapped);
        this.intervalEnds.put(remapped.getEndLabel(), remapped);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SplitPair<T>> splitCurrentIntervals(@NotNull Interval by, boolean keepStart) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(by, "by");
        Iterable $this$map$iv = this.currentIntervals;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SplittableInterval splittableInterval = (SplittableInterval)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.split(it, by, keepStart));
        }
        return (List)destination$iv$iv;
    }

    public final void splitAndRemoveCurrentIntervals(@NotNull Interval by, boolean keepStart) {
        Intrinsics.checkNotNullParameter(by, "by");
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.currentIntervals);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SplittableInterval it = (SplittableInterval)element$iv;
            boolean bl = false;
            this.splitAndRemoveIntervalFromCurrents(it, by, keepStart);
        }
    }

    public final void processCurrent(@NotNull LabelNode curIns, boolean directOrder) {
        SplittableInterval it;
        Intrinsics.checkNotNullParameter(curIns, "curIns");
        List<T> list2 = this.getInterval(curIns, directOrder);
        Intrinsics.checkNotNullExpressionValue(list2, "getInterval(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (SplittableInterval)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            boolean added = this.currentIntervals.add(it);
            if (!_Assertions.ENABLED || added) continue;
            boolean $i$a$-assert-IntervalMetaInfo$processCurrent$1$22 = false;
            String $i$a$-assert-IntervalMetaInfo$processCurrent$1$22 = "Wrong interval structure: " + curIns + ", " + it;
            throw new AssertionError((Object)$i$a$-assert-IntervalMetaInfo$processCurrent$1$22);
        }
        List<T> list3 = this.getInterval(curIns, !directOrder);
        Intrinsics.checkNotNullExpressionValue(list3, "getInterval(...)");
        $this$forEach$iv = list3;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (SplittableInterval)element$iv;
            boolean bl = false;
            boolean removed = this.currentIntervals.remove(it);
            if (!_Assertions.ENABLED || removed) continue;
            boolean bl2 = false;
            String string2 = "Wrong interval structure: " + curIns + ", " + it;
            throw new AssertionError((Object)string2);
        }
    }

    @NotNull
    public final SplitPair<T> split(@NotNull T interval, @NotNull Interval by, boolean keepStart) {
        Intrinsics.checkNotNullParameter(interval, "interval");
        Intrinsics.checkNotNullParameter(by, "by");
        SplitPair split = interval.split(by, keepStart);
        if (!keepStart) {
            this.remapStartLabel(((SplittableInterval)split.getNewPart()).getStartLabel(), (SplittableInterval)split.getPatchedPart());
        } else {
            this.remapEndLabel(((SplittableInterval)split.getNewPart()).getEndLabel(), (SplittableInterval)split.getPatchedPart());
        }
        this.addNewInterval((SplittableInterval)split.getNewPart());
        return split;
    }

    @NotNull
    public final SplitPair<T> splitAndRemoveIntervalFromCurrents(@NotNull T interval, @NotNull Interval by, boolean keepStart) {
        Intrinsics.checkNotNullParameter(interval, "interval");
        Intrinsics.checkNotNullParameter(by, "by");
        SplitPair<T> splitPair = this.split(interval, by, keepStart);
        boolean removed = this.currentIntervals.remove(splitPair.getPatchedPart());
        if (_Assertions.ENABLED && !removed) {
            boolean bl = false;
            String string2 = "Wrong interval structure: " + splitPair;
            throw new AssertionError((Object)string2);
        }
        return splitPair;
    }

    private final List<T> getInterval(LabelNode curIns, boolean isOpen) {
        return isOpen ? this.intervalStarts.get((Object)curIns) : this.intervalEnds.get((Object)curIns);
    }
}

