/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FunctionsFromAnyGenerator;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH$J\b\u0010\u000e\u001a\u00020\bH\u0002J\u001e\u0010\u000f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H$J\u0016\u0010\u0013\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/common/DataClassMethodGenerator;", "Lorg/jetbrains/kotlin/backend/common/FunctionsFromAnyGenerator;", "declaration", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "generate", "", "generateComponentFunction", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "generateComponentFunctionsForDataClasses", "generateCopyFunction", "constructorParameters", "", "Lorg/jetbrains/kotlin/psi/KtParameter;", "generateCopyFunctionForDataClasses", "backend-common"})
public abstract class DataClassMethodGenerator
extends FunctionsFromAnyGenerator {
    public DataClassMethodGenerator(@NotNull KtClassOrObject declaration2, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        super(declaration2, bindingContext);
    }

    @Override
    public void generate() {
        if (!(this.getDeclaration() instanceof KtObjectDeclaration)) {
            this.generateComponentFunctionsForDataClasses();
            this.generateCopyFunctionForDataClasses(this.getPrimaryConstructorParameters());
        }
        super.generate();
    }

    protected abstract void generateComponentFunction(@NotNull FunctionDescriptor var1, @NotNull ValueParameterDescriptor var2);

    protected abstract void generateCopyFunction(@NotNull FunctionDescriptor var1, @NotNull List<? extends KtParameter> var2);

    private final void generateComponentFunctionsForDataClasses() {
        ClassConstructorDescriptor classConstructorDescriptor = this.getClassDescriptor().getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            return;
        }
        ClassConstructorDescriptor constructor2 = classConstructorDescriptor;
        for (ValueParameterDescriptor parameter2 : constructor2.getValueParameters()) {
            FunctionDescriptor function2 = (FunctionDescriptor)this.getBindingContext().get(BindingContext.DATA_CLASS_COMPONENT_FUNCTION, parameter2);
            if (function2 == null) continue;
            Intrinsics.checkNotNull(parameter2);
            this.generateComponentFunction(function2, parameter2);
        }
    }

    private final void generateCopyFunctionForDataClasses(List<? extends KtParameter> constructorParameters) {
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.getBindingContext().get(BindingContext.DATA_CLASS_COPY_FUNCTION, this.getClassDescriptor());
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor copyFunction = functionDescriptor;
        this.generateCopyFunction(copyFunction, constructorParameters);
    }
}

