/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.elements;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.light.LightIdentifier;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.elements.PsiElementWithOrigin;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B%\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\r\u001a\u00020\u0003H\u0016J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u000fH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/asJava/elements/KtLightIdentifier;", "Lcom/intellij/psi/impl/light/LightIdentifier;", "Lorg/jetbrains/kotlin/asJava/elements/PsiElementWithOrigin;", "Lcom/intellij/psi/PsiElement;", "lightOwner", "ktDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "name", "", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/psi/KtDeclaration;Ljava/lang/String;)V", "origin", "getOrigin", "()Lcom/intellij/psi/PsiElement;", "copy", "equals", "", "other", "", "getContainingFile", "Lcom/intellij/psi/PsiFile;", "getParent", "getTextOffset", "", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "hashCode", "isPhysical", "light-classes-base"})
public class KtLightIdentifier
extends LightIdentifier
implements PsiElementWithOrigin<PsiElement> {
    @NotNull
    private final PsiElement lightOwner;
    @Nullable
    private final KtDeclaration ktDeclaration;
    @Nullable
    private final String name;

    @JvmOverloads
    public KtLightIdentifier(@NotNull PsiElement lightOwner, @Nullable KtDeclaration ktDeclaration2, @Nullable String name2) {
        Intrinsics.checkNotNullParameter(lightOwner, "lightOwner");
        super(lightOwner.getManager(), name2);
        this.lightOwner = lightOwner;
        this.ktDeclaration = ktDeclaration2;
        this.name = name2;
    }

    public /* synthetic */ KtLightIdentifier(PsiElement psiElement, KtDeclaration ktDeclaration2, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            KtDeclaration ktDeclaration3 = ktDeclaration2;
            string2 = ktDeclaration3 != null ? ktDeclaration3.getName() : null;
        }
        this(psiElement, ktDeclaration2, string2);
    }

    @Override
    @Nullable
    public PsiElement getOrigin() {
        PsiElement psiElement;
        KtDeclaration ktDeclaration2 = this.ktDeclaration;
        if (ktDeclaration2 instanceof KtSecondaryConstructor) {
            psiElement = ((KtSecondaryConstructor)this.ktDeclaration).getConstructorKeyword();
        } else if (ktDeclaration2 instanceof KtPrimaryConstructor) {
            psiElement = ((KtPrimaryConstructor)this.ktDeclaration).getConstructorKeyword();
            if (psiElement == null) {
                KtParameterList ktParameterList = ((KtPrimaryConstructor)this.ktDeclaration).getValueParameterList();
                if (ktParameterList != null) {
                    psiElement = ktParameterList;
                } else {
                    KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(this.ktDeclaration);
                    psiElement = ktClassOrObject != null ? ktClassOrObject.getNameIdentifier() : null;
                }
            }
        } else {
            psiElement = ktDeclaration2 instanceof KtPropertyAccessor ? ((KtPropertyAccessor)this.ktDeclaration).getNamePlaceholder() : (ktDeclaration2 instanceof KtNamedDeclaration ? ((KtNamedDeclaration)this.ktDeclaration).getNameIdentifier() : null);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement copy() {
        return new KtLightIdentifier(this.getParent(), this.ktDeclaration, this.name);
    }

    @Override
    public boolean isPhysical() {
        return true;
    }

    @Override
    @NotNull
    public PsiElement getParent() {
        return this.lightOwner;
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        PsiFile psiFile = this.lightOwner.getContainingFile();
        Intrinsics.checkNotNullExpressionValue(psiFile, "getContainingFile(...)");
        return psiFile;
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        PsiElement psiElement = this.getOrigin();
        TextRange textRange = psiElement != null ? psiElement.getTextRange() : null;
        if (textRange == null) {
            TextRange textRange2 = TextRange.EMPTY_RANGE;
            textRange = textRange2;
            Intrinsics.checkNotNullExpressionValue(textRange2, "EMPTY_RANGE");
        }
        return textRange;
    }

    @Override
    public int getTextOffset() {
        PsiElement psiElement = this.getOrigin();
        return psiElement != null ? psiElement.getTextOffset() : -1;
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof KtLightIdentifier && Intrinsics.areEqual(((KtLightIdentifier)other).lightOwner, this.lightOwner) && Intrinsics.areEqual(((KtLightIdentifier)other).ktDeclaration, this.ktDeclaration) && Intrinsics.areEqual(((KtLightIdentifier)other).name, this.name);
    }

    public int hashCode() {
        return this.lightOwner.hashCode();
    }

    @JvmOverloads
    public KtLightIdentifier(@NotNull PsiElement lightOwner, @Nullable KtDeclaration ktDeclaration2) {
        Intrinsics.checkNotNullParameter(lightOwner, "lightOwner");
        this(lightOwner, ktDeclaration2, null, 4, null);
    }
}

