/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.util;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirResolvableModuleSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ExceptionUtilsKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u001a\t\u0010\r\u001a\u00020\u000eH\u0080\b\u001a-\u0010\u000f\u001a\u0002H\u0010\"\b\b\u0000\u0010\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0015H\u0000\u00a2\u0006\u0002\u0010\u0016\u001a\f\u0010\u0017\u001a\u00020\u0006*\u00020\nH\u0000\u001a1\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0015H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001d\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\"\u0018\u0010\t\u001a\u00020\n*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001e"}, d2={"containingKtFileIfAny", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getContainingKtFileIfAny", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Lorg/jetbrains/kotlin/psi/KtFile;", "isErrorElement", "", "Lorg/jetbrains/kotlin/fir/FirElement;", "(Lorg/jetbrains/kotlin/fir/FirElement;)Z", "ktDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getKtDeclaration", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Lorg/jetbrains/kotlin/psi/KtDeclaration;", "checkCanceled", "", "withInvalidationOnException", "R", "", "session", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirResolvableModuleSession;", "action", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirResolvableModuleSession;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "isNonAnonymousClassOrObject", "lockWithPCECheck", "T", "Ljava/util/concurrent/locks/Lock;", "lockingIntervalMs", "", "(Ljava/util/concurrent/locks/Lock;JLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/util/UtilsKt\n*L\n1#1,75:1\n47#1,2:76\n47#1,2:78\n*S KotlinDebug\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/util/UtilsKt\n*L\n33#1:76,2\n36#1:78,2\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final <R> R withInvalidationOnException(@NotNull LLFirResolvableModuleSession session, @NotNull Function0<? extends R> action) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(action, "action");
        try {
            return action.invoke();
        }
        catch (Throwable e) {
            session.invalidate();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T lockWithPCECheck(@NotNull Lock $this$lockWithPCECheck, long lockingIntervalMs, @NotNull Function0<? extends T> action) {
        boolean $i$f$checkCanceled;
        Intrinsics.checkNotNullParameter($this$lockWithPCECheck, "<this>");
        Intrinsics.checkNotNullParameter(action, "action");
        boolean $i$f$lockWithPCECheck = false;
        do {
            $i$f$checkCanceled = false;
            ProgressManager.checkCanceled();
        } while (!$this$lockWithPCECheck.tryLock(lockingIntervalMs, TimeUnit.MILLISECONDS));
        try {
            $i$f$checkCanceled = false;
            ProgressManager.checkCanceled();
            T t = action.invoke();
            return t;
        }
        finally {
            InlineMarker.finallyStart(1);
            $this$lockWithPCECheck.unlock();
            InlineMarker.finallyEnd(1);
        }
    }

    public static final void checkCanceled() {
        boolean $i$f$checkCanceled = false;
        ProgressManager.checkCanceled();
    }

    public static final boolean isErrorElement(@NotNull FirElement $this$isErrorElement) {
        Intrinsics.checkNotNullParameter($this$isErrorElement, "<this>");
        return $this$isErrorElement instanceof FirDiagnosticHolder;
    }

    @NotNull
    public static final KtDeclaration getKtDeclaration(@NotNull FirDeclaration $this$ktDeclaration) {
        KtDeclaration ktDeclaration2;
        Intrinsics.checkNotNullParameter($this$ktDeclaration, "<this>");
        PsiElement psiElement = org.jetbrains.kotlin.fir.UtilsKt.getPsi($this$ktDeclaration);
        if (psiElement == null) {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("PSI element was not found", null, $this$ktDeclaration, null, null, null, 58, null);
            throw null;
        }
        PsiElement psi2 = psiElement;
        PsiElement psiElement2 = psi2;
        if (psiElement2 instanceof KtDeclaration) {
            ktDeclaration2 = (KtDeclaration)psi2;
        } else if (psiElement2 instanceof KtObjectLiteralExpression) {
            KtObjectDeclaration ktObjectDeclaration = ((KtObjectLiteralExpression)psi2).getObjectDeclaration();
            Intrinsics.checkNotNullExpressionValue(ktObjectDeclaration, "getObjectDeclaration(...)");
            ktDeclaration2 = ktObjectDeclaration;
        } else {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("FirDeclaration.psi (" + Reflection.getOrCreateKotlinClass($this$ktDeclaration.getClass()).getSimpleName() + ") should be KtDeclaration but was " + Reflection.getOrCreateKotlinClass(psi2.getClass()).getSimpleName(), null, $this$ktDeclaration, null, psi2, null, 42, null);
            throw null;
        }
        return ktDeclaration2;
    }

    @Nullable
    public static final KtFile getContainingKtFileIfAny(@NotNull FirDeclaration $this$containingKtFileIfAny) {
        Intrinsics.checkNotNullParameter($this$containingKtFileIfAny, "<this>");
        PsiElement psiElement = org.jetbrains.kotlin.fir.UtilsKt.getPsi($this$containingKtFileIfAny);
        PsiFile psiFile = psiElement != null ? psiElement.getContainingFile() : null;
        return psiFile instanceof KtFile ? (KtFile)psiFile : null;
    }

    public static final boolean isNonAnonymousClassOrObject(@NotNull KtDeclaration $this$isNonAnonymousClassOrObject) {
        Intrinsics.checkNotNullParameter($this$isNonAnonymousClassOrObject, "<this>");
        return $this$isNonAnonymousClassOrObject instanceof KtClassOrObject && !KtPsiUtilKt.isObjectLiteral((KtClassOrObject)$this$isNonAnonymousClassOrObject);
    }
}

