/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeMapper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.light.LightClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TypeCorrector
extends PsiTypeMapper {
    private final Map<PsiClassType, PsiClassType> myResultMap = new IdentityHashMap<PsiClassType, PsiClassType>();
    private final GlobalSearchScope myResolveScope;

    TypeCorrector(GlobalSearchScope resolveScope2) {
        this.myResolveScope = resolveScope2;
    }

    @Override
    public PsiType visitType(@NotNull PsiType type2) {
        if (type2 == null) {
            TypeCorrector.$$$reportNull$$$0(0);
        }
        if (LambdaUtil.notInferredType(type2)) {
            return type2;
        }
        return super.visitType(type2);
    }

    @Nullable
    public <T extends PsiType> T correctType(@NotNull T type2) {
        PsiClass mappedClass;
        PsiClassType.ClassResolveResult classResolveResult;
        PsiClass psiClass;
        PsiClassType classType;
        if (type2 == null) {
            TypeCorrector.$$$reportNull$$$0(1);
        }
        if (type2 instanceof PsiClassType && (classType = (PsiClassType)type2).getParameterCount() == 0 && (psiClass = (classResolveResult = classType.resolveGenerics()).getElement()) != null && classResolveResult.getSubstitutor() == PsiSubstitutor.EMPTY && ((mappedClass = PsiSuperMethodUtil.correctClassByScope(psiClass, this.myResolveScope)) == null || mappedClass == psiClass)) {
            return (T)classType;
        }
        return (T)type2.accept(this);
    }

    @Override
    public PsiType visitClassType(@NotNull PsiClassType classType) {
        if (classType == null) {
            TypeCorrector.$$$reportNull$$$0(2);
        }
        if (classType instanceof PsiCorrectedClassType) {
            return this.myResolveScope.equals(classType.getResolveScope()) ? classType : this.visitClassType(((PsiCorrectedClassType)classType).myDelegate);
        }
        PsiClassType alreadyComputed = this.myResultMap.get(classType);
        if (alreadyComputed != null) {
            return alreadyComputed;
        }
        PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
        PsiClass psiClass = classResolveResult.getElement();
        PsiSubstitutor substitutor2 = classResolveResult.getSubstitutor();
        if (psiClass == null) {
            return classType;
        }
        if (psiClass instanceof LightClass) {
            return classType;
        }
        PsiUtilCore.ensureValid(psiClass);
        PsiClass mappedClass = PsiSuperMethodUtil.correctClassByScope(psiClass, this.myResolveScope);
        if (mappedClass == null) {
            return classType;
        }
        PsiCorrectedClassType mappedType2 = new PsiCorrectedClassType(classType.getLanguageLevel(), classType, new CorrectedResolveResult(psiClass, mappedClass, substitutor2, classResolveResult));
        this.myResultMap.put(classType, mappedType2);
        return mappedType2;
    }

    @NotNull
    private PsiSubstitutor mapSubstitutor(PsiClass originalClass, PsiClass mappedClass, PsiSubstitutor substitutor2) {
        PsiClass originalContaining;
        PsiTypeParameter[] originalTypeParameters;
        PsiTypeParameter[] typeParameters2 = mappedClass.getTypeParameters();
        if (typeParameters2.length != (originalTypeParameters = originalClass.getTypeParameters()).length) {
            if (originalTypeParameters.length == 0) {
                PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory(mappedClass.getProject()).createRawSubstitutor(mappedClass);
                if (psiSubstitutor == null) {
                    TypeCorrector.$$$reportNull$$$0(3);
                }
                return psiSubstitutor;
            }
            PsiSubstitutor psiSubstitutor = substitutor2;
            if (psiSubstitutor == null) {
                TypeCorrector.$$$reportNull$$$0(4);
            }
            return psiSubstitutor;
        }
        Map<PsiTypeParameter, PsiType> substitutionMap = substitutor2.getSubstitutionMap();
        PsiSubstitutor mappedSubstitutor = PsiSubstitutor.EMPTY;
        for (int i = 0; i < originalTypeParameters.length; ++i) {
            if (!substitutionMap.containsKey(originalTypeParameters[i])) continue;
            PsiType originalSubstitute = substitutor2.substitute(originalTypeParameters[i]);
            if (originalSubstitute != null) {
                PsiType substitute2 = this.mapType(originalSubstitute);
                if (substitute2 == null) {
                    PsiSubstitutor psiSubstitutor = substitutor2;
                    if (psiSubstitutor == null) {
                        TypeCorrector.$$$reportNull$$$0(5);
                    }
                    return psiSubstitutor;
                }
                mappedSubstitutor = mappedSubstitutor.put(typeParameters2[i], substitute2);
                continue;
            }
            mappedSubstitutor = mappedSubstitutor.put(typeParameters2[i], null);
        }
        if (mappedClass.hasModifierProperty("static")) {
            PsiSubstitutor psiSubstitutor = mappedSubstitutor;
            if (psiSubstitutor == null) {
                TypeCorrector.$$$reportNull$$$0(6);
            }
            return psiSubstitutor;
        }
        PsiClass mappedContaining = mappedClass.getContainingClass();
        if (mappedContaining != null != ((originalContaining = originalClass.getContainingClass()) != null)) {
            PsiSubstitutor psiSubstitutor = substitutor2;
            if (psiSubstitutor == null) {
                TypeCorrector.$$$reportNull$$$0(7);
            }
            return psiSubstitutor;
        }
        if (mappedContaining != null) {
            PsiSubstitutor psiSubstitutor = mappedSubstitutor.putAll(this.mapSubstitutor(originalContaining, mappedContaining, substitutor2));
            if (psiSubstitutor == null) {
                TypeCorrector.$$$reportNull$$$0(8);
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = mappedSubstitutor;
        if (psiSubstitutor == null) {
            TypeCorrector.$$$reportNull$$$0(9);
        }
        return psiSubstitutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/TypeCorrector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/TypeCorrector";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "mapSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "correctType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitClassType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class CorrectedResolveResult
    implements PsiClassType.ClassResolveResult {
        private final PsiClass myPsiClass;
        private final PsiClass myMappedClass;
        private final PsiSubstitutor mySubstitutor;
        private final PsiClassType.ClassResolveResult myClassResolveResult;
        private volatile PsiSubstitutor myLazySubstitutor;

        CorrectedResolveResult(PsiClass psiClass, PsiClass mappedClass, PsiSubstitutor substitutor2, PsiClassType.ClassResolveResult classResolveResult) {
            this.myPsiClass = psiClass;
            this.myMappedClass = mappedClass;
            this.mySubstitutor = substitutor2;
            this.myClassResolveResult = classResolveResult;
        }

        @Override
        @NotNull
        public PsiSubstitutor getSubstitutor() {
            PsiSubstitutor result2 = this.myLazySubstitutor;
            if (result2 == null) {
                this.myLazySubstitutor = result2 = TypeCorrector.this.mapSubstitutor(this.myPsiClass, this.myMappedClass, this.mySubstitutor);
            }
            PsiSubstitutor psiSubstitutor = result2;
            if (psiSubstitutor == null) {
                CorrectedResolveResult.$$$reportNull$$$0(0);
            }
            return psiSubstitutor;
        }

        @Override
        public PsiClass getElement() {
            return this.myMappedClass;
        }

        @Override
        public boolean isPackagePrefixPackageReference() {
            return this.myClassResolveResult.isPackagePrefixPackageReference();
        }

        @Override
        public boolean isAccessible() {
            return this.myClassResolveResult.isAccessible();
        }

        @Override
        public boolean isStaticsScopeCorrect() {
            return this.myClassResolveResult.isStaticsScopeCorrect();
        }

        @Override
        public PsiElement getCurrentFileResolveScope() {
            return this.myClassResolveResult.getCurrentFileResolveScope();
        }

        @Override
        public boolean isValidResult() {
            return this.myClassResolveResult.isValidResult();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/TypeCorrector$CorrectedResolveResult", "getSubstitutor"));
        }
    }

    private final class PsiCorrectedClassType
    extends PsiClassType.Stub {
        private final PsiClassType myDelegate;
        private final CorrectedResolveResult myResolveResult;

        private PsiCorrectedClassType(LanguageLevel languageLevel, PsiClassType delegate, CorrectedResolveResult resolveResult) {
            if (languageLevel == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(0);
            }
            super(languageLevel, delegate.getAnnotationProvider());
            if (delegate instanceof PsiCorrectedClassType) {
                throw new IllegalArgumentException();
            }
            this.myDelegate = delegate;
            this.myResolveResult = resolveResult;
        }

        @Override
        @NotNull
        public PsiClass resolve() {
            PsiClass psiClass = this.myResolveResult.myMappedClass;
            if (psiClass == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(1);
            }
            return psiClass;
        }

        @Override
        public String getClassName() {
            return this.myDelegate.getClassName();
        }

        @Override
        @Nullable
        public PsiElement getPsiContext() {
            return this.myDelegate.getPsiContext();
        }

        @Override
        public PsiType @NotNull [] getParameters() {
            PsiType[] psiTypeArray = ContainerUtil.map2Array(this.myDelegate.getParameters(), PsiType.class, type2 -> {
                if (type2 == null) {
                    LOG.error(this.myDelegate + " of " + this.myDelegate.getClass() + "; substitutor=" + this.myDelegate.resolveGenerics().getSubstitutor());
                    return null;
                }
                return TypeCorrector.this.mapType(type2);
            });
            if (psiTypeArray == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(2);
            }
            return psiTypeArray;
        }

        @Override
        public int getParameterCount() {
            return this.myDelegate.getParameters().length;
        }

        @Override
        @NotNull
        public PsiClassType.ClassResolveResult resolveGenerics() {
            CorrectedResolveResult correctedResolveResult = this.myResolveResult;
            if (correctedResolveResult == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(3);
            }
            return correctedResolveResult;
        }

        @Override
        @NotNull
        public PsiClassType rawType() {
            PsiClass psiClass = this.resolve();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(psiClass.getProject());
            PsiClassType psiClassType = factory.createType(psiClass, factory.createRawSubstitutor(psiClass));
            if (psiClassType == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(4);
            }
            return psiClassType;
        }

        @Override
        @NotNull
        public GlobalSearchScope getResolveScope() {
            GlobalSearchScope globalSearchScope = TypeCorrector.this.myResolveScope;
            if (globalSearchScope == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(5);
            }
            return globalSearchScope;
        }

        @Override
        @NotNull
        public LanguageLevel getLanguageLevel() {
            LanguageLevel languageLevel = this.myLanguageLevel;
            if (languageLevel == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(6);
            }
            return languageLevel;
        }

        @Override
        @NotNull
        public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
            if (languageLevel == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(7);
            }
            return new PsiCorrectedClassType(languageLevel, this.myDelegate, this.myResolveResult);
        }

        @Override
        @NotNull
        public PsiClassType annotate(@NotNull TypeAnnotationProvider provider2) {
            PsiClassType newDelegate;
            if (provider2 == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(8);
            }
            return (newDelegate = this.myDelegate.annotate(provider2)) == this.myDelegate ? this : new PsiCorrectedClassType(this.myLanguageLevel, newDelegate, this.myResolveResult);
        }

        @Override
        @NotNull
        public String getPresentableText(boolean annotated) {
            String string2 = this.myDelegate.getPresentableText(annotated);
            if (string2 == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(9);
            }
            return string2;
        }

        @Override
        @NotNull
        public String getCanonicalText(boolean annotated) {
            String string2 = this.myDelegate.getCanonicalText(annotated);
            if (string2 == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(10);
            }
            return string2;
        }

        @Override
        @NotNull
        public String getInternalCanonicalText() {
            String string2 = this.myDelegate.getInternalCanonicalText();
            if (string2 == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(11);
            }
            return string2;
        }

        @Override
        public boolean isValid() {
            return this.myDelegate.isValid() && this.myResolveResult.myMappedClass.isValid() && this.myResolveResult.mySubstitutor.isValid();
        }

        @Override
        public boolean equalsToText(@NotNull @NonNls String text) {
            if (text == null) {
                PsiCorrectedClassType.$$$reportNull$$$0(12);
            }
            return this.myDelegate.equalsToText(text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageLevel";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/TypeCorrector$PsiCorrectedClassType";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/TypeCorrector$PsiCorrectedClassType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameters";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveGenerics";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rawType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResolveScope";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguageLevel";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInternalCanonicalText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setLanguageLevel";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "annotate";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "equalsToText";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

